/*
 * Decompiled with CFR 0.152.
 */
package jet.swingviewer;

import guitools.Painter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import jet.JCliResource;
import jet.datastream.TOCNode;

public class ETOCTreeNodeRender
extends DefaultTreeCellRenderer {
    boolean strike;
    boolean underline;
    boolean italic;
    boolean bold;
    boolean isSelected;
    Color backgroundColor;
    Color hexColor;
    Color selectedColor;
    String fontName;
    int fontSize;
    int align = 4;
    Font font;
    String nodeDisplayValue = "";
    Icon icon;
    private int FAMILY = 18;
    private static final int POSTURE = 1;

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        if (bl3) {
            this.setIcon(new ImageIcon(JCliResource.getImage("grouppage")));
        } else if (bl2) {
            this.setIcon(new ImageIcon(JCliResource.getImage("folderopen")));
        } else {
            this.setIcon(new ImageIcon(JCliResource.getImage("folder")));
        }
        this.setEnabled(jTree.isEnabled());
        this.icon = this.getIcon();
        this.FAMILY = this.icon.getIconHeight();
        if (object != null) {
            this.nodeDisplayValue = "";
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            this.nodeDisplayValue = ((TOCNode)defaultMutableTreeNode.getUserObject()).getNodeDisplayValue();
            this.setText(this.nodeDisplayValue + "     ");
        }
        this.isSelected = bl;
        if (this.isSelected) {
            this.setForeground(this.selectedColor);
        } else {
            this.setForeground(this.hexColor);
        }
        this.setBackgroundNonSelectionColor(this.backgroundColor);
        return this;
    }

    public void buildTOCNodeStyle() {
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        if (this.bold) {
            hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (this.italic) {
            hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        hashMap.put(TextAttribute.FAMILY, this.fontName);
        if (this.fontSize > 0) {
            hashMap.put(TextAttribute.SIZE, Float.valueOf(this.fontSize + ""));
        }
        this.font = new Font(hashMap);
        this.setFont(this.font);
        hashMap = null;
    }

    public int getNodeHeight() {
        return Math.max(this.fontSize, this.FAMILY);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.drawImage(((ImageIcon)this.icon).getImage(), 1, Math.abs((this.fontSize - this.icon.getIconHeight()) / 2) + 1, this.icon.getIconWidth(), this.icon.getIconHeight(), this);
        Rectangle rectangle = new Rectangle(this.icon.getIconWidth() + 4, 0, this.getWidth() + 2, this.getHeight());
        if (this.isSelected) {
            Painter.drawText(graphics, rectangle, 0, this.nodeDisplayValue, this.font, this.selectedColor, false, this.underline, this.strike, this.align);
        } else {
            Painter.drawText(graphics, rectangle, 0, this.nodeDisplayValue, this.font, this.hexColor, false, this.underline, this.strike, this.align);
        }
    }
}

