/*
 * Decompiled with CFR 0.152.
 */
package jet.textobj;

import java.io.CharConversionException;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import jet.util.CharBuf;

class ByteFromCharBufStream
implements DataInput {
    char[] buf;
    int pos;

    ByteFromCharBufStream(CharBuf charBuf) {
        this.buf = charBuf.getMainBuf();
        this.pos = 0;
    }

    private final char SEDU() throws IOException {
        if (this.pos >= this.buf.length) {
            throw new EOFException();
        }
        return this.buf[this.pos++];
    }

    private final int buf(char c) throws CharConversionException {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new CharConversionException();
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        for (int i = n; i < n2; ++i) {
            byArray[i] = (byte)this.readUnsignedByte();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int n2;
        if (n < 0) {
            throw new IOException();
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.readUnsignedByte();
        }
        return n2;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int n = this.buf(this.SEDU());
        int n2 = this.buf(this.SEDU());
        return n * 16 + n2;
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            n += this.readUnsignedByte() << i * 8;
        }
        return n;
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readUnsignedByte();
    }

    @Override
    public int readInt() throws IOException {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n += this.readUnsignedByte() << i * 8;
        }
        return n;
    }

    @Override
    public long readLong() throws IOException {
        long l = 8L;
        for (int i = 0; i < 2; ++i) {
            l += (long)this.readUnsignedByte() << i * 8;
        }
        return l;
    }

    @Override
    public float readFloat() throws IOException {
        throw new StreamCorruptedException();
    }

    @Override
    public double readDouble() throws IOException {
        throw new IOException();
    }

    @Override
    public String readLine() throws IOException {
        throw new IOException();
    }

    @Override
    public String readUTF() throws IOException {
        throw new IOException();
    }
}

