/*
 * Decompiled with CFR 0.152.
 */
package jet.textobj;

import java.awt.Color;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import jet.log.JRLogger;
import jet.textobj.CharsProp;
import jet.textobj.ChrMtrcTmpl;
import jet.textobj.DLLBufable;
import jet.textobj.DblLinkable;
import jet.textobj.FieldDest;
import jet.textobj.FlagProp;
import jet.textobj.KwdObj;
import jet.textobj.ObjProp;
import jet.textobj.ObjTmpl;
import jet.textobj.Prop;
import jet.textobj.RtfDest;
import jet.textobj.ToggleProp;
import jet.textobj.ValueProp;
import jet.textobj.Vect;
import jet.textobj.rtf.KwdToken;
import jet.textobj.rtf.Pcdata;
import jet.util.Assertion;
import jet.util.CharBuf;
import jet.util.HashVector;
import jet.util.IntKeyHashtable;
import jet.util.MiscTools;

public class Obj
implements DblLinkable {
    HashVector props;
    String name = "noname";
    String mappingName = "noname";
    int[] numericPropSets;
    int[] valuePropValues;
    Obj[] objPropSets;
    CharBuf[] charsPropSets;
    ObjTmpl tmpl;
    Obj owner = null;
    FieldDest fldOwner = null;
    boolean isExt;
    boolean notAddToProp = false;
    boolean modified = false;
    private static JRLogger B = JRLogger.getLogger(Obj.class.getName());
    DblLinkable next = null;
    DblLinkable prev = null;

    Obj() {
    }

    public final HashVector getProps() {
        return this.props;
    }

    public final FieldDest getFldOwner() {
        return this.fldOwner;
    }

    public final void setFldOwner(FieldDest fieldDest) {
        this.fldOwner = fieldDest;
    }

    public final boolean isObj(String string) {
        return this.name.equals(string);
    }

    public static boolean isTab(Obj obj) {
        return obj != null && obj.isObj("kwd") && ((KwdObj)obj).isKwd(895);
    }

    public static boolean isPar(Obj obj) {
        return obj != null && obj.isObj("kwd") && ((KwdObj)obj).isKwd(630);
    }

    final int getIntFlag(int n, int n2, short s) {
        int n3 = this.makeMask(s);
        int n4 = this.numericPropSets[n];
        return n4 >> n2 & n3;
    }

    final void setIntFlag(short s, byte by, short s2, int n) {
        int n2 = this.makeMask(s2);
        int n3 = this.numericPropSets[s];
        this.numericPropSets[s] = n3 & ~(n2 << by) | (n & n2) << by;
    }

    final boolean getBooleanFlag(int n, int n2) {
        return this.getIntFlag(n, n2, (short)1) != 0;
    }

    final void setBooleanFlag(short s, byte by, boolean bl) {
        this.setIntFlag(s, by, (short)1, bl ? 1 : 0);
    }

    final int getIntValue(int n) {
        return this.valuePropValues[n];
    }

    final void setIntValue(short s, int n) {
        this.valuePropValues[s] = n;
    }

    final Obj getObjValue(int n) {
        return this.objPropSets[n];
    }

    final void setObjValue(short s, Obj obj) {
        if (obj != null) {
            obj.setOwner(this);
        }
        this.objPropSets[s] = obj;
        if (obj != null) {
            obj.notAddToProp = false;
        }
    }

    final CharBuf getCharsValue(int n) {
        return this.charsPropSets[n];
    }

    final void setCharsValue(short s, CharBuf charBuf) {
        this.charsPropSets[s] = charBuf;
    }

    final int makeMask(short s) {
        int n = 0;
        int n2 = 1;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            n |= n2;
            n2 <<= 1;
        }
        return n;
    }

    final void setModified(Prop prop) {
        switch (prop.type) {
            case 2: {
                this.setBooleanFlag(prop.pos1, (byte)(prop.pos2 + prop.pos3), true);
                break;
            }
            case 1: {
                this.setBooleanFlag(prop.pos1, (byte)(prop.pos2 + 1), true);
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                this.setBooleanFlag(prop.pos1, prop.pos2, true);
            }
        }
    }

    protected final void resetToDef(Prop prop) {
        switch (prop.type) {
            case 2: {
                this.setBooleanFlag(prop.pos1, (byte)(prop.pos2 + prop.pos3), false);
                break;
            }
            case 1: {
                this.setBooleanFlag(prop.pos1, (byte)(prop.pos2 + 1), false);
                break;
            }
            case 8: {
                this.setObjValue(prop, (Obj)null);
                this.setBooleanFlag(prop.pos1, prop.pos2, false);
                break;
            }
            case 4: 
            case 16: {
                this.setBooleanFlag(prop.pos1, prop.pos2, false);
            }
        }
    }

    final boolean isModified(Prop prop) {
        switch (prop.type) {
            case 2: {
                return this.getBooleanFlag(prop.pos1, prop.pos2 + prop.pos3);
            }
            case 1: {
                return this.getBooleanFlag(prop.pos1, prop.pos2 + 1);
            }
            case 4: 
            case 8: 
            case 16: {
                return this.getBooleanFlag(prop.pos1, prop.pos2);
            }
        }
        return false;
    }

    final boolean hasValue(Prop prop) {
        return this.isModified(prop) || this.hasDefval(prop);
    }

    final boolean hasDefval(Prop prop) {
        return prop.hasDefval();
    }

    final int getIntValue(Prop prop) {
        switch (prop.type) {
            case 2: {
                if (this.isModified(prop)) {
                    return this.getIntFlag(prop.pos1, prop.pos2, prop.pos3);
                }
                if (this.hasDefval(prop)) {
                    return (Integer)prop.defval;
                }
                throw new NullPointerException();
            }
            case 4: {
                if (this.isModified(prop)) {
                    return this.getIntValue(prop.pos3);
                }
                if (this.hasDefval(prop)) {
                    return (Integer)prop.defval;
                }
                throw new NullPointerException();
            }
        }
        throw new IllegalArgumentException("cannot getIntValue of prop " + prop.name + " in " + this.name);
    }

    final int getFlagValue(Prop prop) {
        switch (prop.type) {
            case 2: {
                if (this.isModified(prop)) {
                    return this.getIntValue(prop.pos4);
                }
                if (this.hasDefval(prop)) {
                    return (Integer)prop.defval;
                }
                throw new NullPointerException();
            }
        }
        throw new IllegalArgumentException("cannot getFlagValue of prop " + prop.name + " in " + this.name);
    }

    final boolean getBooleanValue(Prop prop) {
        switch (prop.type) {
            case 1: {
                if (this.isModified(prop)) {
                    return this.getBooleanFlag(prop.pos1, prop.pos2);
                }
                if (this.hasDefval(prop)) {
                    return (Boolean)prop.defval;
                }
                throw new NullPointerException();
            }
        }
        throw new IllegalArgumentException("cannot getBooleanValue of prop " + prop.name + " in " + this.name);
    }

    public final Obj getObjValue(Prop prop) {
        switch (prop.type) {
            case 8: {
                Obj obj = this.getObjValue(prop.pos3);
                if (obj == null) {
                    if (prop.hasDefval()) {
                        obj = ((Obj)prop.defval).shallowClone();
                        this.setObjValue(prop.pos3, obj);
                        return obj;
                    }
                    throw new NullPointerException();
                }
                return obj;
            }
        }
        throw new IllegalArgumentException("cannot getObjValue of prop " + prop.name + " in " + this.name);
    }

    final CharBuf getCharsValue(Prop prop) {
        switch (prop.type) {
            case 16: {
                if (this.isModified(prop)) {
                    return this.getCharsValue(prop.pos3);
                }
                if (this.hasDefval(prop)) {
                    return (CharBuf)prop.defval;
                }
                throw new NullPointerException();
            }
        }
        throw new IllegalArgumentException("cannot getCharsValue of prop " + prop.name + " in " + this.name);
    }

    final void setIntValue(Prop prop, int n) {
        switch (prop.type) {
            case 4: {
                this.setIntValue(prop.pos3, n);
                this.setModified(prop);
                break;
            }
            case 2: {
                FlagProp flagProp = (FlagProp)prop;
                if (flagProp.flagtbl != null) {
                    if (flagProp.flagtbl.getKwd(n) == null) {
                        throw new IllegalArgumentException("unknown value " + n + " of FlagProp " + prop.name + " in " + this.name);
                    }
                    this.setIntFlag(prop.pos1, prop.pos2, prop.pos3, n);
                } else {
                    this.setIntFlag(prop.pos1, prop.pos2, prop.pos3, n != 0 ? 1 : 0);
                }
                this.setModified(prop);
                break;
            }
            case 1: {
                this.setBooleanFlag(prop.pos1, prop.pos2, n != 0);
                this.setModified(prop);
                break;
            }
            default: {
                throw new IllegalArgumentException("cannot set intValue on prop " + prop.name + " in Obj " + this.name);
            }
        }
        this.setModified();
    }

    final void setFlagValue(Prop prop, int n) {
        switch (prop.type) {
            case 2: {
                this.setIntValue(prop.pos4, n);
                break;
            }
            default: {
                throw new IllegalArgumentException("cannot set FlagValue on prop " + prop.name + " in Obj " + this.name);
            }
        }
    }

    final void setBooleanValue(Prop prop, boolean bl) {
        switch (prop.type) {
            case 1: {
                this.setBooleanFlag(prop.pos1, prop.pos2, bl);
                this.setModified(prop);
                break;
            }
            default: {
                throw new IllegalArgumentException("cannot set BooleanValue on prop " + prop.name + " in Obj " + this.name);
            }
        }
        this.setModified();
    }

    final void setObjValue(Prop prop, Obj obj) {
        if (obj != null && !prop.name.equals(obj.name)) {
            throw new IllegalArgumentException("prop " + prop.name + " must equal with " + obj.name + " in " + this.name);
        }
        switch (prop.type) {
            case 4: {
                this.setIntValue(prop.pos3, obj.getIntValue(obj.name));
                this.setModified(prop);
                break;
            }
            case 16: {
                this.setCharsValue(prop.pos3, obj.getCharsValue(obj.name));
                this.setModified(prop);
                break;
            }
            case 8: {
                this.setObjValue(prop.pos3, obj);
                this.setModified(prop);
                break;
            }
            default: {
                throw new IllegalArgumentException("cannot add Obj " + obj.name + " to Obj " + this.name);
            }
        }
        this.setModified();
    }

    final void setCharsValue(Prop prop, CharBuf charBuf) {
        switch (prop.type) {
            case 16: {
                this.setCharsValue(prop.pos3, charBuf);
                this.setModified(prop);
                break;
            }
            default: {
                throw new IllegalArgumentException("cannot add CharBuf " + charBuf + " to Obj " + this.name);
            }
        }
        this.setModified();
    }

    public final boolean hasProp(String string) {
        return this.getProp(string) != null;
    }

    public void copyPropValue(Obj obj, String string) {
        Prop prop = obj.getProp(string);
        if (!obj.isModified(string)) {
            obj.resetToDef(string);
            return;
        }
        switch (prop.type) {
            case 1: {
                this.setBooleanValue(string, obj.getBooleanValue(string));
                break;
            }
            case 4: {
                this.setIntValue(string, obj.getIntValue(string));
                break;
            }
            case 2: {
                this.setIntValue(string, obj.getIntValue(string));
                this.setFlagValue(string, obj.getFlagValue(string));
                break;
            }
            case 16: {
                this.setCharsValue(string, obj.getCharsValue(string));
                break;
            }
            case 8: {
                this.setObjValue(string, obj.getObjValue(string));
            }
        }
    }

    public final Prop getProp(String string) {
        Prop prop;
        if (this.props == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        Obj obj = this;
        while (true) {
            char c;
            String string2 = stringTokenizer.nextToken();
            int n = -1;
            int n2 = string2.length() - 1;
            while (Character.isDigit(c = string2.charAt(n2))) {
                if (n == -1) {
                    n = 0;
                }
                n += Character.digit(c, 10) * string2.length() - 1 - n2;
                --n2;
            }
            if (n > -1) {
                string2 = string2.substring(0, n2);
                if (!(obj instanceof Vect)) {
                    throw new IllegalArgumentException("cannot identify the prop " + string + " in " + this.name);
                }
                obj = ((Vect)((Object)obj)).getSubProp(n);
                if (stringTokenizer.hasMoreTokens()) continue;
                throw new IllegalArgumentException("cannot identify the prop " + string + " in " + this.name);
            }
            prop = (Prop)obj.props.get(string2);
            if (prop == null) {
                return null;
            }
            if (!stringTokenizer.hasMoreTokens()) break;
            if (prop.type != 8) {
                throw new IllegalArgumentException("cannot identify the prop " + string + " in " + this.name);
            }
            obj = obj.getObjValue(prop);
        }
        return prop;
    }

    public Obj getRoot(StringBuffer stringBuffer) {
        Obj obj = this;
        while (true) {
            if (obj.getOwner() == null) {
                return obj;
            }
            Obj obj2 = obj.getOwner();
            if (obj2.getProp(obj.name) != null) {
                stringBuffer.insert(0, obj.name + ".");
                obj = obj2;
                continue;
            }
            if (!(obj2 instanceof Vect) || !obj.name.equals(((Vect)((Object)obj2)).getSubObjName())) break;
            stringBuffer.insert(0, obj2.name + ((Vect)((Object)obj2)).getSubObjs().indexOf(obj) + ".");
            obj = obj2;
        }
        return obj;
    }

    public final Obj getOwner(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        Obj obj = this;
        while (true) {
            String string2;
            Prop prop;
            if ((prop = (Prop)obj.props.get(string2 = stringTokenizer.nextToken())) == null) {
                throw new IllegalArgumentException("unknown prop " + string2 + " in " + obj.name);
            }
            if (!stringTokenizer.hasMoreTokens()) break;
            if (prop.type != 8) {
                throw new IllegalArgumentException("cannot identify the prop " + string + " in " + this.name);
            }
            obj = obj.getObjValue(prop);
        }
        return obj;
    }

    public final boolean isModified(String string) {
        Prop prop = this.getProp(string);
        if (prop == null) {
            throw new IllegalArgumentException("unknown prop " + string + " in Obj " + this.name);
        }
        return this.getOwner(string).isModified(prop);
    }

    public final boolean hasDefval(String string) {
        Prop prop = this.getProp(string);
        if (prop == null) {
            throw new IllegalArgumentException("unknown prop " + string + " in Obj " + this.name);
        }
        return prop.hasDefval();
    }

    public final boolean hasValue(String string) {
        Prop prop = this.getProp(string);
        if (prop == null) {
            throw new IllegalArgumentException("unknown prop " + string + " in Obj " + this.name);
        }
        return this.getOwner(string).hasValue(prop);
    }

    public final void resetToDef(String string) {
        Prop prop = this.getProp(string);
        if (prop == null) {
            throw new IllegalArgumentException("unknown prop " + string + " in Obj " + this.name);
        }
        this.getOwner(string).resetToDef(prop);
    }

    public final void resetAllToDef() {
        this.modified = false;
        Enumeration enumeration = this.props.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.resetToDef((Prop)this.props.get(string));
        }
    }

    public final int getIntValue(String string) {
        Prop prop = this.getProp(string);
        if (prop == null) {
            throw new IllegalArgumentException("unknown prop " + string + " in " + this.name);
        }
        return this.getOwner(string).getIntValue(prop);
    }

    public final int getFlagValue(String string) {
        Prop prop = this.getProp(string);
        if (prop == null) {
            throw new IllegalArgumentException("unknown prop " + string + " in " + this.name);
        }
        return this.getOwner(string).getFlagValue(prop);
    }

    public final void setObjValue(String string, Obj obj) {
        Prop prop = this.getProp(string);
        if (prop == null) {
            throw new IllegalArgumentException("unknown prop " + string + " in " + this.name);
        }
        this.getOwner(string).setObjValue(prop, obj);
    }

    public final void setCharsValue(String string, CharBuf charBuf) {
        Prop prop = this.getProp(string);
        if (prop == null) {
            throw new IllegalArgumentException("unknown prop " + string + " in " + this.name);
        }
        this.getOwner(string).setCharsValue(prop, charBuf);
    }

    public final void setCharsValue(String string, String string2) {
        this.setCharsValue(string, new CharBuf(string2));
    }

    public final boolean getBooleanValue(String string) {
        Prop prop = this.getProp(string);
        if (prop == null) {
            throw new IllegalArgumentException("unknown prop " + string + " in " + this.name);
        }
        return this.getOwner(string).getBooleanValue(prop);
    }

    public final Obj getObjValue(String string) {
        Prop prop = this.getProp(string);
        if (prop == null) {
            throw new IllegalArgumentException("unknown prop " + string + " in " + this.name);
        }
        return this.getOwner(string).getObjValue(prop);
    }

    public final CharBuf getCharsValue(String string) {
        Prop prop = this.getProp(string);
        if (prop == null) {
            throw new IllegalArgumentException("unknown prop " + string + " in " + this.name);
        }
        return this.getOwner(string).getCharsValue(prop);
    }

    public final void setIntValue(String string, int n) {
        Prop prop = this.getProp(string);
        if (prop == null) {
            throw new IllegalArgumentException("unknown prop " + string + " in " + this.name);
        }
        this.getOwner(string).setIntValue(prop, n);
    }

    public final void setFlagValue(String string, int n) {
        Prop prop = this.getProp(string);
        if (prop == null) {
            throw new IllegalArgumentException("unknown prop " + string + " in " + this.name);
        }
        this.getOwner(string).setFlagValue(prop, n);
    }

    public final void setBooleanValue(String string, String string2) {
        this.setBooleanValue(string, Boolean.getBoolean(string2));
    }

    public final void setBooleanValue(String string, boolean bl) {
        Prop prop = this.getProp(string);
        if (prop == null) {
            throw new IllegalArgumentException("unknown prop " + string + " in " + this.name);
        }
        this.getOwner(string).setBooleanValue(prop, bl);
    }

    public Obj shallowClone() {
        Obj obj = this.tmpl.makeInst();
        this.copyPropsTo(obj);
        return obj;
    }

    public void addToOwner() {
        Obj obj = this.getOwner();
        if (obj == null) {
            return;
        }
        if (obj instanceof DLLBufable) {
            if (obj.getProp(this.getName()) != null) {
                obj.addProp(this);
            } else {
                ((DLLBufable)((Object)obj)).add(this);
            }
        } else {
            obj.addProp(this);
        }
    }

    public Obj deepClone(DLLBufable dLLBufable, boolean bl) {
        Obj obj = this.shallowClone();
        obj.setOwner((Obj)((Object)dLLBufable));
        obj.addToOwner();
        this.copyPropsTo(obj);
        return obj;
    }

    public final Obj deepClone(DLLBufable dLLBufable) {
        return this.deepClone(dLLBufable, false);
    }

    public final Obj deepClone() {
        return this.deepClone(null);
    }

    public void copyPropsTo(Obj obj) {
        HashVector hashVector = this.getProps();
        int n = hashVector.size();
        block7: for (int i = 0; i < n; ++i) {
            String string = (String)hashVector.elementAt(i);
            Prop prop = this.getProp(string);
            switch (prop.type) {
                case 4: {
                    if (this.isModified(prop)) {
                        obj.setIntValue(prop, this.getIntValue(prop));
                        continue block7;
                    }
                    obj.resetToDef(prop);
                    continue block7;
                }
                case 2: {
                    if (this.isModified(prop)) {
                        obj.setIntValue(prop, this.getIntValue(prop));
                        if (((FlagProp)prop).flagtbl == null) continue block7;
                        obj.setFlagValue(prop, this.getFlagValue(prop));
                        continue block7;
                    }
                    obj.resetToDef(prop);
                    continue block7;
                }
                case 1: {
                    if (this.isModified(prop)) {
                        obj.setBooleanValue(prop, this.getBooleanValue(prop));
                        continue block7;
                    }
                    obj.resetToDef(prop);
                    continue block7;
                }
                case 8: {
                    if (this.isModified(prop)) {
                        obj.setObjValue(prop, this.getObjValue(prop).deepClone());
                        continue block7;
                    }
                    obj.resetToDef(prop);
                    continue block7;
                }
                case 16: {
                    if (this.isModified(prop)) {
                        obj.setCharsValue(prop, (CharBuf)this.getCharsValue(prop).clone());
                        continue block7;
                    }
                    obj.resetToDef(prop);
                }
            }
        }
        obj.modified = this.modified;
    }

    public void addProp(KwdToken kwdToken) {
        Prop prop = this.getProp(kwdToken.getName());
        if (prop == null) {
            throw new IllegalArgumentException("add unknown KwdToken " + kwdToken.image + " to Obj " + this.name);
        }
        switch (prop.type) {
            case 4: {
                this.setIntValue(prop, kwdToken.param);
                this.setModified(prop);
                break;
            }
            case 2: {
                FlagProp flagProp = (FlagProp)prop;
                if (flagProp.flagtbl != null) {
                    int n = flagProp.flagtbl.getId(kwdToken.getImg());
                    this.setIntValue(prop, n);
                } else {
                    this.setIntValue(prop, 1);
                }
                if (kwdToken.hasParam) {
                    this.setFlagValue(prop, kwdToken.param);
                }
                this.setModified(prop);
                break;
            }
            case 1: {
                if (kwdToken.hasParam) {
                    this.setBooleanValue(prop, kwdToken.param != 0);
                } else {
                    this.setBooleanValue(prop, true);
                }
                this.setModified(prop);
                break;
            }
            default: {
                throw new IllegalArgumentException("cannot add KwdToken " + kwdToken.image + " to Obj " + this.name);
            }
        }
    }

    public void addProp(Obj obj) {
        Prop prop = this.getProp(obj.name);
        if (prop == null) {
            throw new IllegalArgumentException("unknown Obj prop " + obj.name + " in " + this.name);
        }
        switch (prop.type) {
            case 4: {
                this.setIntValue(prop, obj.getIntValue(obj.name));
                break;
            }
            case 16: {
                this.setCharsValue(prop, obj.getCharsValue(obj.name));
                break;
            }
            case 8: {
                this.setObjValue(prop, obj);
                break;
            }
            default: {
                throw new IllegalArgumentException("cannot add Obj " + obj.name + " to Obj " + this.name);
            }
        }
    }

    public void addProp(Pcdata pcdata) {
        if (this.tmpl.nonDestCharsProp == null) {
            throw new IllegalArgumentException("cannot add chars " + pcdata + " to Obj " + this.name);
        }
        this.setCharsValue(this.tmpl.nonDestCharsProp, pcdata.toCharBuf());
    }

    public void setOwner(Obj obj) {
        this.owner = obj;
    }

    public Obj getOwner() {
        return this.owner;
    }

    public final String getName() {
        return this.name;
    }

    public final String getMappingName() {
        return this.mappingName;
    }

    public final boolean isModified() {
        return this.modified;
    }

    public final void setModified() {
        Obj obj;
        this.modified = true;
        Obj obj2 = this;
        while ((obj = obj2.getOwner()) != null && (!(obj instanceof DLLBufable) || obj.hasProp(obj2.getName()))) {
            obj.modified = true;
            if (obj.getProp(obj2.getName()) != null) {
                obj.setModified(obj.getProp(obj2.getName()));
            }
            obj2 = obj;
        }
    }

    public void resetToDef() {
        this.modified = false;
        Enumeration enumeration = this.props.keys();
        while (enumeration.hasMoreElements()) {
            Prop prop = (Prop)this.props.get(enumeration.nextElement());
            this.resetToDef(prop);
        }
    }

    public CharBuf getText() {
        return new CharBuf();
    }

    public void toRTF(DataOutputStream dataOutputStream) throws IOException {
        if (this.isObj("colordef")) {
            this.propsToRTF(dataOutputStream);
            dataOutputStream.write(59);
        } else if (this.isObj("fontinfo")) {
            dataOutputStream.write(123);
            this.propsToRTF(dataOutputStream);
            dataOutputStream.write(125);
        } else {
            this.propsToRTF(dataOutputStream);
        }
    }

    final CharBuf getRtfCharsValue(Prop prop) {
        int n;
        CharBuf charBuf = (CharBuf)this.getCharsValue(prop).clone();
        for (int i = n = charBuf.size() - 1; i >= 0; --i) {
            char c = charBuf.charAt(i);
            if (c == '{' || c == '}' || c == '\\') {
                charBuf.insert('\\', i);
                continue;
            }
            if (c > '\u00ff') {
                charBuf.replace(' ', i);
                charBuf.insert("\\u" + c, i);
                continue;
            }
            if (this.B(c)) continue;
            charBuf.replace(' ', i);
            charBuf.insert("\\uc0\\u" + c, i);
        }
        return charBuf;
    }

    void propsToRTF(DataOutputStream dataOutputStream) throws IOException {
        Enumeration enumeration = this.props.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Prop prop = (Prop)this.props.get(string);
            this.propToRTF(prop, dataOutputStream);
        }
    }

    void propToRTF(Prop prop, DataOutputStream dataOutputStream) throws IOException {
        if (!this.isModified(prop)) {
            return;
        }
        int n = 0;
        switch (prop.type) {
            case 1: {
                dataOutputStream.write(92);
                if (this.getBooleanValue(prop)) {
                    ToggleProp toggleProp = (ToggleProp)prop;
                    dataOutputStream.writeBytes(toggleProp.getName());
                }
                dataOutputStream.write(32);
                break;
            }
            case 2: {
                dataOutputStream.write(92);
                FlagProp flagProp = (FlagProp)prop;
                n = this.getFlagValue(flagProp);
                if (flagProp.flagtbl != null) {
                    dataOutputStream.writeBytes(flagProp.flagtbl.getKwd(this.getIntValue(flagProp)));
                } else {
                    dataOutputStream.writeBytes(flagProp.getName());
                }
                if (n != 0) {
                    dataOutputStream.writeBytes("" + n);
                }
                dataOutputStream.write(32);
                break;
            }
            case 8: {
                this.objPropToRTF((ObjProp)prop, dataOutputStream);
                break;
            }
            case 4: {
                dataOutputStream.write(92);
                ValueProp valueProp = (ValueProp)prop;
                dataOutputStream.writeBytes(valueProp.getName());
                dataOutputStream.writeBytes("" + this.getIntValue(valueProp));
                dataOutputStream.write(32);
                break;
            }
            case 16: {
                CharsProp charsProp = (CharsProp)prop;
                dataOutputStream.write(this.getRtfCharsValue(charsProp).toByteArray());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown prop " + prop + " in " + this.getName());
            }
        }
    }

    void objPropToRTF(ObjProp objProp, DataOutputStream dataOutputStream) throws IOException {
        Obj obj = this.getObjValue(objProp);
        if (obj != null && (obj instanceof DLLBufable && ((DLLBufable)((Object)obj)).isAdded() || obj.isModified())) {
            obj.toRTF(dataOutputStream);
        }
    }

    public void dump(int n) {
        this.dump(n, false);
    }

    public void dump(int n, boolean bl) {
    }

    public void dumpProp(int n) {
    }

    public static void outIndent(int n) {
    }

    @Override
    public DblLinkable getNext() {
        return this.next;
    }

    @Override
    public DblLinkable getPrev() {
        return this.prev;
    }

    @Override
    public void setNext(DblLinkable dblLinkable) {
        this.next = dblLinkable;
    }

    @Override
    public void setPrev(DblLinkable dblLinkable) {
        this.prev = dblLinkable;
    }

    @Override
    public boolean isTail() {
        return this.next == null;
    }

    @Override
    public boolean isHead() {
        return this.prev == null;
    }

    public Obj getNextLeaf() {
        if (this.isObj("kwd") || this.isObj("chr")) {
            Obj obj = this;
            if (obj.getNext() != null) {
                return (Obj)obj.getNext();
            }
            do {
                if ((obj = obj.getOwner()) != null) continue;
                return null;
            } while (obj.getNext() == null);
            obj = (Obj)obj.getNext();
            while (true) {
                if (obj.isObj("chr") || obj.isObj("kwd")) {
                    return obj;
                }
                obj = (Obj)((DLLBufable)((Object)obj)).getHead();
            }
        }
        throw new IllegalArgumentException("Not a leaf node");
    }

    public Obj getPrevLeaf() {
        if (this.isObj("kwd") || this.isObj("chr")) {
            Obj obj = this;
            if (obj.getPrev() != null) {
                return (Obj)obj.getPrev();
            }
            do {
                if ((obj = obj.getOwner()) != null) continue;
                return null;
            } while (obj.getPrev() == null);
            obj = (Obj)obj.getPrev();
            while (true) {
                if (obj.isObj("chr") || obj.isObj("kwd")) {
                    return obj;
                }
                obj = (Obj)((DLLBufable)((Object)obj)).getTail();
            }
        }
        throw new IllegalArgumentException("Not a leaf node");
    }

    public int getTextSize() {
        throw new Assertion("cannot support method in obj:" + this.getName());
    }

    public String getPropValue(String string, RtfDest rtfDest) {
        if (!(this.hasValue(string) || string.equals("f") || string.endsWith(".f") || string.equals("cb") || string.endsWith(".cb") || string.equals("docbk") || string.endsWith(".docbk"))) {
            return "";
        }
        Prop prop = this.getProp(string);
        switch (prop.type) {
            case 2: {
                if (((FlagProp)prop).flagtbl != null) {
                    return ((FlagProp)prop).flagtbl.getMappingName(this.getIntValue(string));
                }
                int n = this.getIntValue(string);
                if (n == 0) {
                    return "off";
                }
                if (n == 1) {
                    return "on";
                }
                return "";
            }
            case 4: {
                switch (prop.getInspType()) {
                    case 1003: {
                        Vect vect = (Vect)((Object)rtfDest.getObjValue("colortbl"));
                        int n = 0;
                        if (this.hasValue(string)) {
                            n = this.getIntValue(string);
                        }
                        if (n == -1) {
                            return MiscTools.mapColorToString(null);
                        }
                        Obj obj = vect.getSubProp(n);
                        return MiscTools.mapColorToString(new Color(obj.getIntValue("red"), obj.getIntValue("green"), obj.getIntValue("blue")));
                    }
                    case 1002: {
                        ChrMtrcTmpl chrMtrcTmpl = rtfDest.chrMtrcTmpl;
                        return chrMtrcTmpl.getFontName(this.hasValue(string) ? this.getIntValue(string) : rtfDest.getIntValue("deff"));
                    }
                    case 1004: {
                        return "";
                    }
                    case 7873: {
                        int n = this.getIntValue(string);
                        int n2 = this.getIntValue("slmult");
                        if (n2 == 1) {
                            String string2 = ((ValueProp)prop).valuetbl.getMappingName(this.getIntValue(string));
                            if (string2 != null) {
                                return string2;
                            }
                            float f = (float)n / 240.0f;
                            f = (float)Math.round(f * 100.0f) / 100.0f;
                            return String.valueOf(f);
                        }
                        B.error("wrong value of slmult: " + n2, new IllegalArgumentException("wrong value of slmult: " + n2));
                        return "Single";
                    }
                }
                if (((ValueProp)prop).valuetbl != null) {
                    return ((ValueProp)prop).valuetbl.getMappingName(this.getIntValue(string));
                }
                return "" + this.getIntValue(string) / ((ValueProp)prop).getAdjFactor();
            }
            case 1: {
                return "" + this.getBooleanValue(string);
            }
            case 8: {
                return "";
            }
            case 16: {
                return this.getCharsValue(string).toString();
            }
        }
        return null;
    }

    RtfDest getRtfRoot() {
        Obj obj = this;
        while (obj != null) {
            if (obj.isObj("rtf")) {
                return (RtfDest)obj;
            }
            obj = obj.getOwner();
        }
        return null;
    }

    public boolean setPropValue(String string, String string2, RtfDest rtfDest) {
        Prop prop = this.getProp(string);
        int n = prop.getOrgValue(string2);
        block4 : switch (prop.type) {
            case 1: {
                switch (n) {
                    case 0: {
                        this.setBooleanValue(string, false);
                        break block4;
                    }
                    case 1: {
                        this.setBooleanValue(string, true);
                        break block4;
                    }
                }
                return false;
            }
            case 4: {
                switch (prop.getInspType()) {
                    case 1002: {
                        try {
                            this.setIntValue(string, rtfDest.chrMtrcTmpl.getFontNum(string2, 8));
                            break block4;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return false;
                        }
                    }
                    case 1004: {
                        break block4;
                    }
                    case 1003: {
                        try {
                            Color color = MiscTools.mapStringToColor(string2);
                            int n2 = 0;
                            n2 = color == null ? (string.endsWith("cb") || string.endsWith("docbk") ? -1 : rtfDest.chrMtrcTmpl.getColorIndex(Color.black)) : rtfDest.chrMtrcTmpl.getColorIndex(color);
                            this.setIntValue(string, n2);
                            break block4;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return false;
                        }
                    }
                }
                if (n > -1) {
                    this.setIntValue(string, n);
                    break;
                }
                try {
                    int n3 = Integer.parseInt(string2);
                    this.setIntValue(string, n3 * ((ValueProp)prop).getAdjFactor());
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            case 2: {
                if (n > -1) {
                    this.setIntValue(string, n);
                    break;
                }
                try {
                    int n4 = Integer.parseInt(string2);
                    if (n4 != 0 && n4 != 1) {
                        return false;
                    }
                    this.setIntValue(string, n4);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            case 8: 
            case 16: {
                this.setCharsValue(string, string2);
                break;
            }
        }
        Obj obj = this;
        if (obj.notAddToProp) {
            Obj obj2 = obj.getOwner();
            obj2.setObjValue(obj.getName(), obj);
            obj = obj2;
        }
        return true;
    }

    public String toString() {
        return this.getHashName();
    }

    public String getHashName() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return this.getName() + "@" + this.hashCode();
    }

    public HashVector getTextObjProps() {
        HashVector hashVector = this.getProps();
        int n = hashVector.size();
        HashVector<String, Object> hashVector2 = new HashVector<String, Object>(n);
        for (int i = 0; i < n; ++i) {
            String string = (String)hashVector.get(i);
            Prop prop = (Prop)hashVector.get(string);
            Object object = this.getPropValue(prop);
            if (object == null) continue;
            hashVector2.put(prop.mappingName, object);
        }
        return hashVector2;
    }

    protected Object getPropValue(Prop prop) {
        Object object = null;
        if (prop != null) {
            try {
                switch (prop.type) {
                    case 2: 
                    case 4: {
                        object = new Integer(this.getIntValue(prop));
                        break;
                    }
                    case 16: {
                        object = this.getCharsValue(prop);
                        break;
                    }
                    case 8: {
                        object = this.getObjValue(prop);
                        break;
                    }
                    case 1: {
                        object = new Boolean(this.getBooleanValue(prop));
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
        }
        return object;
    }

    public Object getPropValue(String string) {
        Prop prop = this.getProp(string);
        if (prop == null) {
            return null;
        }
        return this.getPropValue(prop);
    }

    private boolean B(char c) {
        char c2 = c;
        return c2 >= ' ' && c2 <= '~';
    }

    public void mapFontsAndColors(int[] nArray, IntKeyHashtable intKeyHashtable, int n) {
        Obj obj = this.getObjValue("chrfmt");
        if (obj == null) {
            return;
        }
        if (obj.hasValue("f")) {
            obj.setIntValue("f", (int)((Integer)intKeyHashtable.get(obj.getIntValue("f"))));
        } else if (n != -1) {
            obj.setIntValue("f", n);
        }
        if (obj.hasValue("cf") && obj.getIntValue("cf") > -1) {
            obj.setIntValue("cf", nArray[obj.getIntValue("cf")]);
        }
        if (obj.hasValue("cb") && obj.getIntValue("cb") > -1) {
            obj.setIntValue("cb", nArray[obj.getIntValue("cb")]);
        }
    }
}

