/*
 * Decompiled with CFR 0.152.
 */
package jet.textobj;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import jet.textobj.ByteFromCharBufStream;
import jet.textobj.DLLBufable;
import jet.textobj.Dest;
import jet.textobj.Obj;
import jet.textobj.WmfBuff;
import jet.util.CharBuf;

public class PictDest
extends Dest {
    Image img = null;
    int x;
    int y;
    int width;
    int height;
    int bmppos = 0;
    int pos = 0;

    public PictDest() {
    }

    public PictDest(Image image) {
        this.img = image;
    }

    @Override
    public Obj deepClone(DLLBufable dLLBufable, boolean bl) {
        PictDest pictDest = (PictDest)super.deepClone(dLLBufable, bl);
        pictDest.x = this.x;
        pictDest.y = this.y;
        pictDest.width = this.width;
        pictDest.height = this.height;
        pictDest.img = this.img;
        this.copyPropsTo(pictDest);
        return pictDest;
    }

    public void parseWmf() {
        CharBuf charBuf = this.getCharsValue("data");
        ByteFromCharBufStream byteFromCharBufStream = new ByteFromCharBufStream(charBuf);
        WmfBuff wmfBuff = new WmfBuff(byteFromCharBufStream);
        this.img = Toolkit.getDefaultToolkit().createImage(wmfBuff.getMemImgSrc());
        this.setPictBounds(wmfBuff.getDestX(), wmfBuff.getDestY(), wmfBuff.getDestWidth(), wmfBuff.getDestHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseJpegPng() {
        CharBuf charBuf = this.getCharsValue("data");
        char[] cArray = charBuf.toCharArray();
        byte[] byArray = new byte[cArray.length / 2];
        int n = 0;
        int n2 = 0;
        while (n2 + 1 < cArray.length) {
            byArray[n++] = (byte)(this.SEDU(cArray[n2]) << 4 & 0xFF | this.SEDU(cArray[n2 + 1]));
            n2 += 2;
        }
        ImageInputStream imageInputStream = null;
        try {
            imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(byArray));
            this.img = ImageIO.read(imageInputStream);
            this.setPictBounds(0, 0, this.img.getWidth(null), this.img.getHeight(null));
        }
        catch (IOException iOException) {
            this.img = null;
        }
        catch (NullPointerException nullPointerException) {
            this.img = null;
        }
        finally {
            if (imageInputStream != null) {
                try {
                    imageInputStream.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    imageInputStream = null;
                }
            }
        }
    }

    private int SEDU(char c) {
        if (c <= '9' && c >= '0') {
            return c - 48;
        }
        if (c <= 'F' && c >= 'A') {
            return c - 65 + 10;
        }
        if (c <= 'f' && c >= 'a') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException(c + " is not Hex-charactor('0' ~ 'F')");
    }

    public void setPictBounds(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        if (!this.hasValue("picscalex")) {
            this.setIntValue("picscalex", 100);
        }
        if (!this.hasValue("picscaley")) {
            this.setIntValue("picscaley", 100);
        }
        if (!this.hasValue("picwgoal")) {
            this.setIntValue("picwgoal", n3 * 1440 / 96);
        }
        if (!this.hasValue("pichgoal")) {
            this.setIntValue("pichgoal", n4 * 1440 / 96);
        }
    }

    public void setPictBounds(Rectangle rectangle) {
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
        if (!this.hasValue("picscalex")) {
            this.setIntValue("picscalex", 100);
        }
        if (!this.hasValue("picscaley")) {
            this.setIntValue("picscaley", 100);
        }
        if (!this.hasValue("picwgoal")) {
            this.setIntValue("picwgoal", rectangle.width * 1440 / 96);
        }
        if (!this.hasValue("pichgoal")) {
            this.setIntValue("pichgoal", rectangle.height * 1440 / 96);
        }
    }

    public Image getImg() {
        return this.img;
    }

    public void setImg(Image image) {
        this.img = image;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void copyPropsTo(PictDest pictDest) {
        pictDest.setIntValue("picwgoal", this.getIntValue("picwgoal"));
        pictDest.setIntValue("pichgoal", this.getIntValue("pichgoal"));
        pictDest.setIntValue("picscalex", this.getIntValue("picscalex"));
        pictDest.setIntValue("picscaley", this.getIntValue("picscaley"));
    }

    public void setPicwgoal(int n) {
        this.width = n;
        this.setIntValue("picwgoal", n);
    }

    public void setPichgoal(int n) {
        this.height = n;
        this.setIntValue("pichgoal", n);
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public char[] imageToBitmap() {
        int n = this.width;
        int n2 = this.height;
        int n3 = n * 3;
        int n4 = n3 % 4 == 0 ? n3 : (n3 + 3) / 4 * 4;
        int n5 = n4 - n3;
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(this.img, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            // empty if block
        }
        int n6 = n * n2 * 3 + 54 + n2 * n5;
        int n7 = 54;
        char[] cArray = new char[n6];
        this.bmppos = 0;
        this.getCharsValue((byte)66, cArray);
        this.getCharsValue((byte)77, cArray);
        this.getDestHeight(n6, cArray);
        this.getDefaultToolkit((short)0, cArray);
        this.getDefaultToolkit((short)0, cArray);
        this.getDestHeight(n7, cArray);
        int n8 = 40;
        int n9 = n;
        int n10 = n2;
        short s = 1;
        short s2 = 24;
        int n11 = 0;
        int n12 = n6 - 54;
        int n13 = 3780;
        int n14 = 3780;
        int n15 = 0;
        int n16 = 0;
        this.getDestHeight(n8, cArray);
        this.getDestHeight(n9, cArray);
        this.getDestHeight(n10, cArray);
        this.getDefaultToolkit(s, cArray);
        this.getDefaultToolkit(s2, cArray);
        this.getDestHeight(n11, cArray);
        this.getDestHeight(n12, cArray);
        this.getDestHeight(n13, cArray);
        this.getDestHeight(n14, cArray);
        this.getDestHeight(n15, cArray);
        this.getDestHeight(n16, cArray);
        for (int i = n2 - 1; i >= 0; --i) {
            int n17;
            for (n17 = 0; n17 < n; ++n17) {
                int n18 = nArray[i * n + n17] >> 16 & 0xFF;
                int n19 = nArray[i * n + n17] >> 8 & 0xFF;
                int n20 = nArray[i * n + n17] & 0xFF;
                this.getCharsValue((byte)n20, cArray);
                this.getCharsValue((byte)n19, cArray);
                this.getCharsValue((byte)n18, cArray);
            }
            for (n17 = 0; n17 < n5; ++n17) {
                this.getCharsValue((byte)0, cArray);
            }
        }
        return cArray;
    }

    public char[] bitmapToWmfAscCharBuf(char[] cArray) {
        int n;
        this.bmppos = 0;
        this.deepClone(cArray);
        int n2 = this.freeMemory(cArray);
        this.deepClone(cArray);
        this.deepClone(cArray);
        this.freeMemory(cArray);
        this.freeMemory(cArray);
        int n3 = this.freeMemory(cArray);
        int n4 = this.freeMemory(cArray);
        this.deepClone(cArray);
        this.deepClone(cArray);
        this.freeMemory(cArray);
        this.freeMemory(cArray);
        this.freeMemory(cArray);
        this.freeMemory(cArray);
        this.freeMemory(cArray);
        this.freeMemory(cArray);
        char[] cArray2 = new char[2 * (cArray.length + 60)];
        this.pos = 0;
        short s = 3907;
        short s2 = 1;
        short s3 = 9;
        short s4 = 768;
        int n5 = (n2 + 60) / 2;
        short s5 = 1;
        int n6 = (n2 + 14) / 2;
        short s6 = 0;
        long l = Runtime.getRuntime().freeMemory();
        if ((long)cArray2.length > l) {
            cArray2 = new char[]{};
            return cArray2;
        }
        this.copyPropsTo(s2, cArray2);
        this.copyPropsTo(s3, cArray2);
        this.copyPropsTo(s4, cArray2);
        this.createImage(n5, cArray2);
        this.copyPropsTo(s5, cArray2);
        this.createImage(n6, cArray2);
        this.copyPropsTo(s6, cArray2);
        this.createImage(n6, cArray2);
        this.copyPropsTo(s, cArray2);
        int n7 = 0xCC0020;
        short s7 = 0;
        short s8 = (short)n4;
        short s9 = (short)n3;
        short s10 = 0;
        short s11 = 0;
        short s12 = (short)n4;
        short s13 = (short)n3;
        short s14 = 0;
        short s15 = 0;
        this.createImage(n7, cArray2);
        this.copyPropsTo(s7, cArray2);
        this.copyPropsTo(s8, cArray2);
        this.copyPropsTo(s9, cArray2);
        this.copyPropsTo(s10, cArray2);
        this.copyPropsTo(s11, cArray2);
        this.copyPropsTo(s12, cArray2);
        this.copyPropsTo(s13, cArray2);
        this.copyPropsTo(s14, cArray2);
        this.copyPropsTo(s15, cArray2);
        this.bmppos = 0;
        for (n = 0; n < 14; ++n) {
            this.createImageInputStream(cArray);
        }
        for (n = 14; n < cArray.length; ++n) {
            this.close((byte)this.createImageInputStream(cArray), cArray2);
        }
        this.close((byte)3, cArray2);
        for (n = 0; n < 5; ++n) {
            this.close((byte)0, cArray2);
        }
        return cArray2;
    }

    public char[] bitmapToWmfAscCharBuf(String string) throws IOException {
        int n;
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        long l = randomAccessFile.length();
        this.getDestX(randomAccessFile);
        int n2 = this.getDestY(randomAccessFile);
        this.getDestX(randomAccessFile);
        this.getDestX(randomAccessFile);
        this.getDestY(randomAccessFile);
        this.getDestY(randomAccessFile);
        int n3 = this.getDestY(randomAccessFile);
        int n4 = this.getDestY(randomAccessFile);
        this.getDestX(randomAccessFile);
        this.getDestX(randomAccessFile);
        this.getDestY(randomAccessFile);
        this.getDestY(randomAccessFile);
        this.getDestY(randomAccessFile);
        this.getDestY(randomAccessFile);
        this.getDestY(randomAccessFile);
        this.getDestY(randomAccessFile);
        short s = 3907;
        short s2 = 1;
        short s3 = 9;
        short s4 = 768;
        int n5 = (n2 + 60) / 2;
        short s5 = 1;
        int n6 = (n2 + 14) / 2;
        short s6 = 0;
        char[] cArray = new char[2 * (n2 + 60)];
        this.pos = 0;
        this.copyPropsTo(s2, cArray);
        this.copyPropsTo(s3, cArray);
        this.copyPropsTo(s4, cArray);
        this.createImage(n5, cArray);
        this.copyPropsTo(s5, cArray);
        this.createImage(n6, cArray);
        this.copyPropsTo(s6, cArray);
        this.createImage(n6, cArray);
        this.copyPropsTo(s, cArray);
        int n7 = 0xCC0020;
        short s7 = 0;
        short s8 = (short)n4;
        short s9 = (short)n3;
        short s10 = 0;
        short s11 = 0;
        short s12 = (short)n4;
        short s13 = (short)n3;
        short s14 = 0;
        short s15 = 0;
        this.createImage(n7, cArray);
        this.copyPropsTo(s7, cArray);
        this.copyPropsTo(s8, cArray);
        this.copyPropsTo(s9, cArray);
        this.copyPropsTo(s10, cArray);
        this.copyPropsTo(s11, cArray);
        this.copyPropsTo(s12, cArray);
        this.copyPropsTo(s13, cArray);
        this.copyPropsTo(s14, cArray);
        this.copyPropsTo(s15, cArray);
        randomAccessFile.seek(0L);
        for (n = 0; n < 14; ++n) {
            this.getDestWidth(randomAccessFile);
        }
        n = 14;
        while ((long)n < l) {
            this.close((byte)this.getDestWidth(randomAccessFile), cArray);
            ++n;
        }
        this.close((byte)3, cArray);
        for (n = 0; n < 5; ++n) {
            this.close((byte)0, cArray);
        }
        randomAccessFile.close();
        return cArray;
    }

    private byte append(byte by, int n) {
        int n2 = 0;
        if (n == 1) {
            n2 = by & 0xF;
        } else if (n == 2) {
            n2 = (by & 0xF0) >>> 4;
        }
        return this.bmppos((byte)n2);
    }

    private byte bmppos(byte by) {
        if (by <= 9 && by >= 0) {
            return (byte)(by + 48);
        }
        return (byte)(by + 97 - 10);
    }

    private void close(byte by, char[] cArray) {
        for (int i = 2; i > 0; --i) {
            cArray[this.pos++] = (char)this.append(by, i);
        }
    }

    private void copyPropsTo(short s, char[] cArray) {
        this.close((byte)(s & 0xFF), cArray);
        this.close((byte)((s & 0xFF00) >> 8), cArray);
    }

    private void createImage(int n, char[] cArray) {
        this.close((byte)(n & 0xFF), cArray);
        this.close((byte)((n & 0xFF00) >> 8), cArray);
        this.close((byte)((n & 0xFF0000) >> 16), cArray);
        this.close((byte)((n & 0xFF000000) >> 24), cArray);
    }

    private int createImageInputStream(char[] cArray) {
        return cArray[this.bmppos++];
    }

    private int deepClone(char[] cArray) {
        int n = this.createImageInputStream(cArray);
        int n2 = this.createImageInputStream(cArray);
        return n2 << 8 | n;
    }

    private int freeMemory(char[] cArray) {
        int n = this.createImageInputStream(cArray);
        int n2 = this.createImageInputStream(cArray);
        int n3 = this.createImageInputStream(cArray);
        int n4 = this.createImageInputStream(cArray);
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    private void getCharsValue(byte by, char[] cArray) {
        cArray[this.pos++] = (char)by;
    }

    private void getDefaultToolkit(short s, char[] cArray) {
        this.getCharsValue((byte)(s & 0xFF), cArray);
        this.getCharsValue((byte)((s & 0xFF00) >> 8), cArray);
    }

    private void getDestHeight(int n, char[] cArray) {
        this.getCharsValue((byte)(n & 0xFF), cArray);
        this.getCharsValue((byte)((n & 0xFF00) >> 8), cArray);
        this.getCharsValue((byte)((n & 0xFF0000) >> 16), cArray);
        this.getCharsValue((byte)((n & 0xFF000000) >> 24), cArray);
    }

    private int getDestWidth(RandomAccessFile randomAccessFile) throws IOException {
        return randomAccessFile.readUnsignedByte();
    }

    private int getDestX(RandomAccessFile randomAccessFile) throws IOException {
        int n = this.getDestWidth(randomAccessFile);
        int n2 = this.getDestWidth(randomAccessFile);
        return n2 << 8 | n;
    }

    private int getDestY(RandomAccessFile randomAccessFile) throws IOException {
        int n = this.getDestWidth(randomAccessFile);
        int n2 = this.getDestWidth(randomAccessFile);
        int n3 = this.getDestWidth(randomAccessFile);
        int n4 = this.getDestWidth(randomAccessFile);
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    private void getHeight(byte by, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeByte(by);
    }

    private void getIntValue(short s, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeByte((byte)(s & 0xFF));
        randomAccessFile.writeByte((byte)((s & 0xFF00) >> 8));
    }

    private void getMemImgSrc(int n, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeByte((byte)(n & 0xFF));
        randomAccessFile.writeByte((byte)((n & 0xFF00) >> 8));
        randomAccessFile.writeByte((byte)((n & 0xFF0000) >> 16));
        randomAccessFile.writeByte((byte)((n & 0xFF000000) >> 24));
    }
}

