/*
 * Decompiled with CFR 0.152.
 */
package jet.textobj.rtf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import jet.log.JRLogger;
import jet.textobj.ChrObj;
import jet.textobj.DLLBufable;
import jet.textobj.DocObj;
import jet.textobj.Field;
import jet.textobj.FieldDest;
import jet.textobj.KwdObj;
import jet.textobj.NormalFieldImpl;
import jet.textobj.Obj;
import jet.textobj.ObjTmpl;
import jet.textobj.ParObj;
import jet.textobj.PictDest;
import jet.textobj.RtfDest;
import jet.textobj.SecObj;
import jet.textobj.Vect;
import jet.textobj.rtf.ASCII_CharStream;
import jet.textobj.rtf.KwdToken;
import jet.textobj.rtf.ParseException;
import jet.textobj.rtf.Pcdata;
import jet.textobj.rtf.RTFLexer;
import jet.textobj.rtf.RTFParserConstants;
import jet.textobj.rtf.RTFRawLexerTokenManager;
import jet.textobj.rtf.Token;
import jet.textobj.rtf.TokenManager;
import jet.util.CharBuf;
import jet.util.ObjBuf;

public class RTFParser
implements RTFParserConstants {
    public int version = 10;
    String filename;
    private static JRLogger SEDU = JRLogger.getLogger(RTFParser.class.getName());
    Vector argsForParseFieldDest;
    boolean isIgnore;
    RtfDest curRtf = null;
    DocObj curDoc = null;
    ParObj curPar = null;
    SecObj curSec = null;
    ChrObj curChr = null;
    Obj curDest = null;
    Obj curObj = null;
    Obj curTabdef = null;
    Stack grpstk = new Stack();
    Stack deststk = new Stack();
    Vector flddests = null;
    public TokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int add;
    private Token addElement;
    private Token addFieldDest;
    private int addProp;
    public boolean lookingAhead = false;
    private boolean addToOwner;
    private int adjustyKwdTokenKind;
    private final int[] append = new int[8];
    private final int[] arg = new int[]{6, 206, 198, 8, 206, 64, 66, 256};
    private final JJCalls[] bdata = new JJCalls[4];
    private boolean beginDest = false;
    private int body = 0;
    private Vector colordef = new Vector();
    private int[] dest;
    private int dispatchCharKwd = -1;
    private int[] dispatchPropKwd = new int[100];
    private int dispatchSpecKwd;

    public RTFParser(File file, Vector vector) throws FileNotFoundException {
        this(new FileInputStream(file), vector);
        this.filename = file.getPath();
    }

    public RTFParser(String string, Vector vector) throws FileNotFoundException {
        this(new FileInputStream(string), vector);
        this.filename = string;
    }

    public RTFParser(InputStream inputStream, Vector vector) {
        this(new RTFLexer(new RTFRawLexerTokenManager(new ASCII_CharStream(inputStream, 1, 1))));
        this.argsForParseFieldDest = vector;
        ((RTFLexer)this.token_source).parser = this;
    }

    private final void SEDU(boolean bl) {
        this.isIgnore = bl;
        Token token = this.token;
        while (token != null) {
            if (token instanceof KwdToken) {
                ((RTFLexer)this.token_source).adjustyKwdTokenKind((KwdToken)token);
            }
            token = token.next;
        }
    }

    public RtfDest rtf() throws ParseException {
        this.SEDU(true);
        if (this.flddests == null) {
            this.flddests = new Vector();
        } else {
            this.flddests.removeAllElements();
        }
        this.dest();
        this.curRtf.init();
        if (this.flddests.size() != 0) {
            for (int i = 0; i < this.flddests.size(); ++i) {
                FieldDest fieldDest = (FieldDest)this.flddests.elementAt(i);
                ChrObj chrObj = (ChrObj)fieldDest.getOwner();
                ParObj parObj = (ParObj)chrObj.getOwner();
                int n = parObj.indexOf(chrObj);
                NormalFieldImpl.mergeFieldDestContents(fieldDest);
                Field field = FieldDest.getFieldImpl().parseFieldDest(fieldDest, this.curRtf, this.argsForParseFieldDest);
                this.curRtf.addFieldDest(fieldDest);
                fieldDest.setField(field);
                chrObj.remove(fieldDest);
                parObj.remove(chrObj);
                fieldDest.insertTextToRtf(parObj, n);
            }
        }
        this.curRtf.setVersion(this.version);
        return this.curRtf;
    }

    final Obj getChrfmt() {
        return this.curChr.getObjValue("chrfmt");
    }

    final Obj getParfmt() {
        return this.curPar.getObjValue("parfmt");
    }

    final Obj getSecfmt() {
        return this.curSec.getObjValue("secfmt");
    }

    final Obj getDocfmt() {
        return this.curDoc.getObjValue("docfmt");
    }

    final Obj makeKwdObj(KwdToken kwdToken) {
        KwdObj kwdObj = (KwdObj)ObjTmpl.makeInst("kwd");
        kwdObj.setCharsValue("img", kwdToken.getImg());
        kwdObj.setBooleanValue("hasparam", kwdToken.hasParam);
        if (kwdToken.hasParam) {
            kwdObj.setIntValue("param", kwdToken.param);
        }
        if (kwdToken.bdata != null) {
            kwdObj.setCharsValue("bdata", new CharBuf(kwdToken.bdata));
        }
        kwdObj.addProp(this.getSecfmt().shallowClone());
        kwdObj.addProp(this.getParfmt().shallowClone());
        kwdObj.addProp(this.getChrfmt().shallowClone());
        return kwdObj;
    }

    final Obj makeCharsObj(Pcdata pcdata) {
        Obj obj = ObjTmpl.makeInst("chars");
        obj.setCharsValue("chars", pcdata.toCharBuf());
        return obj;
    }

    final Obj makeCharsObj(String string) {
        Obj obj = ObjTmpl.makeInst("chars");
        obj.setCharsValue("chars", new CharBuf(string));
        return obj;
    }

    void pushForGroup() {
        this.grpstk.push(this.getChrfmt().shallowClone());
        ChrObj chrObj = this.curChr;
        if (this.curChr.isAdded()) {
            this.addToOwner(this.curChr);
            this.curChr = (ChrObj)this.curChr.shallowClone();
            this.curChr.setOwner(chrObj.getOwner());
        }
    }

    void popForGroup() {
        ChrObj chrObj = this.curChr;
        if (this.curChr.isAdded()) {
            this.addToOwner(this.curChr);
            this.curChr = (ChrObj)ObjTmpl.makeInst("chr");
            this.curChr.setOwner(chrObj.getOwner());
        }
        this.curChr.setObjValue("chrfmt", (Obj)this.grpstk.pop());
    }

    void beginDest(KwdToken kwdToken) throws ParseException {
        Obj obj = ObjTmpl.makeInst(kwdToken.getName());
        if (obj.isObj("pict")) {
            ChrObj chrObj = this.curChr;
            if (this.curChr.isAdded()) {
                this.addToOwner(this.curChr);
                this.curChr = (ChrObj)this.curChr.shallowClone();
                this.curChr.setOwner(chrObj.getOwner());
            }
        }
        if (!obj.isObj("shppict")) {
            this.setOwner(kwdToken.getOwner(), obj);
        }
        if (obj.isObj("rtf")) {
            this.version = kwdToken.param;
            this.curDest = obj;
            this.curRtf = (RtfDest)this.curDest;
            this.curDoc = (DocObj)ObjTmpl.makeInst("doc");
            this.curDoc.setOwner(this.curRtf);
            this.curSec = (SecObj)ObjTmpl.makeInst("sec");
            this.curSec.setOwner(this.curDoc);
            this.curPar = (ParObj)ObjTmpl.makeInst("par");
            this.curPar.setOwner(this.curSec);
            this.curChr = (ChrObj)ObjTmpl.makeInst("chr");
            this.curChr.setOwner(this.curPar);
        } else {
            this.pushForDest(obj);
            this.addToOwner(obj);
        }
        if (this.curDest.isObj("fonttbl")) {
            this.SEDU(false);
            this.fontinfo();
            this.SEDU(true);
        } else if (this.curDest.isObj("colortbl")) {
            this.colordef();
        } else {
            this.body();
        }
    }

    void endDest() {
        if (this.curDest.isObj("rtf")) {
            Obj obj = this.curChr;
            while (obj.getOwner() != null) {
                if (obj instanceof DLLBufable && ((DLLBufable)((Object)obj)).isAdded()) {
                    this.addToOwner(obj);
                }
                obj = obj.getOwner();
            }
        } else {
            Obj obj = this.curDest;
            this.popForDest();
            if (obj.isObj("field")) {
                this.flddests.addElement(obj);
            } else if (obj.isObj("pict")) {
                this.processPict(obj);
            }
        }
    }

    void pushForDest(Obj obj) {
        if (this.curChr.isAdded()) {
            this.addToOwner(this.curChr);
            this.curChr = (ChrObj)this.curChr.shallowClone();
        }
        this.deststk.push(this.curPar);
        this.deststk.push(this.curTabdef);
        this.deststk.push(this.getChrfmt().shallowClone());
        this.deststk.push(this.curDest);
        this.curDest = obj;
        if (this.curDest instanceof DLLBufable) {
            this.curPar = (ParObj)this.curPar.shallowClone();
            this.curPar.setOwner(this.curDest);
            this.curChr.setOwner(this.curPar);
        }
    }

    void popForDest() {
        if (this.curDest instanceof DLLBufable) {
            if (this.curChr.isAdded()) {
                this.addToOwner(this.curChr);
                this.curChr = (ChrObj)ObjTmpl.makeInst("chr");
            }
            if (this.curPar.isAdded()) {
                this.addToOwner(this.curPar);
            }
        }
        if (this.curDest.isObj("pict") || this.curDest.isObj("shppict")) {
            ChrObj chrObj = this.curChr;
            if (this.curChr.isAdded()) {
                this.addToOwner(this.curChr);
                this.curChr = (ChrObj)ObjTmpl.makeInst("chr");
                this.curChr.setOwner(chrObj.getOwner());
            }
        }
        this.curDest = (Obj)this.deststk.pop();
        this.curChr.setObjValue("chrfmt", (Obj)this.deststk.pop());
        this.curTabdef = (Obj)this.deststk.pop();
        this.curPar = (ParObj)this.deststk.pop();
        this.curChr.setOwner(this.curPar);
    }

    void setOwner(int n, Obj obj) {
        switch (n) {
            case 0: {
                obj.setOwner(null);
                break;
            }
            case 1: {
                obj.setOwner(this.curDest);
                break;
            }
            case 2: {
                obj.setOwner(this.curObj);
                break;
            }
            case 3: {
                obj.setOwner(this.curRtf);
                break;
            }
            case 4: {
                obj.setOwner(this.curDoc);
                break;
            }
            case 5: {
                obj.setOwner(this.curSec);
                break;
            }
            case 6: {
                obj.setOwner(this.curPar);
                break;
            }
            case 7: {
                obj.setOwner(this.curChr);
                break;
            }
            case 8: {
                obj.setOwner(this.getDocfmt());
                break;
            }
            case 9: {
                obj.setOwner(this.getSecfmt());
                break;
            }
            case 10: {
                obj.setOwner(this.getParfmt());
                break;
            }
            case 11: {
                obj.setOwner(this.getChrfmt());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown owner type " + n);
            }
        }
    }

    void addProp(KwdToken kwdToken) {
        switch (kwdToken.getOwner()) {
            case 1: {
                this.curDest.addProp(kwdToken);
                break;
            }
            case 2: {
                this.curObj.addProp(kwdToken);
                break;
            }
            case 3: {
                this.curRtf.addProp(kwdToken);
                break;
            }
            case 8: {
                this.getDocfmt().addProp(kwdToken);
                break;
            }
            case 9: {
                this.getSecfmt().addProp(kwdToken);
                break;
            }
            case 10: {
                this.getParfmt().addProp(kwdToken);
                break;
            }
            case 11: {
                if (this.curChr.isAdded()) {
                    ChrObj chrObj = this.curChr;
                    this.addToOwner(this.curChr);
                    this.curChr = (ChrObj)this.curChr.shallowClone();
                    this.curChr.setOwner(chrObj.getOwner());
                }
                this.getChrfmt().addProp(kwdToken);
                break;
            }
            case 12: {
                if (this.curTabdef == null) {
                    Obj obj = null;
                    obj = this.curDest.hasProp("tabdefs") ? this.curDest.getObjValue("tabdefs") : (this.curDest.hasProp("tabdef") ? this.curDest : this.getParfmt().getObjValue("tabdefs"));
                    this.curTabdef = ObjTmpl.makeInst("tabdef");
                    obj.addProp(this.curTabdef);
                }
                this.curTabdef.addProp(kwdToken);
                break;
            }
            case 13: {
                this.getParfmt().getObjValue("apoctl").addProp(kwdToken);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown owner type in KwdToken " + kwdToken);
            }
        }
    }

    void addToOwner(Obj obj) {
        Obj obj2 = obj.getOwner();
        if (obj2 == null) {
            return;
        }
        if (obj2 instanceof DLLBufable) {
            if (obj2.getProp(obj.getName()) != null) {
                obj2.addProp(obj);
            } else {
                ((DLLBufable)((Object)obj2)).add(obj);
            }
        } else {
            if (obj2.equals(this.getChrfmt()) && this.curChr.isAdded()) {
                ChrObj chrObj = this.curChr;
                this.addToOwner(this.curChr);
                this.curChr = (ChrObj)this.curChr.shallowClone();
                this.curChr.setOwner(chrObj.getOwner());
                obj.setOwner(this.getChrfmt());
            }
            obj2.addProp(obj);
        }
    }

    void dispatchSpecKwd(KwdToken kwdToken) {
        block1 : switch (kwdToken.getId()) {
            case 833: {
                if (this.curChr.isAdded()) {
                    this.addToOwner(this.curChr);
                }
                if (this.curPar.isAdded()) {
                    this.addToOwner(this.curPar);
                }
                this.curSec.add(this.makeKwdObj(kwdToken));
                this.addToOwner(this.curSec);
                SecObj secObj = this.curSec;
                this.curSec = (SecObj)this.curSec.shallowClone();
                this.curSec.setOwner(secObj.getOwner());
                this.curPar = (ParObj)this.curPar.shallowClone();
                this.curPar.setOwner(this.curSec);
                this.curChr = (ChrObj)this.curChr.shallowClone();
                this.curChr.setOwner(this.curPar);
                break;
            }
            case 630: {
                if (this.curChr.isAdded()) {
                    this.addToOwner(this.curChr);
                }
                this.curPar.add(this.makeKwdObj(kwdToken));
                this.addToOwner(this.curPar);
                ParObj parObj = this.curPar;
                this.curPar = (ParObj)this.curPar.shallowClone();
                this.curPar.setOwner(parObj.getOwner());
                this.curChr = (ChrObj)this.curChr.shallowClone();
                this.curChr.setOwner(this.curPar);
                break;
            }
            case 834: {
                this.getSecfmt().resetAllToDef();
                break;
            }
            case 631: {
                this.getParfmt().resetAllToDef();
                break;
            }
            case 691: {
                this.getChrfmt().resetAllToDef();
                break;
            }
            case 896: 
            case 931: {
                Obj obj = null;
                obj = this.curDest.hasProp("tabdefs") ? this.curDest.getObjValue("tabdefs") : (this.curDest.hasProp("tabdef") ? this.curDest : this.getParfmt().getObjValue("tabdefs"));
                ObjBuf objBuf = ((Vect)((Object)obj)).getSubObjs();
                int n = kwdToken.getParam();
                if (objBuf != null) {
                    for (int i = 0; i < objBuf.size(); ++i) {
                        try {
                            int n2 = ((Obj)objBuf.objAt(i)).getFlagValue("tabstyle");
                            if (n != n2) continue;
                            break block1;
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                }
                if (this.curTabdef == null) {
                    this.curTabdef = ObjTmpl.makeInst("tabdef");
                    obj.addProp(this.curTabdef);
                }
                this.curTabdef.addProp(kwdToken);
                this.curTabdef = null;
                break;
            }
            case 895: {
                if (this.curChr.isAdded()) {
                    ChrObj chrObj = this.curChr;
                    this.addToOwner(this.curChr);
                    this.curChr = (ChrObj)this.curChr.shallowClone();
                    this.curChr.setOwner(chrObj.getOwner());
                }
                this.curPar.add(this.makeKwdObj(kwdToken));
                break;
            }
        }
    }

    void dispatchPropKwd(KwdToken kwdToken) {
        switch (kwdToken.getId()) {
            case 896: 
            case 931: {
                break;
            }
            default: {
                this.addProp(kwdToken);
            }
        }
    }

    void dispatchCharKwd(KwdToken kwdToken) {
        String string;
        switch (kwdToken.getId()) {
            case 545: {
                string = "'";
                break;
            }
            case 806: {
                string = "'";
                break;
            }
            case 790: {
                string = "\"";
                break;
            }
            case 507: {
                string = "\"";
                break;
            }
            case 157: {
                string = ".";
                break;
            }
            case 355: {
                string = "-";
                break;
            }
            case 352: {
                string = "_";
                break;
            }
            case 16: {
                string = "\\";
                break;
            }
            case 18: {
                string = "{";
                break;
            }
            case 20: {
                string = "}";
                break;
            }
            default: {
                string = "\u0080";
            }
        }
        Obj obj = this.makeCharsObj(string);
        if (this.curChr.isAdded()) {
            ChrObj chrObj = this.curChr;
            this.addToOwner(this.curChr);
            this.curChr = (ChrObj)this.curChr.shallowClone();
            this.curChr.setOwner(chrObj.getOwner());
        }
        this.curChr.add(obj);
    }

    void processPict(Obj obj) {
        PictDest pictDest = (PictDest)obj;
        switch (pictDest.getIntValue("picttype")) {
            case 2: 
            case 3: {
                pictDest.parseJpegPng();
                break;
            }
            case 6: 
            case 8: {
                pictDest.parseWmf();
                break;
            }
            default: {
                SEDU.error("Unsupported Tags on RTF, can not decode. please send this file to Jinfonet Support");
            }
        }
    }

    public final Pcdata pcdata() throws ParseException {
        Pcdata pcdata = new Pcdata();
        do {
            switch (this.add == -1 ? this.curChr() : this.add) {
                case 1: {
                    Token token = this.body(1);
                    pcdata.add(token.image);
                    break;
                }
                case 2: {
                    Token token = this.body(2);
                    pcdata.add(token.image);
                    break;
                }
                default: {
                    this.append[0] = this.adjustyKwdTokenKind;
                    this.body(-1);
                    throw new ParseException();
                }
            }
        } while (this.add(2));
        return pcdata;
    }

    public final void dest() throws ParseException {
        this.body(3);
        Token token = this.body(4);
        this.beginDest((KwdToken)token);
        this.body(5);
        this.endDest();
    }

    public final void body() throws ParseException {
        block14: while (true) {
            block0 : switch (this.add == -1 ? this.curChr() : this.add) {
                case 6: {
                    Token token = this.body(6);
                    KwdToken kwdToken = (KwdToken)token;
                    if (kwdToken.isType(128)) {
                        this.dispatchSpecKwd(kwdToken);
                    }
                    if (kwdToken.isType(8)) {
                        this.dispatchPropKwd(kwdToken);
                    }
                    if (!kwdToken.isType(1)) break;
                    this.dispatchCharKwd(kwdToken);
                    break;
                }
                case 7: {
                    Token token = this.body(7);
                    KwdToken kwdToken = (KwdToken)token;
                    Obj obj = ObjTmpl.makeInst(kwdToken.getName());
                    this.setOwner(kwdToken.getOwner(), obj);
                    this.addToOwner(obj);
                    this.curObj = obj;
                    if (!kwdToken.isType(8)) break;
                    if (kwdToken.hasOwner(7)) {
                        // empty if block
                    }
                    this.addProp(kwdToken);
                    break;
                }
                case 1: 
                case 2: {
                    Pcdata pcdata = this.pcdata();
                    if (!(this.curDest instanceof DLLBufable)) {
                        this.curDest.addProp(pcdata);
                        break;
                    }
                    Obj obj = this.makeCharsObj(pcdata);
                    if (this.curChr.isAdded()) {
                        ChrObj chrObj = this.curChr;
                        this.addToOwner(this.curChr);
                        this.curChr = (ChrObj)this.curChr.shallowClone();
                        this.curChr.setOwner(chrObj.getOwner());
                    }
                    this.curChr.add(obj);
                    break;
                }
                default: {
                    this.append[2] = this.adjustyKwdTokenKind;
                    if (this.addElement(2)) {
                        this.dest();
                        break;
                    }
                    switch (this.add == -1 ? this.curChr() : this.add) {
                        case 3: {
                            this.body(3);
                            this.pushForGroup();
                            switch (this.add == -1 ? this.curChr() : this.add) {
                                case 1: 
                                case 2: 
                                case 3: 
                                case 6: 
                                case 7: {
                                    this.body();
                                    break;
                                }
                                default: {
                                    this.append[1] = this.adjustyKwdTokenKind;
                                }
                            }
                            this.body(5);
                            this.popForGroup();
                            break block0;
                        }
                    }
                    this.append[3] = this.adjustyKwdTokenKind;
                    this.body(-1);
                    throw new ParseException();
                }
            }
            switch (this.add == -1 ? this.curChr() : this.add) {
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    continue block14;
                }
            }
            break;
        }
        this.append[4] = this.adjustyKwdTokenKind;
    }

    public final void colordef() throws ParseException {
        Obj obj = ObjTmpl.makeInst("colordef");
        block6: while (true) {
            block7: {
                switch (this.add == -1 ? this.curChr() : this.add) {
                    case 6: {
                        break;
                    }
                    default: {
                        this.append[5] = this.adjustyKwdTokenKind;
                        break block7;
                    }
                }
                Token token = this.body(6);
                obj.addProp((KwdToken)token);
                continue;
            }
            this.body(1);
            this.curDest.addProp(obj);
            obj = ObjTmpl.makeInst("colordef");
            switch (this.add == -1 ? this.curChr() : this.add) {
                case 1: 
                case 6: {
                    continue block6;
                }
            }
            break;
        }
        this.append[6] = this.adjustyKwdTokenKind;
    }

    public final void fontinfo() throws ParseException {
        Obj obj = this.curDest;
        Obj obj2 = ObjTmpl.makeInst("fontinfo");
        this.pushForDest(obj2);
        if (this.addProp(2)) {
            while (true) {
                this.body(3);
                Token token = this.body(8);
                this.curDest.addProp((KwdToken)token);
                this.body();
                this.body(5);
                obj.addProp(this.curDest);
                this.curDest = ObjTmpl.makeInst("fontinfo");
                if (this.addFieldDest(2)) {
                    continue;
                }
                break;
            }
        } else {
            switch (this.add == -1 ? this.curChr() : this.add) {
                case 8: {
                    Token token = this.body(8);
                    this.curDest.addProp((KwdToken)token);
                    this.body();
                    obj.addProp(this.curDest);
                    break;
                }
                default: {
                    this.append[7] = this.adjustyKwdTokenKind;
                    this.body(-1);
                    throw new ParseException();
                }
            }
        }
        this.popForDest();
    }

    public final void rtfToken() throws ParseException {
        this.body(9);
        this.body(10);
        this.body(11);
    }

    private final boolean add(int n) {
        this.addProp = n;
        this.addFieldDest = this.addElement = this.token;
        boolean bl = !this.argsForParseFieldDest();
        this.curObj(0, n);
        return bl;
    }

    private final boolean addElement(int n) {
        this.addProp = n;
        this.addFieldDest = this.addElement = this.token;
        boolean bl = !this.beginDest();
        this.curObj(1, n);
        return bl;
    }

    private final boolean addFieldDest(int n) {
        this.addProp = n;
        this.addFieldDest = this.addElement = this.token;
        boolean bl = !this.append();
        this.curObj(2, n);
        return bl;
    }

    private final boolean addProp(int n) {
        this.addProp = n;
        this.addFieldDest = this.addElement = this.token;
        boolean bl = !this.bdata();
        this.curObj(3, n);
        return bl;
    }

    private final boolean addToOwner() {
        if (this.colordef(1)) {
            return true;
        }
        if (this.addProp == 0 && this.addElement == this.addFieldDest) {
            return false;
        }
        return false;
    }

    private final boolean adjustyKwdTokenKind() {
        if (this.colordef(3)) {
            return true;
        }
        if (this.addProp == 0 && this.addElement == this.addFieldDest) {
            return false;
        }
        if (this.colordef(4)) {
            return true;
        }
        if (this.addProp == 0 && this.addElement == this.addFieldDest) {
            return false;
        }
        return false;
    }

    private final boolean append() {
        if (this.colordef(3)) {
            return true;
        }
        if (this.addProp == 0 && this.addElement == this.addFieldDest) {
            return false;
        }
        if (this.colordef(8)) {
            return true;
        }
        if (this.addProp == 0 && this.addElement == this.addFieldDest) {
            return false;
        }
        return false;
    }

    private final boolean arg() {
        if (this.colordef(2)) {
            return true;
        }
        if (this.addProp == 0 && this.addElement == this.addFieldDest) {
            return false;
        }
        return false;
    }

    private final boolean argsForParseFieldDest() {
        Token token = this.addElement;
        if (this.addToOwner()) {
            this.addElement = token;
            if (this.arg()) {
                return true;
            }
            if (this.addProp == 0 && this.addElement == this.addFieldDest) {
                return false;
            }
        } else if (this.addProp == 0 && this.addElement == this.addFieldDest) {
            return false;
        }
        return false;
    }

    private final boolean bdata() {
        Token token;
        block3: {
            if (this.append()) {
                return true;
            }
            if (this.addProp == 0 && this.addElement == this.addFieldDest) {
                return false;
            }
            do {
                token = this.addElement;
                if (this.append()) break block3;
            } while (this.addProp != 0 || this.addElement != this.addFieldDest);
            return false;
        }
        this.addElement = token;
        return false;
    }

    private final boolean beginDest() {
        if (this.adjustyKwdTokenKind()) {
            return true;
        }
        if (this.addProp == 0 && this.addElement == this.addFieldDest) {
            return false;
        }
        return false;
    }

    public RTFParser(TokenManager tokenManager) {
        int n;
        this.token_source = tokenManager;
        this.token = new Token();
        this.add = -1;
        this.adjustyKwdTokenKind = 0;
        for (n = 0; n < 8; ++n) {
            this.append[n] = -1;
        }
        for (n = 0; n < this.bdata.length; ++n) {
            this.bdata[n] = new JJCalls();
        }
    }

    public void ReInit(TokenManager tokenManager) {
        int n;
        this.token_source = tokenManager;
        this.token = new Token();
        this.add = -1;
        this.adjustyKwdTokenKind = 0;
        for (n = 0; n < 8; ++n) {
            this.append[n] = -1;
        }
        for (n = 0; n < this.bdata.length; ++n) {
            this.bdata[n] = new JJCalls();
        }
    }

    private final Token body(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.add = -1;
        if (this.token.kind == n) {
            ++this.adjustyKwdTokenKind;
            if (++this.body > 100) {
                this.body = 0;
                for (int i = 0; i < this.bdata.length; ++i) {
                    JJCalls jJCalls = this.bdata[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.adjustyKwdTokenKind) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.dispatchCharKwd = n;
        throw this.generateParseException();
    }

    private final boolean colordef(int n) {
        if (this.addElement == this.addFieldDest) {
            --this.addProp;
            if (this.addElement.next == null) {
                this.addElement = this.addElement.next = this.token_source.getNextToken();
                this.addFieldDest = this.addElement.next;
            } else {
                this.addFieldDest = this.addElement = this.addElement.next;
            }
        } else {
            this.addElement = this.addElement.next;
        }
        if (this.beginDest) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.addElement) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.curDest(n, n2);
            }
        }
        return this.addElement.kind != n;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.add = -1;
        ++this.adjustyKwdTokenKind;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.addElement : this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int curChr() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.add = this.token.next.kind;
            return this.add;
        }
        this.add = this.jj_nt.kind;
        return this.add;
    }

    private void curDest(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.dispatchSpecKwd + 1) {
            this.dispatchPropKwd[this.dispatchSpecKwd++] = n;
        } else if (this.dispatchSpecKwd != 0) {
            int n3;
            this.dest = new int[this.dispatchSpecKwd];
            for (n3 = 0; n3 < this.dispatchSpecKwd; ++n3) {
                this.dest[n3] = this.dispatchPropKwd[n3];
            }
            n3 = 0;
            Enumeration enumeration = this.colordef.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.dest.length) continue;
                n3 = 1;
                for (int i = 0; i < this.dest.length; ++i) {
                    if (nArray[i] == this.dest[i]) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0) continue;
                break;
            }
            if (n3 == 0) {
                this.colordef.addElement(this.dest);
            }
            if (n2 != 0) {
                this.dispatchSpecKwd = n2;
                this.dispatchPropKwd[this.dispatchSpecKwd - 1] = n;
            }
        }
    }

    public final ParseException generateParseException() {
        int n;
        int n2;
        this.colordef.removeAllElements();
        boolean[] blArray = new boolean[12];
        for (n2 = 0; n2 < 12; ++n2) {
            blArray[n2] = false;
        }
        if (this.dispatchCharKwd >= 0) {
            blArray[this.dispatchCharKwd] = true;
            this.dispatchCharKwd = -1;
        }
        for (n2 = 0; n2 < 8; ++n2) {
            if (this.append[n2] != this.adjustyKwdTokenKind) continue;
            for (n = 0; n < 32; ++n) {
                if ((this.arg[n2] & 1 << n) == 0) continue;
                blArray[n] = true;
            }
        }
        for (n2 = 0; n2 < 12; ++n2) {
            if (!blArray[n2]) continue;
            this.dest = new int[1];
            this.dest[0] = n2;
            this.colordef.addElement(this.dest);
        }
        this.dispatchSpecKwd = 0;
        this.curDoc();
        this.curDest(0, 0);
        int[][] nArrayArray = new int[this.colordef.size()][];
        for (n = 0; n < this.colordef.size(); ++n) {
            nArrayArray[n] = (int[])this.colordef.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void curDoc() {
        this.beginDest = true;
        for (int i = 0; i < 4; ++i) {
            JJCalls jJCalls = this.bdata[i];
            do {
                if (jJCalls.gen <= this.adjustyKwdTokenKind) continue;
                this.addProp = jJCalls.arg;
                this.addFieldDest = this.addElement = jJCalls.first;
                switch (i) {
                    case 0: {
                        this.argsForParseFieldDest();
                        break;
                    }
                    case 1: {
                        this.beginDest();
                        break;
                    }
                    case 2: {
                        this.append();
                        break;
                    }
                    case 3: {
                        this.bdata();
                    }
                }
            } while ((jJCalls = jJCalls.next) != null);
        }
        this.beginDest = false;
    }

    private final void curObj(int n, int n2) {
        JJCalls jJCalls = this.bdata[n];
        while (jJCalls.gen > this.adjustyKwdTokenKind) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.adjustyKwdTokenKind + n2 - this.addProp;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

