/*
 * Decompiled with CFR 0.152.
 */
package jet.textobj.rtf;

import java.io.IOException;
import jet.textobj.rtf.ASCII_CharStream;
import jet.textobj.rtf.KwdToken;
import jet.textobj.rtf.RTFRawLexerConstants;
import jet.textobj.rtf.Token;
import jet.textobj.rtf.TokenMgrError;

public class RTFRawLexerTokenManager
implements RTFRawLexerConstants {
    static final long[] jjbitVec0 = new long[]{0L, 0L, -1L, -1L};
    static final int[] jjnextStates = new int[]{1, 2, 3, 4};
    public static final String[] jjstrLiteralImages = new String[]{"", null, null, null, "{", "}", null, null, ";"};
    public static final String[] lexStateNames = new String[]{"DEFAULT"};
    static final long[] jjtoToken = new long[]{497L};
    static final long[] jjtoSkip = new long[]{14L};
    static final long[] jjtoSpecial = new long[]{8L};
    private ASCII_CharStream BeginToken;
    private final int[] GetImage = new int[8];
    private final int[] GetSuffix = new int[16];
    StringBuffer image;
    int jjimageLen;
    int lengthOfMatch;
    protected char curChar;
    int curLexState = 0;
    int defaultLexState = 0;
    int jjnewStateCnt;
    int jjround;
    int jjmatchedPos;
    int jjmatchedKind;

    char[] getBinData(int n) throws IOException {
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = this.BeginToken.readChar();
        }
        return cArray;
    }

    byte[] getHexData(int n) throws IOException {
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)this.BeginToken.readChar();
        }
        return byArray;
    }

    private final int BeginToken(int n, long l) {
        switch (n) {
            case 0: {
                if ((l & 8L) != 0L) {
                    return 5;
                }
                return -1;
            }
        }
        return -1;
    }

    private final int GetImage(int n, long l) {
        return this.beginColumn(this.BeginToken(n, l), n + 1);
    }

    private final int GetSuffix(int n, int n2) {
        this.jjmatchedKind = n2;
        this.jjmatchedPos = n;
        return n + 1;
    }

    private final int ReInit(int n, int n2, int n3) {
        this.jjmatchedKind = n2;
        this.jjmatchedPos = n;
        try {
            this.curChar = this.BeginToken.readChar();
        }
        catch (IOException iOException) {
            return n + 1;
        }
        return this.beginColumn(n3, n + 1);
    }

    private final int SEDU() {
        switch (this.curChar) {
            case ';': {
                return this.GetSuffix(0, 8);
            }
            case '\\': {
                return this.SwitchTo(8L);
            }
            case '{': {
                return this.GetSuffix(0, 4);
            }
            case '}': {
                return this.GetSuffix(0, 5);
            }
        }
        return this.beginColumn(0, 0);
    }

    private final int SwitchTo(long l) {
        try {
            this.curChar = this.BeginToken.readChar();
        }
        catch (IOException iOException) {
            this.BeginToken(0, l);
            return 1;
        }
        switch (this.curChar) {
            case '*': {
                if ((l & 8L) == 0L) break;
                return this.GetSuffix(1, 3);
            }
        }
        return this.GetImage(0, l);
    }

    private final void TokenLexicalActions(int n) {
        if (this.GetImage[n] != this.jjround) {
            this.GetSuffix[this.jjnewStateCnt++] = n;
            this.GetImage[n] = this.jjround;
        }
    }

    private final void Z(int n, int n2) {
        do {
            this.GetSuffix[this.jjnewStateCnt++] = jjnextStates[n];
        } while (n++ != n2);
    }

    private final void append(int n, int n2) {
        this.TokenLexicalActions(n);
        this.TokenLexicalActions(n2);
    }

    private final void backup(int n, int n2) {
        do {
            this.TokenLexicalActions(jjnextStates[n]);
        } while (n++ != n2);
    }

    private final void bdata(int n) {
        this.TokenLexicalActions(jjnextStates[n]);
        this.TokenLexicalActions(jjnextStates[n + 1]);
    }

    private final int beginColumn(int n, int n2) {
        int n3 = 0;
        this.jjnewStateCnt = 8;
        int n4 = 1;
        this.GetSuffix[0] = n;
        int n5 = Integer.MAX_VALUE;
        while (true) {
            if (++this.jjround == Integer.MAX_VALUE) {
                this.beginLine();
            }
            if (this.curChar < '@') {
                long l = 1L << this.curChar;
                block22: do {
                    switch (this.GetSuffix[--n4]) {
                        case 0: {
                            if ((0xF7FFFFFFFFFFD9FFL & l) != 0L) {
                                if (n5 > 7) {
                                    n5 = 7;
                                }
                                this.TokenLexicalActions(7);
                                break;
                            }
                            if (this.curChar != '\t' || n5 <= 6) continue block22;
                            n5 = 6;
                            break;
                        }
                        case 5: {
                            if ((0xFC00FBFFFFFFFFFFL & l) == 0L || n5 <= 6) continue block22;
                            n5 = 6;
                            break;
                        }
                        case 2: {
                            if (this.curChar != '-') break;
                            this.TokenLexicalActions(3);
                            break;
                        }
                        case 3: {
                            if ((0x3FF000000000000L & l) == 0L) continue block22;
                            if (n5 > 6) {
                                n5 = 6;
                            }
                            this.append(3, 4);
                            break;
                        }
                        case 4: {
                            if (this.curChar != ' ' || n5 <= 6) continue block22;
                            n5 = 6;
                            break;
                        }
                        case 6: {
                            if (this.curChar != '\t' || n5 <= 6) continue block22;
                            n5 = 6;
                            break;
                        }
                        case 7: {
                            if ((0xF7FFFFFFFFFFD9FFL & l) == 0L) continue block22;
                            if (n5 > 7) {
                                n5 = 7;
                            }
                            this.TokenLexicalActions(7);
                            break;
                        }
                    }
                } while (n4 != n3);
            } else if (this.curChar < '\u0080') {
                long l = 1L << (this.curChar & 0x3F);
                block23: do {
                    switch (this.GetSuffix[--n4]) {
                        case 0: {
                            if ((0xD7FFFFFFEFFFFFFFL & l) != 0L) {
                                if (n5 > 7) {
                                    n5 = 7;
                                }
                                this.TokenLexicalActions(7);
                                break;
                            }
                            if (this.curChar != '\\') break;
                            this.append(1, 5);
                            break;
                        }
                        case 5: {
                            if ((0x7FFFFFE00000000L & l) != 0L) {
                                if (n5 > 6) {
                                    n5 = 6;
                                }
                                this.backup(0, 3);
                                break;
                            }
                            if ((0xF8000001F8000001L & l) == 0L || n5 <= 6) continue block23;
                            n5 = 6;
                            break;
                        }
                        case 1: {
                            if ((0x7FFFFFE00000000L & l) == 0L) continue block23;
                            if (n5 > 6) {
                                n5 = 6;
                            }
                            this.backup(0, 3);
                            break;
                        }
                        case 7: {
                            if ((0xD7FFFFFFEFFFFFFFL & l) == 0L) continue block23;
                            if (n5 > 7) {
                                n5 = 7;
                            }
                            this.TokenLexicalActions(7);
                            break;
                        }
                    }
                } while (n4 != n3);
            } else {
                int n6 = (this.curChar & 0xFF) >> 6;
                long l = 1L << (this.curChar & 0x3F);
                block24: do {
                    switch (this.GetSuffix[--n4]) {
                        case 0: 
                        case 7: {
                            if ((jjbitVec0[n6] & l) == 0L) continue block24;
                            if (n5 > 7) {
                                n5 = 7;
                            }
                            this.TokenLexicalActions(7);
                            break;
                        }
                        case 5: {
                            if ((jjbitVec0[n6] & l) == 0L || n5 <= 6) continue block24;
                            n5 = 6;
                            break;
                        }
                    }
                } while (n4 != n3);
            }
            if (n5 != Integer.MAX_VALUE) {
                this.jjmatchedKind = n5;
                this.jjmatchedPos = n2;
                n5 = Integer.MAX_VALUE;
            }
            ++n2;
            n4 = this.jjnewStateCnt;
            this.jjnewStateCnt = n3;
            if (n4 == (n3 = 8 - this.jjnewStateCnt)) {
                return n2;
            }
            try {
                this.curChar = this.BeginToken.readChar();
            }
            catch (IOException iOException) {
                return n2;
            }
        }
    }

    public RTFRawLexerTokenManager(ASCII_CharStream aSCII_CharStream) {
        this.BeginToken = aSCII_CharStream;
    }

    public RTFRawLexerTokenManager(ASCII_CharStream aSCII_CharStream, int n) {
        this(aSCII_CharStream);
        this.SwitchTo(n);
    }

    public void ReInit(ASCII_CharStream aSCII_CharStream) {
        this.jjnewStateCnt = 0;
        this.jjmatchedPos = 0;
        this.curLexState = this.defaultLexState;
        this.BeginToken = aSCII_CharStream;
        this.beginLine();
    }

    private final void beginLine() {
        this.jjround = -2147483647;
        int n = 8;
        while (n-- > 0) {
            this.GetImage[n] = Integer.MIN_VALUE;
        }
    }

    public void ReInit(ASCII_CharStream aSCII_CharStream, int n) {
        this.ReInit(aSCII_CharStream);
        this.SwitchTo(n);
    }

    public void SwitchTo(int n) {
        if (n >= 1 || n < 0) {
            throw new TokenMgrError("Error: Ignoring invalid lexical state : " + n + ". State unchanged.", 2);
        }
        this.curLexState = n;
    }

    private final Token curChar() {
        Token token = Token.newToken(this.jjmatchedKind);
        token.kind = this.jjmatchedKind;
        String string = jjstrLiteralImages[this.jjmatchedKind];
        token.image = string == null ? this.BeginToken.GetImage() : string;
        token.beginLine = this.BeginToken.getBeginLine();
        token.beginColumn = this.BeginToken.getBeginColumn();
        token.endLine = this.BeginToken.getEndLine();
        token.endColumn = this.BeginToken.getEndColumn();
        return token;
    }

    public final Token getNextToken() {
        Token token = null;
        int n = 0;
        while (true) {
            Token token2;
            try {
                this.curChar = this.BeginToken.BeginToken();
            }
            catch (IOException iOException) {
                this.jjmatchedKind = 0;
                token2 = this.curChar();
                token2.specialToken = token;
                return token2;
            }
            this.image = null;
            this.jjimageLen = 0;
            try {
                while (this.curChar <= '\r' && (0x2400L & 1L << this.curChar) != 0L) {
                    this.curChar = this.BeginToken.BeginToken();
                }
            }
            catch (IOException iOException) {
                continue;
            }
            this.jjmatchedKind = Integer.MAX_VALUE;
            this.jjmatchedPos = 0;
            n = this.SEDU();
            if (this.jjmatchedKind == Integer.MAX_VALUE) break;
            if (this.jjmatchedPos + 1 < n) {
                this.BeginToken.backup(n - this.jjmatchedPos - 1);
            }
            if ((jjtoToken[this.jjmatchedKind >> 6] & 1L << (this.jjmatchedKind & 0x3F)) != 0L) {
                token2 = this.curChar();
                token2.specialToken = token;
                this.TokenLexicalActions(token2);
                return token2;
            }
            if ((jjtoSpecial[this.jjmatchedKind >> 6] & 1L << (this.jjmatchedKind & 0x3F)) == 0L) continue;
            token2 = this.curChar();
            if (token == null) {
                token = token2;
                continue;
            }
            token2.specialToken = token;
            token = token.next = token2;
        }
        int n2 = this.BeginToken.getEndLine();
        int n3 = this.BeginToken.getEndColumn();
        String string = null;
        boolean bl = false;
        try {
            this.BeginToken.readChar();
            this.BeginToken.backup(1);
        }
        catch (IOException iOException) {
            bl = true;
            String string2 = string = n <= 1 ? "" : this.BeginToken.GetImage();
            if (this.curChar == '\n' || this.curChar == '\r') {
                ++n2;
                n3 = 0;
            }
            ++n3;
        }
        if (!bl) {
            this.BeginToken.backup(1);
            string = n <= 1 ? "" : this.BeginToken.GetImage();
        }
        throw new TokenMgrError(bl, this.curLexState, n2, n3, string, this.curChar, 0);
    }

    final void TokenLexicalActions(Token token) {
        switch (this.jjmatchedKind) {
            case 4: {
                if (this.image == null) {
                    this.image = new StringBuffer(jjstrLiteralImages[4]);
                } else {
                    this.image.append(jjstrLiteralImages[4]);
                }
                token.kind = 3;
                break;
            }
            case 5: {
                if (this.image == null) {
                    this.image = new StringBuffer(jjstrLiteralImages[5]);
                } else {
                    this.image.append(jjstrLiteralImages[5]);
                }
                token.kind = 5;
                break;
            }
            case 6: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.BeginToken.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.BeginToken.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                token.kind = 6;
                KwdToken kwdToken = (KwdToken)token;
                kwdToken.init();
                if (kwdToken.specialToken != null && kwdToken.specialToken.kind == 3) {
                    kwdToken.isExt = true;
                }
                int n = kwdToken.getId();
                try {
                    switch (n) {
                        case 12: {
                            char[] cArray = new char[]{(char)Integer.parseInt(new String(this.getHexData(2), 0), 16)};
                            kwdToken.image = new String(cArray);
                            break;
                        }
                        case 107: {
                            kwdToken.bdata = this.getBinData(kwdToken.param);
                            break;
                        }
                        case 945: {
                            kwdToken.kind = 2;
                            kwdToken.image = "" + (char)kwdToken.param;
                        }
                    }
                    break;
                }
                catch (IOException iOException) {
                    throw new TokenMgrError("Can't get enough bytes for token:" + kwdToken, 0);
                }
            }
            case 7: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.BeginToken.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.BeginToken.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                token.kind = 2;
                break;
            }
            case 8: {
                if (this.image == null) {
                    this.image = new StringBuffer(jjstrLiteralImages[8]);
                } else {
                    this.image.append(jjstrLiteralImages[8]);
                }
                token.kind = 1;
                break;
            }
        }
    }
}

