/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import com.jinfonet.util.JRLog;
import guitools.SpecialAWT;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.Vector;
import jet.datastream.DSContainer;
import jet.datastream.DSGroup;
import jet.datastream.DSReference;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.thinviewer.JReportContainerable;
import jet.thinviewer.JReportObjectRender;
import jet.thinviewer.JReportViewer;
import jet.udo.JRObjectRender;

public class JRContainerImpl
implements JReportContainerable {
    int startY = 0;
    Container peer;

    public JRContainerImpl(Container container) {
        this.peer = container;
    }

    @Override
    public void createChildren(DSContainer dSContainer) {
        Vector vector = dSContainer.getChildren();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.elementAt(i);
            JRObjectRender jRObjectRender = this.createComponent(jRObjectResult);
            if (jRObjectRender == null) continue;
            if (this.peer instanceof SpecialAWT) {
                ((SpecialAWT)((Object)this.peer)).addSpecial((Component)((Object)jRObjectRender));
                continue;
            }
            this.peer.add((Component)((Object)jRObjectRender));
        }
    }

    protected JRObjectRender createComponent(JRObjectResult jRObjectResult) {
        JReportObjectRender jReportObjectRender;
        boolean bl = true;
        if (jRObjectResult instanceof DSReference) {
            bl = false;
            jRObjectResult = ((DSReference)jRObjectResult).getRefData();
        }
        if ((jReportObjectRender = JReportViewer.createViewObject(jRObjectResult)) != null) {
            jReportObjectRender.setProperty(jRObjectResult);
            Rectangle rectangle = ((JRVisiableResult)jRObjectResult).getBounds();
            rectangle.y = ((JRVisiableResult)jRObjectResult).getStartYPos() != 0 ? 0 : (rectangle.y -= this.startY);
            if (bl) {
                rectangle.height = Math.min(this.peer.getBounds().height - rectangle.y, rectangle.height);
            }
            ((Component)((Object)jReportObjectRender)).setBounds(rectangle);
            if (jRObjectResult instanceof DSContainer) {
                ((JReportContainerable)((Object)jReportObjectRender)).createChildren((DSContainer)jRObjectResult);
            }
        } else if (!(jRObjectResult instanceof DSGroup) && JRLog.isError(2)) {
            JRLog.error(2, 2401518, jRObjectResult);
        }
        return jReportObjectRender;
    }
}

