/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import com.jinfonet.util.JRLog;
import guitools.PainterConstants;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.util.StringTokenizer;
import jet.datastream.DSArea;
import jet.thinviewer.JReportAreaComponent;
import jet.thinviewer.JReportViewer;
import jet.thinviewer.ViewerTools;
import jet.util.PropertySetable;
import util.RenderToolkit;

public class JReportArea
extends JReportAreaComponent
implements PainterConstants {
    private static final long serialVersionUID = 1L;
    Color fillColor = null;
    Color boundaryColor = null;
    int boundaryWidth;
    int boundaryStyle;
    int[] xPoints;
    int[] yPoints;
    int nPoints;
    private DSArea SEDU = null;

    public JReportArea() {
        this.enableEvents(16L);
    }

    @Override
    public void setProperty(PropertySetable propertySetable) {
        this.SEDU = (DSArea)propertySetable;
        super.setProperty(this.SEDU);
        Rectangle rectangle = this.SEDU.getBounds();
        double d = 1.0;
        this.type = this.SEDU.getShapeType();
        this.boundaryStyle = this.SEDU.getBoundaryStyle();
        int[][] nArray = this.SEDU.getPolygon();
        this.fillColor = this.SEDU.getFillColorValue();
        this.boundaryColor = this.SEDU.getBoundaryColorValue();
        this.boundaryWidth = Unit.convertUnitToPixel(this.SEDU.getBoundaryWidth(), this.resolution);
        if (this.type == 3 || this.type == 4) {
            int n;
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "Area type is polygon or polygongroup: " + this.type);
            }
            this.nPoints = nArray.length;
            this.xPoints = new int[this.nPoints];
            this.yPoints = new int[this.nPoints];
            for (n = 0; n < this.nPoints; ++n) {
                this.xPoints[n] = Unit.convertUnitToPixel(nArray[n][0], this.resolution);
                this.yPoints[n] = Unit.convertUnitToPixel(nArray[n][1], this.resolution);
            }
            d = (double)rectangle.width / (double)new Polygon((int[])this.xPoints, (int[])this.yPoints, (int)this.nPoints).getBounds().width;
            if (Math.abs(d - 1.0) > 0.03) {
                for (n = 0; n < this.nPoints; ++n) {
                    this.xPoints[n] = (int)Math.round((double)this.xPoints[n] * d);
                    this.yPoints[n] = (int)Math.round((double)this.yPoints[n] * d);
                }
            }
            this.shape = new Polygon(this.xPoints, this.yPoints, this.nPoints);
        } else {
            int[] nArray2 = this.parseShape((String)this.SEDU.getPropertyByName("Coordinates").getObject());
            if (this.type == 2) {
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, "Area type is circle: " + this.type);
                }
                d = (double)rectangle.width / (double)(nArray2[2] * 2);
                this.shape = new Ellipse2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                if (JRLog.isTrace(5)) {
                    JRLog.trace(5, "Area type is others(rectangle or others): " + this.type);
                }
                this.shape = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        if (Math.abs(d - 1.0) > 0.03) {
            this.boundaryWidth = (int)Math.round((double)this.boundaryWidth * d);
        }
    }

    protected void fillBackground(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.fillColor != null) {
            graphics.setColor(this.fillColor);
            if (this.type == 3) {
                graphics.fillPolygon(this.xPoints, this.yPoints, this.nPoints);
            } else if (this.type == 4) {
                int[] nArray = null;
                int[] nArray2 = null;
                int n = 0;
                int[] nArray3 = this.SEDU.getGroupPoints();
                int[] nArray4 = this.SEDU.getCoordParts();
                int n2 = 0;
                for (int i = 0; i < nArray4.length; ++i) {
                    n2 = nArray4[i];
                    n = nArray3[i];
                    nArray = new int[n];
                    nArray2 = new int[n];
                    System.arraycopy(this.xPoints, n2, nArray, 0, n);
                    System.arraycopy(this.yPoints, n2, nArray2, 0, n);
                    graphics.fillPolygon(nArray, nArray2, n);
                }
            } else if (this.type == 2) {
                graphics.fillOval(0, 0, dimension.width, dimension.height);
            } else {
                graphics.fillRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.boundaryWidth > 0 && this.boundaryColor != null && this.boundaryStyle != 0) {
            if (this.type == 3) {
                for (int i = 0; i < this.nPoints - 1; ++i) {
                    RenderToolkit.drawLine(graphics, this.xPoints[i], this.yPoints[i], this.xPoints[i + 1], this.yPoints[i + 1], this.boundaryColor, this.boundaryWidth, this.boundaryStyle);
                }
                RenderToolkit.drawLine(graphics, this.xPoints[0], this.yPoints[0], this.xPoints[this.nPoints - 1], this.yPoints[this.nPoints - 1], this.boundaryColor, this.boundaryWidth, this.boundaryStyle);
            } else if (this.type == 4) {
                int n = 0;
                int[] nArray = this.SEDU.getGroupPoints();
                int[] nArray2 = this.SEDU.getCoordParts();
                for (int i = 0; i < nArray2.length; ++i) {
                    n = nArray[i];
                    int[] nArray3 = new int[n];
                    int[] nArray4 = new int[n];
                    System.arraycopy(this.xPoints, nArray2[i], nArray3, 0, n);
                    System.arraycopy(this.yPoints, nArray2[i], nArray4, 0, n);
                    for (int j = 0; j < n - 1; ++j) {
                        RenderToolkit.drawLine(graphics, nArray3[j], nArray4[j], nArray3[j + 1], nArray4[j + 1], this.boundaryColor, this.boundaryWidth, this.boundaryStyle);
                    }
                }
            } else if (this.type == 2) {
                RenderToolkit.drawOval(graphics, 0.0f, 0.0f, dimension.width, dimension.height, null, this.boundaryColor, this.boundaryWidth, this.boundaryStyle);
            } else {
                RenderToolkit.drawBox(graphics, 0.0f, 0.0f, dimension.width - 1, dimension.height - 1, null, this.boundaryColor, this.boundaryWidth, this.boundaryStyle);
            }
        }
        super.paint(graphics);
    }

    int[] parseShape(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, new String(","));
        int n = stringTokenizer.countTokens();
        int[] nArray = new int[n];
        try {
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                nArray[i] = Unit.convertUnitToPixel(new Integer(string2.trim()), this.resolution);
            }
        }
        catch (NumberFormatException numberFormatException) {
            ViewerTools.writeErrorMessage(2401501, numberFormatException);
        }
        return nArray;
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
    }

    private boolean hasLink() {
        boolean bl = false;
        JReportViewer jReportViewer = this.SEDU();
        bl = jReportViewer.hasLink(this.SEDU);
        return bl;
    }

    private JReportViewer SEDU() {
        Container container = this.getParent();
        while (!(container instanceof JReportViewer)) {
            container = container.getParent();
        }
        return (JReportViewer)container;
    }
}

