/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import guitools.toolkit.FigurePeer;
import guitools.toolkit.TComponent;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Graphics;
import jet.datastream.DSPolyLine;
import jet.export.ExportAuxInfo;
import jet.export.util.ExportingInfo;
import jet.thinviewer.JReportObjectRender;
import jet.util.PropertySetable;
import util.RenderToolkit;

public class JReportAreaLine
extends TComponent
implements JReportObjectRender,
FigurePeer {
    private static final long serialVersionUID = 1L;
    int[][] coords;
    int lineWidth;
    int lineStyle;
    private DSPolyLine SEDU = null;
    private Color convertUnitToPixel = null;
    private int drawLine = 72;
    protected ExportAuxInfo auxinfo;
    protected boolean islcView;
    private ExportingInfo getLineColorValue;

    public JReportAreaLine() {
        this.setEraser(false);
    }

    public void setResolution(int n) {
        this.drawLine = n;
    }

    @Override
    public void setProperty(PropertySetable propertySetable) {
        this.SEDU = (DSPolyLine)propertySetable;
        this.convertUnitToPixel = this.SEDU.getLineColorValue();
        this.lineStyle = this.SEDU.getLineStyle();
        this.lineWidth = this.SEDU.getLineWidth();
        this.lineWidth = Unit.convertUnitToPixel(this.lineWidth, this.drawLine);
        this.coords = this.SEDU.getPolygon();
    }

    public void paintLine(Graphics graphics) {
        int n = this.coords.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < this.coords.length - 1; ++i) {
            nArray[i] = Unit.convertUnitToPixel(this.coords[i][0], this.drawLine);
            nArray2[i] = Unit.convertUnitToPixel(this.coords[i][1], this.drawLine);
            nArray[i + 1] = Unit.convertUnitToPixel(this.coords[i + 1][0], this.drawLine);
            nArray2[i + 1] = Unit.convertUnitToPixel(this.coords[i + 1][1], this.drawLine);
            if (this.lineWidth <= 0 || this.convertUnitToPixel == null || this.lineStyle == -1) continue;
            RenderToolkit.drawLine(graphics, nArray[i], nArray2[i], nArray[i + 1], nArray2[i + 1], this.convertUnitToPixel, this.lineWidth, this.lineStyle);
        }
    }

    @Override
    public void paintInterior(Graphics graphics) {
    }

    @Override
    public void paintShape(Graphics graphics) {
    }

    @Override
    public void getAuxinfo() {
    }

    @Override
    public void setauxinfo(ExportAuxInfo exportAuxInfo) {
        this.auxinfo = exportAuxInfo;
    }

    @Override
    public void setLcView(boolean bl) {
        this.islcView = bl;
    }

    @Override
    public void setExportInfo(ExportingInfo exportingInfo) {
        this.getLineColorValue = exportingInfo;
    }
}

