/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import jet.datastream.CTGridInfo;
import jet.datastream.DSCrossTab;
import jet.datastream.JRObjectResult;
import jet.thinviewer.JReportContainer;
import jet.util.PropertySetable;

public class JReportCTCrossTab
extends JReportContainer {
    Color clrBorder = null;
    boolean hasborder;
    List gridInfos = null;

    public JReportCTCrossTab() {
        this.setLayout(null);
        this.setEraser(false);
    }

    @Override
    public void setProperty(PropertySetable propertySetable) {
        super.setProperty(propertySetable);
        JRObjectResult jRObjectResult = (JRObjectResult)propertySetable;
        this.clrBorder = this.getColorPropertyByName(jRObjectResult, "BorderColor");
        this.hasborder = this.clrBorder != null && this.getBooleanPropertyByName(jRObjectResult, "Hasborder");
        this.gridInfos = ((DSCrossTab)propertySetable).getGridInfos();
    }

    private void I(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.hasEraser()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
        if (this.gridInfos != null) {
            int n = this.gridInfos.size();
            for (int i = 0; i < n; ++i) {
                List list = (List)this.gridInfos.get(i);
                int n2 = list.size();
                for (int j = 0; j < n2; ++j) {
                    CTGridInfo cTGridInfo = (CTGridInfo)list.get(j);
                    if (i == 0 && j == 0 && cTGridInfo.getChildren().size() == 0) continue;
                    Rectangle rectangle = new Rectangle();
                    rectangle.x = Unit.convertUnitToPixel(cTGridInfo.bgRect.x, this.resolution);
                    rectangle.y = Unit.convertUnitToPixel(cTGridInfo.bgRect.y, this.resolution);
                    rectangle.width = Unit.convertUnitToPixel(cTGridInfo.bgRect.x + cTGridInfo.bgRect.width, this.resolution) - rectangle.x;
                    rectangle.height = Unit.convertUnitToPixel(cTGridInfo.bgRect.y + cTGridInfo.bgRect.height, this.resolution) - rectangle.y;
                    rectangle.y -= this.startY;
                    if (cTGridInfo.fillColor != null) {
                        graphics.setColor(cTGridInfo.fillColor);
                        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                    if (!this.hasborder) continue;
                    graphics.setColor(this.clrBorder);
                    graphics.drawRect(rectangle.x, rectangle.y, Math.min(rectangle.width, dimension.width - rectangle.x - 1), Math.min(rectangle.height, dimension.height - rectangle.y - 1));
                }
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        this.I(graphics);
        super.paint(graphics);
    }
}

