/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import chart.graphics.ChartFillPattern;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import jet.datastream.DSChartHeatMapGroupRect;
import jet.export.util.BorderProperties;
import jet.thinviewer.JReportNewContainer;
import jet.thinviewer.JReportObjectRender;
import jet.thinviewer.JReportViewer;
import jet.util.PropertySetable;

public class JReportChartHeatMapGroupRect
extends JReportNewContainer
implements JReportObjectRender,
ActionListener {
    boolean hasShadow = false;
    Color shadowColor = null;
    boolean isSuccess = true;
    int shadowWidth = 0;
    BorderProperties borderProp = null;
    DSChartHeatMapGroupRect mapGroupRect = null;
    Vector haveBorders = new Vector();

    public JReportChartHeatMapGroupRect() {
        this.enableEvents(16L);
    }

    @Override
    public void setProperty(PropertySetable propertySetable) {
        super.setProperty(propertySetable);
        this.mapGroupRect = (DSChartHeatMapGroupRect)propertySetable;
        this.haveBorders = this.mapGroupRect.getIsDrawBroderList();
        boolean bl = (Boolean)this.haveBorders.get(0);
        boolean bl2 = (Boolean)this.haveBorders.get(1);
        boolean bl3 = (Boolean)this.haveBorders.get(2);
        boolean bl4 = (Boolean)this.haveBorders.get(3);
        this.borderStyle = new int[4];
        this.borderWidth = new int[4];
        this.borderColor = new Color[4];
        int n = this.getIntPropertyByName(this.mapGroupRect, "BorderPenTransparency");
        if (bl) {
            this.borderStyle[0] = this.SEDU(this.getIntPropertyByName(this.mapGroupRect, "BorderPenStyle"));
            this.borderWidth[0] = Unit.convertUnitToPixel(this.getIntPropertyByName(this.mapGroupRect, "BorderPenThickness"), this.resolution);
            if (this.borderWidth[0] > 1) {
                this.borderWidth[0] = this.borderWidth[0] / 2;
            }
            this.borderColor[0] = this.I(this.getColorPropertyByName(this.mapGroupRect, "BorderPenColor"), n);
        }
        if (bl2) {
            this.borderStyle[1] = this.SEDU(this.getIntPropertyByName(this.mapGroupRect, "BorderPenStyle"));
            this.borderWidth[1] = Unit.convertUnitToPixel(this.getIntPropertyByName(this.mapGroupRect, "BorderPenThickness"), this.resolution);
            if (this.borderWidth[1] > 1) {
                this.borderWidth[1] = this.borderWidth[1] / 2;
            }
            this.borderColor[1] = this.I(this.getColorPropertyByName(this.mapGroupRect, "BorderPenColor"), n);
        }
        if (bl3) {
            this.borderStyle[2] = this.SEDU(this.getIntPropertyByName(this.mapGroupRect, "BorderPenStyle"));
            this.borderWidth[2] = Unit.convertUnitToPixel(this.getIntPropertyByName(this.mapGroupRect, "BorderPenThickness"), this.resolution);
            if (this.borderWidth[2] > 1) {
                this.borderWidth[2] = this.borderWidth[2] / 2;
            }
            this.borderColor[2] = this.I(this.getColorPropertyByName(this.mapGroupRect, "BorderPenColor"), n);
        }
        if (bl4) {
            this.borderStyle[3] = this.SEDU(this.getIntPropertyByName(this.mapGroupRect, "BorderPenStyle"));
            this.borderWidth[3] = Unit.convertUnitToPixel(this.getIntPropertyByName(this.mapGroupRect, "BorderPenThickness"), this.resolution);
            if (this.borderWidth[3] > 1) {
                this.borderWidth[3] = this.borderWidth[3] / 2;
            }
            this.borderColor[3] = this.I(this.getColorPropertyByName(this.mapGroupRect, "BorderPenColor"), n);
        }
    }

    private Color I(Color color, int n) {
        if (color == null) {
            return null;
        }
        if (n <= 5) {
            return color;
        }
        int n2 = 256;
        int n3 = 256;
        int n4 = 256;
        int n5 = color.getAlpha();
        int n6 = color.getBlue();
        int n7 = color.getGreen();
        int n8 = (n5 * (100 - n) + n2 * n) / 100;
        int n9 = (n6 * (100 - n) + n3 * n) / 100;
        int n10 = (n7 * (100 - n) + n4 * n) / 100;
        return new Color(n8, n9, n10);
    }

    private int SEDU(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == 1 || n == 6) {
            return 3;
        }
        if (n == 2 || n == 3) {
            return 2;
        }
        if (n == 4 || n == 5 || n == 7 || n == 8) {
            return 4;
        }
        if (n == 9) {
            return 0;
        }
        return n;
    }

    @Override
    public void paint(Graphics graphics) {
        this.booleanValue(graphics);
        super.paint(graphics);
    }

    private void booleanValue(Graphics graphics) {
        Rectangle rectangle = this.mapGroupRect.getBounds();
        ChartFillPattern chartFillPattern = this.mapGroupRect.getBackgroupFillPattern();
        if (chartFillPattern != null) {
            int n = rectangle.x;
            int n2 = rectangle.y;
            int n3 = rectangle.width;
            int n4 = rectangle.height;
            if (this.hasShadow) {
                n3 -= this.shadowWidth;
                n4 -= this.shadowWidth;
            }
            Rectangle rectangle2 = new Rectangle(0, 0, rectangle.width, rectangle.height);
            chartFillPattern.fill((Graphics2D)graphics, rectangle2);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
    }

    private JReportViewer borderColor() {
        Container container = this.getParent();
        while (!(container instanceof JReportViewer)) {
            container = container.getParent();
        }
        return (JReportViewer)container;
    }

    private boolean hasLink() {
        boolean bl = false;
        JReportViewer jReportViewer = this.borderColor();
        bl = jReportViewer.hasLink(this.mapGroupRect);
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }
}

