/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import com.jinfonet.util.JRLog;
import guitools.toolkit.TContainer;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.List;
import jet.connect.Record;
import jet.datastream.DSArea;
import jet.datastream.DSBody;
import jet.datastream.DSContainer;
import jet.datastream.DSGroup;
import jet.datastream.DSPolyLine;
import jet.datastream.DSReference;
import jet.datastream.DSSection;
import jet.datastream.DSSubReport;
import jet.datastream.DSTableObject;
import jet.datastream.DSTableRow;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.export.ExportAuxInfo;
import jet.export.util.CCUtil;
import jet.export.util.ExportingInfo;
import jet.export.util.FillPatternAdapter;
import jet.export.util.FillPatternProperties;
import jet.export.util.ViewerExportingInfo;
import jet.thinviewer.JReportAreaLine;
import jet.thinviewer.JReportChartHeatMapGroupRect;
import jet.thinviewer.JReportChartPlatform;
import jet.thinviewer.JReportContainerable;
import jet.thinviewer.JReportField;
import jet.thinviewer.JReportObjectRender;
import jet.thinviewer.JReportParagraph;
import jet.thinviewer.JReportParagraphText;
import jet.thinviewer.JReportTableObject;
import jet.thinviewer.JReportViewer;
import jet.thinviewer.ViewerTools;
import jet.udo.JRObjectRender;
import jet.util.JRInterruptedException;
import jet.util.PropertySetable;
import jet.util.image.ImageResource;

public class JReportContainer
extends TContainer
implements JReportObjectRender,
JReportContainerable {
    private static final long serialVersionUID = 1L;
    protected int startY = 0;
    protected int resolution;
    private double ConvertProperties = 1.0;
    private double SEDU = 1.0;
    private FillPatternProperties convertUnitToPixel;
    protected boolean isLCView;
    protected ExportingInfo info = new ViewerExportingInfo();
    protected ExportAuxInfo auxinfo = null;

    @Override
    public void setProperty(PropertySetable propertySetable) {
        if (propertySetable instanceof DSSection || propertySetable instanceof DSTableRow || propertySetable instanceof DSBody) {
            this.convertUnitToPixel = FillPatternAdapter.ConvertProperties((JRObjectResult)propertySetable);
        } else {
            Color color = this.getColorPropertyByName((JRObjectResult)propertySetable, "Background");
            if (color != null) {
                this.setBackground(color);
                this.setEraser(true);
            } else {
                this.setEraser(false);
            }
        }
        this.resolution = ((JRObjectResult)propertySetable).getResolution();
        this.startY = Unit.convertUnitToPixel(((DSContainer)propertySetable).getStartYPos(), this.resolution);
    }

    @Override
    public void createChildren(DSContainer dSContainer) {
        this.removeAll();
        List list = dSContainer.getChildren();
        list = ViewerTools.zOrder(list);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)list.get(i);
            JRObjectRender jRObjectRender = null;
            try {
                jRObjectRender = this.createComponent(jRObjectResult);
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, "JRInterruptedException", (Throwable)jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                ViewerTools.writeErrorMessage(2401503, exception);
            }
            if (jRObjectRender == null) continue;
            this.add((Component)((Object)jRObjectRender));
        }
    }

    protected JRObjectRender createComponent(JRObjectResult jRObjectResult) {
        boolean bl = true;
        while (jRObjectResult instanceof DSReference) {
            bl = false;
            jRObjectResult = ((DSReference)jRObjectResult).getRefData();
        }
        if (!this.info.isExport(jRObjectResult)) {
            return null;
        }
        JReportObjectRender jReportObjectRender = JReportViewer.createViewObject(jRObjectResult);
        if (jReportObjectRender != null) {
            if (jRObjectResult instanceof DSPolyLine) {
                ((JReportAreaLine)jReportObjectRender).setProperty((DSPolyLine)jRObjectResult);
                ((JReportAreaLine)jReportObjectRender).setResolution(this.resolution);
                return jReportObjectRender;
            }
            JRVisiableResult jRVisiableResult = (JRVisiableResult)jRObjectResult;
            if (jRVisiableResult.getObjectType() == 393514 || jRVisiableResult.getObjectType() == 393513 || jRVisiableResult.getObjectType() == 393473) {
                ((JReportField)jReportObjectRender).setZoom(this.ConvertProperties, this.SEDU);
            }
            jReportObjectRender.setExportInfo(this.info);
            jReportObjectRender.setProperty(jRVisiableResult);
            Rectangle rectangle = jRVisiableResult.getBounds();
            int n = 0;
            if (jRVisiableResult.getStartYPos() != 0) {
                JRObjectResult jRObjectResult2;
                int n2 = 0;
                if ((jRVisiableResult instanceof DSSection || jRVisiableResult instanceof DSSubReport) && ((jRObjectResult2 = (JRObjectResult)((Object)jRVisiableResult.getParent())).getObjectType() == 45 || jRObjectResult2.getObjectType() == 33 && CCUtil.getBooleanPropertyByName(jRVisiableResult, "Embedded") || (jRObjectResult2.getObjectType() & 0x200) == 512)) {
                    n2 = Math.max(0, jRVisiableResult.getY() - ((JRVisiableResult)jRObjectResult2).getStartYPos());
                }
                rectangle.y = (n = n2) > 0 ? Unit.convertUnitToPixel(n, this.resolution) : 0;
            } else {
                rectangle.y -= this.startY;
            }
            if (bl && n > 0) {
                rectangle.height = Math.min(this.getBounds().height, rectangle.height);
            } else if (bl) {
                rectangle.height = Math.min(this.getBounds().height - rectangle.y, rectangle.height);
            }
            if (jReportObjectRender instanceof JReportParagraph) {
                ((JReportParagraph)jReportObjectRender).setActualSize(rectangle);
            } else if (jReportObjectRender instanceof JReportParagraphText) {
                ((Component)((Object)jReportObjectRender)).setBounds(rectangle);
            } else if (jReportObjectRender instanceof JReportChartHeatMapGroupRect) {
                ++rectangle.width;
                ++rectangle.height;
                ((Component)((Object)jReportObjectRender)).setBounds(rectangle);
            } else if (!(jReportObjectRender instanceof JReportChartPlatform)) {
                ((Component)((Object)jReportObjectRender)).setBounds(rectangle);
            }
            if (jRVisiableResult instanceof DSContainer && !(jRVisiableResult instanceof DSArea) && !(jReportObjectRender instanceof JReportTableObject)) {
                ((JReportContainerable)((Object)jReportObjectRender)).createChildren((DSContainer)jRVisiableResult);
            }
            if (jReportObjectRender instanceof JReportChartPlatform) {
                ((Component)((Object)jReportObjectRender)).setBounds(rectangle);
            }
            if (jReportObjectRender instanceof JReportTableObject) {
                ((JReportTableObject)jReportObjectRender).createChildren((DSTableObject)jRVisiableResult);
            }
        } else if (!(jRObjectResult instanceof DSGroup) && JRLog.isTrace(5)) {
            JRLog.trace(5, 2401518, jRObjectResult);
        }
        return jReportObjectRender;
    }

    public FillPatternProperties getFillProp() {
        return this.convertUnitToPixel;
    }

    public void setProperty(PropertySetable propertySetable, Record record) {
    }

    protected Color getColorPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getColorPropertyByName(jRObjectResult, string);
    }

    protected boolean getBooleanPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getBooleanPropertyByName(jRObjectResult, string);
    }

    protected int getIntPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getIntPropertyByName(jRObjectResult, string);
    }

    protected Image getImagePropertyByName(JRObjectResult jRObjectResult, String string) {
        ImageResource imageResource = CCUtil.getImagePropertyByName(jRObjectResult, string);
        if (imageResource == null) {
            return null;
        }
        return imageResource.getImage();
    }

    protected String getStringPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getStringPropertyByName(jRObjectResult, string);
    }

    @Override
    public void setauxinfo(ExportAuxInfo exportAuxInfo) {
        this.auxinfo = exportAuxInfo;
    }

    @Override
    public void setLcView(boolean bl) {
        this.isLCView = bl;
    }

    @Override
    public void getAuxinfo() {
    }

    @Override
    public void setExportInfo(ExportingInfo exportingInfo) {
        this.info = exportingInfo;
    }
}

