/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import guitools.toolkit.Unit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.datastream.DSBody;
import jet.datastream.DSContainable;
import jet.datastream.DSContainer;
import jet.datastream.DSPage;
import jet.datastream.DSSection;
import jet.datastream.DataStream;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.export.util.ViewerExportingInfo;
import jet.thinviewer.JReportBody;
import jet.thinviewer.JReportContainer;
import jet.thinviewer.JReportObjectRender;
import jet.thinviewer.JReportViewer;
import jet.thinviewer.ViewerTools;
import jet.util.Containable;
import jet.util.PropertySetable;

public class JReportDrillDownViewer
extends JReportViewer {
    DSPage curPage = null;

    public JReportDrillDownViewer(DataStream dataStream, String string) {
        super(dataStream);
        this.groupby = string;
        this.res = dataStream.getCommunicator().getResolution();
    }

    @Override
    boolean hasDrillDown(String string) {
        return !this.groupby.equals(string);
    }

    public void setCurPage(DSPage dSPage) {
        this.curPage = dSPage;
        Insets insets = this.getInsets();
        Rectangle rectangle = dSPage.getPrintableArea();
        Rectangle rectangle2 = new Rectangle();
        rectangle2.x = Unit.convertUnitToPixel(rectangle.x, this.res) + insets.left;
        rectangle2.y = Unit.convertUnitToPixel(rectangle.y, this.res) + insets.top;
        rectangle2.width = Unit.convertUnitToPixel(rectangle.width, this.res);
        rectangle2.height = Unit.convertUnitToPixel(rectangle.height, this.res);
        this.viewerClient.setBounds(rectangle2);
    }

    @Override
    protected void addChild() {
        Object object;
        JReportContainer jReportContainer = null;
        int n = 0;
        int n2 = this.curPage.size();
        for (int i = 0; i < n2; ++i) {
            Containable containable;
            object = this.curPage.getObject(i);
            int n3 = ((JRObjectResult)object).getObjectType();
            if ((n3 & 0x200) == 512) {
                containable = (DSSection)object;
                Rectangle rectangle = ((JRVisiableResult)((Object)containable)).getBounds();
                jReportContainer = (JReportContainer)JReportDrillDownViewer.createViewObject((JRObjectResult)((Object)containable));
                jReportContainer.setExportInfo(this.info);
                jReportContainer.setProperty((PropertySetable)((Object)containable));
                jReportContainer.setBounds(rectangle.x, n, rectangle.width, rectangle.height);
                ViewerExportingInfo viewerExportingInfo = new ViewerExportingInfo();
                jReportContainer.setExportInfo(viewerExportingInfo);
                jReportContainer.createChildren((DSContainer)containable);
                this.viewerClient.add((Component)jReportContainer, 0);
                if (((Boolean)((JRVisiableResult)((Object)containable)).getPropertyByName("Underlay").getObject()).booleanValue()) continue;
                n += rectangle.height;
                continue;
            }
            if (n3 != 262177) continue;
            containable = (JReportBody)JReportDrillDownViewer.createViewObject((JRObjectResult)object);
            ((JReportBody)containable).setProperty((PropertySetable)object);
            ((Component)((Object)containable)).setBounds(((DSBody)object).getBounds());
            ((JReportBody)containable).createChildren((DSBody)object);
            this.viewerClient.add((Component)((Object)containable), 0);
        }
        this.add(this.viewerClient);
        this.validate();
        Dimension dimension = this.viewerClient.getSize();
        if (n > dimension.height) {
            object = this.getSize();
            this.setSize(((Dimension)object).width, ((Dimension)object).height + n - dimension.height);
            this.viewerClient.setSize(dimension.width, n);
            if (this.sizeChangedListener != null) {
                this.sizeChangedListener.viewerSizeChanged(this.getSize());
            }
        }
        this.status = 4;
    }

    @Override
    public void drillDown(String string, DSSection dSSection) throws JRStopEngineException {
        if (this.drillDownImplement != null) {
            int n = -1;
            try {
                n = this.I(dSSection);
            }
            catch (IOException iOException) {
                ViewerTools.writeErrorMessage(2401519, iOException);
                this.status = -1;
            }
            DSPage dSPage = null;
            if (n != -1) {
                dSPage = this.dataStream.getCommunicator().getDrillDownPage(dSSection.getDataStream().getSubIndex(), n, dSSection.getRecordIndex(), dSSection.getTemplateIndex(), (Integer)dSSection.getTemplate().getPropertyByName("BranchIdx").getObject(), dSSection);
            }
            if (dSPage != null) {
                this.drillDownImplement.addDrillDownCard(dSPage, string, dSSection.groupValue.toString(), this.dataStream);
            }
        }
    }

    private int I(DSSection dSSection) throws IOException, JRStopEngineException {
        int n = -1;
        int n2 = this.dataStream.getCommunicator().getPageNum();
        for (int i = 1; i <= n2; ++i) {
            DSPage dSPage = this.dataStream.getPage(i);
            if (!this.search(dSPage, dSSection)) continue;
            n = i;
            break;
        }
        return n;
    }

    private boolean search(DSContainable dSContainable, DSSection dSSection) {
        if (dSContainable.equals(dSSection)) {
            return true;
        }
        Vector vector = dSContainable.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)vector.get(i);
            if (!(jRObjectResult instanceof DSContainer) || !this.search((DSContainer)jRObjectResult, dSSection)) continue;
            return true;
        }
        return false;
    }

    static JReportObjectRender createViewObject(JRObjectResult jRObjectResult) {
        return ViewerTools.createViewObject(jRObjectResult, true);
    }
}

