/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import jet.datastream.DSField;
import jet.datastream.render.Render;
import jet.datastream.render.RenderButton;
import jet.export.ExportAuxInfo;
import jet.export.util.ExportingInfo;
import jet.thinviewer.JReportLCCheckbox;
import jet.thinviewer.JReportLCConfigPanel;
import jet.thinviewer.JReportLCContainer;
import jet.thinviewer.JReportLCDropdownList;
import jet.thinviewer.JReportLCMultiValueContainer;
import jet.thinviewer.JReportLCObject;
import jet.thinviewer.JReportLCTextfield;
import jet.thinviewer.JReportLCUtil;
import jet.util.PropertySetable;

public class JReportLCButton
extends JButton
implements JReportLCObject {
    DSField dsField;
    int specialID;

    @Override
    public void setProperty(PropertySetable propertySetable) {
        this.dsField = (DSField)propertySetable;
        RenderButton renderButton = (RenderButton)this.dsField.getRender();
        this.specialID = JReportLCUtil.getIntPropertyByName(this.dsField, "SpecialID");
        this.treatRender(renderButton);
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 500) {
            JReportLCContainer jReportLCContainer = (JReportLCContainer)SwingUtilities.getAncestorOfClass(JReportLCContainer.class, this);
            if (jReportLCContainer.listener != null) {
                JReportLCConfigPanel jReportLCConfigPanel = jReportLCContainer.getConfigPanel();
                jReportLCConfigPanel.setVisible(false);
                jReportLCConfigPanel.setSize(new Dimension(0, 0));
                jReportLCConfigPanel.validate();
                jReportLCContainer.changeIcon();
                jReportLCContainer.validateComponent();
                jReportLCContainer.listener.refresh(false);
                if (this.specialID == 2) {
                    for (Component component : jReportLCConfigPanel.getComponents()) {
                        if (component instanceof JReportLCCheckbox) {
                            ((JReportLCCheckbox)component).setSelected(((JReportLCCheckbox)component).getDefaultValue());
                            continue;
                        }
                        if (component instanceof JReportLCDropdownList) {
                            ((JReportLCDropdownList)component).setSelectedIndex(0);
                            continue;
                        }
                        if (component instanceof JReportLCMultiValueContainer) {
                            JList jList = ((JReportLCMultiValueContainer)component).getList();
                            jList.setListData(((JReportLCMultiValueContainer)component).getDefaultValue());
                            continue;
                        }
                        if (!(component instanceof JReportLCTextfield)) continue;
                        ((JReportLCTextfield)component).setText(((JReportLCTextfield)component).getDefaultValue());
                    }
                }
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public Dimension getPreferredSize() {
        return null;
    }

    @Override
    public void treatRender(Render render) {
        String string = render.getText();
        Font font = render.getFont();
        this.setFont(font);
        Color color = JReportLCUtil.getBorderColor(this.dsField);
        int n = JReportLCUtil.getBorderWidth(this.dsField, this.dsField.getResolution());
        LineBorder lineBorder = new LineBorder(color, n);
        this.setBorder(lineBorder);
        Color color2 = JReportLCUtil.getColorPropertyByName(this.dsField, "Background");
        Color color3 = JReportLCUtil.getColorPropertyByName(this.dsField, "Foreground");
        this.setBackground(color2);
        this.setForeground(color3);
        this.setText(string);
    }

    @Override
    public void getAuxinfo() {
    }

    @Override
    public void setauxinfo(ExportAuxInfo exportAuxInfo) {
    }

    @Override
    public void setLcView(boolean bl) {
    }

    @Override
    public void setExportInfo(ExportingInfo exportingInfo) {
    }
}

