/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import jet.controls.JetNumber;
import jet.datastream.DSField;
import jet.datastream.render.Render;
import jet.datastream.render.RenderCheckBox;
import jet.export.ExportAuxInfo;
import jet.export.util.ExportingInfo;
import jet.thinviewer.JReportLCObject;
import jet.thinviewer.JReportLCUtil;
import jet.util.PropertySetable;

public class JReportLCCheckbox
extends JCheckBox
implements JReportLCObject {
    DSField dsField;
    boolean defIsChecked = false;

    @Override
    public void setProperty(PropertySetable propertySetable) {
        this.dsField = (DSField)propertySetable;
        RenderCheckBox renderCheckBox = (RenderCheckBox)this.dsField.getRender();
        this.treatRender(renderCheckBox);
    }

    @Override
    public void treatRender(Render render) {
        boolean bl;
        Serializable serializable;
        RenderCheckBox renderCheckBox = (RenderCheckBox)render;
        Color color = JReportLCUtil.getBorderColor(this.dsField);
        int n = JReportLCUtil.getBorderWidth(this.dsField, this.dsField.getResolution());
        if (color != null && n != 0) {
            serializable = new LineBorder(color, n);
            this.setBorder((Border)((Object)serializable));
        }
        serializable = JReportLCUtil.getColorPropertyByName(this.dsField, "Background");
        Color color2 = JReportLCUtil.getColorPropertyByName(this.dsField, "Foreground");
        this.setBackground((Color)serializable);
        this.setForeground(color2);
        String string = renderCheckBox.getText();
        this.setSelected(renderCheckBox.isChecked());
        this.setFont(renderCheckBox.getFont());
        JetNumber jetNumber = (JetNumber)this.dsField.getPropertyByName("SpecialID");
        boolean bl2 = bl = jetNumber.intValue() == 1;
        if (bl) {
            this.setText(string);
        }
        this.setHorizontalAlignment(JReportLCUtil.getHorizontalAlignment(this.dsField));
        this.setVerticalAlignment(JReportLCUtil.getVerticalAlignment(this.dsField));
        this.SEDU(renderCheckBox.isChecked());
    }

    private void SEDU(boolean bl) {
        this.defIsChecked = bl;
    }

    public boolean getDefaultValue() {
        return this.defIsChecked;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public Dimension getPreferredSize() {
        return null;
    }

    @Override
    public void getAuxinfo() {
    }

    @Override
    public void setauxinfo(ExportAuxInfo exportAuxInfo) {
    }

    @Override
    public void setLcView(boolean bl) {
    }

    @Override
    public void setExportInfo(ExportingInfo exportingInfo) {
    }
}

