/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.border.LineBorder;
import jet.datastream.DSContainable;
import jet.datastream.DSMultiValueContainer;
import jet.datastream.DSPage;
import jet.datastream.JRObjectResult;
import jet.datastream.render.Render;
import jet.datastream.render.RenderDropDownList;
import jet.export.util.CCUtil;
import jet.thinviewer.JReportLCObject;
import jet.thinviewer.JReportLCUtil;
import jet.thinviewer.JReportNewContainer;
import jet.util.PropertySetable;

public class JReportLCDropdownList
extends JReportNewContainer
implements JReportLCObject {
    private Render I = null;
    private DSMultiValueContainer SEDU = null;
    private Color convertUnitToPixel;
    private Color getBorderColor;
    private String getBorderWidth = "";
    JComboBox comboBox;

    @Override
    public void setProperty(PropertySetable propertySetable) {
        this.SEDU = (DSMultiValueContainer)propertySetable;
        this.I = this.SEDU.getConfigRender();
        this.convertUnitToPixel = CCUtil.getColorPropertyByName(this.SEDU, "Background");
        if (this.convertUnitToPixel == null) {
            this.convertUnitToPixel = this.SEDU((DSContainable)this.SEDU.getParent());
        }
        this.resolution = this.SEDU.getResolution();
        this.getBorderColor = CCUtil.getColorPropertyByName(this.SEDU, "Foreground");
        if (this.I != null) {
            this.treatRender(this.I);
        }
    }

    private int I(RenderDropDownList renderDropDownList) {
        Vector vector = new Vector(renderDropDownList.getTexts());
        String string = renderDropDownList.getSelectedTexts();
        int n = -1;
        if (!vector.isEmpty()) {
            n = vector.indexOf(string);
        }
        return n;
    }

    private Color SEDU(DSContainable dSContainable) {
        if (dSContainable instanceof DSPage) {
            return ((DSPage)dSContainable).getDataStream().getCommunicator().getHeaderInfo((int)0).background;
        }
        Color color = CCUtil.getColorPropertyByName((JRObjectResult)((Object)dSContainable), "Background");
        if (color != null) {
            return color;
        }
        return this.SEDU((DSContainable)((JRObjectResult)((Object)dSContainable)).getParent());
    }

    @Override
    public void treatRender(Render render) {
        int n = Unit.convertUnitToPixel(render.getX(), this.resolution);
        int n2 = Unit.convertUnitToPixel(render.getY(), this.resolution);
        int n3 = Unit.convertUnitToPixel(render.getWidth(), this.resolution);
        int n4 = Unit.convertUnitToPixel(render.getHeight(), this.resolution);
        RenderDropDownList renderDropDownList = (RenderDropDownList)render;
        Vector vector = new Vector(renderDropDownList.getTexts());
        this.comboBox = new JComboBox(vector);
        this.comboBox.setBackground(this.convertUnitToPixel);
        this.comboBox.setForeground(this.getBorderColor);
        this.comboBox.setBounds(n, n2, n3, n4);
        this.comboBox.setSelectedIndex(this.I(renderDropDownList));
        Color color = JReportLCUtil.getBorderColor(this.SEDU);
        int n5 = JReportLCUtil.getBorderWidth(this.SEDU, this.SEDU.getResolution());
        LineBorder lineBorder = new LineBorder(color, n5);
        this.comboBox.setBorder(lineBorder);
        Color color2 = JReportLCUtil.getColorPropertyByName(this.SEDU, "Background");
        Color color3 = JReportLCUtil.getColorPropertyByName(this.SEDU, "Foreground");
        this.comboBox.setFont(renderDropDownList.getFont());
        this.add(this.comboBox);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
    }

    public void setSelectedIndex(int n) {
        this.comboBox.setSelectedIndex(n);
    }
}

