/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import com.jinfonet.util.JRLog;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.List;
import jet.datastream.DSContainer;
import jet.datastream.DSGroup;
import jet.datastream.DSMultiValueContainer;
import jet.datastream.DSReference;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.thinviewer.JReportChartPlatform;
import jet.thinviewer.JReportContainerable;
import jet.thinviewer.JReportLCButton;
import jet.thinviewer.JReportLCParagraph;
import jet.thinviewer.JReportLCUtil;
import jet.thinviewer.JReportNewContainer;
import jet.thinviewer.JReportObjectRender;
import jet.thinviewer.JReportParagraph;
import jet.thinviewer.ViewerTools;
import jet.udo.JRObjectRender;
import jet.util.JRInterruptedException;
import jet.util.PropertySetable;

public class JReportLCTextbox
extends JReportNewContainer {
    @Override
    public void setProperty(PropertySetable propertySetable) {
        super.setProperty(propertySetable);
    }

    @Override
    public void createChildren(DSContainer dSContainer) {
        this.removeAll();
        List list = dSContainer.getChildren();
        list = ViewerTools.zOrder(list);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)list.get(i);
            JRObjectRender jRObjectRender = null;
            try {
                jRObjectRender = this.createComponent(jRObjectResult);
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, "JRInterruptedException", (Throwable)jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                ViewerTools.writeErrorMessage(2401503, exception);
            }
            if (jRObjectRender != null) {
                if (jRObjectRender instanceof JReportLCButton) {
                    this.add((Component)((Object)jRObjectRender), 0);
                } else {
                    this.add((Component)((Object)jRObjectRender));
                }
            }
            this.validate();
        }
    }

    @Override
    public JRObjectRender createComponent(JRObjectResult jRObjectResult) {
        while (jRObjectResult instanceof DSReference) {
            jRObjectResult = ((DSReference)jRObjectResult).getRefData();
        }
        if (!this.info.isExport(jRObjectResult)) {
            return null;
        }
        JReportObjectRender jReportObjectRender = JReportLCUtil.createViewObject(jRObjectResult, false);
        if (jReportObjectRender != null) {
            JRVisiableResult jRVisiableResult = (JRVisiableResult)jRObjectResult;
            jReportObjectRender.setProperty(jRVisiableResult);
            Rectangle rectangle = jRVisiableResult.getBounds();
            if (jReportObjectRender instanceof JReportLCParagraph || jReportObjectRender instanceof JReportParagraph) {
                ((JReportParagraph)jReportObjectRender).setActualSize(rectangle);
            }
            if (jRVisiableResult instanceof DSContainer && !(jRVisiableResult instanceof DSMultiValueContainer)) {
                ((JReportContainerable)((Object)jReportObjectRender)).createChildren((DSContainer)jRVisiableResult);
            }
            if (!(jReportObjectRender instanceof JReportChartPlatform)) {
                ((Component)((Object)jReportObjectRender)).setBounds(rectangle);
            }
        } else if (!(jRObjectResult instanceof DSGroup) && JRLog.isTrace(5)) {
            JRLog.trace(5, 2401518, jRObjectResult);
        }
        return jReportObjectRender;
    }
}

