/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import guitools.Painter;
import guitools.toolkit.FigurePeer;
import guitools.toolkit.TComponent;
import guitools.toolkit.Unit;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import jet.connect.Record;
import jet.datastream.JRObjectResult;
import jet.export.ExportAuxInfo;
import jet.export.util.CCUtil;
import jet.export.util.ExportingInfo;
import jet.thinviewer.JReportObjectRender;
import jet.util.PropertySetable;

public class JReportLine
extends TComponent
implements JReportObjectRender,
FigurePeer {
    int x1;
    int y1;
    int x2;
    int y2;
    int lineWidth;
    int lineStyle;

    public JReportLine() {
        this.setEraser(false);
    }

    @Override
    public void setProperty(PropertySetable propertySetable) {
        JRObjectResult jRObjectResult = (JRObjectResult)propertySetable;
        int n = jRObjectResult.getResolution();
        this.setForeground(CCUtil.getColorPropertyByName(jRObjectResult, "LineColor"));
        this.lineStyle = CCUtil.getIntPropertyByName(jRObjectResult, "LineStyle");
        this.lineWidth = CCUtil.getIntPropertyByName(jRObjectResult, "LineWidth");
        this.lineWidth = Unit.convertUnitToPixel(this.lineWidth, n);
    }

    public void setCoordinates(int n, int n2, int n3, int n4) {
        this.x1 = n;
        this.y1 = n2;
        this.x2 = n3;
        this.y2 = n4;
        this.SEDU();
    }

    private void SEDU() {
        Rectangle rectangle = new Rectangle(this.x2 < this.x1 ? this.x2 : this.x1, this.y2 < this.y1 ? this.y2 : this.y1, this.x2 > this.x1 ? this.x2 - this.x1 + 1 : this.x1 - this.x2 + 1, this.y2 > this.y1 ? this.y2 - this.y1 + 1 : this.y1 - this.y2 + 1);
        if (this.lineWidth > 1) {
            if (Math.abs(this.x2 - this.x1) < this.lineWidth) {
                rectangle.x -= this.lineWidth / 2;
                rectangle.width = this.lineWidth;
            }
            if (Math.abs(this.y2 - this.y1) < this.lineWidth) {
                rectangle.y -= this.lineWidth / 2;
                rectangle.height = this.lineWidth;
            }
        }
        this.setBounds(rectangle);
    }

    @Override
    public final void paintShape(Graphics graphics) {
        Point point = this.getLocation();
        Painter.drawLine(graphics, this.x1 - point.x, this.y1 - point.y, this.x2 - point.x, this.y2 - point.y, this.getForeground(), this.lineWidth, this.lineStyle);
    }

    @Override
    public final void paintInterior(Graphics graphics) {
    }

    public void setProperty(PropertySetable propertySetable, Record record) {
    }

    @Override
    public void getAuxinfo() {
    }

    @Override
    public void setauxinfo(ExportAuxInfo exportAuxInfo) {
    }

    @Override
    public void setLcView(boolean bl) {
    }

    @Override
    public void setExportInfo(ExportingInfo exportingInfo) {
    }
}

