/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import com.jinfonet.util.JRLog;
import guitools.Painter;
import guitools.PainterConstants;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import jet.datastream.DSContainer;
import jet.datastream.DSParameterForm;
import jet.export.util.BorderProperties;
import jet.export.util.CCUtil;
import jet.export.util.DrawBorderAdapter;
import jet.export.util.FillPatternAdapter;
import jet.export.util.FillPatternProperties;
import jet.thinviewer.JReportBody;
import jet.thinviewer.JReportChartHeatMapGroupRect;
import jet.thinviewer.JReportContainer;
import jet.thinviewer.JReportSection;
import jet.thinviewer.JReportTableRow;
import jet.thinviewer.ViewerTools;
import jet.util.PropertySetable;

class JReportNewContainer
extends JReportContainer {
    int[] borderStyle = null;
    int[] borderWidth = null;
    Color[] borderColor = null;
    boolean hasShadow = false;
    Color shadowColor = null;
    boolean isSuccess = true;
    int shadowWidth = 0;
    boolean isDrawDSFormTitle = false;
    DSFormParameterTtile DSPTitle = null;
    BorderProperties borderProp = null;
    Color patternColor;
    int patternStyle;

    JReportNewContainer() {
    }

    @Override
    public void setProperty(PropertySetable propertySetable) {
        Object object;
        super.setProperty(propertySetable);
        DSContainer dSContainer = (DSContainer)propertySetable;
        if (dSContainer.getObjectType() == 262184) {
            object = (DSParameterForm)propertySetable;
            this.isDrawDSFormTitle = this.getBooleanPropertyByName(dSContainer, "IsShowTitle");
            this.patternStyle = this.getIntPropertyByName(dSContainer, "PatternStyle");
            this.patternColor = this.getColorPropertyByName(dSContainer, "PatternColor");
            if (this.isDrawDSFormTitle) {
                this.DSPTitle = new DSFormParameterTtile((DSParameterForm)object);
            }
        }
        if (dSContainer.getObjectType() == 45 && ((BorderProperties)(object = DrawBorderAdapter.ConvertBorderProperties(dSContainer, this.resolution))).getBorderJoint() == BorderProperties.BORDERJOINT_ROUND) {
            this.borderProp = object;
        }
        boolean bl = true;
        if (this instanceof JReportBody && this.isLCView) {
            bl = false;
        }
        if (bl && this.borderProp == null) {
            try {
                this.borderStyle = new int[4];
                this.borderWidth = new int[4];
                this.borderColor = new Color[4];
                this.shadowWidth = Unit.convertUnitToPixel(PainterConstants.DEFAULT_SHADOW_WIDTH, this.resolution);
                this.borderStyle[0] = this.getIntPropertyByName(dSContainer, "TopLine");
                this.borderStyle[1] = this.getIntPropertyByName(dSContainer, "BottomLine");
                this.borderStyle[2] = this.getIntPropertyByName(dSContainer, "LeftLine");
                this.borderStyle[3] = this.getIntPropertyByName(dSContainer, "RightLine");
                this.borderWidth[0] = Unit.convertUnitToPixel(this.getIntPropertyByName(dSContainer, "border-top-width"), this.resolution);
                this.borderWidth[1] = Unit.convertUnitToPixel(this.getIntPropertyByName(dSContainer, "border-bottom-width"), this.resolution);
                this.borderWidth[2] = Unit.convertUnitToPixel(this.getIntPropertyByName(dSContainer, "border-left-width"), this.resolution);
                this.borderWidth[3] = Unit.convertUnitToPixel(this.getIntPropertyByName(dSContainer, "border-right-width"), this.resolution);
                this.borderColor[0] = this.getColorPropertyByName(dSContainer, "border-top-color");
                this.borderColor[1] = this.getColorPropertyByName(dSContainer, "border-bottom-color");
                this.borderColor[2] = this.getColorPropertyByName(dSContainer, "border-left-color");
                this.borderColor[3] = this.getColorPropertyByName(dSContainer, "border-right-color");
                this.hasShadow = this.getBooleanPropertyByName(dSContainer, "Shadow");
                this.shadowColor = this.getColorPropertyByName(dSContainer, "ShadowColor");
            }
            catch (NullPointerException nullPointerException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, 2401520, propertySetable, (Throwable)nullPointerException);
                }
                this.isSuccess = false;
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Shape shape;
        Rectangle rectangle;
        if (!(this instanceof JReportSection) && !(this instanceof JReportChartHeatMapGroupRect)) {
            if (this instanceof JReportTableRow || this instanceof JReportBody) {
                this.BORDERJOINT_ROUND(graphics);
            } else {
                this.drawBackGround(graphics);
            }
        }
        if (this.isDrawDSFormTitle && this.DSPTitle != null) {
            rectangle = this.DSPTitle.getRect();
            shape = new Rectangle(Unit.convertUnitToPixel(rectangle.x, this.resolution), Unit.convertUnitToPixel(rectangle.y, this.resolution), Unit.convertUnitToPixel(rectangle.width, this.resolution), Unit.convertUnitToPixel(rectangle.height, this.resolution));
            Painter.drawBox(graphics, ((Rectangle)shape).x, ((Rectangle)shape).y, ((Rectangle)shape).width, ((Rectangle)shape).height, this.DSPTitle.getBGColor(), null, 0, 0);
            Painter.drawText(graphics, (Rectangle)shape, this.DSPTitle.getColorPropertyByName, this.DSPTitle.getFont(), this.DSPTitle.getFGColor(), false, this.DSPTitle.getUnderLine(), this.DSPTitle.getStrikout(), this.DSPTitle.getAlign(), true);
        }
        rectangle = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        if (this.patternColor != null && this.patternStyle != 0) {
            Painter.drawPattern(graphics, rectangle, this.patternColor, this.patternStyle);
        }
        shape = graphics.getClip();
        super.paint(graphics);
        if (this.isSuccess) {
            Dimension dimension = this.getSize();
            Color color = this.hasEraser() ? this.getBackground() : null;
            ViewerTools.drawBorder(graphics, dimension, color, this.borderStyle, this.borderWidth, this.borderColor, this.hasShadow, this.hasShadow, this.hasShadow, this.hasShadow, this.shadowColor, this.shadowWidth);
        }
        graphics.setClip(shape);
    }

    private void BORDERJOINT_ROUND(Graphics graphics) {
        FillPatternProperties fillPatternProperties = this.getFillProp();
        if (fillPatternProperties != null) {
            FillPatternAdapter fillPatternAdapter = new FillPatternAdapter(fillPatternProperties);
            Dimension dimension = this.getSize();
            fillPatternAdapter.fillPattern(graphics, new Rectangle(0, 0, dimension.width, dimension.height));
        }
    }

    protected void drawBackGround(Graphics graphics) {
        Dimension dimension = this.getSize();
        Color color = this.getBackground();
        if (color != null && this.hasEraser()) {
            graphics.setColor(color);
            int n = dimension.width;
            int n2 = dimension.height;
            if (this.hasShadow) {
                n -= this.shadowWidth;
                n2 -= this.shadowWidth;
            }
            graphics.fillRect(0, 0, n, n2);
        }
    }

    class DSFormParameterTtile {
        private DSParameterForm SEDU = null;
        private Rectangle getBooleanPropertyByName = null;
        private String getColorPropertyByName = null;
        private Color getIntPropertyByName = null;
        private Color getStringPropertyByName = null;
        private Font getTitleFont;
        private boolean getTitleRec;
        private boolean length;
        private int I;

        DSFormParameterTtile(DSParameterForm dSParameterForm) {
            this.SEDU = dSParameterForm;
            this.SEDU();
        }

        private void SEDU() {
            this.getBooleanPropertyByName = this.SEDU.getTitleRec();
            this.getColorPropertyByName = CCUtil.getStringPropertyByName(this.SEDU, "TitleText");
            if (this.getColorPropertyByName != null && this.getColorPropertyByName.length() > 0) {
                this.getTitleFont = this.SEDU.getTitleFont();
                this.getTitleRec = CCUtil.getBooleanPropertyByName(this.SEDU, "TitleUnderline");
                this.length = false;
                int n = CCUtil.getIntPropertyByName(this.SEDU, "TitleHorizontalAlignment");
                this.I = n == 1 ? 3 : (n == 3 ? 0 : n);
                this.getIntPropertyByName = CCUtil.getColorPropertyByName(this.SEDU, "TitleForeground");
                this.getStringPropertyByName = CCUtil.getColorPropertyByName(this.SEDU, "TitleBackground");
            }
        }

        Font getFont() {
            return this.getTitleFont;
        }

        Rectangle getRect() {
            return this.getBooleanPropertyByName;
        }

        Color getFGColor() {
            return this.getIntPropertyByName;
        }

        Color getBGColor() {
            return this.getStringPropertyByName;
        }

        boolean getUnderLine() {
            return this.getTitleRec;
        }

        boolean getStrikout() {
            return this.length;
        }

        int getAlign() {
            return this.I;
        }
    }
}

