/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import jet.datastream.DSContainer;
import jet.datastream.DSParagraph;
import jet.datastream.JRObjectResult;
import jet.thinviewer.JReportContainer;
import jet.thinviewer.ViewerTools;
import jet.udo.JRObjectRender;
import jet.util.JRInterruptedException;
import jet.util.PropertySetable;

public class JReportParagraph
extends JReportContainer {
    private Rectangle I;
    int[] borderStyle = new int[4];
    int[] borderWidth = new int[4];
    Color[] borderColor = new Color[4];
    private boolean SEDU = true;
    private boolean convertUnitToPixel = false;

    @Override
    public void setProperty(PropertySetable propertySetable) {
        super.setProperty(propertySetable);
        DSParagraph dSParagraph = (DSParagraph)propertySetable;
        if (!this.convertUnitToPixel) {
            this.setBounds(dSParagraph.getBounds());
        }
        try {
            DSContainer dSContainer = (DSContainer)propertySetable;
            this.borderStyle[0] = this.getIntPropertyByName(dSContainer, "TopLine");
            this.borderStyle[1] = this.getIntPropertyByName(dSContainer, "BottomLine");
            this.borderStyle[2] = this.getIntPropertyByName(dSContainer, "LeftLine");
            this.borderStyle[3] = this.getIntPropertyByName(dSContainer, "RightLine");
            this.borderWidth[0] = Unit.convertUnitToPixel(this.getIntPropertyByName(dSContainer, "border-top-width"), this.resolution);
            this.borderWidth[1] = Unit.convertUnitToPixel(this.getIntPropertyByName(dSContainer, "border-bottom-width"), this.resolution);
            this.borderWidth[2] = Unit.convertUnitToPixel(this.getIntPropertyByName(dSContainer, "border-left-width"), this.resolution);
            this.borderWidth[3] = Unit.convertUnitToPixel(this.getIntPropertyByName(dSContainer, "border-right-width"), this.resolution);
            this.borderColor[0] = this.getColorPropertyByName(dSContainer, "border-top-color");
            this.borderColor[1] = this.getColorPropertyByName(dSContainer, "border-bottom-color");
            this.borderColor[2] = this.getColorPropertyByName(dSContainer, "border-left-color");
            this.borderColor[3] = this.getColorPropertyByName(dSContainer, "border-right-color");
        }
        catch (NullPointerException nullPointerException) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 2401520, propertySetable, (Throwable)nullPointerException);
            }
            this.SEDU = false;
        }
    }

    protected void setActualSize(Rectangle rectangle) {
        this.I = rectangle;
    }

    @Override
    public void createChildren(DSContainer dSContainer) {
        this.removeAll();
        List list = dSContainer.getChildren();
        list = ViewerTools.zOrder(list);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            JRObjectResult jRObjectResult = (JRObjectResult)list.get(i);
            JRObjectRender jRObjectRender = null;
            if (!this.info.isExport(jRObjectResult)) continue;
            try {
                jRObjectRender = this.createComponent(jRObjectResult);
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, "JRInterruptedException", (Throwable)jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                ViewerTools.writeErrorMessage(2401507, exception);
            }
            if (jRObjectRender == null) continue;
            this.add((Component)((Object)jRObjectRender));
        }
    }

    private void I(Graphics graphics) {
        Color color = this.getBackground();
        if (color != null && this.hasEraser()) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.I.width, this.I.height);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.convertUnitToPixel) {
            graphics.setClip(this.I.x, this.I.y, this.I.width, this.I.height);
        }
        super.paint(graphics);
        if (this.SEDU) {
            Dimension dimension = new Dimension(this.I.width, this.I.height);
            Color color = this.hasEraser() ? this.getBackground() : null;
            ViewerTools.drawBorder(graphics, dimension, color, this.borderStyle, this.borderWidth, this.borderColor, false, false, false, false, null, 0);
        }
    }

    public void resetXY(boolean bl) {
    }
}

