/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import guitools.Painter;
import guitools.PainterConstants;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Graphics;
import jet.datastream.DSTextObj;
import jet.thinviewer.JReportContainer;
import jet.util.PropertySetable;

public class JReportTextObject
extends JReportContainer
implements PainterConstants {
    Color borderColor;
    int borderWidth;
    int leftStyle;
    int rightStyle;
    int topStyle = 0;
    int bottomStyle = 0;
    boolean drawShadow;
    Color shadowColor;
    int shadowWidth;
    boolean isStart;
    boolean isFinish;

    @Override
    public void setProperty(PropertySetable propertySetable) {
        super.setProperty(propertySetable);
        DSTextObj dSTextObj = (DSTextObj)propertySetable;
        this.isStart = ((DSTextObj)propertySetable).getStartYPos() == 0;
        this.isFinish = ((DSTextObj)propertySetable).isFinish();
        this.borderColor = this.getColorPropertyByName(dSTextObj, "BorderColor");
        this.borderWidth = this.getIntPropertyByName(dSTextObj, "BorderWidth");
        this.borderWidth = Unit.convertUnitToPixel(this.borderWidth, this.resolution);
        if (this.isStart) {
            this.topStyle = this.getIntPropertyByName(dSTextObj, "TopLine");
        }
        if (this.isFinish) {
            this.bottomStyle = this.getIntPropertyByName(dSTextObj, "BottomLine");
        }
        this.leftStyle = this.getIntPropertyByName(dSTextObj, "LeftLine");
        this.rightStyle = this.getIntPropertyByName(dSTextObj, "RightLine");
        this.drawShadow = this.getBooleanPropertyByName(dSTextObj, "Shadow");
        this.shadowColor = this.getColorPropertyByName(dSTextObj, "ShadowColor");
        this.shadowWidth = Unit.convertUnitToPixel(DEFAULT_SHADOW_WIDTH, this.resolution);
    }

    @Override
    public void paint(Graphics graphics) {
        Painter.drawBorder(graphics, this.getSize(), this.hasEraser() ? this.getBackground() : null, this.borderColor, this.borderWidth, this.topStyle, this.bottomStyle, this.leftStyle, this.rightStyle, this.drawShadow && this.isFinish, this.drawShadow, this.drawShadow && this.isFinish, this.isStart, this.shadowColor, this.shadowWidth);
        super.paint(graphics);
    }
}

