/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.common.api.JdbcDriversConfig;
import com.jinfonet.dataservice.schema.relational.datasource.relational.RdbConnection;
import java.security.acl.NotOwnerException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.acl.JetAcl;
import jet.acl.JetPolicy;
import jet.acl.PermissionManager;
import jet.connect.DbColumnLink;
import jet.connect.DbDecimal;
import jet.connect.DbQuery;
import jet.connect.DbTableLink;
import jet.cs.jacl.JPermissionLinkException;
import jet.cs.jacl.JPolicyLinkException;
import jet.cs.jacl.SecurityData;
import jet.dataengine.api.DSException;
import jet.dataengine8.core.queryengine.querybuilder.info.NamingTools;
import jet.dataengine8.core.queryengine.sqltoolkit.CritNode;
import jet.dataengine8.core.queryengine.sqltoolkit.WCParser;
import jet.dataengine8.core.queryengine.transform.QueryTransform;
import jet.formula.ParamDesc;
import jet.log.JRLogger;
import jet.server.api.SecurityContext;
import jet.universe.DataCollectionNameFinder;
import jet.universe.JetUAcl;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUField;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUParameter;
import jet.universe.JetUSupportInfo;
import jet.universe.JetUTableView;
import jet.universe.JetUUniverse;
import jet.universe.psql.FileQuery;
import jet.util.RLSTools;
import toolkit.db.PsqlQuery;
import toolkit.db.gui.JdbcDatabase;
import toolkit.db.gui.MappingSQLType;
import toolkit.db.version2.CallTrace;

public class DataCollection {
    private boolean conFormat = false;
    private static JRLogger logger = JRLogger.getLogger(DataCollection.class.getName());
    private int recordsToDisplay = -1;
    private String securityEntry = null;
    private String userName = null;
    private SecurityContext sc = null;
    private SecurityData sd = null;
    private JdbcDriversConfig jdc;

    public DataCollection() {
        this(null);
    }

    public DataCollection(JdbcDriversConfig config) {
        this.jdc = config;
        if (this.jdc == null && logger.isDebugEnabled()) {
            logger.debug("DataCollection(...): jdbc driver config is null.");
        }
    }

    public void setConFormat(boolean isConFormat) {
        this.conFormat = isConFormat;
    }

    public Vector[] getResultSet(JetUUniverse unvs, String sourceName, String column, Vector columns) throws SQLException, ClassNotFoundException {
        return this.getResultSet(unvs, sourceName, column, columns, false);
    }

    public Vector[] getResultSet(JetUUniverse unvs, String sourceName, String column, Vector columns, boolean isDistinct) throws SQLException, ClassNotFoundException {
        Vector[] ret = this.getResultSet(unvs, sourceName, column, columns, isDistinct, "");
        String message = "sourceName = " + sourceName + "; column = " + column + "; columns = " + columns;
        if (ret.length == 0) {
            logger.info("DataCollection returns empty value list.");
        }
        logger.info(message, new CallTrace());
        return ret;
    }

    public Vector[] getResultSet(JetUUniverse unvs, String sourceName, String column, Vector columns, boolean isDistinct, String userFormat) throws SQLException, ClassNotFoundException {
        JetUJDBCConnection connection = (JetUJDBCConnection)unvs.getDatabase(sourceName).getConnection();
        JdbcDatabase jdb = new JdbcDatabase(connection.getURL(), connection.getUID(), connection.getPSWD(), connection.getJdbcDriver());
        JetUSupportInfo suppInfo = connection.getSupportInfo();
        String strExtraNameChar = suppInfo.getExtraNameChar();
        String strExtraKeywords = suppInfo.getExtraKeywords();
        String strQuoteChar = suppInfo.getQuoteChar();
        int pattern = connection.getQualifiedNamePattern();
        return this.getResultSet(jdb, strExtraNameChar, strExtraKeywords, strQuoteChar, pattern, unvs, sourceName, column, columns, isDistinct, userFormat);
    }

    public Vector[] getResultSet(JdbcDatabase jdb, String strExtraNameChar, String strExtraKeywords, String strQuoteChar, int pattern, JetUUniverse unvs, String sourceName, String column, Vector columns, boolean isDistinct, String userFormat) throws SQLException, ClassNotFoundException {
        String[] cols = new String[columns == null ? 0 : columns.size()];
        int i = cols.length;
        while (--i >= 0) {
            cols[i] = (String)columns.elementAt(i);
        }
        return this.getResultSet(jdb, strExtraNameChar, strExtraKeywords, strQuoteChar, pattern, unvs, sourceName, column, cols, isDistinct, userFormat, true);
    }

    public Vector[] getResultSet(JetUUniverse unvs, String sourceName, String column, String[] columns) throws SQLException, ClassNotFoundException {
        return this.getResultSet(unvs, sourceName, column, columns, false);
    }

    public Vector[] getResultSet(JetUUniverse unvs, String sourceName, String column, String[] columns, boolean isDistinct) throws SQLException, ClassNotFoundException {
        return this.getResultSet(unvs, sourceName, column, columns, isDistinct, "");
    }

    public Vector[] getResultSet(JetUUniverse unvs, String sourceName, String column, String[] columns, boolean isDistinct, String userFormat) throws SQLException, ClassNotFoundException {
        return this.getResultSet(unvs, sourceName, column, columns, isDistinct, userFormat, false);
    }

    public Vector[] getResultSet(JetUUniverse unvs, String sourceName, String column, String[] columns, boolean isDistinct, String userFormat, boolean isBindParam) throws SQLException, ClassNotFoundException {
        JetUJDBCConnection connection = (JetUJDBCConnection)unvs.getDatabase(sourceName).getConnection();
        JdbcDatabase jdb = new JdbcDatabase(connection.getURL(), connection.getUID(), connection.getPSWD(), connection.getJdbcDriver());
        JetUSupportInfo suppInfo = connection.getSupportInfo();
        String strExtraNameChar = suppInfo.getExtraNameChar();
        String strExtraKeywords = suppInfo.getExtraKeywords();
        String strQuoteChar = suppInfo.getQuoteChar();
        int pattern = connection.getQualifiedNamePattern();
        return this.getResultSet(jdb, strExtraNameChar, strExtraKeywords, strQuoteChar, pattern, unvs, sourceName, column, columns, isDistinct, userFormat, isBindParam);
    }

    public Vector[] getResultSet(JetUUniverse unvs, ParamDesc param, Hashtable allParamDescs) throws SQLException, ClassNotFoundException {
        String sourceName = param.getDataSource();
        JetUJDBCConnection connection = (JetUJDBCConnection)unvs.getDatabase(sourceName).getConnection();
        JdbcDatabase jdb = new JdbcDatabase(connection.getURL(), connection.getUID(), connection.getPSWD(), connection.getJdbcDriver());
        JetUSupportInfo suppInfo = connection.getSupportInfo();
        String strExtraNameChar = suppInfo.getExtraNameChar();
        String strExtraKeywords = suppInfo.getExtraKeywords();
        String strQuoteChar = suppInfo.getQuoteChar();
        int pattern = connection.getQualifiedNamePattern();
        String column = param.getColumn();
        Vector vColumns = param.getColumns();
        String[] columns = new String[vColumns == null ? 0 : vColumns.size()];
        int i = columns.length;
        while (--i >= 0) {
            columns[i] = (String)vColumns.elementAt(i);
        }
        boolean isDistinct = param.isDistinct();
        String userFormat = param.getFormat();
        return this.getResultSet(jdb, strExtraNameChar, strExtraKeywords, strQuoteChar, pattern, unvs, sourceName, column, columns, isDistinct, userFormat, true, param, allParamDescs);
    }

    private Vector[] getResultSet(JdbcDatabase jdb, String strExtraNameChar, String strExtraKeywords, String strQuoteChar, int pattern, JetUUniverse unvs, String sourceName, String column, String[] columns, boolean isDistinct, String userFormat, boolean isBindParam) throws SQLException, ClassNotFoundException {
        return this.getResultSet(jdb, strExtraNameChar, strExtraKeywords, strQuoteChar, pattern, unvs, sourceName, column, columns, isDistinct, userFormat, isBindParam, null, null);
    }

    public void setRecordsToDisplay(int recordsToDisplay) {
        this.recordsToDisplay = recordsToDisplay;
    }

    public int getRecordsToDisplay() {
        return this.recordsToDisplay;
    }

    public void setRLSContext(String securityEntry, String userName, SecurityContext sc, SecurityData sd) {
        this.securityEntry = securityEntry;
        this.userName = userName;
        this.sc = sc;
        this.sd = sd;
    }

    public void unsetRLSContext() {
        this.setRLSContext(null, null, null, null);
    }

    private JetPolicy getPolicy(JetUDatabase udb, String securityEntry, String userName, SecurityContext sc, SecurityData sd) throws JPermissionLinkException, JPolicyLinkException, NotOwnerException {
        JetUAcl uAcl = udb.getAclByResourceName(securityEntry);
        JetAcl acl = uAcl.getAcl();
        PermissionManager pm = null;
        pm = sc == null ? (sd == null ? new PermissionManager(acl, userName) : new PermissionManager(acl, userName, sd)) : new PermissionManager(acl, sc);
        JetPolicy policy = pm.getRLSPolicy();
        return policy;
    }

    public void setJdbcDriversConfig(JdbcDriversConfig jdc) {
        this.jdc = jdc;
    }

    private String toDBName(String mappingName, JetUUniverse unvs, String sourceName) throws DSException {
        JetUConnection conn = unvs.getDatabase(sourceName).getConnection();
        RdbConnection rdbConn = (RdbConnection)QueryTransform.parseConnection(conn);
        JetUField uf = (JetUField)unvs.getResourceByName(sourceName, null, mappingName);
        return NamingTools.getDSName(rdbConn, uf);
    }

    private String getSQLstatement(ParamDesc param, Hashtable allParamDescs, JetUUniverse unvs, String sourceName) throws DSException {
        String sql = param.getImportSql();
        sql = sql.substring(0, sql.indexOf("WHERE") + "WHERE".length());
        sql = sql + " ";
        String preParam = param.getPreviousLevel();
        while (preParam != null && preParam.length() > 0) {
            ParamDesc preLevel = (ParamDesc)allParamDescs.get(preParam.toUpperCase());
            if (preLevel.isMultipleValue() && preLevel.isAllSelected()) {
                sql = sql + " 1=1 ";
            } else {
                String colName = this.toDBName(preLevel.getColumn(), unvs, sourceName);
                String op = preLevel.isMultipleValue() ? " IN " : " = ";
                sql = sql + colName + op + "@\"" + preLevel.name + "\"";
            }
            if ((preParam = preLevel.getPreviousLevel()) == null || preParam.length() <= 0) continue;
            sql = sql + " AND ";
        }
        return sql;
    }

    public Vector[] getResultSet(JdbcDatabase jdb, String strExtraNameChar, String strExtraKeywords, String strQuoteChar, int pattern, JetUUniverse unvs, String sourceName, String column, String[] columns, boolean isDistinct, String userFormat, boolean isBindParam, ParamDesc param, Hashtable allParamDescs) throws SQLException, ClassNotFoundException {
        String importSql = param == null ? null : param.getImportSql();
        boolean bImportSql = importSql != null && importSql.trim().length() > 0;
        columns = columns == null ? new String[]{} : columns;
        Vector[] result = new Vector[columns.length + 1];
        int i = result.length;
        while (--i >= 0) {
            result[i] = new Vector(16);
        }
        JetPolicy policy = null;
        String whereString = null;
        if (this.securityEntry != null) {
            try {
                policy = this.getPolicy(unvs.getDatabase(sourceName), this.securityEntry, this.userName, this.sc, this.sd);
                if (policy == null) {
                    return result;
                }
                WCParser wcp = new WCParser(0);
                DataCollectionNameFinder nameFinder = new DataCollectionNameFinder(unvs, sourceName, this.userName, strExtraNameChar, strQuoteChar, strExtraKeywords, pattern);
                Vector vGrp = RLSTools.mergeSCGroups(policy);
                whereString = PsqlQuery.getStringOfWPGroups(vGrp);
                CritNode cn = wcp.parse(nameFinder, whereString);
                if (cn != null) {
                    whereString = cn.getServerNode().getConditionString();
                }
            }
            catch (Exception e) {
                logger.error(e);
                return result;
            }
        }
        JetUField field = (JetUField)unvs.getMaterialByName(sourceName, column);
        JetUTableView table = field.getTable();
        String type = MappingSQLType.mapSQLTypeToString(field.getSqlType());
        String format = null;
        SimpleDateFormat dateFormat = null;
        if (type.equals("Date")) {
            format = "yyyy-MM-dd";
        } else if (type.equals("DateTime")) {
            format = "yyyy-MM-dd HH:mm:ss.SSS";
        } else if (type.equals("Time")) {
            format = "hh:mm:ss";
        }
        if (format != null) {
            dateFormat = new SimpleDateFormat(format);
        }
        if (type.equals("Currency") && field.currency.get() <= 0) {
            type = "Number";
        }
        DbQuery dbQuery = new DbQuery(jdb, strExtraNameChar, strQuoteChar, strExtraKeywords);
        if (this.jdc != null) {
            dbQuery.setJdbcDriversConfig(this.jdc);
        }
        if (!bImportSql) {
            dbQuery.setQlfOpt(pattern);
            dbQuery.setDistinct(isDistinct);
            String tableName = table.tableName.get();
            DbTableLink dbTable = new DbTableLink(table.qualifier.get(), table.owner.get(), tableName, null, table.getResourceName(), strExtraNameChar, strQuoteChar, strExtraKeywords);
            dbTable.appendColumn(new DbColumnLink(field.name.get().toUpperCase(), field.colName.get()));
            for (int i2 = 0; i2 < columns.length; ++i2) {
                field = (JetUField)unvs.getMaterialByName(sourceName, columns[i2]);
                dbTable.appendColumn(new DbColumnLink(field.name.get().toUpperCase(), field.colName.get()));
            }
            dbQuery.appendTable(dbTable);
            if (whereString != null && !whereString.equals("")) {
                dbQuery.setWhereClause(whereString);
            }
        } else {
            if (param.isCascading() && param.getPreviousLevel() != null && param.getPreviousLevel().length() > 0) {
                try {
                    importSql = this.getSQLstatement(param, allParamDescs, unvs, sourceName);
                }
                catch (DSException e) {
                    throw new SQLException(e.getMessage());
                }
            }
            importSql = this.resolveImportSqlStatement(importSql, param, unvs, allParamDescs, isDistinct);
            if (whereString != null && !whereString.equals("")) {
                importSql = importSql.toUpperCase().indexOf(" WHERE ") > 0 ? importSql + " AND " + whereString : importSql + " WHERE " + whereString;
            }
            dbQuery.setSqlStatement(importSql);
            dbQuery.setFileQueryId();
        }
        ResultSet rs = null;
        try {
            rs = dbQuery.getResultSet();
        }
        catch (SQLException e) {
            logger.error(e);
            return result;
        }
        catch (ClassNotFoundException e) {
            logger.error(e);
            return result;
        }
        catch (JRStopEngineException e) {
            // empty catch block
        }
        Object[] tem = new Object[result.length];
        int recordCnt = 0;
        while (rs.next()) {
            int i3 = result.length;
            while (--i3 >= 0) {
                if (i3 == 0) {
                    if (type.equals("Date")) {
                        Date date = rs.getDate(i3 + 1);
                        if (date != null) {
                            tem[i3] = dateFormat.format(date);
                            continue;
                        }
                        tem[i3] = null;
                        continue;
                    }
                    if (type.equals("DateTime")) {
                        Timestamp datetime = rs.getTimestamp(i3 + 1);
                        if (datetime != null) {
                            tem[i3] = dateFormat.format(datetime);
                            continue;
                        }
                        tem[i3] = null;
                        continue;
                    }
                    if (type.equals("Time")) {
                        Time time2 = rs.getTime(i3 + 1);
                        dateFormat.setTimeZone(TimeZone.getDefault());
                        if (time2 != null) {
                            tem[i3] = dateFormat.format(time2);
                            continue;
                        }
                        tem[i3] = null;
                        continue;
                    }
                    if (type.equals("Boolean")) {
                        boolean bool = rs.getBoolean(i3 + 1);
                        tem[i3] = Boolean.toString(bool);
                        continue;
                    }
                    tem[i3] = rs.getString(i3 + 1);
                    continue;
                }
                tem[i3] = rs.getString(i3 + 1);
            }
            int len = result.length;
            for (i3 = 0; i3 < len && (i3 != 0 || tem[0] != null); ++i3) {
                result[i3].add(tem[i3]);
            }
            if (this.recordsToDisplay <= 0 || ++recordCnt != this.recordsToDisplay) continue;
        }
        dbQuery.close();
        if (this.conFormat && userFormat.equals("")) {
            switch (field.getSqlType()) {
                case 91: {
                    userFormat = unvs.getDatabase(sourceName).getConnection().getDateFormat();
                    break;
                }
                case 92: {
                    userFormat = unvs.getDatabase(sourceName).getConnection().getTimeFormat();
                    break;
                }
                case 93: {
                    userFormat = unvs.getDatabase(sourceName).getConnection().getTimestampFormat();
                }
            }
        }
        if (isBindParam) {
            Locale locale = Locale.getDefault();
            Vector<String> v = new Vector<String>();
            Enumeration e = result[0].elements();
            while (e.hasMoreElements()) {
                String temp = (String)e.nextElement();
                if (!this.conFormat || !userFormat.equals("")) {
                    temp = this.getDisplayValue(temp, locale, type, userFormat);
                }
                v.addElement(temp);
            }
            result[0] = v;
            if (result.length == 1) {
                Vector[] t = new Vector[]{result[0], result[0]};
                result = t;
            }
        }
        if (logger.isDebugEnabled()) {
            String message = "Values got from DB by DataCollection: \n";
            if (result.length > 0) {
                for (int i4 = 0; i4 < result[0].size(); ++i4) {
                    message = message + result[0].elementAt(i4);
                    message = message + ", ";
                }
            }
            logger.info(message, new CallTrace());
        }
        return result;
    }

    private String getDisplayValue(String paramvalue, Locale locale, String type, String userFormat) {
        String sRet = "";
        if (paramvalue != null && !paramvalue.equals("")) {
            if (type.equals("Currency")) {
                DbDecimal value = new DbDecimal();
                value.setValue(paramvalue);
                sRet = !userFormat.equals("") ? new DecimalFormat(userFormat).format(value.value) : NumberFormat.getCurrencyInstance(locale).format(value.value);
            } else if (type.equals("Integer")) {
                long value = new Long(paramvalue);
                sRet = !userFormat.equals("") ? new DecimalFormat(userFormat).format(value) : NumberFormat.getNumberInstance(locale).format(value);
            } else if (type.equals("Number")) {
                double value = new Double(paramvalue);
                sRet = !userFormat.equals("") ? new DecimalFormat(userFormat).format(value) : NumberFormat.getNumberInstance(locale).format(value);
            } else if (type.equals("Date") || type.equals("Time") || type.equals("DateTime")) {
                SimpleDateFormat df;
                DateFormat dff = null;
                if (!userFormat.equals("")) {
                    dff = new SimpleDateFormat(userFormat);
                }
                if (type.equals("DateTime")) {
                    df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                    if (userFormat.equals("")) {
                        dff = DateFormat.getDateTimeInstance(3, 3, locale);
                    }
                    dff.setTimeZone(TimeZone.getDefault());
                } else if (type.equals("Date")) {
                    df = new SimpleDateFormat("yyyy-MM-dd");
                    if (userFormat.equals("")) {
                        dff = DateFormat.getDateInstance(3, locale);
                    }
                } else {
                    df = new SimpleDateFormat("hh:mm:ss");
                    if (userFormat.equals("")) {
                        dff = DateFormat.getTimeInstance(3, locale);
                    }
                }
                try {
                    sRet = dff.format(df.parse(paramvalue));
                }
                catch (ParseException pe) {
                    sRet = paramvalue;
                }
            } else if (type.equals("String")) {
                sRet = paramvalue;
            } else if (type.equals("Boolean")) {
                if (userFormat.equals("")) {
                    sRet = paramvalue;
                } else {
                    String[] formats = DataCollection.parseBooleanFormat(userFormat);
                    sRet = new Boolean(paramvalue) != false ? formats[0] : formats[1];
                }
            } else {
                sRet = paramvalue;
            }
        }
        return sRet;
    }

    private static String[] parseBooleanFormat(String format) {
        String tFalse;
        String tTrue;
        int index = format.indexOf("/");
        if (index != -1) {
            tTrue = format.substring(0, index);
            tFalse = format.substring(index + 1);
        } else {
            tTrue = format;
            tFalse = "false";
        }
        return new String[]{tTrue, tFalse};
    }

    public void setUserName(String username) {
        if (username != null && username.trim().length() > 0) {
            this.userName = username;
        }
    }

    private String resolveImportSqlStatement(String sql, ParamDesc param, JetUUniverse unvs, Hashtable allParamDescs, boolean isDistinct) {
        String sourceName = param.getDataSource();
        JetUDatabase db = unvs.getDatabase(sourceName);
        JetUConnection jetuconn = null;
        String paramName = null;
        JetUParameter jetuparam = null;
        ParamDesc paramTemp = null;
        Vector referP = param.getImportParams();
        if (referP.isEmpty()) {
            referP = this.getImportParams(sql, unvs, db);
        }
        int iPSize = referP.size();
        if (db != null && iPSize > 0) {
            jetuconn = db.getConnection();
            Hashtable htPOPairs = new Hashtable(5);
            Hashtable htUVPairs = new Hashtable(5);
            Vector pos = new Vector(2);
            Hashtable<JetUParameter, ParamDesc> htPVPairs = new Hashtable<JetUParameter, ParamDesc>(5);
            Hashtable htSpecFields = new Hashtable(5);
            for (int i = 0; i < iPSize; ++i) {
                JetUParameter entity;
                paramName = (String)referP.get(i);
                jetuparam = (JetUParameter)db.getResourceByName(paramName);
                if (jetuparam == null && (entity = (JetUParameter)unvs.getAnyResourceByName(paramName)) instanceof JetUParameter) {
                    jetuparam = entity;
                }
                if (jetuparam == null || allParamDescs == null) continue;
                paramTemp = (ParamDesc)allParamDescs.get(paramName.toUpperCase());
                htPVPairs.put(jetuparam, paramTemp);
            }
            if (FileQuery.parseStatement(sql, htPVPairs, htPOPairs, htUVPairs, htSpecFields, pos, unvs, db.getResourceName(), jetuconn, jetuconn.getSupportInfo(), null, this.userName)) {
                sql = FileQuery.getResolvedStatement(sql, htPVPairs, htPOPairs, htUVPairs, htSpecFields, pos, unvs, db.getResourceName(), jetuconn, jetuconn.getSupportInfo(), null, null);
            }
        }
        return isDistinct ? this.insertDistinct(sql) : sql;
    }

    private String insertDistinct(String sql) {
        int selectLength = 6;
        String behindSelect = sql.trim().substring(selectLength);
        if (behindSelect.trim().substring(0, 8).toUpperCase().equals("DISTINCT")) {
            return sql;
        }
        return "SELECT DISTINCT " + behindSelect;
    }

    private Vector getImportParams(String importSql, JetUUniverse universe, JetUDatabase jetudatabase) {
        Vector<String> importParams = new Vector<String>();
        JetUParameter uparam = null;
        JetUConnection jetujdbcconnection = null;
        Hashtable htPVPairs = new Hashtable(5);
        Hashtable htPOPairs = new Hashtable(5);
        Hashtable htUVPairs = new Hashtable(5);
        Hashtable htSpecFields = new Hashtable();
        Vector vPos = new Vector(2);
        if (jetudatabase != null) {
            jetujdbcconnection = jetudatabase.getConnection();
        }
        if (jetudatabase != null && jetujdbcconnection != null && FileQuery.parseStatement(importSql, htPVPairs, htPOPairs, htUVPairs, htSpecFields, vPos, universe, jetudatabase.getResourceName(), jetujdbcconnection, jetujdbcconnection.getSupportInfo(), null, this.userName)) {
            Enumeration e = htPVPairs.keys();
            while (e.hasMoreElements()) {
                uparam = (JetUParameter)e.nextElement();
                importParams.addElement(uparam.getParamDesc().name);
            }
        }
        importParams.addElement("username");
        return importParams;
    }
}

