/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import jet.dataengine8.core.queryengine.sqltoolkit.ColumnReference;
import jet.dataengine8.core.queryengine.sqltoolkit.MappingName;
import jet.dataengine8.core.queryengine.sqltoolkit.NameFinder;
import jet.dataengine8.core.queryengine.sqltoolkit.SqlTools;
import jet.dataengine8.core.queryengine.sqltoolkit.Subquery;
import jet.universe.JetUDatabase;
import jet.universe.JetUField;
import jet.universe.JetUFldQueryField;
import jet.universe.JetUFmlQueryField;
import jet.universe.JetUParameter;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUTableView;
import jet.universe.JetUUniverse;
import jet.universe.psql.RptPsqlTools;
import toolkit.db.DbTools;
import toolkit.db.PsqlColumn;
import toolkit.db.PsqlSelColumn;
import toolkit.db.PsqlTable;
import toolkit.db.api.SQLMapInfo;

class DataCollectionNameFinder
implements NameFinder {
    private JetUUniverse unv;
    private String dataSource;
    private JetUDatabase udb;
    private String userName;
    String strExtraNameChar = "";
    String strQuoteChar = "\"";
    String strExtraKeywords = "";
    int qualifiedNamePattern;

    public DataCollectionNameFinder(JetUUniverse unv, String dataSource, String userName, String strExtraNameChar, String strQuoteChar, String strExtraKeywords, int qualifiedNamePattern) {
        this.unv = unv;
        this.dataSource = dataSource;
        this.udb = unv.getDatabase(dataSource);
        this.userName = userName;
        this.strExtraKeywords = strExtraKeywords;
        this.strExtraNameChar = strExtraNameChar;
        this.strQuoteChar = strQuoteChar;
        this.qualifiedNamePattern = qualifiedNamePattern;
    }

    @Override
    public boolean isLocalName(MappingName mapn) {
        if (mapn != null && mapn.hasAt) {
            int specType = DbTools.isSpecialField(mapn.name);
            switch (specType) {
                case 0: {
                    mapn.type = 4;
                    mapn.paramVal = DbTools.makeSqlString(this.userName);
                    return false;
                }
            }
        }
        if (mapn instanceof ColumnReference) {
            JetUTableView utb;
            ColumnReference colref = (ColumnReference)mapn;
            String name2 = SqlTools.removeQuotes(colref.col);
            mapn.obj = this.udb.getFormulaByResourceName(name2);
            if (mapn.obj != null && colref.tab == null) {
                colref.type = 1;
                colref.name = name2;
                return false;
            }
            JetUParameter up = this.udb.getParameterByResourceName(name2);
            if (up != null && colref.tab == null) {
                mapn.obj = up;
                colref.type = 2;
                colref.name = name2;
                colref.paramVal = RptPsqlTools.getDefaultValueOfUParameter(up);
                return false;
            }
            String tab = SqlTools.removeQuotes(colref.tab);
            if (colref.tab != null) {
                String stmp = tab;
                utb = this.udb.GetTableOrViewByRealName(this.dataSource, tab);
            } else {
                JetUResourceEntity ure = this.udb.getResourceByName(name2);
                if (ure != null && (ure instanceof JetUField || ure instanceof JetUFldQueryField)) {
                    mapn.obj = ure;
                    colref.name = name2;
                    return false;
                }
                utb = null;
            }
            JetUField ufld = null;
            colref.name = utb == null ? name2 : ((ufld = utb.getFieldByFieldName(name2)) != null ? ufld.getResourceName() : name2);
            mapn.obj = ufld;
            return false;
        }
        String name3 = SqlTools.removeQuotes(mapn.name);
        mapn.obj = this.udb.getFormulaByResourceName(name3);
        if (mapn.obj != null) {
            mapn.type = 1;
            mapn.paramVal = mapn.name;
            return false;
        }
        JetUParameter up = this.udb.getParameterByResourceName(name3);
        if (up != null) {
            mapn.type = 2;
            mapn.paramVal = mapn.name;
            mapn.obj = up;
            return false;
        }
        JetUResourceEntity ure = this.udb.getResourceByName(name3);
        mapn.obj = ure;
        if (ure != null) {
            if (ure instanceof JetUField || ure instanceof JetUFldQueryField) {
                mapn.type = 0;
                return false;
            }
            if (ure instanceof JetUFmlQueryField) {
                mapn.type = 1;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getParameterValue(String arg0) {
        return null;
    }

    @Override
    public String getFieldName(MappingName mapn) {
        String str = mapn.name;
        switch (mapn.type) {
            case 0: {
                if (mapn.obj == null) break;
                SQLMapInfo sqlMapInfo = null;
                if (mapn.obj instanceof JetUField) {
                    JetUField ufld = (JetUField)mapn.obj;
                    JetUTableView utbl = ufld.getTable();
                    if (utbl != null) {
                        str = PsqlTable.getQaulifiedName(this.qualifiedNamePattern, utbl.getQualifier(), utbl.getOwner(), utbl.getTableName(), utbl.getResourceName(), this.strExtraNameChar, this.strQuoteChar, this.strExtraKeywords, sqlMapInfo) + "." + PsqlColumn.getQuotedName(ufld.getFldName(), ufld.getResourceName(), this.strExtraNameChar, this.strQuoteChar, this.strExtraKeywords, sqlMapInfo);
                        break;
                    }
                    str = PsqlColumn.getQuotedName(ufld.getFldName(), ufld.getResourceName(), this.strExtraNameChar, this.strQuoteChar, this.strExtraKeywords, sqlMapInfo);
                    break;
                }
                if (!(mapn.obj instanceof JetUFldQueryField)) break;
                JetUFldQueryField ufld = (JetUFldQueryField)mapn.obj;
                PsqlSelColumn pcol = ufld.getPsqlSelColumn();
                if (pcol != null) {
                    if (pcol.isCompCol()) {
                        str = pcol.getExpressionOfCompCol();
                        break;
                    }
                    PsqlTable ptbl = pcol.getPsqlTable();
                    if (ptbl != null) {
                        str = ptbl.getQaulifiedNameCorr(this.qualifiedNamePattern, this.strExtraNameChar, this.strQuoteChar, this.strExtraKeywords, sqlMapInfo) + "." + pcol.getQuotedName(this.strExtraNameChar, this.strQuoteChar, this.strExtraKeywords, sqlMapInfo);
                        break;
                    }
                    str = PsqlTable.getQaulifiedName(this.qualifiedNamePattern, "", "", ufld.getTable().getTableName(), ufld.getTable().getResourceName(), this.strExtraNameChar, this.strQuoteChar, this.strExtraKeywords, sqlMapInfo) + "." + PsqlColumn.getQuotedName(ufld.getFldName(), ufld.getResourceName(), this.strExtraNameChar, this.strQuoteChar, this.strExtraKeywords, sqlMapInfo);
                    break;
                }
                str = PsqlTable.getQaulifiedName(this.qualifiedNamePattern, "", "", ufld.getTable().getTableName(), ufld.getTable().getResourceName(), this.strExtraNameChar, this.strQuoteChar, this.strExtraKeywords, sqlMapInfo) + "." + PsqlColumn.getQuotedName(ufld.getFldName(), ufld.getResourceName(), this.strExtraNameChar, this.strQuoteChar, this.strExtraKeywords, sqlMapInfo);
            }
        }
        return str;
    }

    @Override
    public Object prepareSubquery(Subquery arg0) {
        return null;
    }

    @Override
    public String getResolvedStatement(Subquery arg0) {
        return null;
    }

    @Override
    public MappingName getFormulaMappingName(MappingName mp) {
        return null;
    }

    @Override
    public boolean isBigDSBesidesHive() {
        return false;
    }

    @Override
    public boolean isRecordLevel(MappingName mapn) {
        return false;
    }
}

