/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.JUnifiedBusinessView;

public class DataEntryLocation {
    private String dataSoureceName;
    private String ubvQueryName;
    private int ubvQueryType;
    private String mappingNameOrqdName;

    public DataEntryLocation(String dataSoureceName, String ubvQueryName, int ubvQueryType, String mappingNameOrqdName) {
        this.dataSoureceName = dataSoureceName;
        this.ubvQueryName = ubvQueryName;
        this.ubvQueryType = ubvQueryType;
        this.mappingNameOrqdName = mappingNameOrqdName;
    }

    public DataEntryLocation(BLNode blNode) {
        JUnifiedBusinessView ubv = blNode.getUbv();
        this.dataSoureceName = ubv.getDatabase().getResourceName();
        this.ubvQueryName = ubv.getDisplayName();
        this.ubvQueryType = 1;
        this.mappingNameOrqdName = blNode.getQualifyDisplayName();
    }

    public String getDataSoureceName() {
        return this.dataSoureceName;
    }

    public String getUbvQueryName() {
        return this.ubvQueryName;
    }

    public int getUbvQueryType() {
        return this.ubvQueryType;
    }

    public String getMappingNameOrqdName() {
        return this.mappingNameOrqdName;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataEntryLocation:dataSoureceName[");
        stringBuilder.append(this.dataSoureceName).append("] ");
        if (this.ubvQueryType == 1) {
            stringBuilder.append("UBV[");
        } else {
            stringBuilder.append("Query[");
        }
        stringBuilder.append(this.ubvQueryName).append("].[");
        stringBuilder.append(this.mappingNameOrqdName).append("]");
        return stringBuilder.toString();
    }
}

