/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.Vector;
import jet.log.JRLogger;
import jet.universe.JetUDocFolder;
import jet.universe.JetUDocNode;
import jet.universe.JetUReportDoc;
import jet.universe.JetUUniverse;
import jet.universe.exception.DocException;

public class DocObject {
    public static final String pathSeparator = "/";
    protected JetUUniverse unvs = null;
    protected String strPath = null;
    boolean bResolved = false;
    protected JetUDocNode node = null;
    protected static JRLogger logger = JRLogger.getLogger(DocObject.class.getName());

    protected DocObject(JetUUniverse unvs, JetUDocNode node) {
        this.unvs = unvs;
        this.node = node;
        this.strPath = node.getLocator();
        this.bResolved = true;
    }

    public DocObject(JetUUniverse unvs, String strPath) {
        this.unvs = unvs;
        this.strPath = strPath;
    }

    public DocObject(JetUUniverse unvs, String strParent, String strName) {
        this.strPath = strParent.endsWith(pathSeparator) ? strParent + strName : strParent + pathSeparator + strName;
    }

    public DocObject(JetUUniverse unvs, DocObject doParent, String strName) {
        this(unvs, doParent.getPath(), strName);
    }

    public String getName() {
        int iIndex = this.strPath.lastIndexOf(pathSeparator);
        return iIndex < 0 ? this.strPath : this.strPath.substring(iIndex + 1);
    }

    public String getPath() {
        return this.strPath;
    }

    public String getParent() {
        int index = this.strPath.lastIndexOf(pathSeparator);
        if (index < 0) {
            return null;
        }
        return this.strPath.substring(0, index + 1);
    }

    public DocObject getParentObject() {
        return new DocObject(this.unvs, this.getParent());
    }

    protected void resolve() {
        if (!this.bResolved) {
            this.node = this.unvs.getDocNodeByPath(this.strPath);
            if (this.node != null) {
                this.bResolved = true;
            }
        }
    }

    public boolean exists() {
        this.resolve();
        return this.bResolved;
    }

    public boolean isReport() {
        this.resolve();
        if (!this.bResolved) {
            return false;
        }
        return this.node instanceof JetUReportDoc;
    }

    public boolean isFolder() {
        this.resolve();
        if (!this.bResolved) {
            return false;
        }
        return this.node instanceof JetUDocFolder;
    }

    public String getDescription() {
        this.resolve();
        if (!this.bResolved) {
            return null;
        }
        if (this.node instanceof JetUReportDoc) {
            return ((JetUReportDoc)this.node).getDesc();
        }
        return null;
    }

    public String getFile() {
        this.resolve();
        if (!this.bResolved) {
            return null;
        }
        if (this.node instanceof JetUReportDoc) {
            return ((JetUReportDoc)this.node).getFile();
        }
        return null;
    }

    public String getType() {
        this.resolve();
        if (!this.bResolved) {
            return null;
        }
        if (this.node instanceof JetUReportDoc) {
            return ((JetUReportDoc)this.node).getType();
        }
        return null;
    }

    public String getQueryName() {
        this.resolve();
        if (!this.bResolved) {
            return null;
        }
        if (this.node instanceof JetUReportDoc) {
            return ((JetUReportDoc)this.node).getQueryName();
        }
        return null;
    }

    public String getAuthor() {
        this.resolve();
        if (!this.bResolved) {
            return null;
        }
        if (this.node instanceof JetUReportDoc) {
            return ((JetUReportDoc)this.node).getAuthor();
        }
        return null;
    }

    public long lastModified() {
        this.resolve();
        if (!this.bResolved) {
            return 0L;
        }
        if (this.node instanceof JetUReportDoc) {
            return ((JetUReportDoc)this.node).getLastModifiedTime();
        }
        return 0L;
    }

    public long lastRun() {
        this.resolve();
        if (!this.bResolved) {
            return 0L;
        }
        if (this.node instanceof JetUReportDoc) {
            return ((JetUReportDoc)this.node).getLastRunTime();
        }
        return 0L;
    }

    public long lastPrinted() {
        this.resolve();
        if (!this.bResolved) {
            return 0L;
        }
        if (this.node instanceof JetUReportDoc) {
            return ((JetUReportDoc)this.node).getLastPrintTime();
        }
        return 0L;
    }

    public String getKeywords() {
        this.resolve();
        if (!this.bResolved) {
            return null;
        }
        if (this.node instanceof JetUReportDoc) {
            return ((JetUReportDoc)this.node).getKeywords();
        }
        return null;
    }

    public void setFile(String strFile) {
        this.resolve();
        if (!this.bResolved) {
            return;
        }
        if (this.node instanceof JetUReportDoc) {
            ((JetUReportDoc)this.node).setFile(strFile);
        }
    }

    public void setType(String strType) {
        this.resolve();
        if (!this.bResolved) {
            return;
        }
        if (this.node instanceof JetUReportDoc) {
            ((JetUReportDoc)this.node).setType(strType);
        }
    }

    public void setQueryName(String strQueryName) {
        this.resolve();
        if (!this.bResolved) {
            return;
        }
        if (this.node instanceof JetUReportDoc) {
            ((JetUReportDoc)this.node).setQueryName(strQueryName);
        }
    }

    public void setAuthor(String strAuthor) {
        this.resolve();
        if (!this.bResolved) {
            return;
        }
        if (this.node instanceof JetUReportDoc) {
            ((JetUReportDoc)this.node).setAuthor(strAuthor);
        }
    }

    public void setLastModified(long lastModified) {
        this.resolve();
        if (!this.bResolved) {
            return;
        }
        if (this.node instanceof JetUReportDoc) {
            ((JetUReportDoc)this.node).setLastModifiedTime(lastModified);
        }
    }

    public void setLastRun(long lastRun) {
        this.resolve();
        if (!this.bResolved) {
            return;
        }
        if (this.node instanceof JetUReportDoc) {
            ((JetUReportDoc)this.node).setLastRunTime(lastRun);
        }
    }

    public void setLastPrinted(long lastPrinted) {
        this.resolve();
        if (!this.bResolved) {
            return;
        }
        if (this.node instanceof JetUReportDoc) {
            ((JetUReportDoc)this.node).setLastPrintTime(lastPrinted);
        }
    }

    public void setKeywords(String strKeywords) {
        this.resolve();
        if (!this.bResolved) {
            return;
        }
        if (this.node instanceof JetUReportDoc) {
            ((JetUReportDoc)this.node).setKeywords(strKeywords);
        }
    }

    public boolean createFolder() throws DocException {
        return this.unvs.createReportFolder(this.strPath);
    }

    public boolean createReport() throws DocException {
        return this.unvs.createReportEntity(this.getParent(), this.getName());
    }

    public boolean renameTo(DocObject dest) {
        return this.unvs.renameTo(this, dest);
    }

    public boolean delete(boolean bIfDeleteFile) {
        return this.unvs.deleteReport(this, bIfDeleteFile);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DocObject) {
            return this.unvs == ((DocObject)obj).unvs && this.strPath.equals(((DocObject)obj).strPath);
        }
        return false;
    }

    public Vector list() {
        this.resolve();
        if (!this.bResolved) {
            return null;
        }
        if (this.node instanceof JetUDocFolder) {
            Vector<String> vecList = new Vector<String>();
            Vector vecNodeChildren = ((JetUDocFolder)this.node).getChildren();
            int iSize = vecNodeChildren.size();
            JetUDocNode nodeChild = null;
            boolean bMatch = false;
            for (int i = 0; i < iSize; ++i) {
                nodeChild = (JetUDocNode)vecNodeChildren.elementAt(i);
                vecList.addElement(nodeChild.getName());
            }
        }
        return null;
    }

    public Vector listObjects() {
        this.resolve();
        if (!this.bResolved) {
            return null;
        }
        if (this.node instanceof JetUDocFolder) {
            Vector<DocObject> vecList = new Vector<DocObject>();
            Vector vecNodeChildren = ((JetUDocFolder)this.node).getChildren();
            int iSize = vecNodeChildren.size();
            JetUDocNode nodeChild = null;
            boolean bMatch = false;
            for (int i = 0; i < iSize; ++i) {
                nodeChild = (JetUDocNode)vecNodeChildren.elementAt(i);
                vecList.addElement(new DocObject(this.unvs, nodeChild));
            }
        }
        return null;
    }
}

