/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import jet.acl.ACLException;
import jet.acl.JetAcl;
import jet.acl.JetAclEntry;
import jet.acl.JetPermission;
import jet.acl.JetPolicy;
import jet.controls.JetObject;
import jet.controls.JetRootable;
import jet.log.JRLogger;
import jet.universe.JetUDatabase;
import jet.universe.JetUResourceContainer;
import jet.util.RLSTools;
import toolkit.db.DbTools;
import toolkit.db.PsqlQuery;

public class JetUAcl
extends JetUResourceContainer {
    private static JRLogger logger = JRLogger.getLogger(JetUResourceContainer.class.getName());
    private JetAcl acl = null;
    private static final HashMap nameIdx = new HashMap(2);

    public JetUAcl() {
    }

    @Override
    public boolean isSimilar(JetUResourceContainer container) {
        if (!(container instanceof JetUAcl)) {
            return false;
        }
        if (!this.name.equal(container.name)) {
            return false;
        }
        JetUAcl uacl = (JetUAcl)container;
        if (this.acl == uacl.acl) {
            return true;
        }
        if (this.acl == null || uacl.acl == null) {
            return false;
        }
        return this.acl.equalsTo(uacl.acl);
    }

    public JetUAcl(String name2) {
        super(name2, "");
        this.setAcl(new JetAcl());
    }

    public JetUAcl(String name2, JetAcl acl) {
        super(name2, "");
        this.setAcl(acl);
    }

    public void setAcl(JetAcl acl) {
        this.acl = acl;
        acl.setName(this.getResourceName());
        this.removeall();
        this.add(acl);
    }

    public JetAcl getAcl() {
        if (this.acl != null) {
            return this.acl;
        }
        Vector v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            JetObject child = (JetObject)v.elementAt(i);
            if (!(child instanceof JetAcl)) continue;
            this.acl = (JetAcl)child;
            this.acl.setName(this.getResourceName());
            return this.acl;
        }
        this.setAcl(new JetAcl());
        return this.acl;
    }

    @Override
    public void afterInit() {
        Vector v = this.getChildren();
        for (int i = 0; i < v.size(); ++i) {
            JetObject child = (JetObject)v.elementAt(i);
            if (!(child instanceof JetAcl)) continue;
            this.acl = (JetAcl)child;
            this.acl.setName(this.getResourceName());
            return;
        }
        this.setAcl(new JetAcl());
    }

    public String generateFileName() {
        String fileName = this.getResourceName();
        return fileName;
    }

    @Override
    public JetUDatabase getDatabase() {
        return (JetUDatabase)this.getParent();
    }

    public JetUAcl cloneEntity() {
        return new JetUAcl(this.getResourceName(), (JetAcl)this.getAcl().clone());
    }

    @Override
    public String getInstancePrefix() {
        return "UACL";
    }

    public void importXMLAsACL(String inputFile) throws ACLException {
        JetAcl acl = JetAcl.importXML(inputFile).copy();
        if (acl != null) {
            acl.setName(this.getResourceName());
            this.setAcl(acl);
        }
    }

    public void exportACLToXML(String outFile) throws ACLException {
        JetAcl acl = this.getAcl();
        if (acl == null) {
            return;
        }
        JetObject root = JetObject.getRoot(acl);
        if (root instanceof JetRootable) {
            JetAcl.exportToXML(this.getUniverse().getResourceStore().getDiskStore(), acl, outFile);
        } else {
            JetAcl copy = acl.copy();
            copy.setInstName(acl.getName());
            JetAcl.exportToXML(this.getUniverse().getResourceStore().getDiskStore(), copy, outFile);
        }
    }

    public void importTXTAsACL(String inputFile) throws ACLException {
        JetAcl acl = JetAcl.importTxt(inputFile);
        if (acl != null) {
            acl.setName(this.getResourceName());
            this.setAcl(acl);
        }
    }

    public Vector getMappingFields() {
        JetAcl acl = this.getAcl();
        Vector<String> v = new Vector<String>();
        Hashtable<String, String> names = new Hashtable<String, String>();
        Vector entries = acl.getEntries();
        int sz1 = entries == null ? 0 : entries.size();
        for (int i = 0; i < sz1; ++i) {
            JetAclEntry aclEntry = (JetAclEntry)entries.elementAt(i);
            Vector pers = aclEntry.getPermissions();
            int sz2 = pers == null ? 0 : pers.size();
            for (int j = 0; j < sz2; ++j) {
                JetPolicy policy;
                JetPermission per = (JetPermission)pers.elementAt(j);
                if (!(per.getPolicy() instanceof JetPolicy) || (policy = (JetPolicy)per.getPolicy()) == null) continue;
                Vector vGrp = RLSTools.mergeSCGroups(policy);
                Vector strs = DbTools.getMappingNamesInRawSql(PsqlQuery.getStringOfWPGroups(vGrp));
                int sz3 = strs == null ? 0 : strs.size();
                for (int k = 0; k < sz3; ++k) {
                    String name2 = (String)strs.elementAt(k);
                    if (names.containsKey(name2.toUpperCase())) continue;
                    names.put(name2.toUpperCase(), name2);
                    v.addElement(name2);
                }
            }
        }
        return v;
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    static {
        nameIdx.put("Description", new Integer(0));
        nameIdx.put("Name", new Integer(1));
    }
}

