/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.io.File;
import java.util.Vector;
import jet.JResource;
import jet.JetObjInspector.ObjectInfo;
import jet.ReportEnv;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.jetc.LoaderNoCache;
import jet.jetc.ReadFailureException;
import jet.log.JRLogger;
import jet.universe.JetUBuildInClassNode;
import jet.universe.JetUTree;
import jet.universe.JetUTreeNode;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDefinedClassNode;

public abstract class JetUClassTreeNode
extends JetUTree {
    public JetString name = new JetString(this, "Name");
    public JetString desc = new JetString(this, "Description");
    protected transient ObjectInfo objInfo = null;
    private static final String tempPath = ReportEnv.templatePath;
    public static final String extCls = ".jcls";
    private transient String strUnvPath = null;
    private static JRLogger logger = JRLogger.getLogger(JetUClassTreeNode.class.getName());

    public JetUClassTreeNode() {
    }

    public JetUClassTreeNode(String strName, String strDesc) {
        this.setName(strName);
        this.setDesc(strDesc);
    }

    @Override
    public JetObject add(JetObject child, int pos) {
        super.add(child, pos);
        return child;
    }

    public String getName() {
        return this.name.get();
    }

    public void setName(String strName) {
        this.name.set(strName);
    }

    public String getFullJetcFile() {
        String strFullFile = this.getPath() + this.getName() + extCls;
        File fileTemp = new File(strFullFile);
        strFullFile = fileTemp != null && fileTemp.exists() ? fileTemp.getPath() : null;
        return strFullFile;
    }

    public abstract String getPath();

    public String toString() {
        Vector children = this.getChildren();
        int iSize = children.size();
        String str = this.getName();
        if (iSize > 0) {
            str = str + "[";
            for (int i = 0; i < iSize; ++i) {
                str = str + ((JetUClassTreeNode)children.elementAt(i)).toString() + " ";
            }
            str = str + "]";
        }
        return str;
    }

    @Override
    public String getDesc() {
        return this.desc.get();
    }

    @Override
    public void setDesc(String strDesc) {
        this.desc.set(strDesc);
    }

    public JetUClassTreeNode addClass(JetUClassTreeNode child) {
        this.add(child);
        return child;
    }

    public Vector getClasses() {
        Vector children;
        Vector vAllClasses = children = (Vector)this.getChildren().clone();
        int iSize = children.size();
        JetUClassTreeNode child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetUClassTreeNode)children.elementAt(i);
            JetUClassTreeNode.addChildren(child, vAllClasses);
        }
        return vAllClasses;
    }

    public JetUClassTreeNode getClassByName(String name2) {
        JetUClassTreeNode nodeRet = null;
        JetUClassTreeNode node = null;
        Vector children = this.getClasses();
        for (int i = 0; i < children.size(); ++i) {
            node = (JetUClassTreeNode)children.elementAt(i);
            if (!node.getName().equalsIgnoreCase(name2)) continue;
            nodeRet = node;
            break;
        }
        return nodeRet;
    }

    protected boolean createObjectInfo(StringBuffer error) {
        String strJetcFileName = this.getFullJetcFile();
        boolean bResult = false;
        if (strJetcFileName != null) {
            LoaderNoCache loader = new LoaderNoCache(strJetcFileName);
            try {
                this.objInfo = new ObjectInfo(loader.loadObject(), null);
                bResult = true;
            }
            catch (ReadFailureException e) {
                error.append(e.toString());
            }
        } else {
            error.append(JResource.getMessage("CAT_11", new Object[]{this.getName(), this.getPath()}));
        }
        return bResult;
    }

    public ObjectInfo getObjectInfo(StringBuffer error) {
        if (this.objInfo == null) {
            this.createObjectInfo(error);
        }
        return this.objInfo;
    }

    public JetObject getInstance(StringBuffer error) {
        this.getObjectInfo(error);
        if (this.objInfo != null) {
            return this.objInfo.getObject();
        }
        return null;
    }

    public JetUUniverse getUniverse() {
        for (JetUTreeNode parent = (JetUTreeNode)((Object)this.getParent()); parent != null; parent = (JetUTreeNode)((Object)parent.getParent())) {
            if (!(parent instanceof JetUUniverse)) continue;
            return (JetUUniverse)parent;
        }
        return null;
    }

    public static boolean isValidClassName(String strClassName) {
        if (strClassName == null || strClassName.length() == 0) {
            return false;
        }
        int length = strClassName.length();
        char c = strClassName.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            c = strClassName.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') continue;
            return false;
        }
        return true;
    }

    public JetUUserDefinedClassNode addDerivedClass(String strClassName, String strClassDesc, StringBuffer error) {
        JetUUserDefinedClassNode newClass = null;
        newClass = new JetUUserDefinedClassNode(strClassName, strClassDesc);
        JetObject superInstance = this.getInstance(error);
        if (superInstance != null) {
            JetObject dup = superInstance.deepDup();
            newClass.setInstance(dup);
            boolean bSaved = newClass.saveNewClass(error);
            if (!bSaved) {
                newClass = null;
            } else {
                this.addClass(newClass);
            }
        } else {
            newClass = null;
        }
        return newClass;
    }

    public synchronized JetUClassTreeNode removeClass(JetUUserDefinedClassNode child) {
        boolean bSuc = false;
        String strFileName = child.getFullJetcFile();
        if (strFileName != null) {
            File fileClass = new File(strFileName);
            if (fileClass.exists()) {
                bSuc = fileClass.delete();
            }
        } else {
            bSuc = true;
        }
        return bSuc ? (JetUClassTreeNode)this.remove(child) : null;
    }

    public String getUnvPath() {
        if (this.strUnvPath == null) {
            JetUUniverse unv = JetUUniverse.GetCurrentUniverse();
            this.strUnvPath = unv.getFilePath();
        }
        return this.strUnvPath;
    }

    protected String getTempPath() {
        return tempPath.endsWith(File.separator) ? tempPath : tempPath + File.separator;
    }

    protected JetUUserDefinedClassNode buildAllUserClassTree() {
        JetUUserDefinedClassNode userRoot = new JetUUserDefinedClassNode();
        userRoot.setParent(new JetUUniverse());
        Vector vector = this.getChildren();
        JetUClassTreeNode node = null;
        for (int i = 0; i < vector.size(); ++i) {
            node = (JetUClassTreeNode)vector.elementAt(i);
            if (!(node instanceof JetUBuildInClassNode) || !((JetUBuildInClassNode)node).getDerived()) continue;
            userRoot.add(JetUClassTreeNode.cloneClass(node));
        }
        return userRoot;
    }

    static JetUClassTreeNode cloneClass(JetUClassTreeNode sourceNode) {
        String sourceName = sourceNode.getName();
        JetUClassTreeNode newNode = null;
        newNode = sourceNode instanceof JetUBuildInClassNode ? new JetUBuildInClassNode(sourceName, sourceNode.getDesc()) : new JetUUserDefinedClassNode(sourceName, sourceNode.getDesc());
        Vector sourceChildren = sourceNode.getChildren();
        JetUClassTreeNode sourceChild = null;
        int sourceSize = sourceChildren.size();
        for (int i = 0; i < sourceSize; ++i) {
            sourceChild = (JetUClassTreeNode)sourceChildren.elementAt(i);
            newNode.add(JetUClassTreeNode.cloneClass(sourceChild));
        }
        return newNode;
    }

    static void addChildren(JetUClassTreeNode parent, Vector vAllChildren) {
        Vector children = parent.getChildren();
        int iSize = children.size();
        JetUClassTreeNode child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetUClassTreeNode)children.elementAt(i);
            vAllChildren.addElement(child);
            JetUClassTreeNode.addChildren(child, vAllChildren);
        }
    }

    static void addUserChildren(JetUClassTreeNode parent, Vector vAllChildren) {
        Vector children = parent.getChildren();
        int iSize = children.size();
        JetUClassTreeNode child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetUClassTreeNode)children.elementAt(i);
            if (child instanceof JetUUserDefinedClassNode) {
                vAllChildren.addElement(child);
            }
            JetUClassTreeNode.addUserChildren(child, vAllChildren);
        }
    }

    public static JetUBuildInClassNode getBuildSuperNode(JetUClassTreeNode node) {
        if (node instanceof JetUBuildInClassNode) {
            return (JetUBuildInClassNode)node;
        }
        JetObject nodeSup = (JetObject)((Object)node.getParent());
        if (nodeSup instanceof JetUClassTreeNode) {
            return JetUClassTreeNode.getBuildSuperNode((JetUClassTreeNode)nodeSup);
        }
        return null;
    }

    public String getBuildSuperType() {
        JetUBuildInClassNode nodeSup = JetUClassTreeNode.getBuildSuperNode(this);
        if (nodeSup != null) {
            return nodeSup.getBuildType();
        }
        return null;
    }
}

