/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetEnumeration;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.log.JRLogger;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.JetUFileQuery;
import jet.universe.JetUFolderTree;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUJDBCTypeInfo;
import jet.universe.JetUParamBuildInFileQuery;
import jet.universe.JetUProcedure;
import jet.universe.JetUQueriable;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUSupportInfo;
import jet.universe.JetUTableView;
import jet.universe.JetUUniverse;
import jet.universe.JetUWSOperationConnection;
import jet.universe.exception.AddTableViewException;
import jet.universe.mongodb.JetUMongoConnection;
import jet.universe.psql.FileQuery;
import toolkit.db.DateTimeFormat;
import toolkit.db.ProcInfo;
import toolkit.db.TableInfo;

public abstract class JetUConnection
extends JetUResourceContainer
implements DateTimeFormat {
    public static final int PATTERN_1PART_NAME = 0;
    public static final int PATTERN_2PART_NAME = 1;
    public static final int PATTERN_3PART_NAME = 2;
    public static final int ENCODINGAUTO = 0;
    public static final int ENCODINGYES = 1;
    public static final int ENCODINGNO = 2;
    static Character conChar = new Character('_');
    protected static JRLogger logger = JRLogger.getLogger(JetUConnection.class.getName());
    public JetEnumeration qualifiedNamePattern = new JetEnumeration(this, "QualifiedNamePattern", 82);
    public JetBoolean preJoin = new JetBoolean(this, "Pre-join", false);
    public JetBoolean pushDownGroupQuery = new JetBoolean(this, "PushDownGroupQuery", false);
    public JetString dateFormat = new JetString(this, "DateFormat");
    public JetString timeFormat = new JetString(this, "TimeFormat");
    public JetString timestampFormat = new JetString(this, "TimestampFormat");
    public JetBoolean security = new JetBoolean(this, "SecurityCheck", false);
    public JetBoolean isDefaultConnection = new JetBoolean(this, "IsDefaultConnection", false);
    public JetEnumeration encodingPattern = new JetEnumeration(this, "EncodingPattern", 34);

    public JetUConnection() {
        this.initialize();
    }

    public JetUConnection(String strName, String strDescription) {
        super(strName, strDescription);
        this.initialize();
    }

    private void initialize() {
        this.security.set(false);
        this.pushDownGroupQuery.setEditFlag(0);
    }

    void PrepareBeforeSave() {
        this.deleteBuildinParameterQuery();
        Vector children = this.getChildren();
        JetObject child = null;
        int iSize = children.size();
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)children.elementAt(i);
            if (!(child instanceof JetUFileQuery)) continue;
            ((JetUFileQuery)child).PrepareBeforeSave();
        }
    }

    private void deleteBuildinParameterQuery() {
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            JetObject o = (JetObject)it.next();
            if (!(o instanceof JetUParamBuildInFileQuery)) continue;
            it.remove();
            o.setParent(null);
        }
    }

    @Override
    public JetUDatabase getDatabase() {
        JetUDatabase db = null;
        for (JetObject obj = (JetObject)((Object)this.getParent()); obj != null; obj = (JetObject)((Object)obj.getParent())) {
            if (!(obj instanceof JetUDatabase)) continue;
            db = (JetUDatabase)obj;
            return db;
        }
        return db;
    }

    @Override
    public JetObject add(JetObject child, int pos) {
        super.add(child, pos);
        return child;
    }

    public JetUTableView addTableView(String strResourceName, int iTableType, String strQlf, String strOwner, String strRealTableName) {
        JetUTableView tableview = new JetUTableView(strResourceName, "", iTableType, strQlf, strOwner, strRealTableName);
        boolean bSuc = this.addTableView(tableview);
        if (bSuc) {
            return tableview;
        }
        return null;
    }

    public JetUTableView addTableView(String strResourceName, TableInfo table) {
        return this.addTableView(strResourceName, table, null);
    }

    public JetUTableView addTableView(String strResourceName, TableInfo table, Character c) {
        JetUTableView tableview = new JetUTableView(strResourceName, "", table);
        boolean bSuc = this.addTableView(tableview, c);
        if (bSuc) {
            return tableview;
        }
        return null;
    }

    public boolean addTableView(JetUTableView tableview) {
        return this.addTableView(tableview, null);
    }

    public JetUTableView addAliasTableView(JetUTableView originalTableview, String aliasName) {
        if (this.isNameExist(aliasName)) {
            return null;
        }
        JetUTableView tableview = originalTableview.createNew(aliasName);
        this.add(tableview);
        tableview.InitAfterAlias(originalTableview);
        JetUUniverse unv = (JetUUniverse)this.getDatabase().getParent();
        if (unv.editor != null) {
            unv.editor.addTableView(tableview, this.getDatabase().getResourceName());
        }
        return tableview;
    }

    public boolean addTableView(JetUTableView tableview, Character c) {
        if (this.getDatabase().IsTableNameOK(tableview.getResourceName(), null)) {
            this.add(tableview);
            tableview.InitAfterCreate(c);
            JetUUniverse unv = (JetUUniverse)this.getDatabase().getParent();
            if (unv.editor != null) {
                unv.editor.addTableView(tableview, this.getDatabase().getResourceName());
            }
            return true;
        }
        return false;
    }

    public boolean removeTableView(String strRscName) {
        JetUTableView tableview = this.GetTableByResourceName(strRscName);
        if (tableview != null) {
            return this.removeTableView(tableview);
        }
        return false;
    }

    public boolean removeTableView(JetUTableView tableview) {
        JetUUniverse unv = (JetUUniverse)this.getDatabase().getParent();
        if (unv.editor != null) {
            unv.editor.removeTableView(tableview.tableName.get(), this.getDatabase().getResourceName());
        }
        this.remove(tableview);
        return true;
    }

    public Vector getTables() {
        return this.getTableViews(1);
    }

    public JetUTableView GetTableByResourceName(String strRscTableName) {
        return this.getTableViewsByResourceName(strRscTableName, 1);
    }

    public Vector getViews() {
        return this.getTableViews(2);
    }

    public JetUTableView GetViewByResourceName(String strRscViewName) {
        return this.getTableViewsByResourceName(strRscViewName, 2);
    }

    public JetUTableView GetTableOrViewByResourceName(String strRscName) {
        return this.getTableViewsByResourceName(strRscName, 15);
    }

    public JetUTableView GetTableOrViewByRealName(String strRealName) {
        return this.getTableViewBy3PartName(null, null, strRealName, 15);
    }

    public Vector getTableViews() {
        return this.getTableViews(15);
    }

    public Vector getTableViews(int iTableTypeMask) {
        Vector<JetObject> vecTableViews = new Vector<JetObject>();
        int iSize = this.children.size();
        JetObject jetChild = null;
        for (int i = 0; i < iSize; ++i) {
            jetChild = (JetObject)this.children.elementAt(i);
            if (jetChild instanceof JetUTableView) {
                if ((iTableTypeMask & ((JetUTableView)jetChild).getTableType()) == 0) continue;
                vecTableViews.addElement(jetChild);
                continue;
            }
            if (!(jetChild instanceof JetUWSOperationConnection)) continue;
            Vector tempChild = ((JetUWSOperationConnection)jetChild).getTableViews(iTableTypeMask);
            for (int j = 0; j < tempChild.size(); ++j) {
                vecTableViews.addElement((JetObject)tempChild.get(j));
            }
        }
        return vecTableViews;
    }

    public JetUTableView getTableViewsByResourceName(String strRscName, int iTableTypeMask) {
        int iSize = this.children.size();
        JetObject jetChild = null;
        JetUTableView jetTableView = null;
        for (int i = 0; i < iSize; ++i) {
            jetChild = (JetObject)this.children.elementAt(i);
            if (!(jetChild instanceof JetUTableView ? (iTableTypeMask & (jetTableView = (JetUTableView)jetChild).getTableType()) != 0 && jetTableView.getResourceName().equalsIgnoreCase(strRscName) : jetChild instanceof JetUWSOperationConnection && (jetTableView = ((JetUWSOperationConnection)jetChild).getTableViewsByResourceName(strRscName, iTableTypeMask)) != null)) continue;
            return jetTableView;
        }
        return null;
    }

    public JetUTableView getTableViewBy3PartName(String strQualifier, String strOwner, String strName, int iTableTypeMask) {
        Vector vecTables = this.getTableViewsBy3PartName(strQualifier, strOwner, strName, iTableTypeMask);
        if (vecTables.size() > 0) {
            return (JetUTableView)vecTables.elementAt(0);
        }
        return null;
    }

    public Vector getTableViewsBy3PartName(String strQualifier, String strOwner, String strName, int iTableTypeMask) {
        Vector<JetUTableView> vecTableViews = new Vector<JetUTableView>();
        int iSize = this.children.size();
        JetObject child = null;
        JetUTableView jetTableView = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (child instanceof JetUTableView) {
                jetTableView = (JetUTableView)child;
                if ((iTableTypeMask & jetTableView.getTableType()) == 0 || strQualifier != null && !strQualifier.equalsIgnoreCase(jetTableView.getQualifier()) || strOwner != null && !strOwner.equalsIgnoreCase(jetTableView.getOwner()) || !strName.equalsIgnoreCase(jetTableView.getTableName())) continue;
                vecTableViews.addElement(jetTableView);
                continue;
            }
            if (!(child instanceof JetUWSOperationConnection)) continue;
            Vector tempChild = ((JetUWSOperationConnection)child).getTableViewsBy3PartName(strQualifier, strOwner, strName, iTableTypeMask);
            for (int j = 0; j < tempChild.size(); ++j) {
                vecTableViews.addElement((JetUTableView)tempChild.get(j));
            }
        }
        return vecTableViews;
    }

    @Deprecated
    public JetUProcedure addProcedure(String strResourceName, ProcInfo procedure) {
        JetUProcedure uProcedure = new JetUProcedure(strResourceName, "", procedure);
        uProcedure.connectionName.set(this.getResourceName());
        if (this.getDatabase().addProcedure(uProcedure)) {
            return uProcedure;
        }
        return null;
    }

    @Deprecated
    public boolean addProcedure(JetUProcedure uProcedure) {
        uProcedure.connectionName.set(this.getResourceName());
        return this.getDatabase().addProcedure(uProcedure);
    }

    @Deprecated
    public boolean removeProcedure(String strRscName) {
        JetUProcedure uProcedure = this.getProcedureByResourceName(strRscName);
        if (uProcedure != null) {
            this.getDatabase().mapTable4Queriable.remove(uProcedure.getResourceName().toUpperCase());
            return this.removeProcedure(uProcedure);
        }
        return false;
    }

    @Deprecated
    public boolean removeProcedure(JetUProcedure uProcedure) {
        return this.getDatabase().removeProcedure(uProcedure);
    }

    @Deprecated
    public Vector getProcedures() {
        return this.getDatabase().getProcedures();
    }

    @Deprecated
    public JetUProcedure getProcedureByResourceName(String strRscName) {
        return this.getDatabase().getProcedureByResourceName(strRscName);
    }

    @Deprecated
    public JetUFileQuery addFileQuery(String strResourceName, FileQuery fileQuery) {
        JetUFileQuery uFileQuery = new JetUFileQuery(strResourceName, "", fileQuery);
        uFileQuery.connectionName.set(this.getResourceName());
        boolean bSuc = this.getDatabase().addFileQuery(uFileQuery);
        if (bSuc) {
            return uFileQuery;
        }
        return null;
    }

    @Deprecated
    public boolean addFileQuery(JetUFileQuery uFileQuery) {
        uFileQuery.connectionName.set(this.getResourceName());
        return this.getDatabase().addFileQuery(uFileQuery);
    }

    public boolean addFileQueryAfterInit(JetUFileQuery uFileQuery) {
        if (!this.getDatabase().IsQueryNameExist(uFileQuery.getResourceName())) {
            this.getDatabase().add(uFileQuery);
            uFileQuery.initAfterAdd();
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean removeFileQUery(String strRscName) {
        return this.getDatabase().removeFileQuery(strRscName);
    }

    @Deprecated
    public boolean removeFileQuery(JetUFileQuery uFileQuery) {
        return this.getDatabase().removeFileQuery(uFileQuery);
    }

    @Deprecated
    public Vector getFileQueries() {
        return this.getDatabase().getFileQueries();
    }

    public JetUFolderTree getFolderTree() {
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUFolderTree)) continue;
            return (JetUFolderTree)child;
        }
        return null;
    }

    @Deprecated
    public JetUFileQuery GetFileQueryByResourceName(String strRscName) {
        return this.getDatabase().GetFileQueryByResourceName(strRscName);
    }

    protected boolean IsTableNameExist(String strRscName) {
        return this.GetTableOrViewByResourceName(strRscName) != null;
    }

    @Deprecated
    protected boolean isNameExist(String strRscName) {
        return this.IsTableNameExist(strRscName);
    }

    public JetUDBTreeNode getByResourceName(String strRscName) {
        JetUResourceContainer ret = this.GetTableOrViewByResourceName(strRscName);
        if (ret != null) {
            return ret;
        }
        ret = this.GetFileQueryByResourceName(strRscName);
        if (ret != null) {
            return ret;
        }
        ret = this.getProcedureByResourceName(strRscName);
        if (ret != null) {
            return ret;
        }
        return this.getDatabase().getResourceByName(strRscName);
    }

    public boolean isQueryNameExist(String strRscName) {
        return this.getDatabase().IsQueryNameExist(strRscName);
    }

    public abstract JetUConnection createNew();

    public abstract Vector getFieldsOfTable(String var1, String var2, String var3) throws SQLException, ClassNotFoundException;

    public abstract boolean cnntToSameDB(JetUConnection var1);

    public int getQualifiedNamePattern() {
        return this.qualifiedNamePattern.intValue();
    }

    public void setQualifiedNamePattern(int iQualifiedNamePattern) {
        this.qualifiedNamePattern.set(new Integer(iQualifiedNamePattern));
    }

    public abstract JetUSupportInfo getSupportInfo();

    @Override
    public String getDateFormat() {
        return this.dateFormat.get();
    }

    public void setDateFormat(String strDateFormat) {
        this.dateFormat.set(strDateFormat);
    }

    @Override
    public String getTimeFormat() {
        return this.timeFormat.get();
    }

    public void setTimeFormat(String strTimeFormat) {
        this.timeFormat.set(strTimeFormat);
    }

    @Override
    public String getTimestampFormat() {
        return this.timestampFormat.get();
    }

    public void setTimestampFormat(String strTimestampFormat) {
        this.timestampFormat.set(strTimestampFormat);
    }

    public abstract TableInfo createTableInfo(String var1, String var2, String var3, int var4) throws SQLException, ClassNotFoundException;

    public abstract void fetchSupportInfo() throws SQLException, ClassNotFoundException;

    public abstract void updateSupportInfo() throws SQLException, ClassNotFoundException;

    public abstract Vector addTableViews(String var1, String var2, String var3, int var4) throws ClassNotFoundException, SQLException, AddTableViewException;

    public abstract Vector getTypeInfo();

    protected boolean isMatchingType(int iTypeInCatalog, int iType) {
        if ((iType & 1) != 0 && iTypeInCatalog == 1) {
            return true;
        }
        return (iType & 2) != 0 && iTypeInCatalog == 2;
    }

    public boolean isSecurityCheck() {
        return this.security.get();
    }

    public static final int mapColType(int sqlType) {
        switch (sqlType) {
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                sqlType += 82;
                break;
            }
        }
        return sqlType;
    }

    protected JetUJDBCTypeInfo getTypeInfo(int iSQLType) {
        JetUJDBCTypeInfo retTypeInfo = null;
        Vector vecChildren = this.getTypeInfo();
        int iSize = vecChildren.size();
        for (int i = 0; i < iSize; ++i) {
            retTypeInfo = (JetUJDBCTypeInfo)vecChildren.elementAt(i);
            if (retTypeInfo.DataType.get() != iSQLType) continue;
            return retTypeInfo;
        }
        return retTypeInfo;
    }

    protected abstract boolean isSQLTypeCaseSensitive(int var1);

    public int getEncodingPattern() {
        return this.encodingPattern.intValue();
    }

    public void setEncodingPattern(int iEncodingPattern) {
        this.encodingPattern.set(new Integer(iEncodingPattern));
    }

    @Override
    public void InitAfterLoad() {
        super.InitAfterLoad();
        this.deleteBuildinParameterQuery();
    }

    public HashMap<String, Vector> groupTablesToOneExe(Vector<String> tables) {
        HashMap<String, Vector> ret = new HashMap<String, Vector>();
        ret.put("full", tables);
        return ret;
    }

    public void setDefault() {
        Vector conns = this.getDatabase().getConnections();
        int size = conns.size();
        for (int i = 0; i < size; ++i) {
            JetUConnection con = (JetUConnection)conns.get(i);
            con.isDefaultConnection.set(false);
        }
        this.isDefaultConnection.set(true);
    }

    public boolean isDefault() {
        return this.isDefaultConnection.get();
    }

    public boolean isBigDataSource() {
        if (this instanceof JetUMongoConnection) {
            return true;
        }
        if (this instanceof JetUJDBCConnection) {
            return ((JetUJDBCConnection)this).isHive();
        }
        return false;
    }

    @Override
    public void setResourceName(String connectionName) {
        String oldConnectionName = this.getResourceName();
        super.setResourceName(connectionName);
        if (this.getDatabase() == null) {
            return;
        }
        Hashtable<String, JetUQueriable> qs = this.getDatabase().mapTable4Queriable;
        for (JetUQueriable queriable : qs.values()) {
            if (queriable instanceof JetUFileQuery) {
                JetUFileQuery fq = (JetUFileQuery)queriable;
                if (fq.connectionName.get().equalsIgnoreCase(oldConnectionName)) {
                    fq.connectionName.set(connectionName);
                }
            }
            if (!(queriable instanceof JetUProcedure)) continue;
            JetUProcedure procedure = (JetUProcedure)queriable;
            if (!procedure.connectionName.get().equalsIgnoreCase(oldConnectionName)) continue;
            procedure.connectionName.set(connectionName);
        }
    }
}

