/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.JetObjInspector.ObjectInfo;
import jet.controls.JetEnumeration;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.log.JRLogger;
import jet.universe.JetUDBFakeNode;
import jet.universe.JetUDocNode;
import jet.universe.JetUFolderTree;
import jet.universe.JetUTableView;
import jet.universe.JetUTree;
import jet.universe.exception.DocException;
import jet.util.WildcardMatcher;

public class JetUDBFolder
extends JetUTree
implements JetUDocNode {
    public static final int TYPE_TABLE = 0;
    public static final int TYPE_VIEW = 1;
    public static final int TYPE_SYNONYM = 2;
    public JetString name = new JetString(this, "Name");
    public JetString desc = new JetString(this, "Description");
    public JetEnumeration folderType = new JetEnumeration(this, "FolderType", 37);
    transient ObjectInfo objInfo = null;
    private static JRLogger logger = JRLogger.getLogger(JetUDBFolder.class.getName());
    private static final HashMap nameIdx = new HashMap(3);

    public JetUDBFolder() {
        this.initialize();
    }

    public JetUDBFolder(String strName, String strDesc) {
        this.initialize();
        this.setName(strName);
        this.setDesc(strDesc);
    }

    protected void initialize() {
    }

    @Override
    public JetObject add(JetObject child, int pos) {
        super.add(child, pos);
        return child;
    }

    @Override
    public String getName() {
        return this.name.get();
    }

    @Override
    public void setName(String strName) {
        this.name.set(strName);
    }

    @Override
    public String getDesc() {
        return this.desc.get();
    }

    @Override
    public void setDesc(String strDesc) {
        this.desc.set(strDesc);
    }

    public int getType() {
        return this.folderType.intValue();
    }

    public void setType(int iType) {
        switch (iType) {
            case 0: {
                this.folderType.set(new Integer(0));
                break;
            }
            case 1: {
                this.folderType.set(new Integer(1));
                break;
            }
            case 2: {
                this.folderType.set(new Integer(2));
                break;
            }
            default: {
                this.folderType.set(new Integer(iType));
            }
        }
    }

    public JetUFolderTree getFolderTree() {
        for (JetUDocNode parent = (JetUDocNode)((Object)this.getParent()); parent != null; parent = (JetUDocNode)((Object)parent.getParent())) {
            if (!(parent instanceof JetUFolderTree)) continue;
            return ((JetUFolderTree)parent).getFolderTree();
        }
        return null;
    }

    public boolean isRootFolder() {
        JetUDocNode parent = (JetUDocNode)((Object)this.getParent());
        return parent instanceof JetUFolderTree;
    }

    public boolean IsFolderExistByLocator(String strLocator) {
        JetUDBFolder dbFolder = this.getFolderByLocator(strLocator);
        return dbFolder != null;
    }

    public boolean IsFakeNameExistAll(String strName) {
        JetUDBFakeNode fakeNode = null;
        Vector fakeVec = new Vector();
        fakeVec = this.getAllDBFakeNodes();
        int size = fakeVec.size();
        for (int i = 0; i < size; ++i) {
            fakeNode = (JetUDBFakeNode)fakeVec.elementAt(i);
            if (!strName.equalsIgnoreCase(fakeNode.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean IsFolderNameExist(String strName) {
        JetUDBFolder folder = this.getFolderByName(strName);
        return folder != null;
    }

    protected String getPath() {
        String retStr = "";
        JetObject parentNode = null;
        parentNode = (JetObject)((Object)this.getParent());
        if (parentNode instanceof JetUDBFolder) {
            retStr = ((JetUDBFolder)parentNode).getLocator();
        }
        return retStr;
    }

    @Override
    public String getLocator() {
        String strPath = this.getPath();
        if (strPath.equals("")) {
            return "/";
        }
        if (strPath.equals("/")) {
            return strPath + this.getName();
        }
        return strPath + "/" + this.getName();
    }

    public JetUDBFolder getRootFolder() {
        JetUDBFolder retNode = this;
        JetUTree treeNode = (JetUTree)this.getParent();
        while (treeNode instanceof JetUDBFolder) {
            retNode = (JetUDBFolder)treeNode;
            treeNode = (JetUTree)treeNode.getParent();
        }
        return retNode;
    }

    public JetUDBFolder addFolder(String strName, String strDesc) {
        JetUDBFolder folder = new JetUDBFolder(strName, strDesc);
        return this.addFolder(folder);
    }

    public JetUDBFolder addFolder(String strLocator) throws DocException {
        if (!strLocator.startsWith("/")) {
            throw new DocException(1, strLocator);
        }
        StringTokenizer tokLocator = new StringTokenizer(strLocator, "/");
        JetUDBFolder curNode = this.getRootFolder();
        String strNewFolder = "";
        Object newFolder = null;
        JetUDocNode tempNode = null;
        while (tokLocator.hasMoreTokens()) {
            strNewFolder = tokLocator.nextToken();
            tempNode = curNode.getChildByName(strNewFolder);
            if (tempNode != null && tempNode instanceof JetUDBFakeNode) {
                throw new DocException(1, strLocator);
            }
            if (tempNode == null) {
                curNode = curNode.addFolder(strNewFolder, "");
                continue;
            }
            curNode = (JetUDBFolder)tempNode;
        }
        return curNode;
    }

    protected JetUDocNode getChildByName(String strName) {
        Vector childrenVec = this.getChildren();
        int iSize = childrenVec.size();
        JetUDocNode node = null;
        for (int i = 0; i < iSize; ++i) {
            node = (JetUDocNode)childrenVec.elementAt(i);
            if (!node.getName().equalsIgnoreCase(strName)) continue;
            return node;
        }
        return null;
    }

    public JetUDBFolder addFolder(JetUDBFolder folder) {
        this.add(folder);
        return folder;
    }

    public JetUDBFolder getFolderByName(String strName) {
        JetUDocNode retNode = this.getChildByName(strName);
        return retNode != null && retNode instanceof JetUDBFolder ? (JetUDBFolder)retNode : null;
    }

    public int getChildrenSize() {
        Vector retVec = this.getAllChildren();
        return retVec.size();
    }

    public JetUDBFakeNode addDBFakeNode(JetUTableView tableview) {
        JetUDBFakeNode fakenode = new JetUDBFakeNode(tableview.getResourceName(), tableview.getDesc());
        return (JetUDBFakeNode)this.add(fakenode);
    }

    @Override
    public boolean delete(boolean isTrue) {
        JetUTree parentNode = (JetUTree)this.getParent();
        if (parentNode instanceof JetUDBFolder) {
            ((JetUDBFolder)parentNode).removeSubNode(this);
            ((JetUDBFolder)parentNode).remove(this);
            return true;
        }
        return false;
    }

    public JetUDocNode removeFakeNode(JetUDBFakeNode node) throws SecurityException {
        return (JetUDocNode)((Object)this.remove(node));
    }

    public void removeSubNode(JetUDocNode node) {
        if (node instanceof JetUDBFakeNode) {
            this.removeFakeNode((JetUDBFakeNode)node);
        } else if (node instanceof JetUDBFolder) {
            Vector subNodesVec = ((JetUDBFolder)node).getChildren();
            int iSize = subNodesVec.size();
            JetUDocNode subNode = null;
            for (int i = 0; i < iSize; ++i) {
                subNode = (JetUDocNode)subNodesVec.elementAt(i);
                ((JetUDBFolder)node).removeSubNode(subNode);
            }
        }
    }

    @Override
    public boolean containsReports() {
        return false;
    }

    public boolean containsFakeNodes() {
        return this.getAllDBFakeNodes().size() > 0;
    }

    public Vector getAllDBFakeNodes() {
        Vector retVec = new Vector();
        Vector subNodes = this.getChildren();
        if (subNodes != null) {
            this.getDBFakeNodes(subNodes, retVec);
        }
        return retVec;
    }

    public Vector getAllChildren() {
        Vector retVec = new Vector();
        Vector subNodes = this.getChildren();
        if (subNodes != null) {
            this.getAllChildren(subNodes, retVec);
        }
        return retVec;
    }

    protected void getAllChildren(Vector subNodes, Vector childrenNodes) {
        int iSize = subNodes.size();
        JetUDocNode nodeElement = null;
        for (int i = 0; i < iSize; ++i) {
            nodeElement = (JetUDocNode)subNodes.elementAt(i);
            childrenNodes.addElement(nodeElement);
            if (!(nodeElement instanceof JetUDBFolder)) continue;
            this.getAllChildren(((JetUDBFolder)nodeElement).getChildren(), childrenNodes);
        }
    }

    public JetUDocNode getChildByLocator(String strLocator) {
        JetUDBFolder rootNode = this.getRootFolder();
        if (strLocator.equals("/")) {
            return rootNode;
        }
        if (strLocator.startsWith("/")) {
            return rootNode.getChildByRelativeLocator(strLocator.substring("/".length()));
        }
        return this.getChildByRelativeLocator(strLocator);
    }

    public JetUDocNode getChildByRelativeLocator(String strRelativeLocator) {
        int iIndexOfPathSeparator = strRelativeLocator.indexOf("/");
        if (iIndexOfPathSeparator == -1) {
            return this.getChildByName(strRelativeLocator);
        }
        String strChildName = strRelativeLocator.substring(0, iIndexOfPathSeparator);
        JetUDBFolder docNode = this.getFolderByName(strChildName);
        if (docNode != null) {
            return (JetUDBFolder)docNode.getChildByRelativeLocator(strRelativeLocator.substring(iIndexOfPathSeparator + "/".length()));
        }
        return null;
    }

    public JetUDBFolder getFolderByLocator(String strLocator) {
        JetUDBFolder rootNode = this.getRootFolder();
        if (strLocator.equals("/")) {
            return rootNode;
        }
        if (strLocator.startsWith("/")) {
            return rootNode.getFolderByRelativeLocator(strLocator.substring("/".length()));
        }
        return this.getFolderByRelativeLocator(strLocator);
    }

    public JetUDBFolder getFolderByRelativeLocator(String strRelativeLocator) {
        int iIndexOfPathSeparator = strRelativeLocator.indexOf("/");
        if (iIndexOfPathSeparator == -1) {
            return this.getFolderByName(strRelativeLocator);
        }
        String strChildName = strRelativeLocator.substring(0, iIndexOfPathSeparator);
        JetUDBFolder docNode = this.getFolderByName(strChildName);
        if (docNode != null) {
            return docNode.getFolderByRelativeLocator(strRelativeLocator.substring(iIndexOfPathSeparator + "/".length()));
        }
        return null;
    }

    public void getDBFakeNodes(Vector subNodes, Vector leafNodes) {
        int iSize = subNodes.size();
        JetUDocNode nodeElement = null;
        for (int i = 0; i < iSize; ++i) {
            nodeElement = (JetUDocNode)subNodes.elementAt(i);
            if (nodeElement instanceof JetUDBFakeNode) {
                leafNodes.addElement(nodeElement);
                continue;
            }
            if (!(nodeElement instanceof JetUDBFolder)) continue;
            this.getDBFakeNodes(((JetUDBFolder)nodeElement).getChildren(), leafNodes);
        }
    }

    public Vector getItemsByName(String strWildcard) {
        Vector<JetUDocNode> retVec = new Vector<JetUDocNode>();
        Vector subNodesVec = this.getAllChildren();
        int iSize = subNodesVec.size();
        JetUDocNode subNode = null;
        for (int i = 0; i < iSize; ++i) {
            subNode = (JetUDocNode)subNodesVec.elementAt(i);
            if (!subNode.isMatch(strWildcard, true)) continue;
            retVec.addElement(subNode);
        }
        return retVec;
    }

    public JetUDBFakeNode getDBFokeNodeByName(String strName) {
        Vector childrenVec = this.getChildren();
        int iSize = childrenVec.size();
        JetUDocNode node = null;
        for (int i = 0; i < iSize; ++i) {
            node = (JetUDocNode)childrenVec.elementAt(i);
            if (!(node instanceof JetUDBFakeNode) || !node.getName().equalsIgnoreCase(strName)) continue;
            return (JetUDBFakeNode)node;
        }
        return null;
    }

    public JetUDBFakeNode getDBFakeNodeFromAllByName(String strName) {
        Vector fakeNodeVec = this.getAllDBFakeNodes();
        int iSize = fakeNodeVec.size();
        JetUDocNode node = null;
        for (int i = 0; i < iSize; ++i) {
            node = (JetUDocNode)fakeNodeVec.elementAt(i);
            if (!(node instanceof JetUDBFakeNode) || !node.getName().equalsIgnoreCase(strName)) continue;
            return (JetUDBFakeNode)node;
        }
        return null;
    }

    @Override
    public boolean isMatch(String strFind, boolean bIgnoreCase) {
        return WildcardMatcher.matchWildcard(this.getName(), strFind, bIgnoreCase);
    }

    protected void createObjectInfo() {
        this.objInfo = new ObjectInfo(this, null);
    }

    @Override
    public ObjectInfo getObjectInfo() {
        if (this.objInfo == null) {
            this.createObjectInfo();
        }
        return this.objInfo;
    }

    public String toString() {
        return this.getLocator();
    }

    @Override
    public String getInstancePrefix() {
        return "DBFolder";
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    static {
        nameIdx.put("Description", new Integer(0));
        nameIdx.put("Name", new Integer(1));
        nameIdx.put("FolderType", new Integer(2));
    }
}

