/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.JetObjInspector.ObjectInfo;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.log.JRLogger;
import jet.universe.JetUDatabase;
import jet.universe.JetUTableView;
import jet.universe.JetUTreeNode;
import jet.universe.JetUUniverse;
import jet.universe.UMapTable;

public abstract class JetUDBTreeNode
extends JetUTreeNode {
    public JetString name = new JetString(this, "Name");
    public JetString desc = new JetString(this, "Description");
    transient ObjectInfo objInfo = null;
    private static JRLogger logger = JRLogger.getLogger(JetUDBTreeNode.class.getName());

    public JetUDBTreeNode() {
    }

    public JetUDBTreeNode(String strName, String strDesc) {
        this.name.set(strName);
        this.desc.set(strDesc);
    }

    public String getResourceName() {
        return this.name.get();
    }

    public void setResourceName(String strName) {
        this.name.set(strName);
    }

    @Override
    public String getDesc() {
        return this.desc.get();
    }

    @Override
    public void setDesc(String strDesc) {
        this.desc.set(strDesc);
    }

    @Override
    public void setParent(JetContainable parent) {
        if (parent == null) {
            this.BeforeRemove();
        }
        super.setParent(parent);
    }

    @Override
    public void afterInit() {
        super.afterInit();
        this.InitAfterLoad();
    }

    public void InitAfterLoad() {
    }

    public void InitAfterCreate() {
    }

    public void BeforeRemove() {
    }

    public void AfterAdd() {
    }

    public UMapTable getMapTable() {
        JetUDatabase udb = this.getDatabase();
        if (udb != null) {
            return udb.getMapTable();
        }
        return null;
    }

    public JetUUniverse getUniverse() {
        JetUDatabase udb = this.getDatabase();
        if (udb != null) {
            return udb.getUniverse();
        }
        return null;
    }

    public JetUDatabase getDatabase() {
        if (this instanceof JetUDatabase) {
            return (JetUDatabase)this;
        }
        for (JetObject parent = (JetObject)((Object)this.getParent()); parent != null; parent = (JetObject)((Object)parent.getParent())) {
            if (!(parent instanceof JetUDatabase)) continue;
            return (JetUDatabase)parent;
        }
        return null;
    }

    public String toString() {
        String strNode = this.getClass().getName() + "[ " + this.name.get() + " ]";
        return strNode;
    }

    protected void createObjectInfo() {
        this.objInfo = new ObjectInfo(this, null);
    }

    public ObjectInfo getObjectInfo() {
        if (this.objInfo == null) {
            this.createObjectInfo();
        }
        return this.objInfo;
    }

    public boolean isEqual(JetUDBTreeNode field) {
        boolean bRet;
        boolean bl = bRet = this.name.get().equalsIgnoreCase(field.getResourceName()) && (this instanceof JetUTableView && field instanceof JetUTableView || this.getClass().getName().equals(field.getClass().getName()));
        if (bRet) {
            Hashtable srcProps = this.getProperties();
            Hashtable targetProps = field.getProperties();
            Enumeration e = srcProps.keys();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                if (((JetProperty)targetProps.get(propName)).equal((JetProperty)srcProps.get(propName))) continue;
                bRet = false;
                break;
            }
        }
        return bRet;
    }

    public boolean isSimilar(JetUDBTreeNode node) {
        return this.name.equal(node.name) && node.getClass().getName().equals(this.getClass().getName());
    }

    public static JetUDBTreeNode findNodeByName(Vector nodes, String name2) {
        JetUDBTreeNode ret = null;
        for (int i = 0; i < nodes.size(); ++i) {
            JetUDBTreeNode node;
            if (!(nodes.get(i) instanceof JetUDBTreeNode) || !(node = (JetUDBTreeNode)nodes.get(i)).getResourceName().equalsIgnoreCase(name2)) continue;
            ret = node;
            break;
        }
        return ret;
    }

    public static JetUDBTreeNode findNodeByName(Vector nodes, String name2, String clsName) {
        JetUDBTreeNode ret = null;
        for (int i = 0; i < nodes.size(); ++i) {
            JetUDBTreeNode node;
            if (!(nodes.get(i) instanceof JetUDBTreeNode) || !(node = (JetUDBTreeNode)nodes.get(i)).getResourceName().equalsIgnoreCase(name2) || !node.getClass().getName().equals(clsName) && (!(node instanceof JetUTableView) || !clsName.equals("jet.universe.JetUTableView"))) continue;
            ret = node;
            break;
        }
        return ret;
    }

    public boolean equalsTo(JetUDBTreeNode node) {
        return this.isEqual(node);
    }
}

