/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.io.File;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.UUID;
import java.util.Vector;
import jet.Env;
import jet.JResource;
import jet.connect.DbColDesc;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.dataengine.api.config.JavaFormulaConfigImpl;
import jet.datasource.JRUDSNameChecker;
import jet.exception.FormulaSyntaxErrorException;
import jet.exception.InvalidParameterException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.FormulaCompiler;
import jet.formula.FormulaCompilerListener;
import jet.formula.FormulaContainer;
import jet.formula.FormulatoJava;
import jet.formula.JetRptFormula;
import jet.formula.ParamDesc;
import jet.formula.ParserOption;
import jet.formula.SymbolInfo;
import jet.formula.VarsTable;
import jet.formula.syntaxtree.Symbol;
import jet.log.JRLogger;
import jet.universe.JetUAcl;
import jet.universe.JetUCloneable;
import jet.universe.JetUConnection;
import jet.universe.JetUDBField;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUField;
import jet.universe.JetUFileQuery;
import jet.universe.JetUFormula;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUParamBuildInFileQuery;
import jet.universe.JetUParamBuildInUQuery;
import jet.universe.JetUParameter;
import jet.universe.JetUPrejoins;
import jet.universe.JetUProcedure;
import jet.universe.JetUQueriable;
import jet.universe.JetUQuery;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUTableView;
import jet.universe.JetUTreeNode;
import jet.universe.JetUUDSField;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDataSource;
import jet.universe.JetUWhereFormula;
import jet.universe.JetUWherePortion;
import jet.universe.UMapTable;
import jet.universe.UniverseToolkit;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLIlegalNameException;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.JUnifiedBusinessView;
import jet.universe.businesslogic.MeasureInfo;
import jet.universe.businesslogic.impl.UnifiedBusinessView;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.CannotFindQuery;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.exception.GenerateFormulasCodeException;
import jet.universe.exception.InvalidEntityException;
import jet.universe.psql.JetRptPsqlQuery;
import jet.universe.psql.RptPsqlQuery;
import jet.xml.model.ElementNode;
import toolkit.db.DataSourceInfo;
import toolkit.db.DbTools;
import toolkit.db.EnhancedDataSourceInfo;
import toolkit.db.PsqlTable;

public class JetUDatabase
extends JetUResourceContainer
implements FormulaContainer,
JRUDSNameChecker,
FormulaCompilerListener {
    public static final String strFormulaPackage = "jet.formula.javaformula.";
    public static final String strJavaFileExtension = ".java";
    public static final String DEFAULT_NAME = "Default";
    public JetBoolean preJoin = new JetBoolean(this, "Pre-join", false);
    public JetString javaFrmulaName = new JetString(this, "JavaFormulaName");
    public JetNumber displayRoundingMode = new JetNumber(this, "DisplayRoundingMode", 6);
    protected transient UMapTable mapTable;
    protected transient Hashtable<String, JetUQueriable> mapTable4Queriable;
    protected transient Hashtable<String, UnifiedBusinessView> mapTable4ubv;
    protected transient Vector<JetUConnection> conns;
    private JetUConnection defaultConnection;
    private transient VarsTable gVarTable;
    String strDir;
    static final String strFormulasClassNameBase = "Formula";
    private boolean bFormulaModified;
    private boolean bNeedGenerateJava;
    private static JRLogger logger = JRLogger.getLogger(JetUDatabase.class.getName());
    public static final String FORMULAHEADNAME = "~~FromulaHead";
    private ParserOption parserOption;
    private Vector udfNames;
    public static final String dbName = "Data Source 1";
    public JetBoolean isDefaultDB;
    private static final HashMap nameIdx = new HashMap(3);
    Hashtable globalVarContainer;

    public JetUDatabase() {
        this.displayRoundingMode.setEditorType(JetNumber.CHOICE_EDITOR);
        Vector<String> v = new Vector<String>();
        v.add(String.valueOf(0));
        v.add(String.valueOf(1));
        v.add(String.valueOf(2));
        v.add(String.valueOf(3));
        v.add(String.valueOf(4));
        v.add(String.valueOf(5));
        v.add(String.valueOf(6));
        this.displayRoundingMode.setPropertyChoice(v);
        this.mapTable = new UMapTable();
        this.mapTable4Queriable = new Hashtable();
        this.mapTable4ubv = new Hashtable();
        this.conns = new Vector(5);
        this.gVarTable = new VarsTable();
        this.strDir = null;
        this.bFormulaModified = false;
        this.bNeedGenerateJava = false;
        this.parserOption = new ParserOption();
        this.udfNames = new Vector();
        this.isDefaultDB = new JetBoolean(this, "IsDefaultDB");
        this.globalVarContainer = new Hashtable();
    }

    public JetUDatabase(String strName, String strDesc) {
        super(strName, strDesc);
        this.displayRoundingMode.setEditorType(JetNumber.CHOICE_EDITOR);
        Vector<String> v = new Vector<String>();
        v.add(String.valueOf(0));
        v.add(String.valueOf(1));
        v.add(String.valueOf(2));
        v.add(String.valueOf(3));
        v.add(String.valueOf(4));
        v.add(String.valueOf(5));
        v.add(String.valueOf(6));
        this.displayRoundingMode.setPropertyChoice(v);
        this.mapTable = new UMapTable();
        this.mapTable4Queriable = new Hashtable();
        this.mapTable4ubv = new Hashtable();
        this.conns = new Vector(5);
        this.gVarTable = new VarsTable();
        this.strDir = null;
        this.bFormulaModified = false;
        this.bNeedGenerateJava = false;
        this.parserOption = new ParserOption();
        this.udfNames = new Vector();
        this.isDefaultDB = new JetBoolean(this, "IsDefaultDB");
        this.globalVarContainer = new Hashtable();
    }

    @Override
    public void InitAfterCreate() {
        this.strDir = Env.getTemporaryPath();
        this.strDir = this.strDir == null ? "" : this.strDir;
    }

    @Override
    public void InitAfterLoad() {
        this.deleteBuildinParameterQuery();
        if (this.getResourceName().equalsIgnoreCase("")) {
            this.setResourceName(dbName);
            this.isDefaultDB.set(true);
        }
        this.bFormulaModified = false;
        this.bNeedGenerateJava = false;
        for (Object child : this.children) {
            if (!(child instanceof JetUFormula)) continue;
            if (!((JetUFormula)child).formulainfo.parseOK) {
                this.bNeedGenerateJava = true;
                logger.warn("When load Catalog, formulainfo.parseOK of JetUFormula " + ((JetUFormula)child).getResourceName() + " is false, need parse and general .fml again!");
                break;
            }
            int majorVersion = ((JetUFormula)child).formulainfo.getMajorVersion();
            int minorVersion = ((JetUFormula)child).formulainfo.getMinorVersion();
            if (majorVersion >= 1 && (majorVersion != 1 || minorVersion >= 14)) continue;
            this.bNeedGenerateJava = true;
            logger.warn("When load Catalog, formulainfo.Version of JetUFormula " + ((JetUFormula)child).getResourceName() + " is older than current, need parse and general .fml again!");
            break;
        }
        this.strDir = Env.getTemporaryPath();
        this.strDir = this.strDir == null ? "" : this.strDir;
        Vector cnnts = this.getConnections();
        for (JetUConnection cnnt : cnnts) {
            if (cnnt == null) continue;
            try {
                cnnt.updateSupportInfo();
            }
            catch (SQLException e) {
            }
            catch (ClassNotFoundException e) {}
        }
        this.BuildMapTable();
        this.BuildMapTable4QueryiableAndBV();
        this.ResolveQueries();
        this.InitParameters();
    }

    public void deleteBuildinParameterQuery() {
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            JetObject o = (JetObject)it.next();
            if (!(o instanceof JetUParamBuildInUQuery)) continue;
            it.remove();
            o.setParent(null);
        }
    }

    protected void initConnectionHandle() {
        this.conns = new Vector();
        this.defaultConnection = null;
        int iSize = this.children.size();
        for (int i = 0; i < iSize; ++i) {
            Object child = this.children.elementAt(i);
            if (!(child instanceof JetUConnection)) continue;
            JetUConnection con = (JetUConnection)child;
            this.conns.add(con);
            if (!con.isDefaultConnection.get()) continue;
            this.defaultConnection = (JetUConnection)child;
        }
    }

    private void BuildMapTable4QueryiableAndBV() {
        this.mapTable4Queriable.clear();
        this.mapTable4ubv.clear();
        int iSize = this.children.size();
        for (int i = 0; i < iSize; ++i) {
            Object child = this.children.elementAt(i);
            if (child instanceof JetUQueriable && !(child instanceof JetUParamBuildInUQuery) && !(child instanceof JetUParamBuildInFileQuery)) {
                this.mapTable4Queriable.put(((JetUQueriable)child).getResourceName().toUpperCase(), (JetUQueriable)child);
                continue;
            }
            if (!(child instanceof UnifiedBusinessView)) continue;
            this.mapTable4ubv.put(((UnifiedBusinessView)child).getDisplayName().toUpperCase(), (UnifiedBusinessView)child);
        }
    }

    void PrepareBeforeSave() {
        for (int i = 0; i < this.children.size(); ++i) {
            JetUParameter param;
            String refedQueryName;
            if (!(this.children.get(i) instanceof JetUParameter) || (refedQueryName = (param = (JetUParameter)this.children.get(i)).getRunTimeRefedQueryName()) == null) continue;
            JetUQueriable queriable = this.getQueriableByResourceName(refedQueryName);
            if (queriable instanceof JetUQuery) {
                JetUQuery uQuery = (JetUQuery)queriable;
                this.removeQuery(uQuery);
                Vector childs = uQuery.getChildren();
                int j = 0;
                while (i < childs.size()) {
                    JetObject child = (JetObject)this.children.elementAt(j);
                    String parent = "null";
                    if (uQuery.getParent() != null) {
                        parent = "" + uQuery.getParent().hashCode();
                    }
                    if (child instanceof JetRptPsqlQuery) {
                        logger.debug("remove query  :" + uQuery.hashCode() + ",parent  :" + parent + ",child(JetRptPsqlQuery) instanceName:" + child.getInstNameDirectly());
                    }
                    ++j;
                }
                param.setRunTimeRefedQueryName(null);
            }
            if (!(queriable instanceof JetUFileQuery)) continue;
            JetUFileQuery uFileQuery = (JetUFileQuery)queriable;
            this.getConnection().removeFileQuery(uFileQuery);
            param.setRunTimeRefedQueryName(null);
        }
        JetObject child = null;
        int iSize = this.children.size();
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (child instanceof JetUQuery) {
                ((JetUQuery)child).PrepareBeforeSave();
                continue;
            }
            if (child instanceof UnifiedBusinessView) {
                ((UnifiedBusinessView)child).getQuery().PrepareBeforeSave();
                continue;
            }
            if (child instanceof JetUConnection) {
                ((JetUConnection)child).PrepareBeforeSave();
                continue;
            }
            if (!(child instanceof JetUFileQuery)) continue;
            ((JetUFileQuery)child).PrepareBeforeSave();
        }
        this.deleteBuildinParameterQuery();
    }

    void BuildMapTable() {
        this.AddEntitiesToMapTable(this.mapTable);
    }

    void ResolveQueries() {
        JetObject child = null;
        Vector sortedChildren = this.logicSort(this.children);
        int iSize = sortedChildren.size();
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)sortedChildren.elementAt(i);
            if (!(child instanceof JetUQuery)) continue;
            ((JetUQuery)child).resolvePsqlQuery();
            ((JetUQuery)child).AddEntitiesToMapTable(this.mapTable);
        }
    }

    private Vector logicSort(Vector children) {
        Vector<JetUQuery> ret = new Vector<JetUQuery>();
        for (int i = 0; i < children.size(); ++i) {
            JetObject child = (JetObject)children.elementAt(i);
            if (child instanceof JetUQuery) {
                JetUQuery uQuery = (JetUQuery)child;
                this.logicAdd(uQuery, ret);
            }
            if (!(child instanceof JUnifiedBusinessView)) continue;
            JUnifiedBusinessView ubv = (JUnifiedBusinessView)((Object)child);
            this.logicAdd(ubv.getQuery(), ret);
        }
        return ret;
    }

    private void logicAdd(JetUQuery uQuery, Vector<JetUQuery> sortedQuery) {
        Vector ts = uQuery.getPsqlQuery().vTables;
        for (int i = 0; i < ts.size(); ++i) {
            String queryName;
            JetUQuery q;
            PsqlTable psqlTable = (PsqlTable)ts.get(i);
            if (!psqlTable.isQueriable() || (q = this.GetQueryByResourceName(queryName = psqlTable.getMappingName())) == null) continue;
            this.logicAdd(q, sortedQuery);
        }
        if (!sortedQuery.contains(uQuery)) {
            sortedQuery.add(uQuery);
        }
    }

    void InitParameters() {
        try {
            int iSize = this.children.size();
            JetObject child = null;
            for (int i = 0; i < iSize; ++i) {
                JetUParamBuildInUQuery buildInUQuery;
                child = (JetObject)this.children.elementAt(i);
                if (!(child instanceof JetUParameter)) continue;
                ((JetUParameter)child).checkParameter(ParamDesc.defaultLocale);
                JetUParameter param = (JetUParameter)child;
                if (!param.isCascading.get() || !"".equals(param.getCascadParamBindQueryName()) || (buildInUQuery = param.createCascadParamRefedQuery(param)) == null) continue;
                this.addQuery(buildInUQuery);
            }
        }
        catch (InvalidParameterException e) {
        }
    }

    @Override
    public JetObject add(JetObject child, int pos) {
        super.add(child, pos);
        return child;
    }

    @Override
    public JetObject remove(JetObject child) {
        super.remove(child);
        if (child instanceof JetUFormula) {
            this.FormulaModified();
        }
        if (child instanceof JetUQueriable) {
            this.mapTable4Queriable.remove(((JetUQueriable)((Object)child)).getResourceName().toUpperCase());
        } else if (child instanceof UnifiedBusinessView) {
            this.mapTable4ubv.remove(((UnifiedBusinessView)child).getDisplayName().toUpperCase());
        }
        return child;
    }

    @Override
    public JetUUniverse getUniverse() {
        return (JetUUniverse)this.getParent();
    }

    @Override
    public UMapTable getMapTable() {
        return this.mapTable;
    }

    public JetUConnection addConnection(String strName, String strDesc, String URL2, String UID, String PSWD, int iQualifiedNamePattern, String DRV) {
        try {
            JetUJDBCConnection cnnct = new JetUJDBCConnection(strName, strDesc, URL2, UID, PSWD, iQualifiedNamePattern, DRV);
            this.addConnection(cnnct);
            return cnnct;
        }
        catch (SQLException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public void addConnection(JetUConnection cnntObj) {
        String orgName;
        String candidateName = orgName = cnntObj.getResourceName();
        int sn = 1;
        while (this.IsConnectionNameExist(candidateName)) {
            candidateName = orgName + sn++;
        }
        cnntObj.setResourceName(candidateName);
        this.add(cnntObj);
        if (this.defaultConnection == null) {
            cnntObj.setDefault();
        }
        cnntObj.InitAfterCreate();
        this.initConnectionHandle();
    }

    public boolean removeConnection(JetUConnection cnntObj) {
        this.remove(cnntObj);
        this.initConnectionHandle();
        return true;
    }

    public Vector getConnections() {
        if (this.conns.isEmpty()) {
            this.initConnectionHandle();
        }
        return this.conns;
    }

    public JetUConnection getConnection() {
        if (this.conns.isEmpty()) {
            this.initConnectionHandle();
        }
        return this.defaultConnection;
    }

    public JetUConnection getConnectionByResourceName(String strRscConnectionName) {
        int size = this.conns.size();
        for (int i = 0; i < size; ++i) {
            JetUConnection child = this.conns.get(i);
            if (!child.getResourceName().equalsIgnoreCase(strRscConnectionName)) continue;
            return child;
        }
        return null;
    }

    public JetUQuery addQuery(String strQueryName, RptPsqlQuery psqlQuery) {
        JetUQuery query = new JetUQuery(strQueryName, psqlQuery);
        boolean bSuc = this.addQuery(query);
        if (bSuc) {
            return query;
        }
        return null;
    }

    public boolean addQuery(JetUQuery query) {
        if (!this.IsQueryNameExist(query.getResourceName())) {
            if (logger.isDebugEnabled()) {
                logger.debug("catalog " + this.getUniverse().hashCode() + " add query  :" + query.hashCode());
            }
            this.add(query);
            query.InitAfterCreate();
            return true;
        }
        return false;
    }

    @Override
    public JetObject add(JetObject child) {
        if (child instanceof JetUQueriable) {
            this.mapTable4Queriable.put(((JetUQueriable)((Object)child)).getResourceName().toUpperCase(), (JetUQueriable)((Object)child));
        }
        if (child instanceof UnifiedBusinessView) {
            this.mapTable4ubv.put(((UnifiedBusinessView)child).getDisplayName().toUpperCase(), (UnifiedBusinessView)child);
        }
        return super.add(child);
    }

    public boolean removeQuery(String strRscQueryName) {
        JetUQuery query = this.GetQueryByResourceName(strRscQueryName);
        if (query != null) {
            return this.removeQuery(query);
        }
        return false;
    }

    public boolean removeQuery(JetUQuery query) {
        if (logger.isDebugEnabled()) {
            String parent = "null";
            if (query.getParent() != null) {
                parent = "" + query.getParent().hashCode();
            }
            logger.debug("catalog " + this.getUniverse().hashCode() + " remove query  :" + query.hashCode() + ",parent  :" + parent);
        }
        this.remove(query);
        this.mapTable4Queriable.remove(query.getResourceName().toUpperCase());
        return true;
    }

    public boolean removeBv(UnifiedBusinessView ubv) {
        if (logger.isDebugEnabled()) {
            logger.debug("catalog " + this.getUniverse().hashCode() + " remove ubv  :" + ubv.hashCode());
        }
        this.remove(ubv);
        this.mapTable4ubv.remove(ubv.getDisplayName().toUpperCase());
        return true;
    }

    public JetUDBTreeNode makeCopy(JetUCloneable node) {
        JetUDBTreeNode copyNode = node.copy();
        if (copyNode instanceof JetUQuery) {
            this.addQuery((JetUQuery)copyNode);
        } else if (copyNode instanceof JetUSummary) {
            this.addSummary((JetUSummary)copyNode);
        } else if (copyNode instanceof JetUFormula) {
            this.addFormula((JetUFormula)copyNode);
        }
        return copyNode;
    }

    public Vector getQueries() {
        Vector<JetUQueriable> ret = new Vector<JetUQueriable>();
        for (JetUQueriable queriable : this.mapTable4Queriable.values()) {
            if (!(queriable instanceof JetUQuery) || queriable instanceof JetUParamBuildInFileQuery || queriable instanceof JetUParamBuildInUQuery) continue;
            ret.add(queriable);
        }
        return ret;
    }

    public Vector<UnifiedBusinessView> getBvs() {
        Vector<UnifiedBusinessView> ret = new Vector<UnifiedBusinessView>();
        for (UnifiedBusinessView queriable : this.mapTable4ubv.values()) {
            ret.add(queriable);
        }
        return ret;
    }

    public MeasureInfo getCustomMeasure(String mappingName) {
        BLNode ret;
        String bvName;
        UnifiedBusinessView ubv;
        String name2;
        int index;
        if (mappingName.startsWith("\u007fCM_") && (index = (name2 = mappingName.substring("\u007fCM_".length())).indexOf(46)) != -1 && (ubv = this.getBusinessView(bvName = name2.substring(0, index))) != null && (ret = ubv.getByDisplayName(name2.substring(index + 1, name2.length()))) instanceof MeasureInfo) {
            return (MeasureInfo)ret;
        }
        return null;
    }

    public JetUQuery GetQueryByResourceName(String strRscQueryName) {
        if (strRscQueryName == null) {
            return null;
        }
        if (strRscQueryName.startsWith("\u007fUBV~")) {
            UnifiedBusinessView bv = this.mapTable4ubv.get(strRscQueryName.substring("\u007fUBV~".length()).toUpperCase());
            if (bv == null) {
                return null;
            }
            return bv.getQuery();
        }
        JetUQueriable ret = this.mapTable4Queriable.get(strRscQueryName.toUpperCase());
        if (ret instanceof JetUQuery) {
            return (JetUQuery)ret;
        }
        return null;
    }

    public JetUWherePortion addWherePortion(String strName, String strDescription, String strWherePortion) {
        JetUWherePortion uwhereportion = new JetUWherePortion(strName, strDescription, strWherePortion);
        boolean bSuc = this.addWherePortion(uwhereportion);
        if (bSuc) {
            return uwhereportion;
        }
        return null;
    }

    public boolean addWherePortion(JetUWherePortion uWherePortion) {
        if (!this.IsWherePortionNameExist(uWherePortion.getResourceName())) {
            this.add(uWherePortion);
            uWherePortion.InitAfterCreate();
            return true;
        }
        return false;
    }

    public boolean removeWherePortion(String strName) {
        JetUWherePortion uWherePortion = this.getWherePortionByResourceName(strName);
        if (uWherePortion != null) {
            return this.removeWherePortion(uWherePortion);
        }
        return false;
    }

    public boolean removeWherePortion(JetUWherePortion uWherePortion) {
        this.remove(uWherePortion);
        return true;
    }

    public Vector getWherePortions() {
        Vector<JetUWherePortion> whereportions = new Vector<JetUWherePortion>();
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUWherePortion)) continue;
            whereportions.addElement((JetUWherePortion)child);
        }
        return whereportions;
    }

    public JetUWherePortion getWherePortionByResourceName(String strName) {
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUWherePortion) || !((JetUWherePortion)child).getResourceName().equalsIgnoreCase(strName)) continue;
            return (JetUWherePortion)child;
        }
        return null;
    }

    public boolean removeHierDataSource(JetUHierDataSource hds) {
        this.remove(hds);
        return true;
    }

    public JetUHierDataSource addHierDataSource(ElementNode node, String uri) {
        JetUHierDataSource hds = new JetUHierDataSource(node, uri);
        boolean bSuc = this.addHierDataSource(hds);
        if (bSuc) {
            return hds;
        }
        return null;
    }

    public boolean addHierDataSource(JetUHierDataSource hds) {
        String name2;
        int i = 1;
        if (!this.IsQueryNameExist(hds.getResourceName())) {
            this.add(hds);
            hds.InitAfterCreate();
            return true;
        }
        String tmp = name2 = hds.getResourceName();
        while (this.IsQueryNameExist(tmp)) {
            tmp = name2 + i++;
        }
        hds.setResourceName(tmp);
        this.add(hds);
        hds.InitAfterCreate();
        return true;
    }

    public JetUUserDataSource addDataSource(EnhancedDataSourceInfo ds) {
        JetUUserDataSource uUDS = new JetUUserDataSource(ds);
        boolean bSuc = this.addDataSource(uUDS);
        if (bSuc) {
            return uUDS;
        }
        return null;
    }

    public JetUUserDataSource addDataSource(DataSourceInfo ds) {
        JetUUserDataSource uUDS = new JetUUserDataSource(ds);
        boolean bSuc = this.addDataSource(uUDS);
        if (bSuc) {
            return uUDS;
        }
        return null;
    }

    public boolean addDataSource(JetUUserDataSource uUDS) {
        if (!this.IsQueryNameExist(uUDS.getResourceName())) {
            this.add(uUDS);
            uUDS.InitAfterCreate();
            return true;
        }
        return false;
    }

    public boolean addDataSourceAfterInit(JetUUserDataSource uUDS) {
        if (!this.IsQueryNameExist(uUDS.getResourceName())) {
            this.add(uUDS);
            uUDS.InitAfterCreate();
            return true;
        }
        return false;
    }

    public boolean addHierDataSourceAfterInit(JetUHierDataSource uHDS) {
        if (!this.IsQueryNameExist(uHDS.getResourceName())) {
            this.add(uHDS);
            uHDS.InitAfterCreate();
            return true;
        }
        return false;
    }

    public boolean removeDataSource(String strRscName) {
        JetUUserDataSource jetDataSource = this.getDataSourceByResourceName(strRscName);
        if (jetDataSource != null) {
            return this.removeDataSource(jetDataSource);
        }
        return false;
    }

    public boolean removeDataSource(JetUUserDataSource jetDataSource) {
        this.remove(jetDataSource);
        return true;
    }

    public JetUUserDataSource getDataSourceByResourceName(String strName) {
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUUserDataSource) || !((JetUUserDataSource)child).getResourceName().equalsIgnoreCase(strName)) continue;
            return (JetUUserDataSource)child;
        }
        return null;
    }

    public boolean removeHierDataSource(String strRscName) {
        JetUHierDataSource jetDataSource = this.getHierDataSourceByResourceName(strRscName);
        if (jetDataSource != null) {
            return this.removeHierDataSource(jetDataSource);
        }
        return false;
    }

    public JetUHierDataSource getHierDataSourceByResourceName(String resName) {
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUHierDataSource) || !((JetUHierDataSource)child).getResourceName().equalsIgnoreCase(resName)) continue;
            return (JetUHierDataSource)child;
        }
        return null;
    }

    public Vector getDataSources() {
        Vector<JetUUserDataSource> UDSVec = new Vector<JetUUserDataSource>();
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUUserDataSource)) continue;
            UDSVec.addElement((JetUUserDataSource)child);
        }
        return UDSVec;
    }

    public Vector getHierDataSources() {
        Vector<JetUHierDataSource> HDSVec = new Vector<JetUHierDataSource>();
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUHierDataSource)) continue;
            HDSVec.addElement((JetUHierDataSource)child);
        }
        return HDSVec;
    }

    public Vector getHDSFormulas() {
        Vector hdsVec = this.getHierDataSources();
        Vector fmls = new Vector();
        for (int i = 0; i < hdsVec.size(); ++i) {
            Vector hdsfmls = ((JetUHierDataSource)hdsVec.elementAt(i)).getWhereFormulas();
            if (hdsfmls == null || hdsfmls.size() <= 0) continue;
            fmls.addAll(hdsfmls);
        }
        return fmls;
    }

    public JetUFormula addFormula(String strName, String strDesc, String strExpression) {
        JetUFormula formula2 = new JetUFormula(strName, strDesc, strExpression);
        boolean bSuc = this.addFormula(formula2);
        if (bSuc) {
            return formula2;
        }
        return null;
    }

    public boolean addFormula(JetUFormula formula2) {
        if (!this.IsMappingNameExist(formula2.getResourceName())) {
            this.add(formula2);
            formula2.InitAfterCreate();
            return true;
        }
        return false;
    }

    public boolean removeFormula(JetUFormula formula2) {
        this.remove(formula2);
        return true;
    }

    public Vector getFormulas() {
        Vector<JetUFormula> formulas = new Vector<JetUFormula>();
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUFormula) || child instanceof JetUSummary || ((JetUFormula)child).getResourceName().equals(FORMULAHEADNAME)) continue;
            formulas.addElement((JetUFormula)child);
        }
        return formulas;
    }

    public JetUFormula getFormulaHead() {
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUFormula) || !((JetUFormula)child).getResourceName().equals(FORMULAHEADNAME)) continue;
            return (JetUFormula)child;
        }
        JetUFormula formulaHead = new JetUFormula(FORMULAHEADNAME, "", "");
        this.addFormula(formulaHead);
        return formulaHead;
    }

    public JetUFormula getFormulaByResourceName(String strFormulaName) {
        JetUResourceEntity re = this.mapTable.getResourceByName(strFormulaName.toUpperCase());
        return re instanceof JetUFormula ? (JetUFormula)re : null;
    }

    public JetUParameter addParameter(String strParamName, String strDesc, String strPrompt, String strType, String strDefaultValue) {
        JetUParameter param = new JetUParameter(strParamName, strDesc, strPrompt, strType, strDefaultValue);
        boolean bSuc = this.addParameter(param);
        if (bSuc) {
            return param;
        }
        return null;
    }

    public boolean addParameter(JetUParameter param) {
        String sourceName = param.getResourceName();
        Vector dbs = this.getUniverse().getAllDatabases();
        boolean exist = false;
        for (int i = 0; i < dbs.size(); ++i) {
            JetUDatabase db = (JetUDatabase)dbs.elementAt(i);
            if (!db.IsMappingNameExist(sourceName)) continue;
            exist = true;
            break;
        }
        if (!exist) {
            JetUParamBuildInUQuery buildInUQuery;
            this.add(param);
            param.InitAfterCreate();
            if (param.isCascading.get() && "".equals(param.nextLevel.get()) && (buildInUQuery = param.createCascadParamRefedQuery(param)) != null) {
                this.addQuery(buildInUQuery);
            }
            return true;
        }
        return false;
    }

    public boolean removeParameter(JetUParameter param) {
        String queryName;
        JetUQuery query;
        this.remove(param);
        if (param.isCascading.get() && param.nextLevel.get() == "" && (query = this.GetQueryByResourceName(queryName = param.getCascadParamBindQueryName())) != null) {
            this.removeQuery(query);
        }
        return true;
    }

    public Vector getParameters() {
        Vector<JetUParameter> parameters = new Vector<JetUParameter>();
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUParameter)) continue;
            parameters.addElement((JetUParameter)child);
        }
        return parameters;
    }

    public JetUParameter getParameterByResourceName(String strRscParamName) {
        JetUResourceEntity re = this.getResourceByName(strRscParamName);
        return re instanceof JetUParameter ? (JetUParameter)re : null;
    }

    public JetUSummary addSummary(String strName, String strDesc, String strFunction, String strFieldName, String strGroupByFld) {
        JetUSummary summary = new JetUSummary(strName, strDesc, strFunction, strFieldName, strGroupByFld);
        boolean bSuc = this.addSummary(summary);
        if (bSuc) {
            return summary;
        }
        return null;
    }

    public boolean addSummary(JetUSummary summary) {
        if (!this.IsMappingNameExist(summary.getResourceName())) {
            this.add(summary);
            summary.InitAfterCreate();
            return true;
        }
        return false;
    }

    public boolean removeSummary(JetUSummary summary) {
        this.remove(summary);
        return true;
    }

    public Vector getSummaries() {
        Vector<JetUSummary> summaries = new Vector<JetUSummary>();
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUSummary)) continue;
            summaries.addElement((JetUSummary)child);
        }
        return summaries;
    }

    public JetUSummary getSummaryByResourceName(String strRscSumName) {
        JetUResourceEntity re = this.mapTable.getResourceByName(strRscSumName.toUpperCase());
        return re instanceof JetUSummary ? (JetUSummary)re : null;
    }

    public Vector getFormulasAndSummaries() {
        Vector<JetUFormula> formulas = new Vector<JetUFormula>();
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUFormula) || ((JetUFormula)child).getResourceName().startsWith("~~")) continue;
            formulas.addElement((JetUFormula)child);
        }
        return formulas;
    }

    public Vector getAllSumsValidToQuery(String qryName) {
        int size;
        if (qryName == null) {
            return this.getSummaries();
        }
        JetUQueriable uQuery = this.getQueriableByResourceName(qryName);
        if (uQuery == null) {
            return null;
        }
        Vector sums = this.getSummaries();
        if (uQuery != null && (size = sums.size()) > 0) {
            for (int i = size - 1; i >= 0; --i) {
                JetUSummary sum = (JetUSummary)sums.elementAt(i);
                try {
                    if (uQuery.isFieldValidToQuery(this.getUniverse(), sum, this.getResourceName())) continue;
                    sums.removeElement(sum);
                    continue;
                }
                catch (FormulaHasGrammarError e1) {
                    sums.removeElement(sum);
                    continue;
                }
                catch (CannotFindFrmlRefFld e2) {
                    sums.removeElement(sum);
                    continue;
                }
                catch (CannotFindEntity e3) {
                    sums.removeElement(sum);
                }
            }
        }
        return sums;
    }

    static boolean isDigital(String name2) {
        try {
            Long.parseLong(name2);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public Vector getSummaries(String colName, Vector groupByNames) {
        int iSize = this.children.size();
        JetObject child = null;
        JetUSummary summary = null;
        Vector<JetUSummary> retSummaries = new Vector<JetUSummary>();
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUSummary)) continue;
            summary = (JetUSummary)child;
            if (colName != null && !colName.equalsIgnoreCase(summary.getFieldName())) continue;
            if (groupByNames == null || groupByNames.size() == 0) {
                retSummaries.addElement(summary);
                continue;
            }
            String tmp = summary.getGroupByFld();
            if (tmp != null && !tmp.equalsIgnoreCase("")) {
                int jSize = groupByNames.size();
                for (int j = 0; j < jSize; ++j) {
                    if (!tmp.equalsIgnoreCase((String)groupByNames.elementAt(j))) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("adding summary..." + summary.getResourceName());
                    }
                    retSummaries.addElement(summary);
                }
                continue;
            }
            retSummaries.addElement(summary);
        }
        return retSummaries;
    }

    public Vector getSummaries(String colName, Vector groupByNames, String func) {
        int iSize = this.children.size();
        JetObject child = null;
        Vector<JetUSummary> retSummaries = new Vector<JetUSummary>();
        for (int i = 0; i < iSize; ++i) {
            JetUSummary summary;
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUSummary) || !colName.equalsIgnoreCase((summary = (JetUSummary)child).getFieldName()) || !func.equalsIgnoreCase(summary.getFunction())) continue;
            String tmp = summary.getGroupByFld();
            if (tmp != null && !tmp.equalsIgnoreCase("")) {
                int tSize = groupByNames.size();
                for (int t = 0; t < tSize; ++t) {
                    if (!tmp.equalsIgnoreCase((String)groupByNames.elementAt(t))) continue;
                    retSummaries.addElement(summary);
                }
                continue;
            }
            int gSize = groupByNames.size();
            for (int g = 0; g < gSize; ++g) {
                String groupby = (String)groupByNames.elementAt(g);
                if (groupby != null && !groupby.equals("")) continue;
                retSummaries.addElement(summary);
            }
        }
        return retSummaries;
    }

    protected String[] ParseFullFieldName(String fldName) {
        if (fldName != null) {
            int iEndIndex = fldName.indexOf(46);
            int iStartIndex = 0;
            String[] fullNameArray = new String[3];
            for (int i = 0; i < 3; ++i) {
                if (iEndIndex == -1) {
                    return null;
                }
                fullNameArray[i] = fldName.substring(iStartIndex, iEndIndex);
                iStartIndex = iEndIndex + 1;
                iEndIndex = fldName.indexOf(46, iStartIndex);
            }
            return fullNameArray;
        }
        return null;
    }

    @Override
    public String getDesc() {
        return null;
    }

    @Override
    public void setDesc(String strDesc) {
    }

    @Deprecated
    public JetUTableView GetTableOrViewByRealName(String strConnectionName, String strRealName) {
        JetUConnection cnnct = this.getConnectionByResourceName(strConnectionName);
        if (cnnct != null) {
            return cnnct.GetTableOrViewByRealName(strRealName);
        }
        return null;
    }

    public Vector<JetUTableView> GetTableOrViewByRealName(String catalog, String schema, String strRealName) {
        Vector<JetUTableView> v = new Vector<JetUTableView>();
        for (JetUConnection jetUConnection : this.conns) {
            v.addAll(jetUConnection.getTableViewsBy3PartName(catalog, schema, strRealName, 15));
        }
        return v;
    }

    @Deprecated
    public JetUTableView GetTableOrViewByResourceName(String strConnectionName, String strResourceName) {
        JetUConnection cnnct = this.getConnectionByResourceName(strConnectionName);
        if (cnnct != null) {
            return cnnct.GetTableOrViewByResourceName(strResourceName);
        }
        return null;
    }

    public JetUTableView GetTableOrViewByResourceName(String tableViewName) {
        for (JetUConnection jetUConnection : this.conns) {
            JetUTableView ret = jetUConnection.GetTableOrViewByResourceName(tableViewName);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public JetUField GetFieldByRealName(String strConnectionName, String strTableName, String strFldName) {
        JetUTableView table = this.GetTableOrViewByResourceName(strConnectionName, strTableName);
        if (table != null) {
            return table.getFieldByFieldName(strFldName);
        }
        return null;
    }

    public boolean IsConnectionNameExist(String strConnectionName) {
        return this.getConnectionByResourceName(strConnectionName) != null;
    }

    public boolean IsTableNameExist(String strConnection, String name2) {
        JetUConnection con = this.getConnectionByResourceName(strConnection);
        return con.IsTableNameExist(name2);
    }

    public boolean IsQueryNameExist(String strQueryName) {
        return this.getQueriableByResourceName(strQueryName) != null;
    }

    public boolean IsDataSourceNameExist(String strUDS) {
        return this.getDataSourceByResourceName(strUDS) != null;
    }

    public boolean IsWherePortionNameExist(String strWherePortion) {
        return this.getWherePortionByResourceName(strWherePortion) != null;
    }

    public boolean IsMappingNameExist(String strRscName) {
        return this.mapTable.getResourceByName(strRscName.toUpperCase()) != null;
    }

    boolean IsNameValid(String name2, StringBuffer error) {
        if (name2 != null && (name2 = name2.trim()).length() != 0) {
            return true;
        }
        if (error != null) {
            error.append("The name can not be empty.");
        }
        return false;
    }

    public boolean IsConnectionNameOK(String name2, StringBuffer error) {
        if (!this.IsNameValid(name2, error)) {
            return false;
        }
        if (this.IsConnectionNameExist(name2)) {
            if (error != null) {
                error.append(JResource.getMessage("CAT_13", (Object)name2));
            }
            return false;
        }
        if (DbTools.isSpecialField(name2) != -1) {
            if (error != null) {
                error.append(JResource.getMessage("CAT_111", (Object)name2));
            }
            return false;
        }
        return true;
    }

    public boolean IsTableNameOK(String name2, StringBuffer error) {
        if (!this.IsNameValid(name2, error)) {
            return false;
        }
        Vector cs = this.getConnections();
        for (JetUConnection con : cs) {
            if (con.isNameExist(name2)) {
                if (error != null) {
                    error.append(JResource.getMessage("CAT_14", (Object)name2));
                }
                return false;
            }
            if (DbTools.isSpecialField(name2) == -1) continue;
            if (error != null) {
                error.append(JResource.getMessage("CAT_111", (Object)name2));
            }
            return false;
        }
        return true;
    }

    public boolean IsProcedureNameOK(String name2, StringBuffer error) {
        if (!this.IsNameValid(name2, error)) {
            return false;
        }
        Vector cs = this.getConnections();
        for (JetUConnection con : cs) {
            if (con.isNameExist(name2) || this.IsQueryNameExist(name2)) {
                if (error != null) {
                    error.append(JResource.getMessage("CAT_14", (Object)name2));
                }
                return false;
            }
            if (DbTools.isSpecialField(name2) == -1) continue;
            if (error != null) {
                error.append(JResource.getMessage("CAT_111", (Object)name2));
            }
            return false;
        }
        return true;
    }

    public boolean IsDataSourceNameOK(String name2, StringBuffer error) {
        if (!this.IsNameValid(name2, error)) {
            return false;
        }
        if (this.isQueriableExist(name2)) {
            if (error != null) {
                error.append(JResource.getMessage("CAT_16", (Object)name2));
            }
            return false;
        }
        if (DbTools.isSpecialField(name2) != -1) {
            if (error != null) {
                error.append(JResource.getMessage("CAT_111", (Object)name2));
            }
            return false;
        }
        return true;
    }

    public boolean IsFileQueryNameOK(String name2, StringBuffer error) {
        if (!this.IsNameValid(name2, error)) {
            return false;
        }
        Vector cs = this.getConnections();
        for (JetUConnection con : cs) {
            if (con.isNameExist(name2) || this.IsQueryNameExist(name2)) {
                if (error != null) {
                    error.append(JResource.getMessage("CAT_90", (Object)name2));
                }
                return false;
            }
            if (DbTools.isSpecialField(name2) == -1) continue;
            if (error != null) {
                error.append(JResource.getMessage("CAT_111", (Object)name2));
            }
            return false;
        }
        return true;
    }

    public boolean IsQueryNameOK(String name2, StringBuffer error) {
        if (!this.IsNameValid(name2, error)) {
            return false;
        }
        if (this.isQueriableExist(name2)) {
            if (error != null) {
                error.append(JResource.getMessage("CAT_88", (Object)name2));
            }
            return false;
        }
        if (DbTools.isSpecialField(name2) != -1) {
            if (error != null) {
                error.append(JResource.getMessage("CAT_111", (Object)name2));
            }
            return false;
        }
        return true;
    }

    public boolean IsMappingNameOK(String name2, StringBuffer error) {
        if (!this.IsNameValid(name2, error)) {
            return false;
        }
        if (this.IsMappingNameExist(name2)) {
            if (error != null) {
                error.append(JResource.getMessage("CAT_16", (Object)name2));
            }
            return false;
        }
        if (DbTools.isSpecialField(name2) != -1) {
            if (error != null) {
                error.append(JResource.getMessage("CAT_111", (Object)name2));
            }
            return false;
        }
        return this.getUniverse().IsNonParaMappingNameOK(name2, error);
    }

    public boolean IsWherePortionNameOK(String name2, StringBuffer error) {
        if (!this.IsNameValid(name2, error)) {
            return false;
        }
        if (this.IsWherePortionNameExist(name2)) {
            if (error != null) {
                error.append(JResource.getMessage("CAT_DB_NAMECHECK_WHEREPORTION", (Object)name2));
            }
            return false;
        }
        if (DbTools.isSpecialField(name2) != -1) {
            if (error != null) {
                error.append(JResource.getMessage("CAT_111", (Object)name2));
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isUDSNameOK(String strUDSName) {
        return this.IsDataSourceNameOK(strUDSName, new StringBuffer());
    }

    @Override
    public boolean isColumnMappingNameOK(String strMappingName) {
        return this.IsMappingNameOK(strMappingName, new StringBuffer());
    }

    @Override
    public String hintUDSNameOK(String strUDSName) {
        StringBuffer strBuf = new StringBuffer();
        boolean bIsOK = this.IsDataSourceNameOK(strUDSName, strBuf);
        int i = 1;
        String strTemp = strUDSName;
        while (!bIsOK) {
            strTemp = strUDSName + String.valueOf(i++);
            bIsOK = this.IsDataSourceNameOK(strTemp, strBuf);
        }
        return strTemp;
    }

    @Override
    public String hintColumnMappingNameOK(String strMappingName) {
        StringBuffer strBuf = new StringBuffer();
        boolean bIsOK = this.IsMappingNameOK(strMappingName, strBuf);
        int i = 1;
        String strTemp = strMappingName;
        while (!bIsOK) {
            strTemp = strMappingName + String.valueOf(i++);
            bIsOK = this.IsMappingNameOK(strTemp, strBuf);
        }
        return strTemp;
    }

    @Override
    public String getOldColumnMappingNameByIndex(String strUDSName, int iIndex) {
        JetUUDSField field;
        JetUUserDataSource jUDS = this.getDataSourceByResourceName(strUDSName);
        if (jUDS != null && (field = jUDS.getFieldByMappingIndex(iIndex)) != null) {
            return field.getResourceName();
        }
        return null;
    }

    @Override
    public String getOldColumnMappingNameByPath(String strUDSName, String strPath) {
        JetUUDSField field;
        JetUUserDataSource jUDS = this.getDataSourceByResourceName(strUDSName);
        if (jUDS != null && (field = jUDS.getFieldByPathString(strPath)) != null) {
            return field.getResourceName();
        }
        return null;
    }

    public boolean isHaveTableViews() {
        boolean bResult = false;
        Vector totalTables = new Vector();
        Vector connections = this.getConnections();
        int iSize = connections.size();
        for (int i = 0; i < iSize; ++i) {
            JetUConnection connection = (JetUConnection)connections.elementAt(i);
            Vector tables = connection.getTableViews();
            if (tables.isEmpty()) continue;
            bResult = true;
            break;
        }
        return bResult;
    }

    public boolean isHaveQuery() {
        Vector queries = this.getQueries();
        return !queries.isEmpty();
    }

    @Override
    public void afterInit() {
        super.afterInit();
    }

    public Vector getQueriables() {
        Vector<JetUQueriable> ret = new Vector<JetUQueriable>();
        for (JetUQueriable queriable : this.mapTable4Queriable.values()) {
            if (!(queriable instanceof JetUQueriable) || queriable instanceof JetUParamBuildInUQuery || queriable instanceof JetUParamBuildInFileQuery) continue;
            ret.add(queriable);
        }
        return ret;
    }

    public JetUQueriable getQueriableByResourceName(String strQueryName) {
        if (strQueryName == null) {
            return null;
        }
        if (strQueryName.startsWith("\u007fUBV~")) {
            UnifiedBusinessView bv = this.mapTable4ubv.get(strQueryName.substring("\u007fUBV~".length()).toUpperCase());
            if (bv == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Can't find BV, BV self contain Query: " + strQueryName);
                }
                return null;
            }
            return bv.getQuery();
        }
        return this.mapTable4Queriable.get(strQueryName.toUpperCase());
    }

    public boolean isQueriableExist(String strQueryName) {
        return this.getQueriableByResourceName(strQueryName) != null;
    }

    public JetUResourceEntity getResourceByName(String name2) {
        if (UniverseToolkit.isBuildinParameterName(name2)) {
            return JetUParameter.buildinParameter;
        }
        return this.mapTable.getResourceByName(name2.toUpperCase());
    }

    public JetUResourceEntity getResourceByName(String strQueryName, String name2) {
        JetUQueriable query;
        if (UniverseToolkit.isBuildinParameterName(name2)) {
            return JetUParameter.buildinParameter;
        }
        if (name2 == null) {
            return null;
        }
        JetUResourceEntity re = null;
        if (strQueryName != null && (query = this.getQueriableByResourceName(strQueryName)) != null && query instanceof JetUQuery) {
            re = ((JetUQuery)query).getResourceByName(name2);
        }
        if (re == null) {
            re = this.mapTable.getResourceByName(name2.toUpperCase());
        }
        return re;
    }

    public Vector getAvailableResourceEntitys(String strQueryName) {
        JetUUniverse unvs = this.getUniverse();
        JetUQueriable uQueriable = this.getQueriableByResourceName(strQueryName);
        Vector vecRet = new Vector();
        if (uQueriable != null) {
            Vector qryFields = uQueriable.getFields();
            int iFieldCount = qryFields.size();
            for (int i = 0; i < iFieldCount; ++i) {
                vecRet.addElement(qryFields.elementAt(i));
            }
            Enumeration enums = this.mapTable.elements();
            while (enums.hasMoreElements()) {
                JetUResourceEntity re = (JetUResourceEntity)enums.nextElement();
                if (re instanceof JetUFormula && ((JetUFormula)re).getResourceName().equals(FORMULAHEADNAME)) continue;
                try {
                    if (!uQueriable.isFieldValidToQuery(unvs, re, this.getResourceName()) || vecRet.contains(re)) continue;
                    vecRet.addElement(re);
                }
                catch (FormulaHasGrammarError e) {
                }
                catch (CannotFindFrmlRefFld e) {
                }
                catch (CannotFindEntity e) {}
            }
        }
        return vecRet;
    }

    public Vector getGroupByFormula(String strGroupName) {
        return this.getGroupByFormula(strGroupName, null);
    }

    public Vector getGroupByFormula(String strGroupName, String strQueryName) {
        Vector<JetUFormula> vecRet = new Vector<JetUFormula>();
        JetUQueriable query = this.getQueriableByResourceName(strQueryName);
        Vector formulas = this.getFormulasAndSummaries();
        int iSize = formulas.size();
        try {
            for (int i = 0; i < iSize; ++i) {
                JetUFormula uformula = (JetUFormula)formulas.elementAt(i);
                if (!uformula.isGroupBy(strGroupName) || strQueryName != null && !query.isFieldValidToQuery(this.getUniverse(), uformula.getResourceName(), this.getResourceName())) continue;
                vecRet.addElement(uformula);
            }
        }
        catch (FormulaHasGrammarError e) {
        }
        catch (CannotFindFrmlRefFld e) {
        }
        catch (CannotFindEntity e) {
        }
        return vecRet;
    }

    public boolean checkIfMappingFldsValidToQuery(String strQueryName, Vector colsName) throws InvalidEntityException, CannotFindQuery {
        return this.checkIfMappingFldsValidToQuery(strQueryName, colsName, new Hashtable());
    }

    public boolean checkIfMappingFldsValidToQuery(String strQueryName, Vector colsName, Hashtable otherName) throws InvalidEntityException, CannotFindQuery {
        JetUQueriable uQuery = this.getQueriableByResourceName(strQueryName);
        if (uQuery == null) {
            throw new CannotFindQuery(strQueryName);
        }
        InvalidEntityException exception = null;
        HashMap<String, String> refFldOfFml = new HashMap<String, String>();
        Enumeration e = colsName.elements();
        while (e.hasMoreElements()) {
            Hashtable expRefFld;
            String mappingName = (String)e.nextElement();
            String dsName = (String)otherName.get(mappingName);
            String string = dsName = dsName == null ? this.getResourceName() : dsName;
            if (refFldOfFml.containsKey(mappingName) || exception != null && (expRefFld = exception.getInvalidEntities()).containsKey(mappingName)) continue;
            String errMsg = mappingName + ",[" + "database:" + dsName + ",QueryName:" + strQueryName + "]";
            try {
                if (uQuery.isFieldValidToQuery(this.getUniverse(), mappingName, dsName, refFldOfFml)) continue;
                if (exception == null) {
                    exception = new InvalidEntityException();
                }
                exception.addInvalidEntity(errMsg, (short)3);
            }
            catch (CannotFindEntity err) {
                if (exception == null) {
                    exception = new InvalidEntityException();
                }
                exception.addInvalidEntity(errMsg, (short)1);
            }
            catch (FormulaHasGrammarError formulaError) {
                if (exception == null) {
                    exception = new InvalidEntityException();
                }
                exception.addInvalidEntity(errMsg, (short)2);
            }
            catch (CannotFindFrmlRefFld frmlRefError) {
                if (exception == null) {
                    exception = new InvalidEntityException();
                }
                exception.addInvalidEntity(errMsg, (short)2);
            }
        }
        if (exception != null) {
            throw exception;
        }
        return true;
    }

    public DbColDesc getSQLType(String strQueryName, String colName) {
        JetUResourceEntity entity = this.getResourceByName(strQueryName, colName);
        if (entity != null) {
            return entity.getColDesc();
        }
        return null;
    }

    @Override
    public SymbolInfo getParameterType(String paramname) {
        return this.getParameterByResourceName(paramname).getInfo();
    }

    @Override
    public VarsTable getGVarTable() {
        return this.gVarTable;
    }

    @Override
    public ParserOption getParserOption() {
        this.parserOption.setSupportGlobal(true);
        return this.parserOption;
    }

    public DbColDesc getSQLType(String colName) {
        return this.getSQLType(null, colName);
    }

    @Override
    public DbColDesc getDbSQLType(String dbf) {
        JetUResourceEntity jure = this.getResourceByName(dbf);
        if (jure != null && jure instanceof JetUDBField) {
            DbColDesc dbcd = jure.getColDesc();
            dbcd.setColName(jure.getResourceName());
            return dbcd;
        }
        return null;
    }

    public void FormulaModified() {
        this.bFormulaModified = true;
        this.bNeedGenerateJava = true;
    }

    public void setFormulaModified(boolean bFormulaModified) {
        this.bFormulaModified = bFormulaModified;
    }

    public boolean isFormulaModified() {
        return this.bFormulaModified;
    }

    public void setNeedGenerateJava(boolean bNeedGenerateJava) {
        this.bNeedGenerateJava = bNeedGenerateJava;
    }

    public boolean isNeedGenerateJava() {
        return this.bNeedGenerateJava;
    }

    public String getCurFormulasFullClassName() {
        return this.javaFrmulaName.get();
    }

    private void beforeParseFormulas() {
        if (this.gVarTable == null) {
            this.gVarTable = new VarsTable();
        }
        this.gVarTable.clear();
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            JetUWhereFormula wf;
            child = (JetObject)this.children.elementAt(i);
            if (child instanceof JetUFormula) {
                ((JetUFormula)child).createRptFormula();
                continue;
            }
            if (child instanceof JetUQuery) {
                wf = ((JetUQuery)child).getWhereFormula();
                if (wf == null) continue;
                wf.createRptFormula();
                continue;
            }
            if (child instanceof UnifiedBusinessView) {
                wf = ((UnifiedBusinessView)child).getQuery().getWhereFormula();
                if (wf == null) continue;
                wf.createRptFormula();
                continue;
            }
            if (!(child instanceof JetUHierDataSource)) continue;
            Vector whereformulas = ((JetUHierDataSource)child).getWhereFormulas();
            int iSizeWhere = whereformulas == null ? 0 : whereformulas.size();
            for (int j = 0; j < iSizeWhere; ++j) {
                JetUWhereFormula wf1 = (JetUWhereFormula)whereformulas.elementAt(j);
                wf1.createRptFormula();
            }
        }
    }

    private void afterParseFormulas() {
        int iSize = this.children.size();
        JetObject child = null;
        boolean j = false;
        for (int i = 0; i < iSize; ++i) {
            JetUWhereFormula wf;
            child = (JetObject)this.children.elementAt(i);
            if (child instanceof JetUFormula) {
                ((JetUFormula)child).HandleRptFormula();
                continue;
            }
            if (child instanceof JetUQuery) {
                wf = ((JetUQuery)child).getWhereFormula();
                if (wf == null) continue;
                wf.HandleRptFormula();
                continue;
            }
            if (child instanceof UnifiedBusinessView) {
                wf = ((UnifiedBusinessView)child).getQuery().getWhereFormula();
                if (wf == null) continue;
                wf.HandleRptFormula();
                continue;
            }
            if (!(child instanceof JetUHierDataSource)) continue;
            Vector whereformulas = ((JetUHierDataSource)child).getWhereFormulas();
            int iSizeWhere = whereformulas == null ? 0 : whereformulas.size();
            for (int k = 0; k < iSizeWhere; ++k) {
                JetUWhereFormula wf1 = (JetUWhereFormula)whereformulas.elementAt(k);
                wf1.HandleRptFormula();
            }
        }
    }

    public Vector getRptFormulas() {
        return this.getRptFormulas(false);
    }

    public Vector getRptFormulas(boolean onlyFml) {
        Vector<JetRptFormula> formulas = new Vector<JetRptFormula>();
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            JetUWhereFormula wf;
            child = (JetObject)this.children.elementAt(i);
            if (child instanceof JetUFormula) {
                formulas.addElement(((JetUFormula)child).getRptFormula());
                continue;
            }
            if (child instanceof JetUQuery && !onlyFml) {
                wf = ((JetUQuery)child).getWhereFormula();
                if (wf == null) continue;
                formulas.addElement(wf.getRptFormula());
                continue;
            }
            if (child instanceof UnifiedBusinessView && !onlyFml) {
                wf = ((UnifiedBusinessView)child).getQuery().getWhereFormula();
                if (wf == null) continue;
                formulas.addElement(wf.getRptFormula());
                continue;
            }
            if (!(child instanceof JetUHierDataSource) || onlyFml) continue;
            Vector whereformulas = ((JetUHierDataSource)child).getWhereFormulas();
            int iSizeWhere = whereformulas == null ? 0 : whereformulas.size();
            for (int j = 0; j < iSizeWhere; ++j) {
                JetUWhereFormula wf1 = (JetUWhereFormula)whereformulas.elementAt(j);
                formulas.addElement(wf1.getRptFormula());
            }
        }
        return formulas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File generateFormulaCodes(boolean bReparse, boolean bBaseFormulaName) throws GenerateFormulasCodeException {
        String className = null;
        String fileName = null;
        String classFileName = null;
        String dir = this.strDir;
        if (!this.strDir.endsWith(File.separator)) {
            dir = this.strDir + File.separator;
        }
        className = strFormulasClassNameBase + UUID.randomUUID().toString().replace("-", "").toUpperCase();
        fileName = dir + className + strJavaFileExtension;
        logger.debug("GenerateFormula, Formula file name =[" + fileName + "].");
        try {
            classFileName = this._parseFormulas(bReparse, true, className, false);
            return classFileName;
        }
        catch (ParseFormulaFailedException e) {}
        finally {
            if (this.bNeedGenerateJava) {
                File fileOldJava = new File(fileName);
                if (fileOldJava.exists()) {
                    fileOldJava.delete();
                }
                this.bNeedGenerateJava = false;
            }
            this.javaFrmulaName.set(strFormulaPackage + className);
            if (classFileName != null) {
                File file = new File(classFileName);
                if (!file.exists()) {
                    throw new GenerateFormulasCodeException("When GenerateFormulaFile, java class file [" + classFileName + "] does not exist.");
                }
                return file;
            }
            return null;
        }
    }

    @Override
    public void parseFormulas(boolean bReparse) throws ParseFormulaFailedException {
        this._parseFormulas(bReparse, false, "", false);
    }

    public void parseFormulas(boolean bReparse, boolean onlyFml) throws ParseFormulaFailedException {
        this._parseFormulas(bReparse, false, "", onlyFml);
    }

    public void _parseFormulas(boolean bReparse, PrintStream writer, String className) throws ParseFormulaFailedException {
        this._parseFormulas(bReparse, writer != null, className, false);
    }

    public Vector getUDFNames() {
        return this.udfNames;
    }

    @Override
    public void translateComplete(Vector arg0) {
        for (int i = 0; i < arg0.size(); ++i) {
            logger.error(arg0.elementAt(i));
        }
    }

    private synchronized String _parseFormulas(boolean bReparse, boolean isGenerate, String className, boolean onlyFml) throws ParseFormulaFailedException {
        this.beforeParseFormulas();
        Vector formulas = this.getRptFormulas(onlyFml);
        ParseFormulaFailedException pffe = null;
        String classFile = null;
        FormulaCompiler fc = new FormulaCompiler(this, new JavaFormulaConfigImpl(this.getUniverse().getResourceStore()));
        if (isGenerate) {
            try {
                classFile = fc.compileFormulas(formulas, className, this);
            }
            catch (GenerateFormulasCodeException e) {
                Vector<GenerateFormulasCodeException> v = new Vector<GenerateFormulasCodeException>();
                v.add(e);
                pffe = new ParseFormulaFailedException(v);
            }
        } else {
            try {
                this.bNeedGenerateJava = true;
                fc.checkFormulas(formulas);
            }
            catch (ParseFormulaFailedException pe) {
                pffe = pe;
            }
        }
        this.afterParseFormulas();
        if (pffe != null) {
            throw pffe;
        }
        return classFile;
    }

    public Vector getAllFomulasValidToQuery(String strQueryName) {
        Vector formulas;
        int size;
        JetUQueriable uQuery = this.getQueriableByResourceName(strQueryName);
        if (uQuery != null && (size = (formulas = this.getFormulas()).size()) > 0) {
            Vector<JetUFormula> ret = new Vector<JetUFormula>(size);
            for (int i = 0; i < size; ++i) {
                JetUFormula uFormula = (JetUFormula)formulas.elementAt(i);
                try {
                    if (!uQuery.isFieldValidToQuery(this.getUniverse(), uFormula, this.getResourceName())) continue;
                    ret.addElement(uFormula);
                    continue;
                }
                catch (FormulaHasGrammarError e1) {
                    logger.debug(e1);
                    continue;
                }
                catch (CannotFindFrmlRefFld e2) {
                    logger.debug(e2);
                    continue;
                }
                catch (CannotFindEntity e3) {
                    logger.debug(e3);
                }
            }
            return ret;
        }
        return null;
    }

    @Override
    public JetRptFormula getFormula(String name2) {
        JetUFormula uformula = this.getFormulaByResourceName(name2);
        if (uformula != null) {
            return uformula.getRptFormula();
        }
        return null;
    }

    public void clearMem() {
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            try {
                if (!(child instanceof JetUParameter) && child instanceof JetUJDBCConnection) {
                    Vector children2 = ((JetUJDBCConnection)child).getChildren();
                    int iSize2 = children2.size();
                    JetObject child2 = null;
                    for (int i2 = 0; i2 < iSize2; ++i2) {
                        child2 = (JetObject)children2.elementAt(i2);
                        if (!(child2 instanceof JetUTableView)) continue;
                    }
                }
                child.delete();
                continue;
            }
            catch (Exception pe) {
                logger.debug(pe);
            }
        }
        if (this.mapTable != null) {
            this.mapTable.clearMem();
        }
    }

    public void parseSummary(JetUSummary summary) throws ParseFormulaFailedException {
        JetRptFormula jetformula = summary.createRptFormula();
        FormulatoJava f2j = new FormulatoJava("", null);
        try {
            jetformula.parseFormula(f2j);
        }
        catch (FormulaSyntaxErrorException synerror) {
            Vector<FormulaSyntaxErrorException> failedFormulas = new Vector<FormulaSyntaxErrorException>();
            failedFormulas.addElement(synerror);
            throw new ParseFormulaFailedException(failedFormulas);
        }
        summary.HandleRptFormula();
    }

    public void objectChanged(JetUTreeNode object, int type) {
        JetUUniverse unvs = this.getUniverse();
        JetUUniverse.objectChanged(unvs, object, type);
    }

    public void removeExceptConn() {
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)children.elementAt(i);
            if (child instanceof JetUJDBCConnection || child instanceof JetUConnection) continue;
            this.remove(child);
        }
    }

    @Override
    public String getInstancePrefix() {
        return "Database";
    }

    public JetUAcl getAclByResourceName(String strName) {
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUAcl) || !((JetUAcl)child).getResourceName().equalsIgnoreCase(strName)) continue;
            return (JetUAcl)child;
        }
        return null;
    }

    public boolean addAcl(JetUAcl acl) {
        if (!this.IsAclNameExist(acl.getResourceName())) {
            this.add(acl);
            return true;
        }
        return false;
    }

    public boolean IsAclNameExist(String strAclName) {
        return this.getAclByResourceName(strAclName) != null;
    }

    public boolean IsAclNameOK(String name2, StringBuffer error) {
        if (!this.IsNameValid(name2, error)) {
            return false;
        }
        if (this.IsAclNameExist(name2)) {
            if (error != null) {
                error.append(JResource.getMessage("CAT_88", (Object)name2));
            }
            return false;
        }
        if (DbTools.isSpecialField(name2) != -1) {
            if (error != null) {
                error.append(JResource.getMessage("CAT_111", (Object)name2));
            }
            return false;
        }
        return true;
    }

    public Vector getAcls() {
        Vector<JetUAcl> AclVec = new Vector<JetUAcl>();
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUAcl)) continue;
            AclVec.addElement((JetUAcl)child);
        }
        return AclVec;
    }

    public boolean removeAcl(String strAclName) {
        JetUAcl acl = this.getAclByResourceName(strAclName);
        if (acl != null) {
            return this.removeAcl(acl);
        }
        return false;
    }

    public boolean removeAcl(JetUAcl acl) {
        this.remove(acl);
        return true;
    }

    public String defaultAclName() {
        int iNameCount = 1;
        StringBuffer error = new StringBuffer("");
        String strName = null;
        String strDefaultName = JResource.getMessage("SecurityEntryTag");
        while (!this.IsAclNameOK(strName = strDefaultName + iNameCount++, error)) {
        }
        return strName;
    }

    public JetUDBTreeNode getNodeByName(String strRscName, Class cls) {
        boolean isContainer;
        block6: {
            isContainer = false;
            try {
                isContainer = Class.forName("jet.universe.JetUResourceContainer").isAssignableFrom(cls);
            }
            catch (ClassNotFoundException e) {
                if (!logger.isErrorEnabled()) break block6;
                logger.error("", e);
            }
        }
        JetUDBTreeNode node = null;
        if (isContainer) {
            Vector children = this.getChildren();
            node = JetUDatabase.findNodeByName(children, strRscName, cls.getName());
            if (node == null) {
                Vector cons = this.getConnections();
                for (JetUConnection con : cons) {
                    node = (JetUResourceContainer)JetUDatabase.findNodeByName(con.children, strRscName, cls.getName());
                    if (node == null) continue;
                    return node;
                }
            }
        } else {
            node = this.getResourceByName(strRscName);
        }
        return node;
    }

    public JetUResourceContainer getContainerNodeByName(String strRscName, Class cls) {
        JetUResourceContainer node;
        block4: {
            boolean isContainer = false;
            node = null;
            try {
                Vector children;
                isContainer = Class.forName("jet.universe.JetUResourceContainer").isAssignableFrom(cls);
                if (isContainer && (node = (JetUResourceContainer)JetUDatabase.findNodeByName(children = this.getChildren(), strRscName, cls.getName())) == null) {
                    Vector cons = this.getConnections();
                    for (JetUConnection con : cons) {
                        node = (JetUResourceContainer)JetUDatabase.findNodeByName(con.children, strRscName, cls.getName());
                        if (node == null) continue;
                        return node;
                    }
                }
            }
            catch (ClassNotFoundException e) {
                if (!logger.isErrorEnabled()) break block4;
                logger.error("", e);
            }
        }
        return node;
    }

    @Override
    public Vector getChildren(String className) {
        Vector ret = super.getChildren(className);
        if (ret.size() == 0 && this.getConnection() != null) {
            ret = this.getConnection().getChildren(className);
        }
        return ret;
    }

    @Override
    public Vector getExtChildren(String className) {
        Vector ret = super.getExtChildren(className);
        if (ret.size() == 0 && this.getConnection() != null) {
            ret = this.getConnection().getExtChildren(className);
        }
        return ret;
    }

    public Vector getChildren(String connectionName, String className) {
        Vector ret = super.getChildren(className);
        if (ret.size() == 0 && this.getConnectionByResourceName(connectionName) != null) {
            ret = this.getConnectionByResourceName(connectionName).getChildren(className);
        }
        return ret;
    }

    public Vector getExtChildren(String connectionName, String className) {
        Vector ret = super.getExtChildren(className);
        if (ret.size() == 0 && this.getConnectionByResourceName(connectionName) != null) {
            ret = this.getConnectionByResourceName(connectionName).getExtChildren(className);
        }
        return ret;
    }

    public void setDefaultDB(boolean defaultDB) {
        this.isDefaultDB.set(defaultDB);
    }

    public boolean IsDefaultDB() {
        return this.isDefaultDB.get();
    }

    public boolean rename(String newName) {
        JetUUniverse univ = this.getUniverse();
        boolean flag = univ.IsDataSourceNameExist(newName);
        if (!flag) {
            Vector<UnifiedBusinessView> bvs;
            Hashtable<String, JetUPrejoins> ht;
            JetUPrejoins joins;
            if (univ.editor != null && (joins = (ht = univ.editor.joins).get(this.getResourceName())) != null) {
                ht.put(newName, joins);
                ht.remove(this.getResourceName());
            }
            this.setResourceName(newName);
            Vector queries = this.getQueries();
            if (queries != null) {
                for (int i = 0; i < queries.size(); ++i) {
                    JetUQuery uQuery = (JetUQuery)queries.get(i);
                    uQuery.getPsqlQuery().setUniverse(this.getUniverse(), newName);
                }
            }
            if ((bvs = this.getBvs()) != null) {
                for (int i = 0; i < bvs.size(); ++i) {
                    UnifiedBusinessView bv = bvs.get(i);
                    bv.getQuery().getPsqlQuery().setUniverse(this.getUniverse(), newName);
                }
            }
            Vector buildInQueries = this.getParamBuildInUQuery();
            for (int i = 0; i < buildInQueries.size(); ++i) {
                JetUParamBuildInUQuery uParamBuildInQuery = (JetUParamBuildInUQuery)buildInQueries.get(i);
                RptPsqlQuery tempPsqlQuery = uParamBuildInQuery.getPsqlQuery();
                if (tempPsqlQuery == null) continue;
                tempPsqlQuery.setUniverse(this.getUniverse(), newName);
            }
        }
        return !flag;
    }

    private Vector getParamBuildInUQuery() {
        Vector<JetUQuery> buildInQueries = new Vector<JetUQuery>();
        Vector children = this.getChildren();
        JetObject child = null;
        int iSize = children.size();
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)children.elementAt(i);
            if (!(child instanceof JetUParamBuildInUQuery)) continue;
            buildInQueries.addElement((JetUQuery)child);
        }
        return buildInQueries;
    }

    public static Vector filterHiddenFormula(Vector allFormulas) {
        if (allFormulas == null) {
            return null;
        }
        Vector ret = new Vector();
        for (int i = 0; i < allFormulas.size(); ++i) {
            Object o = allFormulas.elementAt(i);
            if (o instanceof String) {
                if (((String)o).equalsIgnoreCase(FORMULAHEADNAME)) continue;
                ret.add(o);
                continue;
            }
            if (o instanceof JetUFormula) {
                if (((JetUFormula)o).getResourceName().equalsIgnoreCase(FORMULAHEADNAME)) continue;
                ret.add(o);
                continue;
            }
            ret.add(o);
        }
        return ret;
    }

    public JetUQueriable getBindQueryWithParamName(String paramName) {
        JetUQueriable queriable = null;
        if (paramName != null) {
            JetUParamBuildInUQuery buildInUQuery;
            JetUParameter parameter = this.getParameterByResourceName(paramName);
            if (parameter == null) {
                Vector params = this.getParameters();
                for (int i = 0; i < params.size(); ++i) {
                    parameter = (JetUParameter)params.get(i);
                    if (parameter.chainID.get().equals(paramName)) break;
                    parameter = null;
                }
            }
            if (parameter != null && parameter.isCascading.get() && (queriable = this.getQueriableByResourceName(parameter.getCascadParamBindQueryName())) == null && (buildInUQuery = parameter.createCascadParamRefedQuery(parameter)) != null) {
                this.addQuery(buildInUQuery);
                return buildInUQuery;
            }
        }
        return queriable;
    }

    public JetObject deepDupWithoutCopyProperties(Hashtable<JetObject, JetObject> oldToNew, Hashtable<JetObject, JetObject> newToOld, boolean setTmpl, boolean withName) {
        JetUDatabase copyDB = (JetUDatabase)super.deepDupWithoutCopyProperties(oldToNew, newToOld, setTmpl, withName);
        JetUDatabase.copyProperties(this, oldToNew, newToOld, withName);
        copyDB.strDir = this.strDir;
        copyDB.BuildMapTable();
        return copyDB;
    }

    @Override
    public JetObject dup() {
        JetUDatabase copyDB = (JetUDatabase)super.dup();
        JetUDatabase.copyProperties(copyDB, this);
        copyDB.strDir = this.strDir;
        copyDB.BuildMapTable();
        return copyDB;
    }

    @Override
    public SymbolInfo getMeasure(String measureName) {
        return null;
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public Hashtable<String, Symbol> getGlobalVarContainer() {
        return this.globalVarContainer;
    }

    public boolean isQueryHasBigDataSource(String queryName) {
        JetUConnection[] conns;
        JetUQueriable query = this.getQueriableByResourceName(queryName);
        if (query == null) {
            return false;
        }
        for (JetUConnection jetUConnection : conns = query.getConnections()) {
            if (!jetUConnection.isBigDataSource()) continue;
            return true;
        }
        return false;
    }

    public int getDisplayRoundingMode() {
        return this.displayRoundingMode.get();
    }

    public void setDisplayRoundingMode(int displayRoundingMode) {
        this.displayRoundingMode.set(displayRoundingMode);
    }

    public boolean isPreJoin() {
        return this.preJoin.get();
    }

    public void setPrejoin(boolean bPrejoin) {
        this.preJoin.set(bPrejoin);
    }

    public boolean addProcedure(JetUProcedure uProcedure) {
        if (this.IsQueryNameOK(uProcedure.getResourceName(), null)) {
            this.add(uProcedure);
            uProcedure.InitAfterCreate();
            return true;
        }
        return false;
    }

    public JetUProcedure getProcedureByResourceName(String strRscName) {
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject child = null;
        JetUProcedure uProcedure = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)children.elementAt(i);
            if (!(child instanceof JetUProcedure) || !(uProcedure = (JetUProcedure)child).getResourceName().equalsIgnoreCase(strRscName)) continue;
            return uProcedure;
        }
        return null;
    }

    public boolean removeProcedure(String strRscName) {
        JetUProcedure uProcedure = this.getProcedureByResourceName(strRscName);
        if (uProcedure != null) {
            this.getDatabase().mapTable4Queriable.remove(uProcedure.getResourceName().toUpperCase());
            return this.removeProcedure(uProcedure);
        }
        return false;
    }

    public boolean removeProcedure(JetUProcedure uProcedure) {
        this.mapTable4Queriable.remove(uProcedure.getResourceName().toUpperCase());
        this.remove(uProcedure);
        return true;
    }

    public Vector getProcedures() {
        Vector<JetObject> vecProcedures = new Vector<JetObject>();
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUProcedure)) continue;
            vecProcedures.addElement(child);
        }
        return vecProcedures;
    }

    public boolean addFileQuery(JetUFileQuery uFileQuery) {
        if (this.IsQueryNameOK(uFileQuery.getResourceName(), null)) {
            this.add(uFileQuery);
            uFileQuery.InitAfterCreate();
            return true;
        }
        return false;
    }

    public boolean addFileQueryAfterInit(JetUFileQuery uFileQuery) {
        if (this.IsQueryNameOK(uFileQuery.getResourceName(), null)) {
            this.add(uFileQuery);
            uFileQuery.initAfterAdd();
            return true;
        }
        return false;
    }

    public boolean removeFileQuery(String strRscName) {
        JetUFileQuery uFileQuery = this.GetFileQueryByResourceName(strRscName);
        if (uFileQuery != null) {
            return this.removeFileQuery(uFileQuery);
        }
        return false;
    }

    public boolean removeFileQuery(JetUFileQuery uFileQuery) {
        this.remove(uFileQuery);
        this.mapTable4Queriable.remove(uFileQuery.getResourceName().toUpperCase());
        return true;
    }

    public Vector getFileQueries() {
        Vector<JetObject> uFileQueries = new Vector<JetObject>();
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUFileQuery) || child instanceof JetUParamBuildInFileQuery) continue;
            uFileQueries.addElement(child);
        }
        return uFileQueries;
    }

    public JetUFileQuery GetFileQueryByResourceName(String strRscName) {
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject child = null;
        JetUFileQuery uFileQuery = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)children.elementAt(i);
            if (!(child instanceof JetUFileQuery) || !(uFileQuery = (JetUFileQuery)child).getResourceName().equalsIgnoreCase(strRscName)) continue;
            return uFileQuery;
        }
        return null;
    }

    public UnifiedBusinessView getBusinessView(String bvName) {
        if (bvName == null) {
            return null;
        }
        return this.mapTable4ubv.get(bvName.toUpperCase());
    }

    public void renameBusinessView(String newName, UnifiedBusinessView ubv) {
        this.getDatabase().mapTable4ubv.remove(ubv.getDisplayName().toUpperCase());
        this.getDatabase().mapTable4ubv.put(newName.toUpperCase(), ubv);
    }

    public UnifiedBusinessView createBusinessView(String ubvQdName) throws BLDupleNameException, BLIlegalNameException {
        if (this.getBusinessView(ubvQdName) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("catalog " + this.getUniverse().hashCode() + " add UnifiedBusinessView  :" + ubvQdName);
            }
            UnifiedBusinessView ubv = new UnifiedBusinessView(ubvQdName, this.getUniverse(), this.getResourceName());
            this.add(ubv);
            ubv.setParent(this);
            return ubv;
        }
        return null;
    }

    static {
        nameIdx.put("JavaFormulaName", new Integer(0));
        nameIdx.put("Description", new Integer(1));
        nameIdx.put("Name", new Integer(2));
    }
}

