/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.Vector;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.JetUJoinPath;
import jet.universe.JetUQueriable;
import jet.universe.JetUQuery;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.impl.UnifiedBusinessView;
import jet.universe.psql.RptPsqlQuery;
import toolkit.db.PsqlJoin;
import toolkit.db.PsqlTable;

public class JetUDemandQuery
extends JetUQuery {
    public JetUDemandQuery() {
    }

    public JetUDemandQuery(String strName, String strDesc) {
        super(strName, strDesc);
    }

    public JetUDemandQuery(String strName, RptPsqlQuery psqlQuery) {
        super(strName, psqlQuery);
    }

    public boolean addJoin(PsqlJoin pJoin) {
        if (pJoin.name == null || pJoin.name.equals("")) {
            return false;
        }
        Vector existJoins = this.getPsqlQuery().vPsqlJoin;
        for (PsqlJoin join : existJoins) {
            if (!pJoin.name.equals(join.name)) continue;
            return false;
        }
        existJoins.addElement(pJoin);
        return true;
    }

    public PsqlJoin getJoin(String joinName) {
        Vector joins = this.getPsqlQuery().vPsqlJoin;
        for (PsqlJoin join : joins) {
            if (!join.name.equals(joinName)) continue;
            return join;
        }
        return null;
    }

    public Vector getJoins() {
        Vector joins = this.getPsqlQuery().vPsqlJoin;
        return joins;
    }

    public void removeJoin(String joinName) {
        PsqlJoin join = this.getJoin(joinName);
        if (join == null) {
            return;
        }
        this.getPsqlQuery().vPsqlJoin.remove(join);
        Vector paths = this.getJoinPathes();
        for (JetUJoinPath element : paths) {
            element.removeJoin(joinName);
        }
    }

    public void changeJoinName(String oldJoinName, String newJoinName) {
        PsqlJoin join = this.getJoin(oldJoinName);
        if (join == null) {
            return;
        }
        join.name = newJoinName;
        Vector paths = this.getJoinPathes();
        for (JetUJoinPath joinPath : paths) {
            joinPath.hasJoin(oldJoinName);
            joinPath.removeJoin(oldJoinName);
            joinPath.addJoin(newJoinName);
        }
    }

    public boolean addJoinPath(JetUJoinPath path) {
        Vector paths = this.getJoinPathes();
        for (JetUJoinPath element : paths) {
            if (!element.getName().equals(path.getName())) continue;
            return false;
        }
        this.add(path);
        return true;
    }

    public JetUJoinPath getJoinPath(String pathName) {
        Vector paths = this.getJoinPathes();
        JetUJoinPath ret = null;
        for (JetUJoinPath element : paths) {
            if (!element.getName().equals(pathName)) continue;
            ret = element;
        }
        return ret;
    }

    public void removeJoinPath(String pathName) {
        JetUJoinPath path = this.getJoinPath(pathName);
        if (path != null) {
            this.remove(path);
        }
    }

    public Vector getJoinPathes() {
        Vector children = this.getChildren();
        Vector<JetObject> ret = new Vector<JetObject>();
        for (JetObject element : children) {
            if (!(element instanceof JetUJoinPath)) continue;
            ret.add(element);
        }
        return ret;
    }

    public Vector getTables() {
        Vector ret = this.getPsqlQuery().vTables;
        return ret;
    }

    public Vector<JetUQueriable> getRefQueriables() {
        Vector<JetUQueriable> ret = new Vector<JetUQueriable>();
        JetUDatabase dataBase = this.getDatabase();
        Vector tables = this.getPsqlQuery().vTables;
        int size = tables.size();
        for (int i = 0; i < size; ++i) {
            String queryName;
            JetUQueriable qb;
            PsqlTable pTable = (PsqlTable)tables.get(i);
            if (!pTable.isQueriable() || (qb = dataBase.getQueriableByResourceName(queryName = pTable.mappingName)) == null) continue;
            ret.add(qb);
        }
        return ret;
    }

    @Override
    public JetUDBTreeNode copy() {
        JetUDatabase db = this.getDatabase();
        String strName = this.getResourceName();
        int i = 1;
        String strTmp = "Copy of " + strName;
        while (db.IsQueryNameExist(strTmp)) {
            strTmp = "Copy (" + String.valueOf(++i) + ") of " + strName;
        }
        RptPsqlQuery pq = this.getPsqlQuery().getCopy();
        JetUDemandQuery copyQuery = new JetUDemandQuery(strTmp, pq);
        JetObject.copyProperties(copyQuery, this);
        copyQuery.setResourceName(strTmp);
        copyQuery.removeBL();
        JBusinessLogic bl = this.getBL();
        copyQuery.add((JetObject)((Object)(bl == null ? null : bl.copy())));
        Vector joinPaths = this.getJoinPathes();
        for (JetUJoinPath path : joinPaths) {
            copyQuery.addJoinPath(path.getCopy());
        }
        return copyQuery;
    }

    @Override
    public String getInstancePrefix() {
        return "DemandQuery";
    }

    @Override
    public JetUDatabase getDatabase() {
        JetObject parent = (JetObject)((Object)this.getParent());
        if (parent instanceof JetUDatabase) {
            return (JetUDatabase)parent;
        }
        return (JetUDatabase)parent.getParent();
    }

    @Override
    public String getResourceName() {
        JetContainable p = this.getParent();
        if (p != null && p instanceof UnifiedBusinessView) {
            return "\u007fUBV~" + ((UnifiedBusinessView)p).getDisplayName();
        }
        return super.getResourceName();
    }

    public boolean isDistinct() {
        Vector<JetUQueriable> qs = this.getRefQueriables();
        if (this.getTables().size() == 1 && qs.size() == 1 && qs.get(0) instanceof JetUQuery) {
            return ((JetUQuery)qs.get(0)).getPsqlQuery().isDistinct();
        }
        return false;
    }
}

