/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.JetObjInspector.ObjectInfo;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.log.JRLogger;
import jet.universe.JetUDocNode;
import jet.universe.JetUReportDoc;
import jet.universe.JetUTree;
import jet.universe.JetUTreeNode;
import jet.universe.JetUUniverse;
import jet.universe.exception.DocException;
import jet.util.WildcardMatcher;

public class JetUDocFolder
extends JetUTree
implements JetUDocNode {
    public JetString name = new JetString(this, "Name");
    public JetString desc = new JetString(this, "Description");
    transient ObjectInfo objInfo = null;
    private static JRLogger logger = JRLogger.getLogger(JetUDocFolder.class.getName());
    private static final HashMap nameIdx = new HashMap(2);

    public JetUDocFolder() {
    }

    public JetUDocFolder(String strName, String strDesc) {
        this.setName(strName);
        this.setDesc(strDesc);
    }

    @Override
    public JetObject add(JetObject child, int pos) {
        super.add(child, pos);
        return child;
    }

    @Override
    public String getName() {
        return this.name.get();
    }

    @Override
    public void setName(String strName) {
        this.name.set(strName);
    }

    @Override
    public String getDesc() {
        return this.desc.get();
    }

    @Override
    public void setDesc(String strDesc) {
        this.desc.set(strDesc);
    }

    public JetUUniverse getUniverse() {
        for (JetUTreeNode parent = (JetUTreeNode)((Object)this.getParent()); parent != null; parent = (JetUTreeNode)((Object)parent.getParent())) {
            if (!(parent instanceof JetUUniverse)) continue;
            return (JetUUniverse)parent;
        }
        return null;
    }

    protected String getPath() {
        String retStr = "";
        JetUTree parentNode = null;
        parentNode = (JetUTree)this.getParent();
        if (parentNode instanceof JetUDocFolder) {
            retStr = ((JetUDocFolder)parentNode).getLocator();
        }
        return retStr;
    }

    @Override
    public String getLocator() {
        String strPath = this.getPath();
        if (strPath.equals("")) {
            return "/";
        }
        if (strPath.equals("/")) {
            return strPath + this.getName();
        }
        return strPath + "/" + this.getName();
    }

    public JetUDocFolder getRootFolder() {
        JetUDocFolder retNode = this;
        JetUTree treeNode = (JetUTree)this.getParent();
        while (treeNode instanceof JetUDocFolder) {
            retNode = (JetUDocFolder)treeNode;
            treeNode = (JetUTree)treeNode.getParent();
        }
        return retNode;
    }

    public JetUDocFolder addFolder(String strName, String strDesc) {
        JetUDocFolder folder = new JetUDocFolder(strName, strDesc);
        return this.addFolder(folder);
    }

    public JetUDocFolder addFolder(String strLocator) throws DocException {
        if (!strLocator.startsWith("/")) {
            throw new DocException(1, strLocator);
        }
        StringTokenizer tokLocator = new StringTokenizer(strLocator, "/");
        JetUDocFolder curNode = this.getRootFolder();
        String strNewFolder = "";
        Object newFolder = null;
        JetUDocNode tempNode = null;
        while (tokLocator.hasMoreTokens()) {
            strNewFolder = tokLocator.nextToken();
            tempNode = curNode.getChildByName(strNewFolder);
            if (tempNode != null && tempNode instanceof JetUReportDoc) {
                throw new DocException(1, strLocator);
            }
            if (tempNode == null) {
                curNode = curNode.addFolder(strNewFolder, "");
                continue;
            }
            curNode = (JetUDocFolder)tempNode;
        }
        return curNode;
    }

    protected JetUDocNode getChildByName(String strName) {
        Vector childrenVec = this.getChildren();
        int iSize = childrenVec.size();
        JetUDocNode node = null;
        for (int i = 0; i < iSize; ++i) {
            node = (JetUDocNode)childrenVec.elementAt(i);
            if (!node.getName().equalsIgnoreCase(strName)) continue;
            return node;
        }
        return null;
    }

    public JetUDocFolder addFolder(JetUDocFolder folder) {
        this.add(folder);
        return folder;
    }

    public JetUDocFolder getFolderByName(String strName) {
        JetUDocNode retNode = this.getChildByName(strName);
        return retNode != null && retNode instanceof JetUDocFolder ? (JetUDocFolder)retNode : null;
    }

    public JetUReportDoc addReport(String strName, String strDesc, String strFile, String strType, String strQueryName, String strAuthor, String strKeywords, long lastModifiedTime, long lastRunTime, long lastPrintTime) {
        JetUReportDoc reportDoc = new JetUReportDoc(strName, strDesc, strFile, strType, strQueryName, strAuthor, strKeywords, lastModifiedTime, lastRunTime, lastPrintTime);
        return this.addReport(reportDoc);
    }

    public JetUReportDoc addReport(JetUReportDoc reportdoc) {
        this.add(reportdoc);
        return reportdoc;
    }

    @Override
    public boolean delete(boolean bDeleteFile) {
        JetUTree parentNode = (JetUTree)this.getParent();
        if (parentNode instanceof JetUDocFolder) {
            ((JetUDocFolder)parentNode).removeDocNode(this, bDeleteFile);
            ((JetUDocFolder)parentNode).remove(this);
            return true;
        }
        return false;
    }

    public JetUDocNode removeDocNode(JetUDocNode node) throws SecurityException {
        return (JetUDocNode)((Object)this.remove((JetObject)((Object)node)));
    }

    public void removeDocNode(JetUDocNode node, boolean bDeleteFile) {
        if (node instanceof JetUReportDoc) {
            node.delete(bDeleteFile);
        } else if (node instanceof JetUDocFolder) {
            Vector subNodesVec = (Vector)((JetUDocFolder)node).getChildren().clone();
            int iSize = subNodesVec.size();
            JetUDocNode subNode = null;
            for (int i = 0; i < iSize; ++i) {
                subNode = (JetUDocNode)subNodesVec.elementAt(i);
                ((JetUDocFolder)node).removeDocNode(subNode, bDeleteFile);
            }
        }
    }

    @Override
    public boolean containsReports() {
        return this.getAllReports().size() > 0;
    }

    public Vector getAllReports() {
        Vector retVec = new Vector();
        Vector subNodes = this.getChildren();
        if (subNodes != null) {
            this.getReports(subNodes, retVec);
        }
        return retVec;
    }

    public Vector getAllDocFiles() {
        Vector<String> retVec = new Vector<String>();
        Vector reportNodesVec = this.getAllReports();
        int iSize = reportNodesVec.size();
        for (int i = 0; i < iSize; ++i) {
            String fileName = ((JetUReportDoc)reportNodesVec.elementAt(i)).getFile();
            if (fileName == null || "".equals(fileName.trim())) continue;
            retVec.addElement(((JetUReportDoc)reportNodesVec.elementAt(i)).getFile());
        }
        return retVec;
    }

    public Vector getAllChildren() {
        Vector retVec = new Vector();
        Vector subNodes = this.getChildren();
        if (subNodes != null) {
            this.getAllChildren(subNodes, retVec);
        }
        return retVec;
    }

    protected void getAllChildren(Vector subNodes, Vector childrenNodes) {
        int iSize = subNodes.size();
        JetUDocNode nodeElement = null;
        for (int i = 0; i < iSize; ++i) {
            nodeElement = (JetUDocNode)subNodes.elementAt(i);
            childrenNodes.addElement(nodeElement);
            if (!(nodeElement instanceof JetUDocFolder)) continue;
            this.getAllChildren(((JetUDocFolder)nodeElement).getChildren(), childrenNodes);
        }
    }

    public JetUDocNode getChildByLocator(String strLocator) {
        JetUDocFolder rootNode = this.getRootFolder();
        if (strLocator.equals("/")) {
            return rootNode;
        }
        if (strLocator.startsWith("/")) {
            return rootNode.getChildByRelativeLocator(strLocator.substring("/".length()));
        }
        return this.getChildByRelativeLocator(strLocator);
    }

    public JetUDocNode getChildByRelativeLocator(String strRelativeLocator) {
        int iIndexOfPathSeparator = strRelativeLocator.indexOf("/");
        if (iIndexOfPathSeparator == -1) {
            return this.getChildByName(strRelativeLocator);
        }
        String strChildName = strRelativeLocator.substring(0, iIndexOfPathSeparator);
        JetUDocFolder docNode = this.getFolderByName(strChildName);
        if (docNode != null) {
            return (JetUDocFolder)docNode.getChildByRelativeLocator(strRelativeLocator.substring(iIndexOfPathSeparator + "/".length()));
        }
        return null;
    }

    public void getReports(Vector subNodes, Vector leafNodes) {
        int iSize = subNodes.size();
        JetUDocNode nodeElement = null;
        for (int i = 0; i < iSize; ++i) {
            nodeElement = (JetUDocNode)subNodes.elementAt(i);
            if (nodeElement instanceof JetUReportDoc) {
                leafNodes.addElement(nodeElement);
                continue;
            }
            if (!(nodeElement instanceof JetUDocFolder)) continue;
            this.getReports(((JetUDocFolder)nodeElement).getChildren(), leafNodes);
        }
    }

    public Vector getItemsByName(String strWildcard) {
        Vector<JetUDocNode> retVec = new Vector<JetUDocNode>();
        Vector subNodesVec = this.getAllChildren();
        int iSize = subNodesVec.size();
        JetUDocNode subNode = null;
        for (int i = 0; i < iSize; ++i) {
            subNode = (JetUDocNode)subNodesVec.elementAt(i);
            if (!subNode.isMatch(strWildcard, true)) continue;
            retVec.addElement(subNode);
        }
        return retVec;
    }

    public JetUReportDoc getReportByName(String strName) {
        JetUDocNode retNode = this.getChildByName(strName);
        return retNode != null && retNode instanceof JetUReportDoc ? (JetUReportDoc)retNode : null;
    }

    public Vector search(String strFind, boolean bIgnoreCase, boolean bInSubFolder, boolean bFolder, boolean bReport, boolean bInName, boolean bInKeywords) {
        Vector vecResult = new Vector();
        this.search(vecResult, strFind, bIgnoreCase, bInSubFolder, bFolder, bReport, bInName, bInKeywords);
        return vecResult;
    }

    public void search(Vector vecResult, String strFind, boolean bIgnoreCase, boolean bInSubFolder, boolean bFolder, boolean bReport, boolean bInName, boolean bInKeywords) {
        int i;
        Vector vecChildren = this.getChildren();
        int iSize = vecChildren.size();
        JetUDocNode nodeChild = null;
        boolean bMatch = false;
        for (i = 0; i < iSize; ++i) {
            nodeChild = (JetUDocNode)vecChildren.elementAt(i);
            bMatch = nodeChild instanceof JetUReportDoc && bReport ? ((JetUReportDoc)nodeChild).isMatch(strFind, bIgnoreCase, bInName, bInKeywords) : (nodeChild instanceof JetUDocFolder && bFolder ? nodeChild.isMatch(strFind, bIgnoreCase) : false);
            if (!bMatch) continue;
            vecResult.addElement(nodeChild);
        }
        if (bInSubFolder) {
            for (i = 0; i < iSize; ++i) {
                nodeChild = (JetUDocNode)vecChildren.elementAt(i);
                if (!(nodeChild instanceof JetUDocFolder)) continue;
                ((JetUDocFolder)nodeChild).search(vecResult, strFind, bIgnoreCase, bInSubFolder, bFolder, bReport, bInName, bInKeywords);
            }
        }
    }

    @Override
    public boolean isMatch(String strFind, boolean bIgnoreCase) {
        return WildcardMatcher.matchWildcard(this.getName(), strFind, bIgnoreCase);
    }

    protected void createObjectInfo() {
        this.objInfo = new ObjectInfo(this, null);
    }

    @Override
    public ObjectInfo getObjectInfo() {
        if (this.objInfo == null) {
            this.createObjectInfo();
        }
        return this.objInfo;
    }

    public String toString() {
        return this.getLocator();
    }

    @Override
    public String getInstancePrefix() {
        return "DocFolder";
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    static {
        nameIdx.put("Description", new Integer(0));
        nameIdx.put("Name", new Integer(1));
    }
}

