/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.datatypes.DataTypeUtils;
import java.util.HashMap;
import java.util.Vector;
import jet.connect.DbColDesc;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.universe.JetUConnection;
import jet.universe.JetUDBField;
import jet.universe.JetUDatabase;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUResourceField;
import jet.universe.JetUTableView;
import jet.universe.UniverseEditor;
import jet.util.HashVector;

public class JetUField
extends JetUResourceField
implements JetUDBField {
    public static final int DATA = 0;
    public static final int PRIMARYKEY = 1;
    public static final int FOREIGNKEY = 2;
    public JetNumber columnType = new JetNumber(this, "ColumnType");
    public JetString colName;
    public JetNumber sqlType;
    public JetNumber precision;
    public JetNumber scale;
    public JetNumber nullable;
    public JetNumber currency;
    public JetBoolean array;
    private static final HashMap nameIdx = new HashMap(41);
    private static final HashVector grpDesc;

    public JetUField() {
        this.columnType.setEditFlag(3);
    }

    public JetUField(String strName, String strDesc, String strColName, int iSQLType, int iPrecision, int iScale, int iNullable) {
        this(strName, strDesc, strColName, iSQLType, iPrecision, iScale, iNullable, false);
    }

    public JetUField(String strName, String strDesc, String strColName, int iSQLType, int iPrecision, int iScale, int iNullable, boolean bArray) {
        super(strName, strDesc);
        this.columnType.setEditFlag(3);
        this.colName.set(strColName);
        this.sqlType.set(iSQLType);
        this.sqlType.setPropertyChoice(DataTypeUtils.getSQLTypeChoiceVector());
        this.sqlType.setEditorType(JetProperty.COMBO_EDITOR);
        this.precision.set(iPrecision);
        this.scale.set(iScale);
        this.nullable.set(iNullable);
        this.nullable.setPropertyChoice(DataTypeUtils.getNullableChoiceVector());
        this.nullable.setEditorType(JetProperty.COMBO_EDITOR);
        this.nullable.setEditFlag(0);
        this.currency.setEditorType(JetProperty.COMBO_EDITOR);
        this.array.set(bArray);
        this.setHAlignmentDefault(iSQLType);
        this.setVAlignmentDefault(iSQLType);
        this.setFormatDefault(iSQLType);
    }

    public JetUField(String strName, String strDesc, DbColDesc coldesc) {
        super(strName, strDesc);
        this.columnType.setEditFlag(3);
        this.colName.set(coldesc.getColName());
        this.sqlType.set(coldesc.getSqlType());
        this.sqlType.setPropertyChoice(DataTypeUtils.getSQLTypeChoiceVector());
        this.sqlType.setEditorType(JetProperty.COMBO_EDITOR);
        this.precision.set(coldesc.getPrecision());
        this.scale.set(coldesc.getScale());
        this.nullable.set(coldesc.getNullable());
        this.nullable.setPropertyChoice(DataTypeUtils.getNullableChoiceVector());
        this.nullable.setEditorType(JetProperty.COMBO_EDITOR);
        this.nullable.setEditFlag(0);
        this.currency.setEditorType(JetProperty.COMBO_EDITOR);
        this.array.set(coldesc.isArray());
        this.setHAlignmentDefault(coldesc.getSqlType());
        this.setVAlignmentDefault(coldesc.getSqlType());
        this.setFormatDefault(coldesc.getSqlType());
    }

    @Override
    void init() {
        super.init();
        this.colName = new JetString(this, "ColumnName");
        this.sqlType = new JetNumber(this, "SQLType");
        this.sqlType.setPropertyChoice(DataTypeUtils.getSQLTypeChoiceVector());
        this.sqlType.setEditorType(JetProperty.COMBO_EDITOR);
        this.precision = new JetNumber(this, "Precision");
        this.scale = new JetNumber(this, "Scale");
        this.nullable = new JetNumber(this, "Nullable");
        this.nullable.setPropertyChoice(DataTypeUtils.getNullableChoiceVector());
        this.nullable.setEditorType(JetProperty.COMBO_EDITOR);
        this.nullable.setEditFlag(0);
        this.currency = new JetNumber(this, "Currency");
        this.currency.setPropertyChoice(DataTypeUtils.getIsCurrencyChoiceVector());
        this.currency.setEditorType(JetProperty.COMBO_EDITOR);
        this.array = new JetBoolean(this, "Array");
    }

    public JetUField createNew() {
        return new JetUField(this.getResourceName(), this.getDesc(), this.getColDesc());
    }

    @Override
    public String getFldName() {
        return this.colName.get();
    }

    public void setFldName(String strColName) {
        this.colName.set(strColName);
    }

    @Override
    public int getSqlType() {
        return this.sqlType.get();
    }

    public void setSqlType(int iSQLType) {
        this.sqlType.set(iSQLType);
        this.setHAlignmentDefault(iSQLType);
        this.setVAlignmentDefault(iSQLType);
    }

    public int getPrecision() {
        return this.precision.get();
    }

    public void setPrecision(int iPrecision) {
        this.precision.set(iPrecision);
    }

    public int getScale() {
        return this.scale.get();
    }

    public void setScale(int iScale) {
        this.scale.set(iScale);
    }

    public int getNullable() {
        return this.nullable.get();
    }

    public void setNullable(int iNullable) {
        this.nullable.set(iNullable);
    }

    public boolean getArray() {
        return this.array.get();
    }

    public void setArray(boolean bArray) {
        this.array.set(bArray);
    }

    @Override
    public DbColDesc getColDesc() {
        DbColDesc dcd = new DbColDesc(this.getFldName(), this.getSqlType(), this.getPrecision(), this.getScale(), this.getNullable());
        if (this.currency.get() > 0) {
            dcd.setCurrency(true);
        }
        dcd.setArray(this.getArray());
        this.addCaseSensitiveInfo(dcd);
        this.addEncodingPattern(dcd);
        return dcd;
    }

    @Override
    public JetUConnection getConnection() {
        JetUTableView utable = this.getTable();
        if (utable != null) {
            return utable.getConnection();
        }
        return null;
    }

    public String getConnectionName() {
        JetUConnection uconnection = this.getConnection();
        if (uconnection != null) {
            return uconnection.getResourceName();
        }
        return null;
    }

    @Override
    public JetUTableView getTable() {
        return (JetUTableView)this.getParent();
    }

    @Override
    public String getTableName() {
        JetUTableView utable = this.getTable();
        if (utable != null) {
            return utable.getResourceName();
        }
        return null;
    }

    public String get3PartName() {
        return this.getConnectionName() + "." + this.getTableName() + "." + this.getFldName();
    }

    public String getFullTabName() {
        return this.getConnectionName() + "." + this.getTableName();
    }

    protected String getDefaultMapingName() {
        return this.getTableName() + "_" + this.getFldName();
    }

    @Override
    public String getDefinition() {
        return "real name: " + this.getConnectionName() + "." + this.getTableName() + "." + this.getFldName();
    }

    @Override
    public String toString() {
        String strParam = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + " [" + this.getConnectionName() + "|" + this.getTableName() + "|" + this.colName.get() + "|" + this.sqlType.get() + "|" + this.precision.get() + "|" + this.scale.get() + "|" + this.array.get() + "|" + " ]";
        return strParam;
    }

    @Override
    public String getInstancePrefix() {
        return "UField";
    }

    @Override
    public void setResourceName(String strName) {
        JetUDatabase db = this.getDatabase();
        UniverseEditor editor = db.getUniverse().editor;
        if (editor != null && this.getParent() instanceof JetUTableView) {
            editor.updateFieldNames(this.getTableName(), this.getResourceName(), strName, db.getResourceName());
        }
        super.setResourceName(strName);
    }

    @Override
    public boolean isSimilar(JetUResourceEntity field) {
        return super.isSimilar(field) && this.sqlType.equal(((JetUField)field).sqlType) && this.colName.equal(((JetUField)field).colName);
    }

    @Override
    public boolean isSimilarExceptName(JetUResourceEntity field) {
        return super.isSimilarExceptName(field) && this.sqlType.equal(((JetUField)field).sqlType) && this.colName.equal(((JetUField)field).colName);
    }

    public int getColumnType() {
        return this.columnType.get();
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return grpDesc;
    }

    static {
        nameIdx.put("SQLType", new Integer(0));
        nameIdx.put("padding-right", new Integer(1));
        nameIdx.put("RightLine", new Integer(2));
        nameIdx.put("HorizontalAlignment", new Integer(3));
        nameIdx.put("PatternStyle", new Integer(4));
        nameIdx.put("Format", new Integer(5));
        nameIdx.put("Precision", new Integer(6));
        nameIdx.put("Bold", new Integer(7));
        nameIdx.put("AutoFit", new Integer(8));
        nameIdx.put("Width", new Integer(9));
        nameIdx.put("GUIField", new Integer(10));
        nameIdx.put("Height", new Integer(11));
        nameIdx.put("padding-bottom", new Integer(12));
        nameIdx.put("Array", new Integer(13));
        nameIdx.put("Name", new Integer(14));
        nameIdx.put("ShadowColor", new Integer(15));
        nameIdx.put("BottomLine", new Integer(16));
        nameIdx.put("padding-top", new Integer(17));
        nameIdx.put("Description", new Integer(18));
        nameIdx.put("BorderWidth", new Integer(19));
        nameIdx.put("Background", new Integer(20));
        nameIdx.put("Scale", new Integer(21));
        nameIdx.put("DisplayWidth", new Integer(22));
        nameIdx.put("VerticalAlignment", new Integer(23));
        nameIdx.put("PatternColor", new Integer(24));
        nameIdx.put("TopLine", new Integer(25));
        nameIdx.put("FontSize", new Integer(26));
        nameIdx.put("Underline", new Integer(27));
        nameIdx.put("LeftLine", new Integer(28));
        nameIdx.put("Nullable", new Integer(29));
        nameIdx.put("ColumnName", new Integer(30));
        nameIdx.put("FontFace", new Integer(31));
        nameIdx.put("Alignment", new Integer(32));
        nameIdx.put("padding-left", new Integer(33));
        nameIdx.put("WordWrap", new Integer(34));
        nameIdx.put("Italic", new Integer(35));
        nameIdx.put("StrikeOut", new Integer(36));
        nameIdx.put("BorderColor", new Integer(37));
        nameIdx.put("Currency", new Integer(38));
        nameIdx.put("Foreground", new Integer(39));
        nameIdx.put("Shadow", new Integer(40));
        grpDesc = new HashVector(7);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "General";
        grpItems = new Vector<String>(11);
        grpItems.add("Name");
        grpItems.add("Description");
        grpItems.add("GUIField");
        grpItems.add("DisplayWidth");
        grpItems.add("ColumnName");
        grpItems.add("SQLType");
        grpItems.add("Precision");
        grpItems.add("Scale");
        grpItems.add("Nullable");
        grpItems.add("Currency");
        grpItems.add("Array");
        grpDesc.put(grpName, grpItems);
        grpName = "TextFormat";
        grpItems = new Vector(11);
        grpItems.add("FontFace");
        grpItems.add("FontSize");
        grpItems.add("Bold");
        grpItems.add("Italic");
        grpItems.add("StrikeOut");
        grpItems.add("Underline");
        grpItems.add("Format");
        grpItems.add("AutoFit");
        grpItems.add("WordWrap");
        grpItems.add("VerticalAlignment");
        grpItems.add("HorizontalAlignment");
        grpDesc.put(grpName, grpItems);
        grpName = "Padding";
        grpItems = new Vector(4);
        grpItems.add("padding-top");
        grpItems.add("padding-bottom");
        grpItems.add("padding-left");
        grpItems.add("padding-right");
        grpDesc.put(grpName, grpItems);
        grpName = "Geometry";
        grpItems = new Vector(2);
        grpItems.add("Width");
        grpItems.add("Height");
        grpDesc.put(grpName, grpItems);
        grpName = "Color";
        grpItems = new Vector(2);
        grpItems.add("Background");
        grpItems.add("Foreground");
        grpDesc.put(grpName, grpItems);
        grpName = "Border";
        grpItems = new Vector(8);
        grpItems.add("BorderWidth");
        grpItems.add("TopLine");
        grpItems.add("BottomLine");
        grpItems.add("LeftLine");
        grpItems.add("RightLine");
        grpItems.add("Shadow");
        grpItems.add("BorderColor");
        grpItems.add("ShadowColor");
        grpDesc.put(grpName, grpItems);
        grpName = "Pattern";
        grpItems = new Vector(2);
        grpItems.add("PatternColor");
        grpItems.add("PatternStyle");
        grpDesc.put(grpName, grpItems);
        grpName = "Others";
        grpItems = new Vector(1);
        grpItems.add("DataMappingFile");
        grpDesc.put(grpName, grpItems);
    }
}

