/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.log.JRLogger;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUFileQueryField;
import jet.universe.JetUFormula;
import jet.universe.JetUParameter;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLIlegalNameException;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.JBusinessView;
import jet.universe.businesslogic.impl.BusinessLogic;
import jet.universe.businesslogic.impl.BusinessView;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.psql.FileQuery;
import jet.universe.psql.JetFileQuery;
import jet.util.HashVector;
import toolkit.db.StmtSelCol;
import toolkit.db.sql.comments.SqlCommentsTool;

public class JetUFileQuery
extends JetUResourceContainer
implements JetUQueriable {
    public JetString connectionName = new JetString(this, "ConnectionName");
    public JetEnumeration transactionIsolation = new JetEnumeration(this, "TransactionIsolation", 99);
    public JetEnumeration readOnly = new JetEnumeration(this, "ReadOnly", 84);
    public JetNumber maxRows = new JetNumber(this, "maxRows");
    public JetNumber maxDuration = new JetNumber(this, "maxDuration");
    public JetString qualifier = new JetString(this, "Qualifier");
    FileQuery fileQuery = null;
    private static JRLogger logger = JRLogger.getLogger(JetUFileQuery.class.getName());
    private static final HashMap nameIdx = new HashMap(7);
    private static final HashVector grpDesc;

    public JetUFileQuery() {
        this.initialize();
    }

    public JetUFileQuery(String strName, String strDescription, FileQuery fileQuery) {
        this(strName, strDescription, fileQuery, fileQuery.getQualifier());
    }

    public JetUFileQuery(String strName, String strDescription, FileQuery fileQuery, String strQualifier) {
        super(strName, strDescription);
        this.initialize();
        this.fileQuery = fileQuery;
        this.qualifier.set(strQualifier);
    }

    public JetUFileQuery getCopy() {
        Vector curFields;
        FileQuery newFileQry = this.fileQuery.getCopy();
        JetUFileQuery jFileQry = new JetUFileQuery(this.getResourceName(), this.getDesc(), newFileQry);
        if (this.qualifier != null) {
            jFileQry.qualifier = this.qualifier;
        }
        int size = (curFields = this.getFields()) == null ? 0 : curFields.size();
        for (int i = 0; i < size; ++i) {
            JetUFileQueryField fileQryFld = (JetUFileQueryField)curFields.elementAt(i);
            JetUFileQueryField newQryFld = new JetUFileQueryField(fileQryFld.getResourceName(), fileQryFld.getDesc(), newFileQry.getColumnByName(fileQryFld.getFldName()), fileQryFld.getColIndex());
            jFileQry.addField(newQryFld);
            JetObject.copyProperties(newQryFld, fileQryFld);
        }
        JetObject.copyProperties(jFileQry, this);
        jFileQry.removeBL();
        JBusinessLogic bl = this.getBL();
        jFileQry.add((JetObject)((Object)(bl == null ? null : bl.copy())));
        jFileQry.removeBV();
        JBusinessView bv = this.getBV();
        jFileQry.add((JetObject)((Object)(bv == null ? null : bv.copy())));
        return jFileQry;
    }

    protected void initialize() {
        this.transactionIsolation.set(new Integer(0));
        this.readOnly.set(new Integer(1));
    }

    @Override
    public void InitAfterCreate() {
        super.InitAfterCreate();
        this.InitFileQuery();
    }

    public void InitFileQuery() {
        JetUDatabase db = this.getDatabase();
        Vector vSelCols = this.fileQuery.getColumns();
        int iSize = vSelCols.size();
        StringBuffer error = new StringBuffer();
        String strQueryName = this.getResourceName();
        for (int i = 0; i < iSize; ++i) {
            StmtSelCol col = (StmtSelCol)vSelCols.elementAt(i);
            String tblName = col.getTableName();
            String colName = col.getName();
            String strMappingName = tblName != null && !tblName.equals("") ? tblName + "_" + colName : colName;
            String strSuffix = "";
            int iSuffix = 1;
            while (!db.IsMappingNameOK(strMappingName, error)) {
                strMappingName = strQueryName + "_" + colName + strSuffix;
                strSuffix = String.valueOf(iSuffix++);
            }
            JetUFileQueryField field = new JetUFileQueryField(strMappingName, "", col, i + 1);
            this.addField(field);
        }
    }

    @Override
    public void InitAfterLoad() {
        Vector children = this.getChildren();
        int iSize = children.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)children.elementAt(i);
            if (child instanceof JetFileQuery) {
                JetFileQuery jetFileQuery = (JetFileQuery)child;
                this.fileQuery = new FileQuery();
                this.fileQuery.getFromJetObject(jetFileQuery);
                break;
            }
            if (!(child instanceof JBusinessLogic)) continue;
            BusinessLogic bLogic = (BusinessLogic)child;
            bLogic.initAfterLoad();
        }
        super.InitAfterLoad();
    }

    void PrepareBeforeSave() {
        Vector children = (Vector)this.getChildren().clone();
        int iSize = children.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)children.elementAt(i);
            if (!(child instanceof JetFileQuery)) continue;
            this.remove(i);
        }
        JetObject jetFileQuery = this.fileQuery.createJetObject();
        this.fileQuery.setQualifier(this.qualifier.get());
        this.fileQuery.putToJetObject(jetFileQuery);
        this.add(jetFileQuery);
    }

    public void setTransactionIsolation(int iTransactionIsolation) {
        this.transactionIsolation.set(new Integer(iTransactionIsolation));
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionIsolation.intValue();
    }

    public void setReadOnly(int iReadOnly) {
        this.readOnly.set(new Integer(iReadOnly));
    }

    @Override
    public int getReadOnly() {
        return this.readOnly.intValue();
    }

    public void setMaxRows(int maxRows) {
        this.maxRows.set(maxRows);
    }

    @Override
    public int getMaxRows() {
        return this.maxRows.get();
    }

    public void setMaxDuration(int maxDuration) {
        this.maxDuration.set(maxDuration);
    }

    @Override
    public int getMaxDuration() {
        return this.maxDuration.get();
    }

    @Override
    public JetObject add(JetObject child, int pos) {
        super.add(child, pos);
        return child;
    }

    public void addField(JetUFileQueryField field) {
        this.add(field);
        field.InitAfterCreate();
    }

    public void initAfterAdd() {
        Vector fields = this.getChildren();
        int iSize = fields.size();
        for (int i = 0; i < iSize; ++i) {
            if (!(fields.elementAt(i) instanceof JetUFileQueryField)) continue;
            JetUFileQueryField fld = (JetUFileQueryField)fields.elementAt(i);
            fld.InitAfterCreate();
        }
    }

    public JetUFileQueryField removeField(JetUFileQueryField field) {
        this.remove(field);
        return field;
    }

    protected void removeAllFields() {
        Vector fqryFlds = this.getFields();
        int iSize = fqryFlds.size();
        for (int i = 0; i < iSize; ++i) {
            JetUFileQueryField child = (JetUFileQueryField)fqryFlds.elementAt(i);
            this.remove(child);
        }
    }

    @Override
    public Vector getFields() {
        Vector<JetObject> vecRet = new Vector<JetObject>();
        Vector vecChildren = this.getChildren();
        int iSize = vecChildren.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)vecChildren.elementAt(i);
            if (!(child instanceof JetUFileQueryField)) continue;
            vecRet.addElement(child);
        }
        return vecRet;
    }

    @Override
    public JetUResourceEntity getFieldByResourceName(String fldName) {
        Vector fields = this.getChildren();
        int iSize = fields.size();
        for (int i = 0; i < iSize; ++i) {
            JetUFileQueryField fld;
            Object obj = fields.elementAt(i);
            if (!(obj instanceof JetUFileQueryField) || !(fld = (JetUFileQueryField)obj).getResourceName().equalsIgnoreCase(fldName)) continue;
            return fld;
        }
        return null;
    }

    public JetUFileQueryField getFieldByFieldName(String fldName) {
        Vector fields = this.getChildren();
        int iSize = fields.size();
        for (int i = 0; i < iSize; ++i) {
            JetUFileQueryField fld;
            Object obj = fields.elementAt(i);
            if (!(obj instanceof JetUFileQueryField) || !(fld = (JetUFileQueryField)obj).getFldName().equalsIgnoreCase(fldName)) continue;
            return fld;
        }
        return null;
    }

    public FileQuery getFileQuery() {
        return this.fileQuery;
    }

    public void setFileQuery(FileQuery fileQuery) {
        this.objectModified();
        this.fileQuery = fileQuery;
        this.removeAllFields();
        this.InitFileQuery();
        JetUUniverse.objectChanged(this.getUniverse(), this, 1002);
    }

    public JetUConnection getConnection() {
        return this.getDatabase().getConnectionByResourceName(this.connectionName.get());
    }

    @Override
    public JetUConnection[] getConnections() {
        JetUConnection conn = this.getConnection();
        if (conn == null) {
            return new JetUConnection[0];
        }
        return new JetUConnection[]{conn};
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse universe, String mappingName) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        return this.isFieldValidToQuery(universe, mappingName, "");
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse universe, String mappingName, String dataSourceName) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        if (universe == null) {
            return false;
        }
        JetUResourceEntity entity = universe.getResourceByName(dataSourceName, this.getResourceName(), mappingName);
        if (entity == null) {
            throw new CannotFindEntity(mappingName);
        }
        return this.isFieldValidToQuery(universe, entity, dataSourceName);
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse universe, JetUResourceEntity entity) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        return this.isFieldValidToQuery(universe, entity, "");
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse universe, JetUResourceEntity entity, String dataSourceName) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        boolean bRet = false;
        if (entity instanceof JetUParameter) {
            bRet = true;
        } else if (entity instanceof JetUFormula) {
            bRet = this.isFormulaValidToQuery((JetUFormula)entity, universe, dataSourceName);
        } else if (entity instanceof JetUQueriableField && entity instanceof JetUFileQueryField) {
            bRet = ((JetUFileQueryField)entity).getFileQuery().isSimilar(this);
        }
        return bRet;
    }

    public boolean isFormulaValidToQuery(JetUFormula uFormula, JetUUniverse universe) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        return this.isFormulaValidToQuery(uFormula, universe, "");
    }

    public boolean isFormulaValidToQuery(JetUFormula uFormula, JetUUniverse universe, String dataSourceName) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        if (uFormula == null) {
            return false;
        }
        Vector dbFlds = uFormula.getRefDbFld();
        if (dbFlds != null) {
            int iCount = dbFlds.size();
            for (int i = 0; i < iCount; ++i) {
                String name2 = (String)dbFlds.elementAt(i);
                try {
                    if (this.isFieldValidToQuery(universe, name2, dataSourceName)) continue;
                    return false;
                }
                catch (CannotFindEntity e) {
                    throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name2);
                }
            }
        }
        Vector refFormulas = uFormula.getRefFormuFld();
        int iSize = refFormulas.size();
        for (int i = 0; i < iSize; ++i) {
            String name3 = (String)refFormulas.elementAt(i);
            try {
                if (this.isFieldValidToQuery(universe, name3, dataSourceName)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name3);
            }
        }
        Vector groups = uFormula.getGroupByVector();
        iSize = groups.size();
        for (int i = 0; i < iSize; ++i) {
            String name4 = (String)groups.elementAt(i);
            if (JetUDatabase.isDigital(name4)) continue;
            try {
                if (name4.equalsIgnoreCase("Report") || this.isFieldValidToQuery(universe, name4, dataSourceName)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name4);
            }
        }
        return true;
    }

    @Override
    public String getFullSQLString() {
        if (this.fileQuery == null) {
            return null;
        }
        return this.fileQuery.getOriginalStatement();
    }

    @Override
    public String getSQLString() {
        if (this.fileQuery == null) {
            return null;
        }
        return SqlCommentsTool.removeComments(this.fileQuery.getOriginalStatement());
    }

    public String getUserSQLString() {
        if (this.fileQuery == null) {
            return null;
        }
        return this.fileQuery.getOriginalStatement();
    }

    public void clearMem() {
        this.fileQuery = null;
    }

    @Override
    public Vector getAutoGroupFields() {
        return null;
    }

    @Override
    public String getInstancePrefix() {
        return "UFileQuery";
    }

    public String getQualifier() {
        return this.qualifier.toString();
    }

    public void setQualifier(String strQualifier) {
        this.qualifier.set(strQualifier);
    }

    @Override
    public boolean isSimilar(JetUResourceContainer container) {
        if (!super.isSimilar(container)) {
            return false;
        }
        boolean isBLSimilar = this.isBLSimilar((JetUFileQuery)container);
        if (!isBLSimilar) {
            return false;
        }
        boolean isBVSimilar = this.isBVSimilar((JetUFileQuery)container);
        return isBVSimilar;
    }

    private boolean isBLSimilar(JetUFileQuery fileQuery) {
        JBusinessLogic bl2;
        JBusinessLogic bl1 = this.getBL();
        if (bl1 == (bl2 = fileQuery.getBL())) {
            return true;
        }
        if (bl1 == null) {
            return bl2 == null;
        }
        return bl1.isSimilar(bl2);
    }

    private boolean isBVSimilar(JetUFileQuery fileQuery) {
        JBusinessView bv2;
        JBusinessView bv1 = this.getBV();
        if (bv1 == (bv2 = fileQuery.getBV())) {
            return true;
        }
        if (bv1 == null) {
            return bv2 == null;
        }
        return bv1.isSimilar(bv2);
    }

    public JBusinessLogic newBL(String blName) throws BLIlegalNameException, BLDupleNameException {
        if (this.getBL() != null) {
            return null;
        }
        BusinessLogic bl = new BusinessLogic();
        bl.setName(blName);
        bl.setDisplayName(blName);
        this.add(bl);
        return bl;
    }

    public JBusinessView newBV(String bvName) throws BLIlegalNameException, BLDupleNameException {
        if (this.getBV() != null) {
            return null;
        }
        BusinessView bv = new BusinessView();
        bv.setDisplayName(bvName);
        this.add(bv);
        return bv;
    }

    public void removeBL() {
        JBusinessLogic bl = this.getBL();
        if (bl != null) {
            this.remove((JetObject)((Object)bl));
        }
    }

    public void removeBV() {
        JBusinessView bv = this.getBV();
        if (bv != null) {
            this.remove((JetObject)((Object)bv));
        }
    }

    @Override
    public JBusinessLogic getBL() {
        JBusinessLogic ret = null;
        for (JetObject element : this.children) {
            JBusinessLogic bl;
            if (!(element instanceof JBusinessLogic) || (bl = (JBusinessLogic)((Object)element)).getElementType() != 0) continue;
            ret = bl;
        }
        return ret;
    }

    @Override
    public JBusinessView getBV() {
        JBusinessView ret = null;
        for (JetObject element : this.children) {
            JBusinessLogic bl;
            if (!(element instanceof JBusinessLogic) || (bl = (JBusinessLogic)((Object)element)).getElementType() != 1) continue;
            ret = (JBusinessView)bl;
        }
        return ret;
    }

    @Override
    public JetObject deepDupWithoutCopyProperties(Hashtable oldToNew, Hashtable newToOld, boolean setTmpl, boolean withName) {
        JetUFileQuery copyFQ = (JetUFileQuery)super.deepDupWithoutCopyProperties(oldToNew, newToOld, setTmpl, withName);
        copyFQ.fileQuery = this.fileQuery.getCopy();
        return copyFQ;
    }

    @Override
    public JetObject dup() {
        JetUFileQuery copyFQ = (JetUFileQuery)super.dup();
        copyFQ.fileQuery = this.fileQuery.getCopy();
        return copyFQ;
    }

    @Override
    public boolean isEqual(JetUResourceContainer container) {
        return super.isEqual(container) && ((JetUFileQuery)container).getSQLString().equalsIgnoreCase(this.getSQLString());
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            return grpDesc;
        }
        return null;
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse universe, String mappingName, String dataSourceName, Map<String, String> refFldOfFml) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        JetUResourceEntity en;
        if (universe == null) {
            return false;
        }
        if (refFldOfFml == null) {
            refFldOfFml = new HashMap<String, String>();
        }
        if (refFldOfFml.containsKey(mappingName)) {
            return true;
        }
        refFldOfFml.put(mappingName, "");
        JetUResourceEntity entity = universe.getResourceByName(dataSourceName, this.getResourceName(), mappingName);
        if (entity == null && (en = universe.getAnyResourceByName(mappingName)) != null && en instanceof JetUParameter) {
            entity = en;
        }
        if (entity == null) {
            throw new CannotFindEntity(mappingName);
        }
        return this.isFieldValidToQuery(universe, entity, dataSourceName, refFldOfFml);
    }

    private boolean isFieldValidToQuery(JetUUniverse universe, JetUResourceEntity entity, String dataSourceName, Map<String, String> refFldOfFml) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        boolean bRet = false;
        if (entity instanceof JetUParameter) {
            bRet = true;
        } else if (entity instanceof JetUFormula) {
            bRet = this.isFormulaValidToQuery((JetUFormula)entity, universe, dataSourceName, refFldOfFml);
        } else if (entity instanceof JetUQueriableField && entity instanceof JetUFileQueryField) {
            bRet = ((JetUFileQueryField)entity).getFileQuery() == this;
        }
        return bRet;
    }

    private boolean isFormulaValidToQuery(JetUFormula uFormula, JetUUniverse universe, String dataSourceName, Map<String, String> refFldOfFml) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        Vector dbFlds = uFormula.getRefDbFld();
        if (dbFlds != null) {
            int iCount = dbFlds.size();
            for (int i = 0; i < iCount; ++i) {
                String name2 = (String)dbFlds.elementAt(i);
                try {
                    if (this.isFieldValidToQuery(universe, name2, dataSourceName, refFldOfFml)) continue;
                    return false;
                }
                catch (CannotFindEntity e) {
                    throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name2);
                }
            }
        }
        Vector refFormulas = uFormula.getRefFormuFld();
        int iSize = refFormulas.size();
        for (int i = 0; i < iSize; ++i) {
            String name3 = (String)refFormulas.elementAt(i);
            try {
                if (this.isFieldValidToQuery(universe, name3, dataSourceName, refFldOfFml)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name3);
            }
        }
        Vector groups = uFormula.getGroupByVector();
        iSize = groups.size();
        for (int i = 0; i < iSize; ++i) {
            String name4 = (String)groups.elementAt(i);
            if (JetUDatabase.isDigital(name4)) continue;
            try {
                if (name4.equalsIgnoreCase("Report") || this.isFieldValidToQuery(universe, name4, dataSourceName, refFldOfFml)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name4);
            }
        }
        return true;
    }

    @Override
    public int isPushDownGroupQuery() {
        return 2;
    }

    @Override
    public boolean canPushdownSort(String fieldMappingName) {
        return false;
    }

    @Override
    public void setResourceName(String strName) {
        String oldName = this.getResourceName().toUpperCase();
        super.setResourceName(strName);
        this.getDatabase().mapTable4Queriable.remove(oldName);
        this.getDatabase().mapTable4Queriable.put(this.getResourceName().toUpperCase(), this);
    }

    static {
        nameIdx.put("Description", new Integer(0));
        nameIdx.put("maxRows", new Integer(1));
        nameIdx.put("Name", new Integer(2));
        nameIdx.put("ReadOnly", new Integer(3));
        nameIdx.put("maxDuration", new Integer(4));
        nameIdx.put("Qualifier", new Integer(5));
        nameIdx.put("TransactionIsolation", new Integer(6));
        nameIdx.put("ConnectionName", new Integer(7));
        grpDesc = new HashVector(1);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "anonymous";
        grpItems = new Vector<String>(7);
        grpItems.add("Description");
        grpItems.add("maxRows");
        grpItems.add("Name");
        grpItems.add("ReadOnly");
        grpItems.add("maxDuration");
        grpItems.add("Qualifier");
        grpItems.add("TransactionIsolation");
        grpItems.add("ConnectionName");
        grpDesc.put(grpName, grpItems);
    }
}

