/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.datatypes.DataTypeUtils;
import java.util.HashMap;
import java.util.Vector;
import jet.connect.DbColDesc;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.universe.JetUConnection;
import jet.universe.JetUDBField;
import jet.universe.JetUFileQuery;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUResourceField;
import jet.universe.JetUTableView;
import jet.util.HashVector;
import toolkit.db.StmtSelCol;

public class JetUFileQueryField
extends JetUResourceField
implements JetUDBField,
JetUQueriableField {
    public JetString colName;
    public JetNumber sqlType;
    public JetNumber precision;
    public JetNumber scale;
    public JetNumber nullable;
    public JetNumber currency;
    public JetBoolean array;
    public JetNumber columnIndex;
    StmtSelCol col;
    private static final HashMap nameIdx = new HashMap(41);
    private static final HashVector grpDesc;

    public JetUFileQueryField() {
    }

    public JetUFileQueryField(String strName, String strDesc, StmtSelCol col, int iColIndex) {
        super(strName, strDesc);
        this.col = col;
        this.colName.set(col.getName());
        this.sqlType.set(col.getType());
        this.sqlType.setPropertyChoice(DataTypeUtils.getSQLTypeChoiceVector());
        this.sqlType.setEditorType(JetProperty.COMBO_EDITOR);
        this.precision.set(col.getPrecision());
        this.scale.set(col.getScale());
        this.nullable.set(col.getNullable());
        this.nullable.setPropertyChoice(DataTypeUtils.getNullableChoiceVector());
        this.nullable.setEditorType(JetProperty.COMBO_EDITOR);
        this.currency.setEditorType(JetProperty.COMBO_EDITOR);
        this.columnIndex.set(iColIndex);
        this.array.set(col.array);
        this.setHAlignmentDefault(col.getType());
        this.setVAlignmentDefault(col.getType());
    }

    @Override
    void init() {
        super.init();
        this.colName = new JetString(this, "ColumnName");
        this.sqlType = new JetNumber(this, "SQLType");
        this.sqlType.setPropertyChoice(DataTypeUtils.getSQLTypeChoiceVector());
        this.sqlType.setEditorType(JetProperty.COMBO_EDITOR);
        this.precision = new JetNumber(this, "Precision");
        this.scale = new JetNumber(this, "Scale");
        this.nullable = new JetNumber(this, "Nullable");
        this.nullable.setPropertyChoice(DataTypeUtils.getNullableChoiceVector());
        this.nullable.setEditorType(JetProperty.COMBO_EDITOR);
        this.currency = new JetNumber(this, "Currency");
        this.currency.setPropertyChoice(DataTypeUtils.getIsCurrencyChoiceVector());
        this.currency.setEditorType(JetProperty.COMBO_EDITOR);
        this.array = new JetBoolean(this, "Array");
        this.columnIndex = new JetNumber(this, "ColumnIndex");
    }

    @Override
    public String getFldName() {
        return this.colName.get();
    }

    public void setFldName(String strColName) {
        this.colName.set(strColName);
    }

    @Override
    public int getSqlType() {
        return this.sqlType.get();
    }

    public void setSqlType(int iSQLType) {
        this.sqlType.set(iSQLType);
        this.setHAlignmentDefault(iSQLType);
        this.setVAlignmentDefault(iSQLType);
    }

    public int getPrecision() {
        return this.precision.get();
    }

    public void setPrecision(int iPrecision) {
        this.precision.set(iPrecision);
    }

    public int getScale() {
        return this.scale.get();
    }

    public void setScale(int iScale) {
        this.scale.set(iScale);
    }

    public int getNullable() {
        return this.nullable.get();
    }

    public void setNullable(int iNullable) {
        this.nullable.set(iNullable);
    }

    public boolean getArray() {
        return this.array.get();
    }

    public void setArray(boolean bArray) {
        this.array.set(bArray);
    }

    public int getColIndex() {
        return this.columnIndex.get();
    }

    public void setColIndex(int iColIndex) {
        this.columnIndex.set(iColIndex);
    }

    @Override
    public DbColDesc getColDesc() {
        DbColDesc dcd = new DbColDesc(this.getFldName(), this.getSqlType(), this.getPrecision(), this.getScale(), this.getNullable());
        if (this.currency.get() > 0) {
            dcd.setCurrency(true);
        }
        dcd.setArray(this.getArray());
        this.addCaseSensitiveInfo(dcd);
        this.addEncodingPattern(dcd);
        return dcd;
    }

    @Override
    public JetUConnection getConnection() {
        JetUFileQuery usql = this.getFileQuery();
        if (usql != null) {
            return usql.getConnection();
        }
        return null;
    }

    public String getConnectionName() {
        JetUConnection uconnection = this.getConnection();
        if (uconnection != null) {
            return uconnection.getResourceName();
        }
        return null;
    }

    @Override
    public JetUQueriable getQueriable() {
        return this.getFileQuery();
    }

    public JetUFileQuery getFileQuery() {
        return (JetUFileQuery)this.getParent();
    }

    public String getFileQueryName() {
        JetUFileQuery uFileQuery = this.getFileQuery();
        if (uFileQuery != null) {
            return uFileQuery.getResourceName();
        }
        return null;
    }

    @Override
    public String getQueriableName() {
        return this.getFileQueryName();
    }

    protected String getDefaultMapingName() {
        return this.getFileQueryName() + "_" + this.getFldName();
    }

    @Override
    public String getDefinition() {
        return "real name: " + this.getConnectionName() + "." + this.getFileQueryName() + "." + this.getFldName();
    }

    @Override
    public String getTableName() {
        return null;
    }

    @Override
    public JetUTableView getTable() {
        return null;
    }

    @Override
    public String toString() {
        String strParam = "Field[" + this.getConnectionName() + "|" + this.getFileQueryName() + "|" + this.colName.get() + "|" + this.sqlType.get() + "|" + this.precision.get() + "|" + this.scale.get() + "|" + this.array.get() + "|" + " ]";
        return strParam;
    }

    @Override
    public String getInstancePrefix() {
        return "FileQueryField";
    }

    @Override
    public boolean isSimilar(JetUResourceEntity field) {
        return super.isSimilar(field) && this.colName.equal(((JetUFileQueryField)field).colName) && this.columnIndex.equal(((JetUFileQueryField)field).columnIndex) && this.sqlType.equal(((JetUFileQueryField)field).sqlType);
    }

    @Override
    public boolean isSimilarExceptName(JetUResourceEntity field) {
        return super.isSimilarExceptName(field) && this.colName.equal(((JetUFileQueryField)field).colName) && this.columnIndex.equal(((JetUFileQueryField)field).columnIndex) && this.sqlType.equal(((JetUFileQueryField)field).sqlType);
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return grpDesc;
    }

    static {
        nameIdx.put("SQLType", new Integer(0));
        nameIdx.put("padding-right", new Integer(1));
        nameIdx.put("RightLine", new Integer(2));
        nameIdx.put("HorizontalAlignment", new Integer(3));
        nameIdx.put("PatternStyle", new Integer(4));
        nameIdx.put("Format", new Integer(5));
        nameIdx.put("Precision", new Integer(6));
        nameIdx.put("Bold", new Integer(7));
        nameIdx.put("AutoFit", new Integer(8));
        nameIdx.put("Width", new Integer(9));
        nameIdx.put("GUIField", new Integer(10));
        nameIdx.put("Height", new Integer(11));
        nameIdx.put("padding-bottom", new Integer(12));
        nameIdx.put("Array", new Integer(13));
        nameIdx.put("Name", new Integer(14));
        nameIdx.put("ShadowColor", new Integer(15));
        nameIdx.put("ColumnIndex", new Integer(16));
        nameIdx.put("BottomLine", new Integer(17));
        nameIdx.put("padding-top", new Integer(18));
        nameIdx.put("Description", new Integer(19));
        nameIdx.put("BorderWidth", new Integer(20));
        nameIdx.put("Background", new Integer(21));
        nameIdx.put("Scale", new Integer(22));
        nameIdx.put("DisplayWidth", new Integer(23));
        nameIdx.put("VerticalAlignment", new Integer(24));
        nameIdx.put("PatternColor", new Integer(25));
        nameIdx.put("TopLine", new Integer(26));
        nameIdx.put("FontSize", new Integer(27));
        nameIdx.put("Underline", new Integer(28));
        nameIdx.put("LeftLine", new Integer(29));
        nameIdx.put("Nullable", new Integer(30));
        nameIdx.put("ColumnName", new Integer(31));
        nameIdx.put("FontFace", new Integer(32));
        nameIdx.put("Alignment", new Integer(33));
        nameIdx.put("padding-left", new Integer(34));
        nameIdx.put("WordWrap", new Integer(35));
        nameIdx.put("Italic", new Integer(36));
        nameIdx.put("StrikeOut", new Integer(37));
        nameIdx.put("BorderColor", new Integer(38));
        nameIdx.put("Currency", new Integer(39));
        nameIdx.put("Foreground", new Integer(40));
        nameIdx.put("Shadow", new Integer(41));
        grpDesc = new HashVector(7);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "General";
        grpItems = new Vector<String>(11);
        grpItems.add("Name");
        grpItems.add("Description");
        grpItems.add("GUIField");
        grpItems.add("DisplayWidth");
        grpItems.add("ColumnName");
        grpItems.add("ColumnIndex");
        grpItems.add("SQLType");
        grpItems.add("Precision");
        grpItems.add("Scale");
        grpItems.add("Nullable");
        grpItems.add("Currency");
        grpItems.add("Array");
        grpDesc.put(grpName, grpItems);
        grpName = "TextFormat";
        grpItems = new Vector(11);
        grpItems.add("FontFace");
        grpItems.add("FontSize");
        grpItems.add("Bold");
        grpItems.add("Italic");
        grpItems.add("StrikeOut");
        grpItems.add("Underline");
        grpItems.add("Format");
        grpItems.add("AutoFit");
        grpItems.add("WordWrap");
        grpItems.add("VerticalAlignment");
        grpItems.add("HorizontalAlignment");
        grpDesc.put(grpName, grpItems);
        grpName = "Padding";
        grpItems = new Vector(4);
        grpItems.add("padding-top");
        grpItems.add("padding-bottom");
        grpItems.add("padding-left");
        grpItems.add("padding-right");
        grpDesc.put(grpName, grpItems);
        grpName = "Geometry";
        grpItems = new Vector(2);
        grpItems.add("Width");
        grpItems.add("Height");
        grpDesc.put(grpName, grpItems);
        grpName = "Color";
        grpItems = new Vector(2);
        grpItems.add("Background");
        grpItems.add("Foreground");
        grpDesc.put(grpName, grpItems);
        grpName = "Border";
        grpItems = new Vector(8);
        grpItems.add("BorderWidth");
        grpItems.add("TopLine");
        grpItems.add("BottomLine");
        grpItems.add("LeftLine");
        grpItems.add("RightLine");
        grpItems.add("Shadow");
        grpItems.add("BorderColor");
        grpItems.add("ShadowColor");
        grpDesc.put(grpName, grpItems);
        grpName = "Pattern";
        grpItems = new Vector(2);
        grpItems.add("PatternColor");
        grpItems.add("PatternStyle");
        grpDesc.put(grpName, grpItems);
        grpName = "Others";
        grpItems = new Vector(1);
        grpItems.add("DataMappingFile");
        grpDesc.put(grpName, grpItems);
    }
}

