/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.datatypes.DataTypeUtils;
import java.util.HashMap;
import java.util.Vector;
import jet.connect.DbColDesc;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.exception.FormulaSyntaxErrorException;
import jet.formula.DataTypeDef;
import jet.formula.FormulaContainer;
import jet.formula.FormulaInfo;
import jet.formula.JetRptFormula;
import jet.formula.SqlwNode;
import jet.log.JRLogger;
import jet.universe.JetUCloneable;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormulaInterface;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUResourceField;
import jet.universe.JetUSummary;
import jet.universe.exception.CannotFindEntity;
import jet.util.HashVector;
import toolkit.db.gui.MappingSQLType;

public class JetUFormula
extends JetUResourceField
implements JetUFormulaInterface,
JetUCloneable {
    public JetNumber sqlType;
    public JetNumber precision;
    public JetNumber length;
    public JetNumber scale;
    public JetNumber radix;
    public JetString expr;
    protected JetRptFormula rptFormula = null;
    public FormulaInfo formulainfo;
    protected boolean bParsedOK = false;
    private static JRLogger logger = JRLogger.getLogger(JetUFormula.class.getName());
    private static final HashMap nameIdx = new HashMap(41);
    private static final HashVector grpDesc;

    public JetUFormula() {
    }

    public JetUFormula(String strName, String strDesc, String strExpression) {
        super(strName, strDesc);
        this.expr.set(strExpression);
    }

    @Override
    void init() {
        super.init();
        this.sqlType = new JetNumber(this, "SQLType");
        this.sqlType.setPropertyChoice(DataTypeUtils.getSQLTypeChoiceVector());
        this.sqlType.setEditorType(JetProperty.COMBO_EDITOR);
        this.precision = new JetNumber(this, "Precision");
        this.length = new JetNumber(this, "Length");
        this.scale = new JetNumber(this, "Scale");
        this.radix = new JetNumber(this, "Radix");
        this.expr = new JetString(this, "Expression");
        this.formulainfo = new FormulaInfo(this, "formulainfo");
    }

    public JetUFormula createNew() {
        return this.createNewByName(this.getResourceName());
    }

    @Override
    public JetUDBTreeNode copy() {
        JetUDatabase db = this.getDatabase();
        String strName = this.getResourceName();
        int i = 1;
        String strTmp = "Copy_of_" + strName;
        while (db.IsMappingNameExist(strTmp)) {
            strTmp = "Copy_(" + String.valueOf(++i) + ")_of_" + strName;
        }
        JetUFormula newFml = this.createNewByName(strTmp);
        JetObject.copyProperties(newFml, this);
        newFml.setResourceName(strTmp);
        return newFml;
    }

    private JetUFormula createNewByName(String strNewName) {
        JetUFormula newFormula = new JetUFormula(strNewName, this.getDesc(), this.getExpression());
        newFormula.rptFormula = this.getRptFormula();
        newFormula.HandleRptFormula();
        newFormula.createProperties();
        return newFormula;
    }

    @Override
    public void InitAfterCreate() {
        super.InitAfterCreate();
        this.FormulaModified();
    }

    @Override
    public void InitAfterLoad() {
        super.InitAfterLoad();
        if (!(this.formulainfo.formulatype == null || this.getSqlType() == 3 && this instanceof JetUSummary)) {
            if (DataTypeDef.isArray(this.formulainfo.formulatype.getDataType())) {
                int dataType = this.formulainfo.formulatype.getDataType();
                this.sqlType.set(DataTypeDef.FmlToSql(dataType - 11));
            } else {
                this.sqlType.set(DataTypeDef.FmlToSql(this.formulainfo.formulatype.getDataType()));
            }
        }
        if (this.getPrecision() == 0) {
            this.createProperties();
        }
        this.bParsedOK = this.formulainfo.parseOK;
    }

    public void FormulaModified() {
        JetUDatabase db = this.getDatabase();
        if (db != null) {
            db.FormulaModified();
        }
    }

    @Override
    public FormulaInfo getFormulaInfo() {
        return this.formulainfo;
    }

    @Override
    public void setResourceName(String strName) {
        super.setResourceName(strName);
        this.FormulaModified();
    }

    @Override
    public String getExpression() {
        return this.expr.get();
    }

    public void setExpression(String strExpr) {
        this.expr.set(strExpr);
        this.FormulaModified();
    }

    public int getSqlType() {
        return this.sqlType.get();
    }

    public void setSqlType(int iSQLType) {
        if (this.sqlType.get() != iSQLType) {
            this.setHAlignmentDefault(iSQLType);
            this.setVAlignmentDefault(iSQLType);
        }
        this.sqlType.set(iSQLType);
    }

    public int getPrecision() {
        return this.precision.get();
    }

    public void setPrecision(int iPrecision) {
        this.precision.set(iPrecision);
    }

    public int getLength() {
        return this.length.get();
    }

    public void setLength(int iLength) {
        this.length.set(iLength);
    }

    public int getScale() {
        return this.scale.get();
    }

    public void setScale(int iScale) {
        this.scale.set(iScale);
    }

    public int getRadix() {
        return this.radix.get();
    }

    public void setRadix(int iRadix) {
        this.radix.set(iRadix);
    }

    @Override
    public JetUDatabase getDatabase() {
        JetObject ret = this;
        while (!(ret instanceof JetUDatabase)) {
            if ((ret = (JetObject)((Object)ret.getParent())) != null) continue;
            return null;
        }
        return (JetUDatabase)ret;
    }

    public FormulaContainer getFormulaContainer() {
        JetObject ret = this;
        while (!(ret instanceof FormulaContainer)) {
            if ((ret = (JetObject)((Object)ret.getParent())) != null) continue;
            return null;
        }
        return (FormulaContainer)((Object)ret);
    }

    @Override
    public DbColDesc getColDesc() {
        if (this.formulainfo != null && this.formulainfo.parseOK) {
            int type = this.formulainfo.formulatype.getDataType();
            DbColDesc coldesc = new DbColDesc(this.getResourceName(), this.getSqlType(), this.getPrecision(), this.getScale(), 2);
            coldesc.setGroupable(this.formulainfo.formulatype.IsSum() && !this.formulainfo.isRefRunningTotal());
            this.addCaseSensitiveInfo(coldesc);
            this.addEncodingPattern(coldesc);
            coldesc.setArray(DataTypeDef.isArray(type));
            coldesc.setCurrency(DataTypeDef.isCurrency(type));
            return coldesc;
        }
        return null;
    }

    public void createProperties() {
        int[] iProperties = MappingSQLType.getColumnProperty(this.getSqlType());
        this.setPrecision(iProperties[0]);
        this.setScale(iProperties[2]);
    }

    public JetRptFormula createRptFormula() {
        if (this.rptFormula == null) {
            this.rptFormula = new JetRptFormula();
        }
        this.rptFormula.setDataSource(this.getFormulaContainer());
        this.rptFormula.setName(this.getResourceName());
        this.rptFormula.setExpression(this.getExpression());
        return this.rptFormula;
    }

    public boolean isParsedOK() {
        return this.bParsedOK;
    }

    public JetRptFormula getRptFormula() {
        if (this.rptFormula != null) {
            return this.rptFormula;
        }
        JetRptFormula formula2 = new JetRptFormula();
        formula2.setDataSource(this.getFormulaContainer());
        formula2.setName(this.getResourceName());
        formula2.setExpression(this.getExpression());
        formula2.setFormulaInfo(this.formulainfo);
        formula2.setColDesc(this.getColDesc());
        return formula2;
    }

    public void HandleRptFormula() {
        block4: {
            try {
                if (this.rptFormula.isparsedOK()) {
                    this.bParsedOK = true;
                    this.setFormulaType(this.rptFormula.getFormulaInfo(null));
                } else {
                    this.bParsedOK = false;
                    this.setFormulaType(null);
                }
            }
            catch (FormulaSyntaxErrorException e) {
                if (!logger.isErrorEnabled()) break block4;
                logger.error("", e);
            }
        }
        this.rptFormula = null;
    }

    public void setFormulaType(FormulaInfo formulainfo) {
        if (formulainfo == null) {
            this.formulainfo = new FormulaInfo();
        } else {
            formulainfo.copyTo(this.formulainfo);
            if (this.getSqlType() != 3 || !(this instanceof JetUSummary)) {
                if (DataTypeDef.isArray(this.formulainfo.formulatype.getDataType())) {
                    int dataType = formulainfo.formulatype.getDataType();
                    this.setSqlType(DataTypeDef.FmlToSql(dataType - 11));
                } else {
                    this.setSqlType(DataTypeDef.FmlToSql(formulainfo.formulatype.getDataType()));
                }
            }
        }
    }

    public boolean useSysVars() {
        return this.formulainfo.isSysVar();
    }

    public boolean isConstant() {
        if (this.formulainfo.formulatype != null) {
            return this.formulainfo.formulatype.getAttr() == 9;
        }
        return false;
    }

    public boolean isUsePageVars() {
        return this.formulainfo.isUsePageVar();
    }

    public Vector getRefDbFld() {
        return this.formulainfo.refDBfield;
    }

    public Vector getRefAllDbFld() {
        Vector ret = new Vector();
        ret.addAll(this.formulainfo.refDBfield);
        Vector formuls = this.formulainfo.refFormula;
        int size = formuls.size();
        for (int i = 0; i < size; ++i) {
            String formulaName = (String)formuls.get(i);
            JetUFormula formula2 = this.getDatabase().getFormulaByResourceName(formulaName);
            ret.addAll(formula2.getRefAllDbFld());
        }
        return ret;
    }

    @Override
    public Vector getRefFormuFld() {
        return this.formulainfo.refFormula;
    }

    public Vector getRefAllFormuFld() throws CannotFindEntity {
        Vector ret = new Vector();
        ret.addAll(this.formulainfo.refFormula);
        Vector formuls = this.formulainfo.refFormula;
        int size = formuls.size();
        for (int i = 0; i < size; ++i) {
            String formulaName = (String)formuls.get(i);
            JetUFormula formula2 = this.getDatabase().getFormulaByResourceName(formulaName);
            if (formula2 == null) {
                throw new CannotFindEntity(formulaName);
            }
            ret.addAll(formula2.getRefAllFormuFld());
        }
        return ret;
    }

    public Vector getRefParamFld() {
        return this.formulainfo.refParameter;
    }

    public Vector getRefAllParamFld() {
        Vector ret = new Vector();
        ret.addAll(this.formulainfo.refParameter);
        Vector formuls = this.formulainfo.refFormula;
        int size = formuls.size();
        for (int i = 0; i < size; ++i) {
            String formulaName = (String)formuls.get(i);
            JetUFormula formula2 = this.getDatabase().getFormulaByResourceName(formulaName);
            ret.addAll(formula2.getRefAllParamFld());
        }
        return ret;
    }

    public Vector getGroupByVector() {
        return this.formulainfo.GroupbyNames;
    }

    public boolean isGroupBy(String groupName) {
        return this.formulainfo.GroupbyNames.contains(groupName.toUpperCase());
    }

    public boolean isGroupBy() {
        return this.formulainfo.isGroupBy();
    }

    @Override
    public String getDefinition() {
        return "expression: " + this.getExpression();
    }

    @Override
    public String toString() {
        String strParam = "Formula [ " + this.getExpression() + " ]";
        return strParam;
    }

    public JetRptFormula createJetRptFormula() {
        JetRptFormula ret = this.createRptFormula();
        ret.setFormulaInfo(this.formulainfo);
        return ret;
    }

    public SqlwNode getSqlWhere() throws Exception {
        return this.formulainfo.root;
    }

    public boolean canSummary() {
        return this.isParsedOK() && !this.isConstant() && !this.formulainfo.isGlobal && !this.isGroupBy();
    }

    @Override
    public String getInstancePrefix() {
        return "Formula";
    }

    @Override
    public boolean isSimilar(JetUResourceEntity field) {
        return super.isSimilar(field) && this.sqlType.equal(((JetUFormula)field).sqlType) && this.expr.equal(((JetUFormula)field).expr);
    }

    @Override
    public boolean isSimilarExceptName(JetUResourceEntity field) {
        return super.isSimilarExceptName(field) && this.sqlType.equal(((JetUFormula)field).sqlType) && this.expr.equal(((JetUFormula)field).expr);
    }

    public JetRptFormula createNewJetRptFmlInstance() {
        JetRptFormula newFmlInstance = new JetRptFormula();
        newFmlInstance.setDataSource(this.getDatabase());
        newFmlInstance.setName(this.getResourceName());
        newFmlInstance.setExpression(this.getExpression());
        newFmlInstance.setFormulaInfo(this.formulainfo);
        newFmlInstance.setColDesc(this.getColDesc());
        return newFmlInstance;
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return grpDesc;
    }

    static {
        nameIdx.put("SQLType", new Integer(0));
        nameIdx.put("padding-right", new Integer(1));
        nameIdx.put("RightLine", new Integer(2));
        nameIdx.put("HorizontalAlignment", new Integer(3));
        nameIdx.put("Expression", new Integer(4));
        nameIdx.put("PatternStyle", new Integer(5));
        nameIdx.put("Format", new Integer(6));
        nameIdx.put("Precision", new Integer(7));
        nameIdx.put("Length", new Integer(8));
        nameIdx.put("Bold", new Integer(9));
        nameIdx.put("AutoFit", new Integer(10));
        nameIdx.put("Width", new Integer(11));
        nameIdx.put("formulainfo", new Integer(12));
        nameIdx.put("GUIField", new Integer(13));
        nameIdx.put("Height", new Integer(14));
        nameIdx.put("Radix", new Integer(15));
        nameIdx.put("padding-bottom", new Integer(16));
        nameIdx.put("Name", new Integer(17));
        nameIdx.put("ShadowColor", new Integer(18));
        nameIdx.put("BottomLine", new Integer(19));
        nameIdx.put("padding-top", new Integer(20));
        nameIdx.put("Description", new Integer(21));
        nameIdx.put("BorderWidth", new Integer(22));
        nameIdx.put("Background", new Integer(23));
        nameIdx.put("Scale", new Integer(24));
        nameIdx.put("DisplayWidth", new Integer(25));
        nameIdx.put("VerticalAlignment", new Integer(26));
        nameIdx.put("PatternColor", new Integer(27));
        nameIdx.put("TopLine", new Integer(28));
        nameIdx.put("FontSize", new Integer(29));
        nameIdx.put("Underline", new Integer(30));
        nameIdx.put("LeftLine", new Integer(31));
        nameIdx.put("FontFace", new Integer(32));
        nameIdx.put("Alignment", new Integer(33));
        nameIdx.put("padding-left", new Integer(34));
        nameIdx.put("WordWrap", new Integer(35));
        nameIdx.put("Italic", new Integer(36));
        nameIdx.put("StrikeOut", new Integer(37));
        nameIdx.put("BorderColor", new Integer(38));
        nameIdx.put("Foreground", new Integer(39));
        nameIdx.put("Shadow", new Integer(40));
        grpDesc = new HashVector(7);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "General";
        grpItems = new Vector<String>(11);
        grpItems.add("Name");
        grpItems.add("Description");
        grpItems.add("GUIField");
        grpItems.add("DisplayWidth");
        grpItems.add("SQLType");
        grpItems.add("Precision");
        grpItems.add("Scale");
        grpItems.add("Length");
        grpItems.add("Radix");
        grpItems.add("Expression");
        grpDesc.put(grpName, grpItems);
        grpName = "TextFormat";
        grpItems = new Vector(11);
        grpItems.add("FontFace");
        grpItems.add("FontSize");
        grpItems.add("Bold");
        grpItems.add("Italic");
        grpItems.add("StrikeOut");
        grpItems.add("Underline");
        grpItems.add("Format");
        grpItems.add("AutoFit");
        grpItems.add("WordWrap");
        grpItems.add("VerticalAlignment");
        grpItems.add("HorizontalAlignment");
        grpDesc.put(grpName, grpItems);
        grpName = "Padding";
        grpItems = new Vector(4);
        grpItems.add("padding-top");
        grpItems.add("padding-bottom");
        grpItems.add("padding-left");
        grpItems.add("padding-right");
        grpDesc.put(grpName, grpItems);
        grpName = "Geometry";
        grpItems = new Vector(2);
        grpItems.add("Width");
        grpItems.add("Height");
        grpDesc.put(grpName, grpItems);
        grpName = "Color";
        grpItems = new Vector(2);
        grpItems.add("Background");
        grpItems.add("Foreground");
        grpDesc.put(grpName, grpItems);
        grpName = "Border";
        grpItems = new Vector(8);
        grpItems.add("BorderWidth");
        grpItems.add("TopLine");
        grpItems.add("BottomLine");
        grpItems.add("LeftLine");
        grpItems.add("RightLine");
        grpItems.add("Shadow");
        grpItems.add("BorderColor");
        grpItems.add("ShadowColor");
        grpDesc.put(grpName, grpItems);
        grpName = "Pattern";
        grpItems = new Vector(2);
        grpItems.add("PatternColor");
        grpItems.add("PatternStyle");
        grpDesc.put(grpName, grpItems);
        grpName = "Others";
        grpItems = new Vector(1);
        grpItems.add("DataMappingFile");
        grpDesc.put(grpName, grpItems);
    }
}

