/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.datatypes.DataTypeUtils;
import java.util.HashMap;
import java.util.Vector;
import jet.connect.DbColDesc;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.universe.JetUConnection;
import jet.universe.JetUDBField;
import jet.universe.JetUHDSTable;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUResourceField;
import jet.universe.JetUTableView;
import jet.util.HashVector;

public class JetUHDSField
extends JetUResourceField
implements JetUDBField,
JetUQueriableField {
    public JetString colName;
    public JetNumber sqlType;
    public JetNumber precision;
    public JetString format;
    public JetNumber scale;
    public JetNumber nullable;
    public JetBoolean currency;
    public JetBoolean array;
    public JetString fullName;
    public JetBoolean attribute;
    private boolean bSelt = true;
    public static final String ATTEXTENSION = "_Att";
    private static final HashMap nameIdx = new HashMap(44);
    private static final HashVector grpDesc;

    public JetUHDSField() {
    }

    public JetUHDSField(String strName, String strDescription, String coluName, String sfullName, String sFormat, int iSQLType, int iPrecision, int iScale, int iNullable, boolean bCurrency, boolean isArray) {
        this(strName, strDescription, coluName, sfullName, sFormat, iSQLType, iPrecision, iScale, iNullable, bCurrency, false, isArray);
    }

    public JetUHDSField(String strName, String strDescription, String coluName, String sfullName, String sFormat, int iSQLType, int iPrecision, int iScale, int iNullable, boolean bCurrency, boolean att, boolean isArray) {
        super(strName, strDescription);
        this.colName.set(coluName);
        this.sqlType.set(iSQLType);
        this.sqlType.setPropertyChoice(DataTypeUtils.getSQLTypeChoiceVector());
        this.sqlType.setEditorType(JetProperty.COMBO_EDITOR);
        this.precision.set(iPrecision);
        this.scale.set(iScale);
        this.nullable.set(iNullable);
        this.nullable.setPropertyChoice(DataTypeUtils.getNullableChoiceVector());
        this.nullable.setEditorType(JetProperty.COMBO_EDITOR);
        this.currency.set(bCurrency);
        this.format.set(sFormat);
        this.attribute.set(att);
        this.fullName.set(sfullName);
        this.array.set(isArray);
        this.setHAlignmentDefault(iSQLType);
        this.setVAlignmentDefault(iSQLType);
        this.setFormatDefault(iSQLType);
    }

    @Override
    void init() {
        super.init();
        this.fullName = new JetString(this, "FullName");
        this.colName = new JetString(this, "ColumnName");
        this.format = new JetString(this, "HDSFormat");
        this.sqlType = new JetNumber(this, "SQLType");
        this.sqlType.setPropertyChoice(DataTypeUtils.getSQLTypeChoiceVector());
        this.sqlType.setEditorType(JetProperty.COMBO_EDITOR);
        this.precision = new JetNumber(this, "Precision");
        this.scale = new JetNumber(this, "Scale");
        this.nullable = new JetNumber(this, "Nullable");
        this.nullable.setPropertyChoice(DataTypeUtils.getNullableChoiceVector());
        this.nullable.setEditorType(JetProperty.COMBO_EDITOR);
        this.currency = new JetBoolean(this, "Currency", false);
        this.attribute = new JetBoolean(this, "Attribute", false);
        this.array = new JetBoolean(this, "Array", false);
        this.fullName.setEditFlag(0);
    }

    public void setPropValue(JetUHDSField fld) {
        this.colName.set(fld.getFldName());
        this.sqlType.set(fld.getSqlType());
        this.precision.set(fld.getPrecision());
        this.scale.set(fld.getScale());
        this.nullable.set(fld.getNullable());
        this.currency.set(fld.isCurrency());
        this.format.set(fld.getFormat());
        this.attribute.set(fld.isAttribute());
        this.fullName.set(fld.getFullName());
        this.array.set(fld.isArray());
        this.setDesc(fld.getDesc());
        this.setHAlignmentDefault(fld.getSqlType());
        this.setVAlignmentDefault(fld.getSqlType());
        this.setFormatDefault(fld.getSqlType());
    }

    @Override
    public JetUQueriable getQueriable() {
        return this.getHDS();
    }

    public JetUHDSTable getHDS() {
        JetUHDSTable parent = (JetUHDSTable)this.getParent();
        if (parent != null) {
            if (parent instanceof JetUHierDataSource) {
                return parent;
            }
            while (parent != null) {
                if (!((parent = (JetUHDSTable)parent.getParent()) instanceof JetUHierDataSource)) continue;
                return parent;
            }
        }
        return parent;
    }

    @Override
    public String getQueriableName() {
        JetUHierDataSource jetHDS = (JetUHierDataSource)this.getQueriable();
        if (jetHDS != null) {
            return jetHDS.getResourceName();
        }
        return null;
    }

    public String getParentName() {
        JetUHDSTable uJetHDS = (JetUHDSTable)this.getParent();
        if (uJetHDS != null) {
            return uJetHDS.getResourceName();
        }
        return null;
    }

    public void setFullName(String fName) {
        this.fullName.set(fName);
    }

    public String getFullName() {
        return this.fullName.get();
    }

    public void setFldName(String strColName) {
        this.colName.set(strColName);
    }

    @Override
    public String getFldName() {
        return this.colName.get();
    }

    @Override
    public int getSqlType() {
        return this.sqlType.get();
    }

    public void setSqlType(int iSQLType) {
        this.sqlType.set(iSQLType);
        this.setHAlignmentDefault(iSQLType);
        this.setVAlignmentDefault(iSQLType);
    }

    public int getPrecision() {
        return this.precision.get();
    }

    public void setPrecision(int iPrecision) {
        this.precision.set(iPrecision);
    }

    public int getScale() {
        return this.scale.get();
    }

    public void setScale(int iScale) {
        this.scale.set(iScale);
    }

    public int getNullable() {
        return this.nullable.get();
    }

    public void setNullable(int iNullable) {
        this.nullable.set(iNullable);
    }

    public void setFormat(String sFormat) {
        this.format.set(sFormat);
    }

    public String getFormat() {
        return this.format.get();
    }

    public void setCurrency(boolean bCurrency) {
        this.currency.set(bCurrency);
    }

    public boolean isCurrency() {
        return this.currency.get();
    }

    public void setAttribute(boolean att) {
        this.attribute.set(att);
    }

    public boolean isAttribute() {
        return this.attribute.get();
    }

    public void setSelect(boolean s) {
        this.bSelt = s;
    }

    public boolean isSelect() {
        return this.bSelt;
    }

    public void setArray(boolean s) {
        this.array.set(s);
    }

    public boolean isArray() {
        return this.array.get();
    }

    @Override
    public DbColDesc getColDesc() {
        DbColDesc dcd = new DbColDesc(this.getFldName(), this.getSqlType(), this.getPrecision(), this.getScale(), this.getNullable(), this.isCurrency());
        dcd.setArray(this.isArray());
        this.addCaseSensitiveInfo(dcd);
        this.addEncodingPattern(dcd);
        return dcd;
    }

    @Override
    public String getTableName() {
        return null;
    }

    @Override
    public JetUTableView getTable() {
        return null;
    }

    @Override
    public String getDefinition() {
        return null;
    }

    @Override
    public String toString() {
        String strParam = "HDS Column[" + this.getResourceName() + "|" + this.getParentName() + "|" + this.getFldName() + " ]";
        return strParam;
    }

    public void remove() {
        JetUHDSTable p = (JetUHDSTable)this.getParent();
        p.remove(this);
    }

    public JetUHDSField cloneEntity() {
        JetUHDSField fld = new JetUHDSField();
        JetObject.copyProperties(fld, this);
        return fld;
    }

    @Override
    public String getInstancePrefix() {
        return "HDSField";
    }

    @Override
    public boolean isSimilar(JetUResourceEntity field) {
        boolean bRet = super.isSimilar(field) && this.colName.equal(((JetUHDSField)field).colName) && this.array.equal(((JetUHDSField)field).array) && this.sqlType.equal(((JetUHDSField)field).sqlType) && this.fullName.equal(((JetUHDSField)field).fullName);
        return bRet;
    }

    @Override
    public boolean isSimilarExceptName(JetUResourceEntity field) {
        boolean bRet = super.isSimilarExceptName(field) && this.colName.equal(((JetUHDSField)field).colName) && this.array.equal(((JetUHDSField)field).array) && this.sqlType.equal(((JetUHDSField)field).sqlType) && this.fullName.equal(((JetUHDSField)field).fullName);
        return bRet;
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return grpDesc;
    }

    @Override
    public JetUConnection getConnection() {
        return null;
    }

    static {
        nameIdx.put("SQLType", new Integer(0));
        nameIdx.put("padding-right", new Integer(1));
        nameIdx.put("RightLine", new Integer(2));
        nameIdx.put("HorizontalAlignment", new Integer(3));
        nameIdx.put("PatternStyle", new Integer(4));
        nameIdx.put("Format", new Integer(5));
        nameIdx.put("Precision", new Integer(6));
        nameIdx.put("Bold", new Integer(7));
        nameIdx.put("Attribute", new Integer(8));
        nameIdx.put("HDSFormat", new Integer(9));
        nameIdx.put("AutoFit", new Integer(10));
        nameIdx.put("Width", new Integer(11));
        nameIdx.put("GUIField", new Integer(12));
        nameIdx.put("Height", new Integer(13));
        nameIdx.put("padding-bottom", new Integer(14));
        nameIdx.put("Array", new Integer(15));
        nameIdx.put("Name", new Integer(16));
        nameIdx.put("FullName", new Integer(17));
        nameIdx.put("ShadowColor", new Integer(18));
        nameIdx.put("BottomLine", new Integer(19));
        nameIdx.put("padding-top", new Integer(20));
        nameIdx.put("Description", new Integer(21));
        nameIdx.put("BorderWidth", new Integer(22));
        nameIdx.put("Background", new Integer(23));
        nameIdx.put("Scale", new Integer(24));
        nameIdx.put("DisplayWidth", new Integer(25));
        nameIdx.put("VerticalAlignment", new Integer(26));
        nameIdx.put("PatternColor", new Integer(27));
        nameIdx.put("TopLine", new Integer(28));
        nameIdx.put("FontSize", new Integer(29));
        nameIdx.put("Underline", new Integer(30));
        nameIdx.put("LeftLine", new Integer(31));
        nameIdx.put("Nullable", new Integer(32));
        nameIdx.put("ColumnName", new Integer(33));
        nameIdx.put("FontFace", new Integer(34));
        nameIdx.put("Alignment", new Integer(35));
        nameIdx.put("padding-left", new Integer(36));
        nameIdx.put("WordWrap", new Integer(37));
        nameIdx.put("Italic", new Integer(38));
        nameIdx.put("StrikeOut", new Integer(39));
        nameIdx.put("BorderColor", new Integer(40));
        nameIdx.put("Currency", new Integer(41));
        nameIdx.put("Foreground", new Integer(42));
        nameIdx.put("Shadow", new Integer(43));
        grpDesc = new HashVector(7);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "General";
        grpItems = new Vector<String>(13);
        grpItems.add("Name");
        grpItems.add("Description");
        grpItems.add("GUIField");
        grpItems.add("DisplayWidth");
        grpItems.add("FullName");
        grpItems.add("ColumnName");
        grpItems.add("HDSFormat");
        grpItems.add("SQLType");
        grpItems.add("Precision");
        grpItems.add("Scale");
        grpItems.add("Nullable");
        grpItems.add("Currency");
        grpItems.add("Array");
        grpDesc.put(grpName, grpItems);
        grpName = "TextFormat";
        grpItems = new Vector(11);
        grpItems.add("FontFace");
        grpItems.add("FontSize");
        grpItems.add("Bold");
        grpItems.add("Italic");
        grpItems.add("StrikeOut");
        grpItems.add("Underline");
        grpItems.add("Format");
        grpItems.add("AutoFit");
        grpItems.add("WordWrap");
        grpItems.add("VerticalAlignment");
        grpItems.add("HorizontalAlignment");
        grpDesc.put(grpName, grpItems);
        grpName = "Padding";
        grpItems = new Vector(4);
        grpItems.add("padding-top");
        grpItems.add("padding-bottom");
        grpItems.add("padding-left");
        grpItems.add("padding-right");
        grpDesc.put(grpName, grpItems);
        grpName = "Geometry";
        grpItems = new Vector(2);
        grpItems.add("Width");
        grpItems.add("Height");
        grpDesc.put(grpName, grpItems);
        grpName = "Color";
        grpItems = new Vector(2);
        grpItems.add("Background");
        grpItems.add("Foreground");
        grpDesc.put(grpName, grpItems);
        grpName = "Border";
        grpItems = new Vector(8);
        grpItems.add("BorderWidth");
        grpItems.add("TopLine");
        grpItems.add("BottomLine");
        grpItems.add("LeftLine");
        grpItems.add("RightLine");
        grpItems.add("Shadow");
        grpItems.add("BorderColor");
        grpItems.add("ShadowColor");
        grpDesc.put(grpName, grpItems);
        grpName = "Pattern";
        grpItems = new Vector(2);
        grpItems.add("PatternColor");
        grpItems.add("PatternStyle");
        grpDesc.put(grpName, grpItems);
    }
}

