/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.log.JRLogger;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormula;
import jet.universe.JetUHDSField;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUParameter;
import jet.universe.JetUQueriable;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUUniverse;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.JBusinessView;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.FormulaHasGrammarError;
import jet.xml.model.ElementNode;

public class JetUHDSTable
extends JetUResourceContainer
implements JetUQueriable {
    public JetNumber maxRows = new JetNumber(this, "maxRows");
    public JetNumber maxDuration = new JetNumber(this, "maxDuration");
    public JetString fullName = new JetString(this, "FullName");
    public JetBoolean att = new JetBoolean(this, "Attributes", false);
    public JetNumber pushDownGroupQuery = new JetNumber(this, "PushDownGroupQuery", 0);
    private static JRLogger logger = JRLogger.getLogger(JetUHDSTable.class.getName());
    private static final HashMap nameIdx = new HashMap(6);

    public JetUHDSTable() {
        this.pushDownGroupQuery.setEditorType(JetNumber.CHOICE_EDITOR);
        Vector<String> v = new Vector<String>();
        v.add(String.valueOf(0));
        v.add(String.valueOf(1));
        v.add(String.valueOf(2));
        this.pushDownGroupQuery.setPropertyChoice(v);
        this.pushDownGroupQuery.enableAllChangeBys(false);
        this.setPropEdit();
    }

    public JetUHDSTable(String name2, String description) {
        this(name2, description, "");
    }

    public JetUHDSTable(String name2, String description, String fullName) {
        super(name2, description);
        this.pushDownGroupQuery.setEditorType(JetNumber.CHOICE_EDITOR);
        Vector<String> v = new Vector<String>();
        v.add(String.valueOf(0));
        v.add(String.valueOf(1));
        v.add(String.valueOf(2));
        this.pushDownGroupQuery.setPropertyChoice(v);
        this.pushDownGroupQuery.enableAllChangeBys(false);
        this.fullName.set(fullName);
        this.setPropEdit();
    }

    public JetUHDSTable(ElementNode elt) {
        this(elt.getName(), "");
        this.fullName.set(ElementNode.getFullPath(elt));
        this.setPropEdit();
    }

    private void setPropEdit() {
        this.fullName.setEditFlag(0);
    }

    @Override
    public int getTransactionIsolation() {
        return 0;
    }

    @Override
    public int getReadOnly() {
        return 1;
    }

    @Override
    public Vector getAutoGroupFields() {
        return null;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows.set(maxRows);
    }

    @Override
    public int getMaxRows() {
        return this.maxRows.get();
    }

    public void setMaxDuration(int maxDuration) {
        this.maxDuration.set(maxDuration);
    }

    @Override
    public int getMaxDuration() {
        return this.maxDuration.get();
    }

    public void setFullName(String fullPath) {
        this.fullName.set(fullPath);
    }

    public String getFullName() {
        return this.fullName.get();
    }

    public String getRealName() {
        String fName = this.getFullName();
        return fName.substring(fName.lastIndexOf(ElementNode.pathDelimer) + 1);
    }

    public JetUHDSTable getHDSRoot() {
        JetUHDSTable parent;
        if (this instanceof JetUHierDataSource) {
            return this;
        }
        for (parent = (JetUHDSTable)this.getParent(); parent != null; parent = (JetUHDSTable)parent.getParent()) {
            if (!(parent instanceof JetUHierDataSource)) continue;
            return parent;
        }
        return parent;
    }

    public void addColumn(JetUHDSField uHDSLeaf) {
        this.add(uHDSLeaf);
        uHDSLeaf.InitAfterCreate();
    }

    public void addTable(JetUHDSTable branch) {
        this.add(branch);
        branch.InitAfterCreate();
    }

    public Vector getColumns() {
        Vector<JetObject> ret = new Vector<JetObject>();
        Enumeration children = this.getChildren().elements();
        while (children.hasMoreElements()) {
            JetObject hds = (JetObject)children.nextElement();
            if (!(hds instanceof JetUHDSField)) continue;
            ret.add(hds);
        }
        return ret;
    }

    public Vector getTables() {
        Vector<JetObject> ret = new Vector<JetObject>();
        Enumeration children = this.getChildren().elements();
        while (children.hasMoreElements()) {
            JetObject hds = (JetObject)children.nextElement();
            if (!(hds instanceof JetUHDSTable)) continue;
            ret.add(hds);
        }
        return ret;
    }

    public Vector getNoAttribTables() {
        Vector<JetObject> ret = new Vector<JetObject>();
        Enumeration children = this.getChildren().elements();
        while (children.hasMoreElements()) {
            JetObject hds = (JetObject)children.nextElement();
            if (!(hds instanceof JetUHDSTable) || ((JetUHDSTable)hds).isAttrib()) continue;
            ret.add(hds);
        }
        return ret;
    }

    @Override
    public Vector getFields() {
        return this.getColumns();
    }

    public boolean isAttrib() {
        return this.att.get();
    }

    @Override
    public JetUResourceEntity getFieldByResourceName(String fldName) {
        Vector vecChildren = this.getChildren();
        int iSize = vecChildren.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)vecChildren.elementAt(i);
            if (!(child instanceof JetUHDSField) || !((JetUHDSField)child).getResourceName().equalsIgnoreCase(fldName)) continue;
            return (JetUHDSField)child;
        }
        return null;
    }

    public JetUHDSTable getTableByResourceName(String name2) {
        Vector tables = this.getTables();
        for (int j = 0; j < tables.size(); ++j) {
            JetUHDSTable tbl = (JetUHDSTable)tables.elementAt(j);
            if (!tbl.getResourceName().equalsIgnoreCase(name2)) continue;
            return tbl;
        }
        return null;
    }

    @Override
    public String getSQLString() {
        return null;
    }

    @Override
    public String getFullSQLString() {
        return this.getSQLString();
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse unvs, String mappingname) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        return this.isFieldValidToQuery(unvs, mappingname, "");
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse unvs, String mappingname, String dataSourceName) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        JetUResourceEntity en;
        JetUResourceEntity entity = unvs.getResourceByName(dataSourceName, this.getResourceName(), mappingname);
        if (entity == null && (en = unvs.getAnyResourceByName(mappingname)) != null && en instanceof JetUParameter) {
            entity = en;
        }
        if (entity == null) {
            throw new CannotFindEntity(mappingname);
        }
        return this.isFieldValidToQuery(unvs, entity, dataSourceName);
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse unvs, JetUResourceEntity re) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        return this.isFieldValidToQuery(unvs, re, "");
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse unvs, JetUResourceEntity re, String dataSourceName) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        boolean bRet = false;
        if (re instanceof JetUParameter) {
            bRet = true;
        } else if (re instanceof JetUFormula) {
            bRet = this.isFormulaValidToQuery((JetUFormula)re, unvs, dataSourceName);
        } else if (re instanceof JetUHDSField) {
            bRet = ((JetUHDSField)re).getHDS() == this;
        }
        return bRet;
    }

    public boolean isFormulaValidToQuery(JetUFormula uFormula, JetUUniverse universe, String dataSourceName) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        Vector dbFlds = uFormula.getRefDbFld();
        if (dbFlds != null) {
            int iCount = dbFlds.size();
            for (int i = 0; i < iCount; ++i) {
                String name2 = (String)dbFlds.elementAt(i);
                try {
                    if (this.isFieldValidToQuery(universe, name2, dataSourceName)) continue;
                    return false;
                }
                catch (CannotFindEntity e) {
                    throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name2);
                }
            }
        }
        Vector refFormulas = uFormula.getRefFormuFld();
        int iSize = refFormulas.size();
        for (int i = 0; i < iSize; ++i) {
            String name3 = (String)refFormulas.elementAt(i);
            try {
                if (this.isFieldValidToQuery(universe, name3, dataSourceName)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name3);
            }
        }
        Vector groups = uFormula.getGroupByVector();
        iSize = groups.size();
        for (int i = 0; i < iSize; ++i) {
            String name4 = (String)groups.elementAt(i);
            if (uFormula instanceof JetUSummary && JetUDatabase.isDigital(name4)) continue;
            try {
                if (name4.equalsIgnoreCase("Report") || this.isFieldValidToQuery(universe, name4, dataSourceName)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name4);
            }
        }
        return true;
    }

    public JetUHDSField getFieldByPathString(String strPath) {
        Vector vecFields = this.getColumns();
        int iSize = vecFields.size();
        JetUHDSField field = null;
        for (int i = 0; i < iSize; ++i) {
            field = (JetUHDSField)vecFields.elementAt(i);
            String sFullPath = field.getFullName();
            if (!sFullPath.equals(strPath)) continue;
            return field;
        }
        return null;
    }

    public Hashtable getAllFields(Hashtable flds) {
        Enumeration tabls = this.getTables().elements();
        Enumeration cols = this.getColumns().elements();
        while (cols.hasMoreElements()) {
            JetUHDSField col = (JetUHDSField)cols.nextElement();
            if (col.isAttribute()) {
                flds.put(col.getFullName() + "_Att", col);
                continue;
            }
            flds.put(col.getFullName(), col);
        }
        while (tabls.hasMoreElements()) {
            JetUHDSTable tbl = (JetUHDSTable)tabls.nextElement();
            tbl.getAllFields(flds);
        }
        return flds;
    }

    public JetUHDSTable findTablebyName(String fullName) {
        Vector tbls = this.getTables();
        JetUHDSTable tbl = null;
        int idx = fullName.indexOf(".");
        for (int i = 0; i < tbls.size(); ++i) {
            tbl = (JetUHDSTable)tbls.elementAt(i);
            if (idx > -1) {
                if (!tbl.getRealName().equalsIgnoreCase(fullName.substring(0, idx))) continue;
                tbl = tbl.findTablebyName(fullName.substring(idx + 1));
                return tbl;
            }
            if (!tbl.getRealName().equalsIgnoreCase(fullName)) continue;
            return tbl;
        }
        return null;
    }

    public String getMappingName(String strRealName, JetUHDSTable parent) {
        String realName;
        StringBuffer error = new StringBuffer();
        JetUDatabase db = this.getDatabase();
        String strTemp = null;
        String strMappingName = realName = strRealName == null ? "fw" : strRealName;
        boolean bIsOK = db.IsMappingNameOK(strMappingName, error);
        int i = 1;
        if (!bIsOK) {
            strMappingName = parent != null ? parent.getResourceName() + "_" + realName : this.getResourceName() + "_" + realName;
            bIsOK = db.IsMappingNameOK(strMappingName, error);
        }
        strTemp = strMappingName;
        while (!bIsOK) {
            strMappingName = strTemp + i++;
            bIsOK = db.IsMappingNameOK(strMappingName, error);
        }
        return strMappingName;
    }

    public Vector getMappingNames(String strRealName, JetUHDSTable parent, int count) {
        StringBuffer error = new StringBuffer();
        JetUDatabase db = this.getDatabase();
        Vector<String> ret = new Vector<String>();
        int j = 0;
        for (int i = 0; i < count; ++i) {
            String strMappingName = strRealName + "_" + j;
            while (!db.IsMappingNameOK(strMappingName, error) || ret.contains(strMappingName)) {
                strMappingName = strRealName + "_" + ++j;
            }
            ret.addElement(strMappingName);
        }
        return ret;
    }

    public void cloneChildren(JetUHDSTable tbl) {
        Enumeration cols = this.getColumns().elements();
        while (cols.hasMoreElements()) {
            JetUHDSField fld = ((JetUHDSField)cols.nextElement()).cloneEntity();
            tbl.add(fld);
        }
        Enumeration tabls = this.getTables().elements();
        while (tabls.hasMoreElements()) {
            JetUHDSTable _tbl = ((JetUHDSTable)tabls.nextElement()).cloneEntity();
            tbl.add(_tbl);
        }
    }

    public JetUHDSTable cloneEntity() {
        JetUHDSTable tbl = new JetUHDSTable(this.getResourceName(), this.getDesc());
        tbl.setMaxRows(this.getMaxRows());
        tbl.setMaxDuration(this.getMaxDuration());
        tbl.setFullName(this.getFullName());
        this.cloneChildren(tbl);
        JetObject.copyProperties(tbl, this);
        return tbl;
    }

    @Override
    public boolean isEqualChildren(JetUResourceContainer that) {
        boolean bRet = that instanceof JetUHDSTable;
        if (bRet) {
            Vector thatFlds = ((JetUHDSTable)that).getFields();
            Vector thisFlds = this.getFields();
            if (thatFlds.size() >= thisFlds.size()) {
                for (int i = 0; i < thisFlds.size(); ++i) {
                    JetUHDSField thisFld = (JetUHDSField)thisFlds.elementAt(i);
                    if (JetUHDSTable.findNodeByName(thatFlds, thisFld.getResourceName()) != null) continue;
                    bRet = false;
                    break;
                }
            } else {
                bRet = false;
            }
            if (bRet) {
                Vector thatTbls = ((JetUHDSTable)that).getTables();
                Vector thisTbls = this.getTables();
                if (thatTbls.size() >= thisTbls.size()) {
                    for (int j = 0; j < thisTbls.size(); ++j) {
                        JetUHDSTable thisTbl = (JetUHDSTable)thisTbls.elementAt(j);
                        if (JetUHDSTable.findNodeByName(thatTbls, thisTbl.getResourceName()) != null) continue;
                        bRet = false;
                        break;
                    }
                } else {
                    bRet = false;
                }
            }
        }
        return bRet;
    }

    public boolean hasSibling() {
        JetUHDSTable parent = (JetUHDSTable)this.getParent();
        if (parent == null) {
            return false;
        }
        return parent.getTables().size() > 1;
    }

    @Override
    public String toString() {
        return this.getResourceName();
    }

    @Override
    public String getInstancePrefix() {
        return "HDSTable";
    }

    @Override
    public boolean isSimilar(JetUResourceContainer container) {
        return super.isSimilar(container) && this.att.equal(((JetUHDSTable)container).att);
    }

    @Override
    public JBusinessLogic getBL() {
        return null;
    }

    @Override
    public JBusinessView getBV() {
        return null;
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse unvs, String mappingname, String dataSourceName, Map<String, String> refFldOfFml) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        JetUResourceEntity en;
        JetUResourceEntity entity = unvs.getResourceByName(dataSourceName, this.getResourceName(), mappingname);
        if (entity == null && (en = unvs.getAnyResourceByName(mappingname)) != null && en instanceof JetUParameter) {
            entity = en;
        }
        if (entity == null) {
            throw new CannotFindEntity(mappingname);
        }
        return this.isFieldValidToQuery(unvs, entity, dataSourceName, refFldOfFml);
    }

    private boolean isFieldValidToQuery(JetUUniverse unvs, JetUResourceEntity entity, String dataSourceName, Map<String, String> refFldOfFml) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        boolean bRet = false;
        if (entity instanceof JetUParameter) {
            bRet = true;
        } else if (entity instanceof JetUFormula) {
            bRet = this.isFormulaValidToQuery((JetUFormula)entity, unvs, dataSourceName, refFldOfFml);
        } else if (entity instanceof JetUHDSField) {
            bRet = ((JetUHDSField)entity).getHDS() == this;
        }
        return bRet;
    }

    private boolean isFormulaValidToQuery(JetUFormula uFormula, JetUUniverse universe, String dataSourceName, Map<String, String> refFldOfFml) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        Vector dbFlds = uFormula.getRefDbFld();
        if (dbFlds != null) {
            int iCount = dbFlds.size();
            for (int i = 0; i < iCount; ++i) {
                String name2 = (String)dbFlds.elementAt(i);
                try {
                    if (this.isFieldValidToQuery(universe, name2, dataSourceName, refFldOfFml)) continue;
                    return false;
                }
                catch (CannotFindEntity e) {
                    throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name2);
                }
            }
        }
        Vector refFormulas = uFormula.getRefFormuFld();
        int iSize = refFormulas.size();
        for (int i = 0; i < iSize; ++i) {
            String name3 = (String)refFormulas.elementAt(i);
            try {
                if (this.isFieldValidToQuery(universe, name3, dataSourceName, refFldOfFml)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name3);
            }
        }
        Vector groups = uFormula.getGroupByVector();
        iSize = groups.size();
        for (int i = 0; i < iSize; ++i) {
            String name4 = (String)groups.elementAt(i);
            if (uFormula instanceof JetUSummary && JetUDatabase.isDigital(name4)) continue;
            try {
                if (name4.equalsIgnoreCase("Report") || this.isFieldValidToQuery(universe, name4, dataSourceName, refFldOfFml)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name4);
            }
        }
        return true;
    }

    @Override
    public int isPushDownGroupQuery() {
        return 2;
    }

    @Override
    public boolean canPushdownSort(String fieldMappingName) {
        return false;
    }

    @Override
    public JetUConnection[] getConnections() {
        return new JetUConnection[0];
    }

    static {
        nameIdx.put("Description", new Integer(0));
        nameIdx.put("maxRows", new Integer(1));
        nameIdx.put("Name", new Integer(2));
        nameIdx.put("maxDuration", new Integer(3));
        nameIdx.put("Attributes", new Integer(4));
        nameIdx.put("FullName", new Integer(5));
    }
}

