/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.dataservice.expression.unchecked.UnCheckedOperatorImpl;
import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetContainable;
import jet.controls.JetObject;
import jet.controls.JetVector;
import jet.dataengine.api.expression.ConditionException;
import jet.dataengine.api.expression.ExpressionFactoryCreator;
import jet.dataengine.api.expression.IExpression;
import jet.dataengine.api.expression.IExpressionFactory;
import jet.dataengine.api.expression.tuple.IUnCheckedBinaryExpression;
import jet.dataengine.api.expression.variable.IUnCheckedVariableExpression;
import jet.universe.JetUWhereFormula;
import jet.universe.businesslogic.filter.UFilterExpression;
import jet.universe.businesslogic.filter.convert.IExpression2Jet;
import jet.universe.businesslogic.filter.convert.Jet2IExpression;
import jet.util.HashVector;

public class JetUHDSWhereFormula
extends JetUWhereFormula
implements JetContainable {
    public JetVector conditions = new JetVector(this, "Conditions");
    Vector children = new Vector();
    private static final String delim1 = "[@']";
    private static final String delim2 = "['$]";
    private static final HashMap nameIdx = new HashMap(42);
    private static final HashVector grpDesc;

    public JetUHDSWhereFormula() {
    }

    public JetUHDSWhereFormula(String strName, String strDesc, String strExpression, IExpression conditions) {
        super(strName, strDesc, strExpression);
        this.fillCondition(conditions);
    }

    public JetUHDSWhereFormula(String strName, String strDesc, String strExpression) {
        super(strName, strDesc, strExpression);
    }

    public void fillCondition(IExpression conds) {
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            Object ob = this.children.get(i);
            if (!(ob instanceof UFilterExpression)) continue;
            this.children.remove(ob);
            break;
        }
        IExpression2Jet itoj = new IExpression2Jet();
        UFilterExpression condition = null;
        try {
            condition = itoj.convert(conds);
        }
        catch (ConditionException e) {
            // empty catch block
        }
        this.add(condition);
        condition.setParent(this);
    }

    public IExpression getConditions() {
        if (this.children.size() == 0) {
            this.afterInit();
        }
        Jet2IExpression jtoi = new Jet2IExpression();
        IExpression ret = null;
        try {
            ret = jtoi.convert((UFilterExpression)this.children.get(0), null, null, null);
        }
        catch (ConditionException conditionException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public void afterInit() {
        super.afterInit();
        if (this.children.size() != 0) {
            return;
        }
        Vector vGrps = JetUHDSWhereFormula.getConds(this.conditions);
        IUnCheckedBinaryExpression expTopTree = null;
        try {
            IExpressionFactory expFactory = ExpressionFactoryCreator.getIExpressionFactory();
            Vector grp = null;
            String[] rec = null;
            String grpTopLogic = null;
            int size = vGrps.size();
            for (int i = 0; i < size; ++i) {
                grp = (Vector)vGrps.elementAt(i);
                String grpLogic = null;
                IUnCheckedBinaryExpression expTree = null;
                int size2 = grp.size();
                for (int j = 0; j < size2; ++j) {
                    rec = (String[])grp.elementAt(j);
                    IUnCheckedVariableExpression exp0 = expFactory.createUnCheckedVariableExpression(rec[0]);
                    UnCheckedOperatorImpl op = new UnCheckedOperatorImpl(rec[1]);
                    IUnCheckedVariableExpression exp2 = expFactory.createUnCheckedVariableExpression(rec[2]);
                    IUnCheckedBinaryExpression condition = expFactory.createUnCheckedBinaryExpression(op, exp0, exp2);
                    expTree = expTree == null ? condition : expFactory.createUnCheckedBinaryExpression(new UnCheckedOperatorImpl(grpLogic), expTree, condition);
                    grpLogic = rec[3];
                }
                expTopTree = expTopTree == null ? expTree : expFactory.createUnCheckedBinaryExpression(new UnCheckedOperatorImpl(grpTopLogic), expTopTree, expTree);
                grpTopLogic = grpLogic;
            }
        }
        catch (ConditionException conditionException) {
            // empty catch block
        }
        this.fillCondition(expTopTree);
    }

    public static Vector getConds(JetVector conditions) {
        Vector<Object> conds = new Vector<Object>();
        Vector jconds = conditions.get();
        if (jconds == null || jconds.size() == 0) {
            return conds;
        }
        int sz1 = jconds.size();
        String subcon = new String();
        String delim = new String();
        Vector<String[]> grp = new Vector<String[]>();
        for (int i = 0; i < sz1; ++i) {
            subcon = (String)jconds.elementAt(i);
            Vector v1 = JetUHDSWhereFormula.splitString(subcon, delim1);
            for (int j = 0; j < v1.size(); ++j) {
                String expr = (String)v1.elementAt(j);
                Vector v2 = JetUHDSWhereFormula.splitString(expr, delim2);
                String[] rec = new String[]{"", "", "", ""};
                for (int k = 0; k < v2.size() && k < 4; ++k) {
                    rec[k] = (String)v2.elementAt(k);
                }
                grp.addElement(rec);
            }
            conds.addElement(grp.clone());
            grp.removeAllElements();
        }
        return conds;
    }

    private static Vector splitString(String str, String delim) {
        int index2;
        if (str == null || str.length() == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        String rec = new String();
        if (str.indexOf(delim) == -1) {
            v.addElement(str.substring(0));
            return v;
        }
        int index1 = 0;
        do {
            if ((rec = (index2 = str.indexOf(delim, index1)) == -1 ? str.substring(index1) : str.substring(index1, index2)) == null || rec.length() == 0) continue;
            v.addElement(rec);
        } while (str.indexOf(delim, index1 = index2 + delim.length()) != -1);
        return v;
    }

    @Override
    public JetUWhereFormula cloneEntity() {
        JetUHDSWhereFormula newFormula = new JetUHDSWhereFormula(this.getResourceName(), this.getDesc(), this.getExpression());
        newFormula.fillCondition(this.getConditions());
        newFormula.rptFormula = this.getRptFormula();
        newFormula.HandleRptFormula();
        newFormula.createProperties();
        return newFormula;
    }

    @Override
    public String getInstancePrefix() {
        return "HDSWhereFormula";
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return grpDesc;
    }

    @Override
    public Vector getChildren() {
        return (Vector)this.children.clone();
    }

    @Override
    public JetObject add(JetObject child) {
        this.children.add(child);
        return child;
    }

    @Override
    public JetObject remove(JetObject child) {
        this.objectModified();
        if (this.children.contains(child)) {
            this.children.removeElement(child);
            child.setParent(null);
        }
        return child;
    }

    @Override
    public void broadcast(JetObject sender, int iMessage) {
        int iSize = this.children.size();
        int iIndex = 0;
        while (iIndex < iSize) {
            JetObject xobj;
            if ((xobj = (JetObject)this.children.elementAt(iIndex++)).equals(sender) || !(xobj instanceof JetContainable)) continue;
            ((JetContainable)((Object)xobj)).broadcast(sender, iMessage);
        }
    }

    static {
        nameIdx.put("SQLType", new Integer(0));
        nameIdx.put("padding-right", new Integer(1));
        nameIdx.put("RightLine", new Integer(2));
        nameIdx.put("HorizontalAlignment", new Integer(3));
        nameIdx.put("Expression", new Integer(4));
        nameIdx.put("PatternStyle", new Integer(5));
        nameIdx.put("Format", new Integer(6));
        nameIdx.put("Precision", new Integer(7));
        nameIdx.put("Length", new Integer(8));
        nameIdx.put("Bold", new Integer(9));
        nameIdx.put("AutoFit", new Integer(10));
        nameIdx.put("Width", new Integer(11));
        nameIdx.put("formulainfo", new Integer(12));
        nameIdx.put("GUIField", new Integer(13));
        nameIdx.put("Height", new Integer(14));
        nameIdx.put("Radix", new Integer(15));
        nameIdx.put("Conditions", new Integer(16));
        nameIdx.put("padding-bottom", new Integer(17));
        nameIdx.put("Name", new Integer(18));
        nameIdx.put("ShadowColor", new Integer(19));
        nameIdx.put("BottomLine", new Integer(20));
        nameIdx.put("padding-top", new Integer(21));
        nameIdx.put("Description", new Integer(22));
        nameIdx.put("BorderWidth", new Integer(23));
        nameIdx.put("Background", new Integer(24));
        nameIdx.put("Scale", new Integer(25));
        nameIdx.put("DisplayWidth", new Integer(26));
        nameIdx.put("VerticalAlignment", new Integer(27));
        nameIdx.put("PatternColor", new Integer(28));
        nameIdx.put("TopLine", new Integer(29));
        nameIdx.put("FontSize", new Integer(30));
        nameIdx.put("Underline", new Integer(31));
        nameIdx.put("LeftLine", new Integer(32));
        nameIdx.put("FontFace", new Integer(33));
        nameIdx.put("Alignment", new Integer(34));
        nameIdx.put("padding-left", new Integer(35));
        nameIdx.put("WordWrap", new Integer(36));
        nameIdx.put("Italic", new Integer(37));
        nameIdx.put("StrikeOut", new Integer(38));
        nameIdx.put("BorderColor", new Integer(39));
        nameIdx.put("Foreground", new Integer(40));
        nameIdx.put("Shadow", new Integer(41));
        grpDesc = new HashVector(7);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "General";
        grpItems = new Vector<String>(11);
        grpItems.add("Name");
        grpItems.add("Description");
        grpItems.add("GUIField");
        grpItems.add("DisplayWidth");
        grpItems.add("SQLType");
        grpItems.add("Precision");
        grpItems.add("Scale");
        grpItems.add("Length");
        grpItems.add("Radix");
        grpItems.add("Expression");
        grpItems.add("formulainfo");
        grpDesc.put(grpName, grpItems);
        grpName = "TextFormat";
        grpItems = new Vector(11);
        grpItems.add("FontFace");
        grpItems.add("FontSize");
        grpItems.add("Bold");
        grpItems.add("Italic");
        grpItems.add("StrikeOut");
        grpItems.add("Underline");
        grpItems.add("Format");
        grpItems.add("AutoFit");
        grpItems.add("WordWrap");
        grpItems.add("VerticalAlignment");
        grpItems.add("HorizontalAlignment");
        grpDesc.put(grpName, grpItems);
        grpName = "Padding";
        grpItems = new Vector(4);
        grpItems.add("padding-top");
        grpItems.add("padding-bottom");
        grpItems.add("padding-left");
        grpItems.add("padding-right");
        grpDesc.put(grpName, grpItems);
        grpName = "Geometry";
        grpItems = new Vector(2);
        grpItems.add("Width");
        grpItems.add("Height");
        grpDesc.put(grpName, grpItems);
        grpName = "Color";
        grpItems = new Vector(2);
        grpItems.add("Background");
        grpItems.add("Foreground");
        grpDesc.put(grpName, grpItems);
        grpName = "Border";
        grpItems = new Vector(8);
        grpItems.add("BorderWidth");
        grpItems.add("TopLine");
        grpItems.add("BottomLine");
        grpItems.add("LeftLine");
        grpItems.add("RightLine");
        grpItems.add("Shadow");
        grpItems.add("BorderColor");
        grpItems.add("ShadowColor");
        grpDesc.put(grpName, grpItems);
        grpName = "Pattern";
        grpItems = new Vector(2);
        grpItems.add("PatternColor");
        grpItems.add("PatternStyle");
        grpDesc.put(grpName, grpItems);
    }
}

