/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.dataengine.api.expression.IExpression;
import jet.log.JRLogger;
import jet.universe.JetUDatabase;
import jet.universe.JetUHDSField;
import jet.universe.JetUHDSTable;
import jet.universe.JetUHDSWhereFormula;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUWhereFormula;
import jet.util.HashVector;
import jet.xml.model.AttValuesNode;
import jet.xml.model.ElementNode;

public class JetUHierDataSource
extends JetUHDSTable {
    public JetString className = new JetString(this, "ClassName");
    public JetString uri = new JetString(this, "URI");
    public JetString xsduri = new JetString(this, "XSDURI");
    public JetString rname = new JetString(this, "RootName");
    public JetString parameter = new JetString(this, "Parameter");
    public JetNumber version = new JetNumber(this, "Version");
    private static final int currentVersion = 1;
    ElementNode rootElt = null;
    public static final String strParameterDelimiter = ";";
    public static final String interClass = "jet.datasource.hds.JetHDSDataSourceImpl";
    Hashtable flds;
    private Vector vParams = new Vector();
    private String rptUserName;
    private static JRLogger logger = JRLogger.getLogger(JetUHierDataSource.class.getName());
    private static final HashMap nameIdx = new HashMap(12);
    private static final HashVector grpDesc;

    public JetUHierDataSource() {
        this.setPropEdit();
    }

    public JetUHierDataSource(String name2, String clsName, String param) {
        this(name2, clsName, param, "", "", "");
    }

    public JetUHierDataSource(ElementNode elt, String uri) {
        super(elt);
        this.uri.set(uri);
        this.rootElt = elt;
        this.setPropEdit();
        this.className.set(interClass);
    }

    public JetUHierDataSource(String name2, String clsName, String param, String xmluri, String xsd, String eltRoot) {
        super(name2, "", name2);
        this.className.set(clsName);
        this.parameter.set(param);
        this.uri.set(xmluri);
        this.xsduri.set(xsd);
        this.rname.set(eltRoot);
        this.setPropEdit();
        this.className.set(clsName);
    }

    public void setEltRoot(ElementNode elt) {
        this.rootElt = elt;
    }

    private void setPropEdit() {
        this.className.setEditFlag(0);
        this.version.setEditFlag(0);
    }

    public void hidePros() {
        JetProperty pro = null;
        String[] hidePros = new String[]{"URI", "XSDURI", "RootName"};
        for (int j = 0; j < hidePros.length; ++j) {
            pro = this.nameToProperty(hidePros[j]);
            if (pro == null) continue;
            pro.setEditFlag(3);
        }
    }

    @Override
    public void InitAfterCreate() {
        super.InitAfterCreate();
        if (this.rootElt != null) {
            this.buildDataTree(this.rootElt, this);
        }
        this.version.set(1);
    }

    public void updateVersion() {
        int oldVersion = this.version.get();
        if (oldVersion < 1 && !this.uri.get().startsWith("@") && !this.uri.get().startsWith(":")) {
            this.setURI('\"' + this.uri.get() + '\"');
        }
        this.version.set(1);
        this.getDatabase().getUniverse().setModified(true);
    }

    @Override
    public void InitAfterLoad() {
        super.InitAfterLoad();
        if (this.version.get() < 1) {
            this.updateVersion();
        }
    }

    public Hashtable getAllFields() {
        return this.flds;
    }

    private void buildDataTree(ElementNode parentNode, JetUHDSTable root) {
        Vector vChild = parentNode.getChildren();
        vChild.addAll(parentNode.getAttributs().values());
        Object hdsFld = null;
        this.flds = new Hashtable();
        for (int i = 0; i < vChild.size(); ++i) {
            JetUHDSField fld;
            Object name2 = null;
            Object fullPath = null;
            if (vChild.elementAt(i) instanceof AttValuesNode) {
                AttValuesNode attNode = (AttValuesNode)vChild.elementAt(i);
                fld = (JetUHDSField)attNode.getObject();
                if (fld.isSelect()) {
                    fld.setResourceName(this.getMappingName(fld.getFldName(), root));
                    root.addColumn(fld);
                    this.flds.put(fld.getResourceName(), root.getFullName());
                    continue;
                }
                fld = null;
                continue;
            }
            if (!(vChild.elementAt(i) instanceof ElementNode)) continue;
            ElementNode xmlNode = (ElementNode)vChild.elementAt(i);
            if (xmlNode.isLeaf()) {
                fld = (JetUHDSField)xmlNode.getObject();
                if (fld.isSelect()) {
                    fld.setResourceName(this.getMappingName(fld.getFldName(), root));
                    root.addColumn(fld);
                    this.flds.put(fld.getResourceName(), root.getFullName());
                    continue;
                }
                fld = null;
                continue;
            }
            JetUHDSTable hdsTbl = new JetUHDSTable(xmlNode);
            root.add(hdsTbl);
            this.buildDataTree(xmlNode, hdsTbl);
        }
    }

    public void setClassName(String clsName) {
        this.className.set(clsName);
    }

    public String getClassName() {
        return this.className.get();
    }

    public void setParameter(String sParam) {
        this.parameter.set(sParam);
    }

    public String getParameter() {
        return this.parameter.get();
    }

    public void setURI(String sUri) {
        this.uri.set(sUri);
    }

    public Vector getParams() {
        return this.vParams;
    }

    public String getURI() {
        String path;
        String string = path = this.uri != null ? this.uri.get() : null;
        if (!(path == null || path.indexOf("/") > -1 || path.indexOf(File.separator) > -1 || path.startsWith("\"file:") || path.startsWith("\"http:") || path.startsWith("\"https:") || path.startsWith("\"ftp:") || !path.endsWith(".xml\""))) {
            path = ((JetUDatabase)this.getParent()).getUniverse().getFilePath() + path.substring(1, path.length() - 1);
            path = "\"" + path + "\"";
        }
        return path;
    }

    public String getURIValue() {
        return this.uri.get();
    }

    public void setRootName(String name2) {
        this.rname.set(name2);
    }

    public String getRootName() {
        return this.rname.get();
    }

    public void setXSDURI(String xuri) {
        this.xsduri.set(xuri);
    }

    public String getXSDValue() {
        return this.xsduri.get();
    }

    public String getXSDURI() {
        String path;
        String string = path = this.xsduri != null ? this.xsduri.get() : null;
        if (path != null && path.trim().length() > 0 && path.indexOf(File.separator) <= -1 && path.indexOf("://") <= -1) {
            path = ((JetUDatabase)this.getParent()).getUniverse().getFilePath() + path;
        }
        return path;
    }

    public String[] parseParameter() {
        String[] strParams = null;
        if (this.parameter != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.parameter.get(), strParameterDelimiter);
            Vector<String> vecParams = new Vector<String>();
            while (tokenizer.hasMoreTokens()) {
                vecParams.addElement(tokenizer.nextToken());
            }
            int iSize = vecParams.size();
            strParams = new String[iSize];
            for (int i = 0; i < iSize; ++i) {
                strParams[i] = (String)vecParams.elementAt(i);
            }
        }
        return strParams;
    }

    @Override
    public String getInstancePrefix() {
        return "HierarchicalDataSource";
    }

    public JetUWhereFormula getWhereFormula(String name2) {
        Vector children = this.getChildren();
        int iSize = children.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)children.elementAt(i);
            if (!(child instanceof JetUWhereFormula) || !((JetUWhereFormula)child).getResourceName().equalsIgnoreCase(name2)) continue;
            return (JetUWhereFormula)child;
        }
        return null;
    }

    public Vector getWhereFormulas() {
        Vector<JetObject> ret = new Vector<JetObject>();
        Vector children = this.getChildren();
        int iSize = children.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)children.elementAt(i);
            if (!(child instanceof JetUWhereFormula)) continue;
            ret.addElement(child);
        }
        if (ret.size() > 0) {
            return ret;
        }
        return null;
    }

    public void addFormulaWhere(String name2, String expr) {
        block9: {
            boolean bChanged = false;
            JetUWhereFormula uf = this.getWhereFormula(name2);
            if (expr != null && !expr.equals("")) {
                if (uf == null || !expr.equalsIgnoreCase(uf.getExpression())) {
                    if (uf == null) {
                        uf = this.createWhereFormula(name2, expr);
                    } else {
                        uf.setExpression(expr);
                    }
                    bChanged = true;
                }
            } else if (uf != null) {
                this.deleteWhereFormula(name2);
                bChanged = true;
            }
            if (bChanged) {
                try {
                    JetUDatabase db = this.getDatabase();
                    db.parseFormulas(false);
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block9;
                    logger.error("", e);
                }
            }
        }
    }

    public void addHDSFormulaWhere(String name2, String expr, IExpression conditions) {
        block10: {
            boolean bChanged = false;
            JetUWhereFormula wf = this.getWhereFormula(name2);
            JetUHDSWhereFormula uf = null;
            if (wf != null && wf instanceof JetUHDSWhereFormula) {
                uf = (JetUHDSWhereFormula)wf;
            }
            if (expr != null && !expr.equals("")) {
                if (uf == null || !expr.equalsIgnoreCase(uf.getExpression())) {
                    if (uf == null) {
                        uf = this.createHDSWhereFormula(name2, expr, conditions);
                    } else {
                        uf.setExpression(expr);
                        uf.fillCondition(conditions);
                    }
                    bChanged = true;
                }
            } else if (uf != null) {
                this.deleteWhereFormula(name2);
                bChanged = true;
            }
            if (bChanged) {
                try {
                    JetUDatabase db = this.getDatabase();
                    db.parseFormulas(false);
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block10;
                    logger.error("", e);
                }
            }
        }
    }

    public void addHDSFormulaWheres(Vector names, Vector exprs, Vector conditions) {
        block8: {
            boolean bChanged = false;
            for (int i = 0; i < names.size(); ++i) {
                String name2 = (String)names.elementAt(i);
                String expr = (String)exprs.elementAt(i);
                IExpression con = (IExpression)conditions.elementAt(i);
                JetUWhereFormula wf = this.getWhereFormula(name2);
                JetUHDSWhereFormula uf = null;
                if (wf != null && wf instanceof JetUHDSWhereFormula) {
                    uf = (JetUHDSWhereFormula)wf;
                }
                if (expr != null && !expr.equals("")) {
                    if (uf != null && expr.equalsIgnoreCase(uf.getExpression())) continue;
                    if (uf == null) {
                        uf = this.createHDSWhereFormula(name2, expr, con);
                    } else {
                        uf.setExpression(expr);
                        uf.fillCondition(con);
                    }
                    bChanged = true;
                    continue;
                }
                if (uf == null) continue;
                this.deleteWhereFormula(name2);
                bChanged = true;
            }
            if (bChanged) {
                try {
                    JetUDatabase db = this.getDatabase();
                    db.parseFormulas(false);
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block8;
                    logger.error("", e);
                }
            }
        }
    }

    public JetUWhereFormula deleteWhereFormula(String name2) {
        Vector children = this.getChildren();
        int iSize = children.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)children.elementAt(i);
            if (!(child instanceof JetUWhereFormula) || !((JetUWhereFormula)child).getResourceName().equalsIgnoreCase(name2)) continue;
            this.remove(i);
            return (JetUWhereFormula)child;
        }
        return null;
    }

    public JetUWhereFormula createWhereFormula(String strWFName, String strWFExpr) {
        JetUWhereFormula wf = new JetUWhereFormula(strWFName, "", strWFExpr);
        this.add(wf);
        wf.InitAfterCreate();
        return wf;
    }

    public JetUHDSWhereFormula createHDSWhereFormula(String strWFName, String strWFExpr, IExpression conditions) {
        JetUHDSWhereFormula wf = new JetUHDSWhereFormula(strWFName, "", strWFExpr, conditions);
        this.add(wf);
        wf.InitAfterCreate();
        return wf;
    }

    public JetUHierDataSource cloneHDS() {
        JetUHierDataSource hds = new JetUHierDataSource(this.getResourceName(), this.getClassName(), this.getParameter());
        hds.setDesc(this.getDesc());
        hds.setURI(this.getURIValue());
        hds.setXSDURI(this.getXSDValue());
        hds.setRootName(this.getRootName());
        hds.setMaxRows(this.getMaxRows());
        hds.setMaxDuration(this.getMaxDuration());
        hds.setFullName(this.getFullName());
        hds.rptUserName = this.rptUserName;
        this.cloneWhereFormula(hds);
        this.cloneChildren(hds);
        JetObject.copyProperties(hds, this);
        return hds;
    }

    private void cloneWhereFormula(JetUHierDataSource hds) {
        Vector fmls = this.getWhereFormulas();
        int size = fmls == null ? 0 : fmls.size();
        for (int i = 0; i < size; ++i) {
            JetUWhereFormula fw = ((JetUWhereFormula)fmls.elementAt(i)).cloneEntity();
            String desc = fw.getDesc();
            fw.InitAfterCreate();
            fw.setDesc(desc);
            hds.add(fw);
        }
    }

    @Override
    public boolean isEqualChildren(JetUResourceContainer hds) {
        boolean bRet;
        boolean bl = bRet = hds instanceof JetUHierDataSource && super.isEqualChildren(hds);
        if (bRet) {
            Vector srcFmls = this.getWhereFormulas();
            Vector tFmls = ((JetUHierDataSource)hds).getWhereFormulas();
            if (srcFmls == null && tFmls == null) {
                bRet = true;
            } else if (srcFmls != null && tFmls != null && srcFmls.size() <= tFmls.size()) {
                for (int i = 0; i < srcFmls.size(); ++i) {
                    JetUWhereFormula sFml = (JetUWhereFormula)srcFmls.elementAt(i);
                    if (JetUHierDataSource.findNodeByName(tFmls, sFml.getResourceName()) != null) continue;
                    bRet = false;
                    break;
                }
            }
        }
        return bRet;
    }

    @Override
    public boolean isSimilar(JetUResourceContainer container) {
        return super.isSimilar(container);
    }

    public void setRptUserName(String name2) {
        this.rptUserName = name2;
    }

    public String getRptUserName() {
        return this.rptUserName;
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            return grpDesc;
        }
        return null;
    }

    static {
        nameIdx.put("Attributes", new Integer(0));
        nameIdx.put("Name", new Integer(1));
        nameIdx.put("maxRows", new Integer(2));
        nameIdx.put("XSDURI", new Integer(3));
        nameIdx.put("Description", new Integer(4));
        nameIdx.put("Parameter", new Integer(5));
        nameIdx.put("RootName", new Integer(6));
        nameIdx.put("URI", new Integer(7));
        nameIdx.put("Version", new Integer(8));
        nameIdx.put("maxDuration", new Integer(9));
        nameIdx.put("ClassName", new Integer(10));
        nameIdx.put("FullName", new Integer(11));
        grpDesc = new HashVector(1);
        String grpName = "anonymous";
        Vector<String> grpItems = new Vector<String>(7);
        grpItems.add("Attributes");
        grpItems.add("Name");
        grpItems.add("maxRows");
        grpItems.add("XSDURI");
        grpItems.add("Description");
        grpItems.add("Parameter");
        grpItems.add("RootName");
        grpItems.add("URI");
        grpItems.add("Version");
        grpItems.add("maxDuration");
        grpItems.add("ClassName");
        grpItems.add("FullName");
        grpDesc.put(grpName, grpItems);
    }
}

