/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import jet.JResource;
import jet.connect.DbColDesc;
import jet.controls.JetBoolean;
import jet.controls.JetEnumeration;
import jet.controls.JetObject;
import jet.controls.JetPassword;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.dataengine.api.DSException;
import jet.dataengine.api.query.DatabaseMetadataInfo;
import jet.dataengine.api.query.JDSQuery;
import jet.dataengine8.core.queryengine.transform.QueryTransform;
import jet.log.JRLogger;
import jet.universe.JetUConnection;
import jet.universe.JetUJDBCTypeInfo;
import jet.universe.JetUJdbcSupportInfo;
import jet.universe.JetUSupportInfo;
import jet.universe.JetUTableView;
import jet.universe.exception.AddTableViewException;
import jet.universe.mongodb.JetUMongoConnection;
import jet.util.HashVector;
import oracle.jdbc.driver.OracleConnection;
import toolkit.db.ConnectionToolkit;
import toolkit.db.TableInfo;
import toolkit.db.gui.ConnectionsBroker;
import toolkit.db.gui.MappingSQLType;
import toolkit.db.mongo.MongoConnection;
import toolkit.db.mongo.MongoDbException;
import toolkit.db.version2.ConnectionInfo;

public class JetUJDBCConnection
extends JetUConnection {
    static final int JDBC_COLDESC_COLUMN_NAME = 4;
    static final int JDBC_COLDESC_DATA_TYPE = 5;
    static final int JDBC_COLDESC_DATA_TYPE_NAME = 6;
    static final int JDBC_COLDESC_COLUMN_SIZE = 7;
    static final int JDBC_COLDESC_DECIMAL_DIGITS = 9;
    static final int JDBC_COLDESC_ARRAYBASE_DATA_TYPE = 14;
    static final int JDBC_MONGO_COLUMN_TYPE = 22;
    static final int JDBC_COLDESC_NULLABLE = 11;
    public static final int EXTRA_NAME_JDBC = 0;
    public static final int EXTRA_NAME_USERDEFINED = 1;
    public static final int TRANSACTION_DEFAULT = 0;
    public static final int TRANSACTION_NONE = 1;
    public static final int TRANSACTION_READ_UNCOMMITTED = 2;
    public static final int TRANSACTION_READ_COMMITTED = 3;
    public static final int TRANSACTION_REPEATABLE_READ = 4;
    public static final int TRANSACTION_SERIALIZABLE = 5;
    public static final int READ_ONLY_DEFAULT = 1;
    public static final int READ_ONLY_TRUE = 2;
    public static final int READ_ONLY_FALSE = 0;
    public static final String HIVE = "JDBC:HIVE://";
    public JetString url = new JetString(this, "URL");
    public JetString drv = new JetString(this, "Driver");
    public JetString user = new JetString(this, "User");
    public JetPassword password = new JetPassword(this, "Password");
    public JetEnumeration extraNamePattern = new JetEnumeration(this, "ExtraNamePattern", 35);
    public JetBoolean uptoDateSI = new JetBoolean(this, "uptoDateSI");
    public JetEnumeration transactionIsolation = new JetEnumeration(this, "TransactionIsolation", 98);
    public JetEnumeration readOnly = new JetEnumeration(this, "ReadOnly", 84);
    public JetString sqlNameAnalyser = new JetString(this, "SQLNameAnalyser");
    public JetString sqlStmtCreator = new JetString(this, "SQLStmtCreator");
    public JetString customQueryOptimizer = new JetString(this, "CustomQueryOptimizer");
    public JetVector schemaNames = new JetVector(this, "SchemaName");
    public JetBoolean explicitInnerJoin = new JetBoolean(this, "ExplicitInnerJoin");
    public JetString escapeCharacter = new JetString(this, "EscapeCharacter");
    public JetString escapeReplaced = new JetString(this, "EscapeReplaced");
    public JetBoolean fetchTypeinfoSuccess = new JetBoolean(this, "FetchTypeinfoSuccess");
    public JetEnumeration outerJoinMarker = new JetEnumeration(this, "OuterJoinMarker", 127);
    public transient int conFlag = 0;
    private static JRLogger logger = JRLogger.getLogger(JetUJDBCConnection.class.getName());
    private static final HashMap nameIdx = new HashMap(22);
    private static final HashVector grpDesc;
    public static final int INNERJOINSPELLTYPE_WHERECLAUSE = 1;
    public static final int INNERJOINSPELLTYPE_KEYWORD = 2;
    Hashtable<Long, JDSQuery> runTimeDBMetaData = new Hashtable();
    Hashtable<Long, JetUSupportInfo> supportInfos = new Hashtable();

    public JetUJDBCConnection() {
        this.initialize();
    }

    public JetUJDBCConnection(String strName, String strDescription, String strURL, String strUser, String strPassword, int iQualifiedNamePattern, String strDriver) throws SQLException, ClassNotFoundException {
        super(strName, strDescription);
        this.initialize();
        this.setURL(strURL);
        this.user.set(strUser);
        this.password.set(strPassword);
        this.drv.set(strDriver);
        this.qualifiedNamePattern.set(new Integer(iQualifiedNamePattern));
        this.createSupportInfo();
    }

    public JetUJDBCConnection(String strName, String strDescription, toolkit.db.ConnectionInfo conInfo) throws SQLException, ClassNotFoundException {
        super(strName, strDescription);
        this.initialize();
        this.setConnectionInfo(conInfo);
        conInfo = null;
    }

    protected void initialize() {
        this.qualifiedNamePattern.set(new Integer(0));
        this.extraNamePattern.set(new Integer(0));
        this.encodingPattern.set(new Integer(0));
        this.dateFormat.set("yyyy-MM-dd");
        this.timeFormat.set("HH:mm:ss");
        this.timestampFormat.set("yyyy-MM-dd HH:mm:ss.SSS");
        this.uptoDateSI.set(false);
        this.uptoDateSI.setEditFlag(3);
        this.transactionIsolation.set(new Integer(0));
        this.readOnly.set(new Integer(1));
        this.outerJoinMarker.set(new Integer(0));
        this.security.set(false);
        this.sqlNameAnalyser.setEditFlag(3);
        this.preJoin.set(true);
        this.explicitInnerJoin.set(false);
        this.pushDownGroupQuery.setEditFlag(2);
        this.setHive();
    }

    protected void createSupportInfo() throws SQLException, ClassNotFoundException {
        JetUJdbcSupportInfo suppInfo = new JetUJdbcSupportInfo();
        this.add(suppInfo);
        this.fetchSupportInfo();
    }

    @Override
    public boolean cnntToSameDB(JetUConnection cnnt) {
        if (cnnt instanceof JetUJDBCConnection) {
            String thisURL = this.getURL();
            String thatURL = ((JetUJDBCConnection)cnnt).getURL();
            return thisURL.equalsIgnoreCase(thatURL);
        }
        return false;
    }

    public String getURL() {
        if (this.url.get() == null) {
            return this.url.get();
        }
        return this.url.get().trim();
    }

    public void setURL(String strURL) {
        this.url.set(strURL);
        this.setHive();
    }

    private void setHive() {
        if (this.isHive()) {
            this.explicitInnerJoin.set(true);
            this.explicitInnerJoin.setEditFlag(0);
            this.pushDownGroupQuery.set(true);
            this.pushDownGroupQuery.setEditFlag(0);
        }
    }

    public boolean isHive() {
        return this.url.get().toUpperCase().startsWith(HIVE);
    }

    public String getJdbcDriver() {
        if (this.drv.get() == null) {
            return this.drv.get();
        }
        return this.drv.get().trim();
    }

    public void setJdbcDriver(String strDriver) {
        this.drv.set(strDriver);
    }

    public String getUID() {
        return this.user.get();
    }

    public void setUID(String strUser) {
        this.user.set(strUser);
    }

    public void setEscapeCharacter(String escapeCharacter) {
        this.escapeCharacter.set(escapeCharacter);
    }

    public String getEscapeCharacter() {
        String ret;
        DatabaseMetadataInfo dmi;
        long tid = Thread.currentThread().getId();
        JDSQuery query = this.runTimeDBMetaData.get(new Long(tid));
        if (query != null && (dmi = (DatabaseMetadataInfo)query.getDynamicDatabaseMetadataInfos().get(this.getResourceName())) != null && (ret = dmi.getEscapeReplaced()) != null) {
            return ret;
        }
        return this.escapeCharacter.get();
    }

    public void setEscapeReplaced(String escapeReplaced) {
        this.escapeReplaced.set(escapeReplaced);
    }

    public String getEscapeReplaced() {
        String ret;
        DatabaseMetadataInfo dmi;
        long tid = Thread.currentThread().getId();
        JDSQuery query = this.runTimeDBMetaData.get(new Long(tid));
        if (query != null && (dmi = (DatabaseMetadataInfo)query.getDynamicDatabaseMetadataInfos().get(this.getResourceName())) != null && (ret = dmi.getReplacedBy()) != null) {
            return ret;
        }
        return this.escapeReplaced.get();
    }

    public String getPSWD() {
        return this.password.get();
    }

    public void setPSWD(String strPassword) {
        this.password.set(strPassword);
    }

    public int getExtraNamePattern() {
        return this.extraNamePattern.intValue();
    }

    public void setExtraNamePattern(int iExtraNamePattern) {
        this.extraNamePattern.set(new Integer(iExtraNamePattern));
    }

    public boolean isUptoDateSupportInfo() {
        return this.uptoDateSI.get();
    }

    public void setTransactionIsolation(int iTransactionIsolation) {
        this.transactionIsolation.set(new Integer(iTransactionIsolation));
    }

    public int getTransactionIsolation() {
        int ret;
        DatabaseMetadataInfo dmi;
        long tid = Thread.currentThread().getId();
        JDSQuery query = this.runTimeDBMetaData.get(new Long(tid));
        if (query != null && (dmi = (DatabaseMetadataInfo)query.getDynamicDatabaseMetadataInfos().get(this.getResourceName())) != null && (ret = dmi.getTransactionIsolation()) != -1) {
            return ret;
        }
        return this.transactionIsolation.intValue();
    }

    public void setReadOnly(int iReadOnly) {
        this.readOnly.set(new Integer(iReadOnly));
    }

    public int getReadOnly() {
        int ret;
        DatabaseMetadataInfo dmi;
        long tid = Thread.currentThread().getId();
        JDSQuery query = this.runTimeDBMetaData.get(new Long(tid));
        if (query != null && (dmi = (DatabaseMetadataInfo)query.getDynamicDatabaseMetadataInfos().get(this.getResourceName())) != null && (ret = dmi.getReadWriteMode()) != -1) {
            return ret;
        }
        return this.readOnly.intValue();
    }

    public int getOuterJoinMarker() {
        return this.outerJoinMarker.intValue();
    }

    public void setOuterJoinMarker(int outerJoinMarkerType) {
        this.outerJoinMarker.set(new Integer(outerJoinMarkerType));
    }

    public boolean isSql92() {
        return this.getOuterJoinMarker() == 0;
    }

    public toolkit.db.ConnectionInfo getConnectionInfo() {
        return new toolkit.db.ConnectionInfo(this.getResourceName(), this.getDesc(), this.getURL(), this.getUID(), this.getPSWD(), this.getJdbcDriver(), this.getQualifiedNamePattern(), this.getExtraNamePattern(), this.getSupportInfo().getExtraNameChar(), this.getSupportInfo().getQuoteChar(), this.getEncodingPattern(), this.getDateFormat(), this.getTimeFormat(), this.getTimestampFormat(), this.isUptoDateSupportInfo(), this.getTransactionIsolation(), this.getReadOnly());
    }

    public void setConnectionInfo(toolkit.db.ConnectionInfo conInfo) {
        this.setResourceName(conInfo.getName());
        this.setDesc(conInfo.getDescription());
        this.setURL(conInfo.getUrl());
        this.setUID(conInfo.getUid());
        this.setPSWD(conInfo.getPassword());
        this.setJdbcDriver(conInfo.getDriver());
        this.setQualifiedNamePattern(conInfo.getQualifiedNamePattern());
        this.setDateFormat(conInfo.getDateFormat());
        this.setTimeFormat(conInfo.getTimeFormat());
        this.setTimestampFormat(conInfo.getTimestampFormat());
        int iExtraNamePattern = conInfo.getExtraNamePattern();
        if (this.getExtraNamePattern() == 1) {
            this.getSupportInfo().setExtraNameChar(conInfo.getExtraNameChar());
            this.getSupportInfo().setQuoteChar(conInfo.getQuoteNameChar());
        } else {
            try {
                this.fetchSupportInfo();
            }
            catch (SQLException e) {
            }
            catch (ClassNotFoundException e) {
            }
        }
        this.setExtraNamePattern(iExtraNamePattern);
        this.setEncodingPattern(conInfo.getEncodingPattern());
        this.setTransactionIsolation(conInfo.getTransactionIsolation());
        this.setReadOnly(conInfo.getReadOnly());
        this.setUptoDateSupportInfo(conInfo.isUptoDateSupportInfo());
    }

    public void setUptoDateSupportInfo(boolean bUpToDate) {
        this.uptoDateSI.set(bUpToDate);
    }

    @Override
    public void updateSupportInfo() throws SQLException, ClassNotFoundException {
        if (this.uptoDateSI.get()) {
            this.fetchSupportInfo();
            this.setUptoDateSupportInfo(false);
        }
    }

    @Override
    public void fetchSupportInfo() throws SQLException, ClassNotFoundException {
        Connection con = ConnectionToolkit.getConnection(this);
        JetUJdbcSupportInfo suppInfo = this.getJdbcSupportInfo();
        suppInfo.fetchJDBCSupportInfo(con);
        ConnectionToolkit.freeConnection(con);
    }

    @Override
    public Vector getTypeInfo() {
        JetUJdbcSupportInfo supportinfo = this.getJdbcSupportInfo();
        if (supportinfo != null) {
            Vector vecTypeInfos;
            block5: {
                vecTypeInfos = supportinfo.getTypeInfo();
                if (vecTypeInfos.size() == 0 && this.conFlag != 1 && !this.fetchTypeinfoSuccess.get()) {
                    try {
                        Connection con = ConnectionToolkit.getConnection(this);
                        supportinfo.fetchJDBCTypeInfo(con);
                        ConnectionToolkit.freeConnection(con);
                        vecTypeInfos = supportinfo.getTypeInfo();
                        this.fetchTypeinfoSuccess.set(true);
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (SQLException e) {
                        if (this.conFlag == 2) break block5;
                        this.conFlag = 1;
                    }
                }
            }
            return vecTypeInfos;
        }
        return null;
    }

    @Override
    protected boolean isSQLTypeCaseSensitive(int iSQLType) {
        JetUJDBCTypeInfo typeInfo = this.getTypeInfo(iSQLType);
        return typeInfo == null ? false : typeInfo.CaseSensitive.get();
    }

    @Override
    public JetUConnection createNew() {
        JetUJDBCConnection newCnnt = new JetUJDBCConnection();
        newCnnt.setResourceName(this.getResourceName());
        newCnnt.setUptoDateSupportInfo(true);
        JetObject.copyProperties(newCnnt, this);
        newCnnt.add(this.getSupportInfo().createNew());
        JetUSupportInfo newSupportInfo = newCnnt.getSupportInfo();
        JetUSupportInfo supportInfo = this.getSupportInfo();
        newSupportInfo.setExtraNameChar(supportInfo.getExtraNameChar());
        newSupportInfo.setQuoteChar(supportInfo.getQuoteChar());
        return newCnnt;
    }

    public void copyPropsFrom(JetUJDBCConnection cnnt) {
        this.setDesc(cnnt.getDesc());
        this.setURL(cnnt.getURL());
        this.setUID(cnnt.getUID());
        this.setPSWD(cnnt.getPSWD());
        this.setQualifiedNamePattern(cnnt.getQualifiedNamePattern());
        this.setJdbcDriver(cnnt.getJdbcDriver());
        this.setDateFormat(cnnt.getDateFormat());
        this.setTimeFormat(cnnt.getTimeFormat());
        this.setTimestampFormat(cnnt.getTimestampFormat());
        this.getSupportInfo().setExtraNameChar(cnnt.getSupportInfo().getExtraNameChar());
        this.getSupportInfo().setQuoteChar(cnnt.getSupportInfo().getQuoteChar());
        this.setExtraNamePattern(cnnt.getExtraNamePattern());
        this.setEncodingPattern(cnnt.getEncodingPattern());
        this.setTransactionIsolation(cnnt.getTransactionIsolation());
        this.setReadOnly(cnnt.getReadOnly());
        this.explicitInnerJoin.set(cnnt.explicitInnerJoin.get());
        this.setEscapeCharacter(cnnt.getEscapeCharacter());
        this.setEscapeReplaced(cnnt.getEscapeReplaced());
    }

    @Override
    public Vector addTableViews(String strCatalogName, String schemaPattern, String tablePattern, int iType) throws ClassNotFoundException, SQLException, AddTableViewException {
        Vector<String> retVec = new Vector<String>();
        StringBuffer bufError = new StringBuffer();
        Connection con = ConnectionToolkit.getConnection(this);
        DatabaseMetaData dma = con.getMetaData();
        ResultSet rs = dma.getTables(strCatalogName, schemaPattern, tablePattern, null);
        String strSchemaName = "";
        String strTableName = "";
        String strTableType = "";
        while (rs.next()) {
            strCatalogName = rs.getString(1);
            strSchemaName = rs.getString(2);
            strTableName = rs.getString(3);
            int iTypeInCatalog = this.getIntValueFromType(rs.getString(4));
            if (!this.isMatchingType(iTypeInCatalog, iType)) continue;
            String strResourceName = strTableName;
            int index = 0;
            while (this.isNameExist(strResourceName)) {
                strResourceName = strTableName + String.valueOf(index);
                ++index;
            }
            TableInfo tableInfo = this.createTableInfo(strCatalogName, strSchemaName, strTableName, iTypeInCatalog);
            JetUTableView table = this.addTableView(strResourceName, tableInfo);
            if (table == null) {
                bufError.append("Catalog Name: " + strCatalogName + "\n" + "Schema Name: " + strSchemaName + "\n" + "Table Name: " + strTableName);
            }
            retVec.addElement(strResourceName);
        }
        rs.close();
        ConnectionToolkit.freeConnection(con);
        if (bufError.length() > 0) {
            throw new AddTableViewException(0, bufError.toString());
        }
        return retVec;
    }

    private int getIntValueFromType(String strType) {
        if (strType.indexOf("TABLE") != -1) {
            return 1;
        }
        if (strType.indexOf("VIEW") != -1) {
            return 2;
        }
        return -1;
    }

    public Driver getDriver() {
        Driver driver;
        block5: {
            Connection con;
            block4: {
                driver = null;
                con = null;
                try {
                    con = ConnectionToolkit.getConnection(this);
                }
                catch (Exception e1) {
                    if (!logger.isErrorEnabled()) break block4;
                    logger.error("", e1);
                }
            }
            try {
                driver = DriverManager.getDriver(this.getURL());
                ConnectionToolkit.freeConnection(con);
            }
            catch (SQLException e) {
                if (!logger.isErrorEnabled()) break block5;
                logger.error("", e);
            }
        }
        return driver;
    }

    public Vector getFieldsOfView(String qualifier, String owner, String strView) throws SQLException, ClassNotFoundException {
        return this.getFieldsOfTable(qualifier, owner, strView);
    }

    @Override
    public Vector getFieldsOfTable(String qualifier, String owner, String tablname) throws SQLException, ClassNotFoundException {
        Connection connection = ConnectionToolkit.getConnection(this);
        DatabaseMetaData dma = connection.getMetaData();
        if (qualifier != null && qualifier.length() == 0) {
            qualifier = null;
        }
        if (owner != null && owner.length() == 0) {
            owner = null;
        }
        String strColumnPattern = null;
        String strDriverName = dma.getDriverName();
        if (strDriverName.equals("InterClient")) {
            logger.debug("The current JDBC driver is InterClient.  Use \"%\" to get information.");
            strColumnPattern = "%";
        }
        ResultSet rs = dma.getColumns(qualifier, owner, tablname, strColumnPattern);
        Vector<DbColDesc> cols = new Vector<DbColDesc>();
        boolean bHasMoreCol = rs.next();
        if (!bHasMoreCol) {
            strColumnPattern = "%";
            rs.close();
            rs = dma.getColumns(qualifier, owner, tablname, strColumnPattern);
            bHasMoreCol = rs.next();
        }
        boolean i = false;
        while (bHasMoreCol) {
            DbColDesc coldesc = new DbColDesc(rs.getString(4).trim(), MappingSQLType.mapColType(rs.getInt(5)), rs.getInt(7), rs.getInt(9), rs.getInt(11));
            cols.addElement(coldesc);
            bHasMoreCol = rs.next();
        }
        rs.close();
        ConnectionToolkit.freeConnection(connection);
        return cols;
    }

    public static boolean IsConnectionOK(String strURL, String strUser, String strPassword, String strDriver, StringBuffer strbufMsg) {
        try {
            String strMessage = "URL:\t" + strURL + "\n" + "User:\t" + "*****" + "\n" + "Driver:\t" + strDriver + "\n";
            logger.debug(strMessage);
            Connection connectionTest = ConnectionsBroker.getConnection(strURL, strUser, strPassword, strDriver);
            if (connectionTest != null) {
                ConnectionsBroker.freeConnection(connectionTest);
            }
            return true;
        }
        catch (SQLException e) {
            if (e.getMessage() == null || e.getMessage().length() < 1) {
                strbufMsg.append("An error occurs when creating the connection. Check the connection settings.");
            } else {
                strbufMsg.append(e.getMessage());
            }
            logger.error("", e);
            return false;
        }
        catch (ClassNotFoundException e) {
            String strErr = e.getMessage();
            strbufMsg.append(JResource.getMessage("CAT_91", (Object)(strErr != null ? strErr : "")));
            logger.error("", e);
            return false;
        }
    }

    @Override
    public String getInstancePrefix() {
        return "JDBCConnection";
    }

    public JetUJdbcSupportInfo getJdbcSupportInfo() {
        return (JetUJdbcSupportInfo)this.getSupportInfo();
    }

    @Override
    public TableInfo createTableInfo(String strQualifierName, String strOwnerName, String strTableName, int iType) throws SQLException {
        ConnectionInfo conninfo;
        String driverName;
        DatabaseMetaData dma;
        ConnectionInfo conn;
        Connection realCon;
        boolean isOracle;
        TableInfo tableInfo = new TableInfo(strQualifierName, strOwnerName, strTableName, iType);
        if (strQualifierName != null && strQualifierName.length() == 0) {
            strQualifierName = null;
        }
        Connection connection = null;
        try {
            connection = ConnectionToolkit.getConnection(this);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        String productName = connection.getMetaData().getDatabaseProductName().toUpperCase();
        boolean bl = isOracle = productName.indexOf("ORACLE") != -1;
        if (isOracle && connection instanceof ConnectionInfo && (realCon = (conn = (ConnectionInfo)connection).getRealConn()) instanceof OracleConnection) {
            OracleConnection oracleConnection = (OracleConnection)realCon;
            oracleConnection.setIncludeSynonyms(true);
        }
        if (strQualifierName != null && strQualifierName.trim().length() > 0 && (dma = connection.getMetaData()) != null && (driverName = dma.getDriverName()) != null && ((driverName = driverName.toUpperCase()).indexOf("SQLSRV") >= 0 || driverName.indexOf("SQLServer") >= 0 || driverName.indexOf("I-NET UNA") >= 0)) {
            connection.setCatalog(strQualifierName);
        }
        if (this instanceof JetUMongoConnection && connection instanceof ConnectionInfo && ((MongoConnection)(conninfo = (ConnectionInfo)connection).getRealConn()).isNeedInputDb() && ((JetUMongoConnection)this).dataBaseNames != null && ((JetUMongoConnection)this).dataBaseNames.get().size() > 0) {
            try {
                ((MongoConnection)conninfo.getRealConn()).setDatabases(((JetUMongoConnection)this).dataBaseNames.get());
            }
            catch (MongoDbException e) {
                logger.error(e);
            }
        }
        dma = connection.getMetaData();
        String q = this.getSupportInfo().getQuoteChar();
        if (strOwnerName != null && strOwnerName.length() == 0) {
            strOwnerName = null;
        }
        String strColumnPattern = null;
        String strDriverName = dma.getDriverName();
        if (strDriverName.equals("InterClient")) {
            logger.debug("JDBC Connection\nThe current JDBC driver is InterClient.  Use \"%\" to get information.");
            strColumnPattern = "%";
        }
        ResultSet rs = dma.getColumns(strQualifierName, strOwnerName, strTableName, strColumnPattern);
        Vector<DbColDesc> columnsVec = new Vector<DbColDesc>();
        Vector<Integer> columnsExtender = new Vector<Integer>();
        boolean bHasMoreCol = rs.next();
        if (!bHasMoreCol) {
            rs.close();
            strColumnPattern = "%";
            rs = dma.getColumns(strQualifierName, strOwnerName, strTableName, strColumnPattern);
            bHasMoreCol = rs.next();
        }
        boolean isMongo = dma.getClass().getName().indexOf("MongoDatabaseMetaData") != -1;
        boolean i = false;
        while (bHasMoreCol) {
            String col_name = rs.getString(4).trim();
            int sql_type = rs.getInt(5);
            if (logger.isWarnEnabled() && sql_type == 1111) {
                String warnMessage = " getDatabaseProductName = " + dma.getDatabaseProductName();
                warnMessage = warnMessage + " getDatabaseProductVersion = " + dma.getDatabaseProductVersion();
                warnMessage = warnMessage + " getDriverName = " + dma.getDriverName();
                warnMessage = warnMessage + " getDriverVersion = " + dma.getDriverVersion();
                warnMessage = warnMessage + " strQualifierName  = " + strQualifierName;
                warnMessage = warnMessage + " strOwnerName = " + strOwnerName;
                warnMessage = warnMessage + " strTableName = " + strTableName;
                warnMessage = warnMessage + " col_name = " + col_name;
                warnMessage = warnMessage + "  SqlType in String = " + rs.getString(6);
                logger.warn(warnMessage);
            }
            String nPartQuotedTableName = q + strTableName + q;
            if (strOwnerName != null && strOwnerName.trim().length() > 0) {
                nPartQuotedTableName = q + strOwnerName + q + "." + nPartQuotedTableName;
            }
            if (strQualifierName != null && strQualifierName.trim().length() > 0) {
                nPartQuotedTableName = q + strQualifierName + q + "." + nPartQuotedTableName;
            }
            boolean bArray = false;
            if (sql_type == 2003) {
                bArray = true;
                sql_type = this instanceof JetUMongoConnection ? rs.getInt(14) : JetUJDBCConnection.getArrayBasicType(connection, q + col_name + q, nPartQuotedTableName);
            }
            if (isOracle && sql_type == 1111) {
                sql_type = rs.getString(6).toUpperCase().equals("FLOAT") ? 8 : JetUJDBCConnection.getInfoFromResultSet(connection, q + col_name + q, nPartQuotedTableName, 5);
            }
            if (sql_type == -6) {
                logger.warn("The range of TINYINT of some DBms like Sql server or Sybase are 0 to 255 which does not match with the range of byte  (-128 to 127),so convert TINYINT to SMALLINT");
                sql_type = 5;
            }
            DbColDesc coldesc = new DbColDesc(col_name, MappingSQLType.mapColType(sql_type), rs.getInt(7), rs.getInt(9), rs.getInt(11));
            if (bArray) {
                coldesc.setArray(true);
            }
            columnsVec.addElement(coldesc);
            if (isMongo) {
                columnsExtender.addElement(new Integer(rs.getShort(22)));
            }
            bHasMoreCol = rs.next();
        }
        rs.close();
        if (columnsVec.size() == 0 && isOracle) {
            String nPartQuotedTableName = q + strTableName + q;
            if (strOwnerName != null && strOwnerName.trim().length() > 0) {
                nPartQuotedTableName = q + strOwnerName + q + "." + nPartQuotedTableName;
            }
            if (strQualifierName != null && strQualifierName.trim().length() > 0) {
                nPartQuotedTableName = q + strQualifierName + q + "." + nPartQuotedTableName;
            }
            String sqlString = "select * from " + nPartQuotedTableName + " where 1=0";
            Statement stat = connection.createStatement();
            ResultSet res = stat.executeQuery(sqlString);
            ResultSetMetaData md = res.getMetaData();
            int colCount = md.getColumnCount();
            for (int j = 1; j <= colCount; ++j) {
                int sql_type = md.getColumnType(j);
                String col_name = md.getColumnName(j).trim();
                boolean bArray = false;
                if (sql_type == 2003) {
                    bArray = true;
                    sql_type = JetUJDBCConnection.getArrayBasicType(connection, q + col_name + q, nPartQuotedTableName);
                }
                if (isOracle && sql_type == 1111) {
                    sql_type = rs.getString(6).toUpperCase().equals("FLOAT") ? 8 : JetUJDBCConnection.getInfoFromResultSet(connection, q + col_name + q, nPartQuotedTableName, 5);
                }
                DbColDesc coldesc = new DbColDesc(col_name, MappingSQLType.mapColType(sql_type), md.getPrecision(j), md.getScale(j), md.isNullable(j));
                if (bArray) {
                    coldesc.setArray(true);
                }
                columnsVec.addElement(coldesc);
            }
            res.close();
            stat.close();
        }
        ConnectionToolkit.freeConnection(connection);
        tableInfo.setColumns(columnsVec);
        tableInfo.setColumnsExtender(columnsExtender);
        return tableInfo;
    }

    protected Connection getConnection() throws DSException {
        try {
            return ConnectionToolkit.getConnection(this);
        }
        catch (SQLException e) {
            throw new DSException(0, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new DSException(0, (Throwable)e);
        }
    }

    public static int getInfoFromResultSet(Connection con, String colName, String tabName, int typeInfo) throws SQLException {
        Statement stmt = con.createStatement();
        stmt.setFetchSize(1);
        String str_query = "SELECT " + colName + " FROM " + tabName + " WHERE 0 > 1 ";
        ResultSet rs = stmt.executeQuery(str_query);
        ResultSetMetaData rsmd = rs.getMetaData();
        int ret = 0;
        switch (typeInfo) {
            case 5: {
                ret = rsmd.getColumnType(1);
                break;
            }
            case 7: {
                ret = rsmd.getPrecision(1);
                break;
            }
            case 9: {
                ret = rsmd.getScale(1);
                break;
            }
            case 11: {
                ret = rsmd.isNullable(1);
                break;
            }
            default: {
                throw new Error("unknow sql info : " + typeInfo + " of the column " + colName + " from the table " + tabName);
            }
        }
        rs.close();
        stmt.close();
        return ret;
    }

    public static int getArrayBasicType(Connection con, String colName, String tabName) throws SQLException {
        Statement stmt = con.createStatement();
        stmt.setFetchSize(1);
        String str_query = "SELECT " + colName + " FROM " + tabName;
        ResultSet rs = stmt.executeQuery(str_query);
        ResultSetMetaData rsmd = rs.getMetaData();
        int ret = rsmd.getColumnType(1);
        if (ret == 2003) {
            if (rs.next()) {
                Array array = rs.getArray(1);
                if (array != null) {
                    ret = array.getBaseType();
                } else {
                    ret = 12;
                    logger.debug("TableInfo\nFailed to get sql type for the column " + colName + " in the table " + tabName + "! Type has been set to VARCHAR.");
                }
            }
        } else {
            throw new Error("not equ array type!  the column :" + colName + " from the table " + tabName);
        }
        rs.close();
        stmt.close();
        return ret;
    }

    @Override
    public JetUSupportInfo getSupportInfo() {
        DatabaseMetadataInfo dmi;
        long tid = Thread.currentThread().getId();
        JetUSupportInfo retSupportInfo = this.supportInfos.get(tid);
        if (retSupportInfo != null) {
            return retSupportInfo;
        }
        JDSQuery dsQuery = this.runTimeDBMetaData.get(new Long(tid));
        if (dsQuery != null && (dmi = (DatabaseMetadataInfo)dsQuery.getDynamicDatabaseMetadataInfos().get(this.getResourceName())) != null) {
            String quoteChar = dmi.getQuoteCharacters();
            String extraChar = dmi.getExtraCharacters();
            if (dmi.isRefreshSupportInfo()) {
                JetUJdbcSupportInfo suppInfo = new JetUJdbcSupportInfo();
                Connection con = null;
                try {
                    con = QueryTransform.getConnection(dsQuery);
                }
                catch (DSException e) {
                    // empty catch block
                }
                if (con != null) {
                    suppInfo.fetchJDBCSupportInfo(con);
                    if (quoteChar != null) {
                        suppInfo.setQuoteChar(quoteChar);
                    }
                    if (extraChar != null) {
                        suppInfo.setExtraNameChar(extraChar);
                    }
                    this.supportInfos.put(tid, suppInfo);
                    return suppInfo;
                }
            } else if (quoteChar != null || extraChar != null) {
                JetUJdbcSupportInfo suppInfo = (JetUJdbcSupportInfo)this.getPreDefineSupportInfo().createNew();
                if (quoteChar != null) {
                    suppInfo.setQuoteChar(quoteChar);
                }
                if (extraChar != null) {
                    suppInfo.setExtraNameChar(extraChar);
                }
                this.supportInfos.put(tid, suppInfo);
                return suppInfo;
            }
        }
        return this.getPreDefineSupportInfo();
    }

    public JetUSupportInfo getPreDefineSupportInfo() {
        int iSize = this.children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)this.children.elementAt(i);
            if (!(child instanceof JetUJdbcSupportInfo)) continue;
            return (JetUJdbcSupportInfo)child;
        }
        JetUJdbcSupportInfo suppInfo = new JetUJdbcSupportInfo();
        this.add(suppInfo);
        return suppInfo;
    }

    public Vector getSchemaNames() {
        return this.schemaNames.get();
    }

    public void setSchemaNames(Vector schemaNames) {
        this.schemaNames.set(schemaNames);
    }

    @Override
    public void InitAfterLoad() {
        super.InitAfterLoad();
        this.setHive();
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            return grpDesc;
        }
        return null;
    }

    public int getInnerJoinSpellType() {
        if (this.explicitInnerJoin.get()) {
            return 2;
        }
        return 1;
    }

    public void registerRunTimeDBMetaData(long threadID, JDSQuery dmi) {
        this.runTimeDBMetaData.put(new Long(threadID), dmi);
    }

    public void unregisterRunTimeDBMetaData(long threadID) {
        this.runTimeDBMetaData.remove(new Long(threadID));
        this.supportInfos.remove(new Long(threadID));
    }

    @Override
    public String getDateFormat() {
        String ret;
        DatabaseMetadataInfo dmi;
        long tid = Thread.currentThread().getId();
        JDSQuery query = this.runTimeDBMetaData.get(new Long(tid));
        if (query != null && (dmi = (DatabaseMetadataInfo)query.getDynamicDatabaseMetadataInfos().get(this.getResourceName())) != null && (ret = dmi.getDateFormat()) != null) {
            return ret;
        }
        return this.dateFormat.get();
    }

    @Override
    public String getTimeFormat() {
        String ret;
        DatabaseMetadataInfo dmi;
        long tid = Thread.currentThread().getId();
        JDSQuery query = this.runTimeDBMetaData.get(new Long(tid));
        if (query != null && (dmi = (DatabaseMetadataInfo)query.getDynamicDatabaseMetadataInfos().get(this.getResourceName())) != null && (ret = dmi.getTimeFormat()) != null) {
            return ret;
        }
        return this.timeFormat.get();
    }

    @Override
    public String getTimestampFormat() {
        String ret;
        DatabaseMetadataInfo dmi;
        long tid = Thread.currentThread().getId();
        JDSQuery query = this.runTimeDBMetaData.get(new Long(tid));
        if (query != null && (dmi = (DatabaseMetadataInfo)query.getDynamicDatabaseMetadataInfos().get(this.getResourceName())) != null && (ret = dmi.getDatetimeFormat()) != null) {
            return ret;
        }
        return this.timestampFormat.get();
    }

    @Override
    public int getQualifiedNamePattern() {
        int ret;
        DatabaseMetadataInfo dmi;
        long tid = Thread.currentThread().getId();
        JDSQuery query = this.runTimeDBMetaData.get(new Long(tid));
        if (query != null && (dmi = (DatabaseMetadataInfo)query.getDynamicDatabaseMetadataInfos().get(this.getResourceName())) != null && (ret = dmi.getNamePattern()) != -1) {
            return ret;
        }
        return this.qualifiedNamePattern.intValue();
    }

    static {
        int start = 0;
        nameIdx.put("TimeFormat", new Integer(start++));
        nameIdx.put("Driver", new Integer(start++));
        nameIdx.put("Description", new Integer(start++));
        nameIdx.put("User", new Integer(start++));
        nameIdx.put("SchemaName", new Integer(start++));
        nameIdx.put("SQLNameAnalyser", new Integer(start++));
        nameIdx.put("DateFormat", new Integer(start++));
        nameIdx.put("TimestampFormat", new Integer(start++));
        nameIdx.put("SQLStmtCreator", new Integer(start++));
        nameIdx.put("CustomQueryOptimizer", new Integer(start++));
        nameIdx.put("URL", new Integer(start++));
        nameIdx.put("EncodingPattern", new Integer(start++));
        nameIdx.put("ReadOnly", new Integer(start++));
        nameIdx.put("ExtraNamePattern", new Integer(start++));
        nameIdx.put("uptoDateSI", new Integer(start++));
        nameIdx.put("Name", new Integer(start++));
        nameIdx.put("TransactionIsolation", new Integer(start++));
        nameIdx.put("QualifiedNamePattern", new Integer(start++));
        nameIdx.put("Password", new Integer(start++));
        nameIdx.put("SecurityCheck", new Integer(start++));
        nameIdx.put("ExplicitInnerJoin", new Integer(start++));
        nameIdx.put("OuterJoinMarker", new Integer(start++));
        nameIdx.put("IsDefaultConnection", new Integer(start++));
        grpDesc = new HashVector(1);
        String grpName = "anonymous";
        Vector<String> grpItems = new Vector<String>(20);
        grpItems.add("TimeFormat");
        grpItems.add("Driver");
        grpItems.add("Description");
        grpItems.add("User");
        grpItems.add("SchemaName");
        grpItems.add("SQLNameAnalyser");
        grpItems.add("DateFormat");
        grpItems.add("TimestampFormat");
        grpItems.add("SQLStmtCreator");
        grpItems.add("CustomQueryOptimizer");
        grpItems.add("URL");
        grpItems.add("OuterJoinMarker");
        grpItems.add("ReadOnly");
        grpItems.add("ExtraNamePattern");
        grpItems.add("uptoDateSI");
        grpItems.add("Name");
        grpItems.add("TransactionIsolation");
        grpItems.add("QualifiedNamePattern");
        grpItems.add("Password");
        grpItems.add("PushDownGroupQuery");
        grpItems.add("SecurityCheck");
        grpItems.add("ExplicitInnerJoin");
        grpItems.add("IsDefaultConnection");
        grpDesc.put(grpName, grpItems);
    }
}

