/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import jet.controls.JetObject;
import jet.log.JRLogger;
import jet.universe.JetUJDBCTypeInfo;
import jet.universe.JetUSupportInfo;
import toolkit.db.PsqlJdbcDSInfo;
import toolkit.db.version2.ConnectionInfo;

public class JetUJdbcSupportInfo
extends JetUSupportInfo {
    private static JRLogger logger = JRLogger.getLogger(JetUJdbcSupportInfo.class.getName());

    public void fetchJDBCSupportInfo(Connection connection) {
        if (connection instanceof ConnectionInfo) {
            ConnectionInfo connectionInfo = (ConnectionInfo)connection;
            JetUJdbcSupportInfo supportInfo = connectionInfo.getSupportInfo();
            this.bSuppOwner.set(supportInfo.bSuppOwner.get());
            this.bSuppQlf.set(supportInfo.bSuppQlf.get());
            this.bSuppQlfStart.set(supportInfo.bSuppQlfStart.get());
            this.bSuppQlfEnd.set(supportInfo.bSuppQlfEnd.get());
            this.bSuppPKey.set(supportInfo.bSuppPKey.get());
            this.bSuppFKey.set(supportInfo.bSuppFKey.get());
            this.bSuppAlias.set(supportInfo.bSuppAlias.get());
            this.bSuppCorr.set(supportInfo.bSuppCorr.get());
            this.bSuppOuterJoin.set(supportInfo.bSuppOuterJoin.get());
            this.bSuppCatInProc.set(supportInfo.bSuppCatInProc.get());
            this.bSuppSchInProc.set(supportInfo.bSuppSchInProc.get());
            this.sQlfSep.set(supportInfo.sQlfSep.get());
            this.sQuoteChar.set(supportInfo.sQuoteChar.get());
            this.sExtraNameChar.set(supportInfo.sExtraNameChar.get());
            this.strExtraKeywords.set(supportInfo.strExtraKeywords.get());
            this.sStringFuncs.set(supportInfo.sStringFuncs.get());
            this.sNumericFuncs.set(supportInfo.sNumericFuncs.get());
            this.sTimeDateFuncs.set(supportInfo.sTimeDateFuncs.get());
            this.sDatabaseName.set(supportInfo.sDatabaseName.get());
        } else {
            this.sQlfSep.set(".");
            this.sQuoteChar.set("\"");
            PsqlJdbcDSInfo ds = new PsqlJdbcDSInfo(connection);
            this.getFromPsqlJdbcDSInfo(ds);
        }
        this.fetchJDBCTypeInfo(connection);
    }

    void fetchJDBCTypeInfo(Connection connection) {
        Vector chidren = (Vector)this.getChildren().clone();
        int iSize = chidren.size();
        for (int i = 0; i < iSize; ++i) {
            this.remove((JetObject)chidren.elementAt(i));
        }
        JetUJDBCTypeInfo typeinfo = null;
        try {
            ResultSet rs = connection.getMetaData().getTypeInfo();
            if (rs == null) {
                return;
            }
            while (rs.next()) {
                typeinfo = new JetUJDBCTypeInfo(rs);
                this.add(typeinfo);
            }
            rs.close();
        }
        catch (SQLException e) {
        }
    }

    public void getFromPsqlJdbcDSInfo(PsqlJdbcDSInfo dsinfo) {
        if (dsinfo == null) {
            return;
        }
        this.bSuppOwner.set(dsinfo.bSuppOwner);
        this.bSuppQlf.set(dsinfo.bSuppQlf);
        this.bSuppQlfStart.set(dsinfo.bSuppQlfStart);
        this.bSuppQlfEnd.set(dsinfo.bSuppQlfEnd);
        this.bSuppPKey.set(dsinfo.bSuppPKey);
        this.bSuppFKey.set(dsinfo.bSuppFKey);
        this.bSuppAlias.set(dsinfo.bSuppAlias);
        this.bSuppCatInProc.set(dsinfo.bSuppCatInProc);
        this.bSuppSchInProc.set(dsinfo.bSuppSchInProc);
        this.bSuppOuterJoin.set(dsinfo.bSuppOuterJoin);
        this.sQlfSep.set(dsinfo.sQlfSep);
        this.sQuoteChar.set(dsinfo.sQuoteChar);
        this.sExtraNameChar.set(dsinfo.sExtraNameChar);
        this.sStringFuncs.set(dsinfo.sStringFuncs);
        this.sNumericFuncs.set(dsinfo.sNumericFuncs);
        this.sTimeDateFuncs.set(dsinfo.sTimeDateFuncs);
        this.sDatabaseName.set(dsinfo.getDatabaseName());
        this.strExtraKeywords.set(dsinfo.strExtraKeywords);
    }

    @Override
    public String getInstancePrefix() {
        return "JDBCSupportInfo";
    }

    @Override
    public JetUJdbcSupportInfo createNew() {
        JetUJdbcSupportInfo ret = new JetUJdbcSupportInfo();
        JetObject.copyProperties(ret, this);
        Vector chidren = (Vector)this.getChildren().clone();
        int iSize = chidren.size();
        for (int i = 0; i < iSize; ++i) {
            JetUJDBCTypeInfo typeInfo = (JetUJDBCTypeInfo)chidren.elementAt(i);
            ret.add(typeInfo.createNew());
        }
        return ret;
    }
}

