/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.HashMap;
import java.util.Vector;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.universe.JetUDemandQuery;
import jet.universe.JetUTreeNode;
import toolkit.db.PsqlJoin;

public class JetUJoinPath
extends JetUTreeNode {
    private JetString theName = new JetString(this, "name");
    private JetVector theJoinNames = new JetVector(this, "joinNames");
    private JetString description = new JetString(this, "description");
    private static final HashMap nameIdx = new HashMap(3);

    @Override
    public String getDesc() {
        return this.description.get();
    }

    @Override
    public void setDesc(String strDesc) {
        if (strDesc == null) {
            return;
        }
        this.description.set(strDesc);
    }

    public String getName() {
        return this.theName.get();
    }

    public boolean setName(String strName) {
        JetUDemandQuery query;
        if (strName == null || strName.equals("")) {
            return false;
        }
        if (this.getParent() != null && (query = (JetUDemandQuery)this.getParent()).getJoinPath(strName) != null) {
            return false;
        }
        this.theName.set(strName);
        return true;
    }

    public boolean addJoin(String joinName) {
        JetUDemandQuery query = (JetUDemandQuery)this.getParent();
        if (query == null) {
            return false;
        }
        if (query.getJoin(joinName) == null) {
            return false;
        }
        Vector joinNames = this.theJoinNames.get();
        for (String name2 : joinNames) {
            if (!name2.equals(joinName)) continue;
            return true;
        }
        this.theJoinNames.add(joinName);
        return true;
    }

    public PsqlJoin getJoin(String joinName) {
        if (this.getParent() == null) {
            return null;
        }
        JetUDemandQuery query = (JetUDemandQuery)this.getParent();
        return query.getJoin(joinName);
    }

    public PsqlJoin[] getJoins() {
        PsqlJoin join;
        Vector<PsqlJoin> joins = new Vector<PsqlJoin>(5);
        Vector joinNames = this.theJoinNames.get();
        for (String joinName : joinNames) {
            join = this.getJoin(joinName);
            if (join == null) continue;
            joins.add(this.getJoin(joinName));
        }
        PsqlJoin[] ret = new PsqlJoin[joins.size()];
        for (int i = 0; i < joins.size(); ++i) {
            ret[i] = join = (PsqlJoin)joins.get(i);
        }
        return ret;
    }

    public void removeJoin(String joinName) {
        this.theJoinNames.remove(joinName);
    }

    public boolean hasJoin(String joinName) {
        boolean ret = false;
        Vector names = this.theJoinNames.get();
        for (String element : names) {
            if (!element.equals(joinName)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public JetUJoinPath getCopy() {
        JetUJoinPath ret = new JetUJoinPath();
        ret.setName(this.theName.get());
        ret.setDesc(this.description.get());
        Vector joins = this.theJoinNames.get();
        for (String element : joins) {
            ret.theJoinNames.add(element);
        }
        return ret;
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    static {
        nameIdx.put("name", new Integer(0));
        nameIdx.put("description", new Integer(1));
        nameIdx.put("joinNames", new Integer(2));
    }
}

