/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.dataservice.schema.relational.TransformRelationModel;
import com.jinfonet.dataservice.schema.relational.datasource.xml.XmlTransformToRelation;
import com.jinfonet.dataservice.schema.relational.datasource.xml.XmlTransformToRelationRule;
import jet.JRException;
import jet.controls.JetObject;
import jet.dataengine.xml.MetadataContainerImpl;
import jet.universe.JetUConnection;
import jet.universe.JetUJsonTable;
import jet.universe.JetUTransformRelationModel;
import jet.universe.JetUTransformRelationSchema;
import jet.universe.JetUXMLConnection;
import toolkit.db.TableInfo;

public class JetUJsonConnection
extends JetUXMLConnection {
    public JetUJsonConnection() {
        this.qualifiedNamePattern.setEditFlag(3);
        this.dateFormat.setEditFlag(3);
        this.timeFormat.setEditFlag(3);
        this.timestampFormat.setEditFlag(3);
    }

    @Override
    public JetUJsonTable addTableView(String strResourceName, TableInfo table) {
        String candidateResourceName;
        String resourceName = candidateResourceName = strResourceName;
        int index = 1;
        while (!this.getDatabase().IsTableNameOK(resourceName, null)) {
            resourceName = candidateResourceName + String.valueOf(index);
            ++index;
        }
        JetUJsonTable jetUJsonTable = new JetUJsonTable(strResourceName, "", table);
        jetUJsonTable.elementPath.set(this.getElementPath(table.getTableName()));
        boolean bSuc = this.addTableView(jetUJsonTable, null);
        if (bSuc) {
            return jetUJsonTable;
        }
        return null;
    }

    @Override
    public JetUConnection createNew() {
        JetUTransformRelationSchema schema;
        JetUJsonConnection conn = new JetUJsonConnection();
        JetObject.copyProperties(conn, this);
        MetadataContainerImpl xmlMetadata = this.getXMLMetadata();
        if (xmlMetadata != null) {
            conn.setXMLMetadata((MetadataContainerImpl)xmlMetadata.deepDup());
        }
        if ((schema = this.getTransformRelationSchema()) != null) {
            conn.setTransformRelationSchema((JetUTransformRelationSchema)schema.deepDup());
        }
        return conn;
    }

    private String getElementPath(String strTableName) {
        JetUTransformRelationSchema schema = this.getTransformRelationSchema();
        JetUTransformRelationModel model = schema.getJetUTransformRelationModel(strTableName);
        TransformRelationModel transModel = null;
        try {
            transModel = model.createTransformRelationModel();
        }
        catch (JRException e) {
            // empty catch block
        }
        XmlTransformToRelationRule[] transformRules = ((XmlTransformToRelation)transModel.getTransformToRelation()).getXmlTransformRules();
        String xpath = transformRules[0].getXmlTransformSource().getXpath();
        if (xpath.startsWith("/jet.universe.xml.JSonElement/")) {
            return xpath.substring("/jet.universe.xml.JSonElement/".length()).replace('/', '.');
        }
        return "";
    }

    @Override
    public String getInstancePrefix() {
        return "UJsonConnection";
    }
}

