/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import jet.JRProductConstants;
import jet.ReportEnv;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.controls.JetBoolean;
import jet.controls.JetContainable;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.dataengine.util.StringTools;
import jet.exception.InvalidParameterException;
import jet.formula.NoRangeCheckParamDesc;
import jet.formula.ParamDesc;
import jet.formula.SymbolInfo;
import jet.log.JRLogger;
import jet.parameter.UserInput;
import jet.parameter.definition.ActionOnValueChange;
import jet.parameter.definition.BindColumn;
import jet.parameter.definition.Definition;
import jet.parameter.definition.SortByColumn;
import jet.parameter.definition.ValueListSortInfo;
import jet.parameter.definition.valuelist.UnevaluatedValueListItem;
import jet.universe.JetField;
import jet.universe.JetUConnection;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUDatabase;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUParamBuildInFileQuery;
import jet.universe.JetUParamBuildInUQuery;
import jet.universe.JetUQueriable;
import jet.universe.JetUQuery;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUResourceField;
import jet.universe.JetUUniverse;
import jet.universe.JetUWebServiceConnection;
import jet.universe.JetUXMLConnection;
import jet.universe.psql.BadFileQueryException;
import jet.universe.psql.FileQuery;
import jet.universe.psql.RptPsqlQuery;
import jet.util.HashVector;
import jet.util.TempFile;
import toolkit.db.ReloadQueryException;
import toolkit.db.gui.MappingSQLType;
import toolkit.db.query.parser.ASTQueryStatement;
import toolkit.db.query.parser.ASTWhereClause;
import toolkit.db.query.parser.Node;
import toolkit.db.query.parser.ParseException;
import toolkit.db.query.parser.QueryParser;

public class JetUParameter
extends JetUResourceField
implements PropertyChangeListener {
    private JetString promptText;
    public JetString type;
    private JetVector vValue;
    private JetVector vValue_isExpression;
    private JetVector vValue_expressionName;
    private JetVector vValue_selectedDate;
    private JetVector vLimit;
    private JetString maxValue;
    private JetString minValue;
    private JetString userFormat;
    public JetString objName;
    public JetString objParamName;
    public JetString column;
    public JetVector columns;
    public JetBoolean distinct;
    public JetString dataSourceName;
    public JetString bvName;
    public JetBoolean isDynamicParam;
    private JetNumber index;
    private JetNumber operation;
    private JetString binding;
    private JetBoolean useCurrentDate;
    private JetBoolean useCurrentDateWhenBlank;
    private JetString dynamicTemplate;
    private JetBoolean hideParameterWhenSingleValueReturn;
    public JetBoolean req;
    public JetBoolean isStringNull;
    public JetBoolean isMultipleValue;
    public JetBoolean allowTypeIn;
    public JetNumber whenOutOfRange;
    public JetBoolean isAllowAll;
    public JetBoolean isAllSelected;
    public JetBoolean isCascading;
    public JetString previousLevel;
    public JetString nextLevel;
    public JetString chainID;
    public JetBoolean isSetAsParameter;
    public JetNumber sortType;
    public JetVector sortByColumnsType;
    public JetVector sortByColumns;
    public JetString stringFormat;
    public JetString importSql;
    public JetVector referParams;
    private JetBoolean actionOnValueChange_nullFlag = new JetBoolean(this, "ActionOnValueChange_nullFlag", true);
    private JetString actionOnValueChange_Catalog;
    private JetString actionOnValueChange_DataSource;
    private JetString actionOnValueChange_QueryName;
    private JetString actionOnValueChange_BLName;
    private JetString actionOnValueChange_FormulaName;
    private JetNumber actionOnValueChange_DataSourceType;
    public JetBoolean getValueFromAPI;
    private static JRLogger logger = JRLogger.getLogger(JetUParameter.class.getName());
    private JetString securityEntry;
    protected static final String queryNamePrefix = "\u007fUQ~";
    protected static final String fileQueryNamePrefix = "\u007fUFQ~";
    private String referQueryName;
    private Object referQuerLocker = new Object();
    private String referQueryColumn;
    private Vector referQueryDisplayColumn;
    private JetString cascadParamBindQueryName;
    public JetString queryName;
    public static final String selectToken = "SELECT";
    public static final String distinctToken = "DISTINCT";
    private static final HashMap nameIdx = new HashMap(59);
    private static final HashVector grpDesc;
    public static final String BUILDINPARAMETERNAME = "JRS_P_LOGOURL";
    public static final JetUParameter buildinParameter;

    public JetUParameter() {
        this.dataMappingFile.setEnableAutoValue(true);
        this.dataMappingFile.setAsAutoValue(true);
        this.guiField.set("Standard_ParamField");
        this.type.set("Integer");
    }

    public JetUParameter(String strName, String desc, String prompt, String type, String value) {
        this(strName, desc, type, prompt, null, null, null, -1, -1);
        Vector<UserInput> v = new Vector<UserInput>(1);
        v.addElement(new UnevaluatedValueListItem(value, false, null, null));
        this.setvValueGroup(v);
        this.vLimit.set(new Vector());
    }

    public JetUParameter(String strName, String desc, String prompt, String type, UserInput value) {
        this(strName, desc, type, prompt, null, null, null, -1, -1);
        Vector<UserInput> v = new Vector<UserInput>(1);
        v.addElement(value);
        this.setvValueGroup(v);
        this.vLimit.set(new Vector());
    }

    private void setvValueGroup(Vector<UserInput> v) {
        if (v == null) {
            this.vValue.set(new Vector());
            return;
        }
        Vector<String> v_userInput = new Vector<String>();
        Vector<String> v_isExpression = new Vector<String>();
        Vector<String> v_expressionName = new Vector<String>();
        Vector<String> v_selectedDate = new Vector<String>();
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            UserInput userInput = v.get(i);
            v_userInput.add(userInput.getUserInput());
            if (userInput.isExpression()) {
                v_isExpression.add("T");
                v_expressionName.add(userInput.getExpressionName());
                v_selectedDate.add(Long.toString(userInput.getSelectedDate().getTime()));
                continue;
            }
            v_isExpression.add("F");
            v_expressionName.add("");
            v_selectedDate.add("");
        }
        this.vValue.set(v_userInput);
        this.vValue_isExpression.set(v_isExpression);
        this.vValue_expressionName.set(v_expressionName);
        this.vValue_selectedDate.set(v_selectedDate);
    }

    private Vector<UserInput> getvValueGroup() {
        if (this.vValue.isNull()) {
            return null;
        }
        Vector v_userInput = this.vValue.get();
        Vector v_isExpression = this.vValue_isExpression.get();
        Vector v_expressionName = this.vValue_expressionName.get();
        Vector v_selectedDate = this.vValue_selectedDate.get();
        Vector<UserInput> ret = new Vector<UserInput>();
        int size = v_userInput.size();
        for (int i = 0; i < size; ++i) {
            String value = (String)v_userInput.get(i);
            if (i >= v_isExpression.size()) {
                ret.add(new UnevaluatedValueListItem(value, false, null, null));
                continue;
            }
            boolean isExp = "T".equals(v_isExpression.get(i));
            if (isExp) {
                String expName = "";
                if (i < v_expressionName.size()) {
                    expName = (String)v_expressionName.get(i);
                }
                Date date = new Date();
                date.setTime(Long.parseLong((String)v_selectedDate.get(i)));
                UnevaluatedValueListItem userInput = new UnevaluatedValueListItem(value, isExp, expName, date);
                ret.add(userInput);
                continue;
            }
            UnevaluatedValueListItem userInput = new UnevaluatedValueListItem(value, false, "", null);
            ret.add(userInput);
        }
        return ret;
    }

    public JetUParameter(String strName, String strDescription, String strType, String strPrompt, Vector vStrLimit, Vector vUserInputValue, String strFormat, int operator, int intdex) {
        super(strName, strDescription);
        this.dataMappingFile.setEnableAutoValue(true);
        this.dataMappingFile.setAsAutoValue(true);
        this.guiField.set("Standard_ParamField");
        this.promptText.set(strPrompt);
        this.type.set(strType);
        this.setvValueGroup(vUserInputValue);
        this.vLimit.set(vStrLimit);
        this.userFormat.set(strFormat);
        this.operation.set(operator);
        this.index.set(intdex);
        if (vStrLimit != null) {
            this.vLimit.removePropertyChangeListener(this);
            this.maxValue.removePropertyChangeListener(this);
            this.minValue.removePropertyChangeListener(this);
            switch (vStrLimit.size()) {
                case 1: {
                    this.minValue.set((String)vStrLimit.elementAt(0));
                    this.maxValue.set("");
                    break;
                }
                case 2: {
                    this.minValue.set((String)vStrLimit.elementAt(0));
                    this.maxValue.set((String)vStrLimit.elementAt(1));
                    break;
                }
                default: {
                    this.minValue.set("");
                    this.maxValue.set("");
                }
            }
            this.vLimit.addPropertyChangeListener(this);
            this.maxValue.addPropertyChangeListener(this);
            this.minValue.addPropertyChangeListener(this);
        }
        this.setHAlignmentDefault(MappingSQLType.mapSQLTypeToInt(this.getParamDesc().type));
        this.setVAlignmentDefault(MappingSQLType.mapSQLTypeToInt(this.getParamDesc().type));
        this.setFormatDefault(MappingSQLType.mapSQLTypeToInt(this.getParamDesc().type));
    }

    @Override
    void init() {
        super.init();
        this.promptText = new JetString(this, "PromptText");
        this.type = new JetString(this, "Type");
        this.vValue = new JetVector(this, "Value");
        this.vValue_isExpression = new JetVector(this, "Value_isExpression");
        this.vValue_expressionName = new JetVector(this, "Value_expressionName");
        this.vValue_selectedDate = new JetVector(this, "Value_selectedDate");
        this.vLimit = new JetVector(this, "Limit");
        this.maxValue = new JetString(this, "MaxValue");
        this.minValue = new JetString(this, "MinValue");
        this.userFormat = new JetString(this, "UserFormat", "");
        this.objName = new JetString(this, "ObjName");
        this.objParamName = new JetString(this, "ObjParamName");
        this.column = new JetString(this, "Column");
        this.columns = new JetVector(this, "Columns");
        this.distinct = new JetBoolean(this, "Distinct");
        this.dataSourceName = new JetString(this, "DataSourceName");
        this.bvName = new JetString(this, "BVName");
        this.isDynamicParam = new JetBoolean(this, "IsDynamicParam");
        this.getValueFromAPI = new JetBoolean(this, "GetValueFromAPI");
        this.index = new JetNumber(this, "DefaultNo", -1);
        this.operation = new JetNumber(this, "Operation", -1);
        this.binding = new JetString(this, "Binding");
        this.req = new JetBoolean(this, "Required");
        this.isStringNull = new JetBoolean(this, "IsStringNull");
        this.isMultipleValue = new JetBoolean(this, "IsMultipleValue");
        this.allowTypeIn = new JetBoolean(this, "AllowTypeIN", true);
        this.whenOutOfRange = new JetNumber(this, "WhenOutOfRange", 1);
        this.stringFormat = new JetString(this, "stringFormat");
        this.importSql = new JetString(this, "ImportSql");
        this.securityEntry = new JetString(this, "RecordLevelSecurity");
        this.referParams = new JetVector(this, "ReferParams");
        this.actionOnValueChange_Catalog = new JetString(this, "ActionOnValueChange_Catalog");
        this.actionOnValueChange_DataSource = new JetString(this, "ActionOnValueChange_DataSource");
        this.actionOnValueChange_QueryName = new JetString(this, "ActionOnValueChange_QueryName");
        this.actionOnValueChange_BLName = new JetString(this, "ActionOnValueChange_BLName");
        this.actionOnValueChange_FormulaName = new JetString(this, "ActionOnValueChange_FormulaName");
        this.actionOnValueChange_DataSourceType = new JetNumber(this, "ActionOnValueChange_DataSourceType");
        this.useCurrentDate = new JetBoolean(this, "UseCurrentDate");
        this.useCurrentDateWhenBlank = new JetBoolean(this, "UseCurrentDateWhenBlank");
        this.dynamicTemplate = new JetString(this, "DynamicTemplate");
        this.isCascading = new JetBoolean(this, "IsCascading");
        this.previousLevel = new JetString(this, "PreviousLevel");
        this.nextLevel = new JetString(this, "NextLevel");
        this.chainID = new JetString(this, "ChainID");
        this.isAllowAll = new JetBoolean(this, "IsAllowAll");
        this.isAllSelected = new JetBoolean(this, "IsAllSelected", true);
        this.isSetAsParameter = new JetBoolean(this, "IsSetAsParameter");
        this.hideParameterWhenSingleValueReturn = new JetBoolean(this, "HideParameterWhenSingleValueReturn");
        this.type.addPropertyChangeListener(this);
        this.maxValue.addPropertyChangeListener(this);
        this.minValue.addPropertyChangeListener(this);
        this.vLimit.addPropertyChangeListener(this);
        this.vValue.setEditFlag(0);
        this.vValue_isExpression.setEditFlag(0);
        this.vValue_expressionName.setEditFlag(0);
        this.vValue_selectedDate.setEditFlag(0);
        this.cascadParamBindQueryName = new JetString(this, "CascadingQueryName");
        this.cascadParamBindQueryName.setEditFlag(3);
        this.queryName = new JetString(this, "QueryName");
        this.sortType = new JetNumber(this, "SortType");
        this.sortByColumns = new JetVector(this, "SortByColumns");
        this.sortByColumnsType = new JetVector(this, "SortByColumnsType");
    }

    public boolean equalsTo(JetUParameter param) {
        return this.getParamDesc().equals(param.getParamDesc());
    }

    public JetUParameter createNew() {
        JetUParameter ret = new JetUParameter(this.getResourceName(), this.getDesc(), this.getType(), this.getPrompt(), this.getLimit(), this.getValues(), this.getFormat(), this.getOperation(), this.getDefaultIndex());
        ret.column.set(this.column.get());
        ret.columns.set(this.columns.get());
        ret.distinct.set(this.distinct.get());
        ret.dataSourceName.set(this.dataSourceName.get());
        ret.bvName.set(this.bvName.get());
        ret.isDynamicParam.set(this.isDynamicParam.get());
        ret.getValueFromAPI.set(this.getValueFromAPI.get());
        ret.req.set(this.req.get());
        ret.importSql.set(this.importSql.get());
        ret.securityEntry.set(this.securityEntry.get());
        ret.referParams.set(this.referParams.get());
        ret.useCurrentDate.set(this.useCurrentDate.get());
        ret.useCurrentDateWhenBlank.set(this.useCurrentDateWhenBlank.get());
        ret.dynamicTemplate.set(this.dynamicTemplate.get());
        ret.previousLevel.set(this.previousLevel.get());
        ret.nextLevel.set(this.nextLevel.get());
        ret.chainID.set(this.chainID.get());
        ret.hideParameterWhenSingleValueReturn.set(this.hideParameterWhenSingleValueReturn.get());
        ret.isAllowAll.set(this.isAllowAll.get());
        ret.isAllSelected.set(this.isAllSelected.get());
        ret.isCascading.set(this.isCascading.get());
        ret.isMultipleValue.set(this.isMultipleValue.get());
        ret.whenOutOfRange.set(this.whenOutOfRange.get());
        ret.allowTypeIn.set(this.allowTypeIn.get());
        ret.maxValue.set(this.maxValue.get());
        ret.minValue.set(this.minValue.get());
        ret.binding.set(this.binding.get());
        ret.isStringNull.set(this.isStringNull.get());
        ret.stringFormat.set(this.stringFormat.get());
        ret.isSetAsParameter.set(this.isSetAsParameter.get());
        ret.sortType.set(this.sortType.get());
        ret.sortByColumns.set(this.sortByColumns.get());
        ret.sortByColumnsType.set(this.sortByColumnsType.get());
        ret.actionOnValueChange_nullFlag.set(this.actionOnValueChange_nullFlag.get());
        ret.actionOnValueChange_Catalog.set(this.actionOnValueChange_Catalog.get());
        ret.actionOnValueChange_DataSource.set(this.actionOnValueChange_DataSource.get());
        ret.actionOnValueChange_QueryName.set(this.actionOnValueChange_QueryName.get());
        ret.actionOnValueChange_BLName.set(this.actionOnValueChange_BLName.get());
        ret.actionOnValueChange_FormulaName.set(this.actionOnValueChange_FormulaName.get());
        ret.actionOnValueChange_DataSourceType.set(this.actionOnValueChange_DataSourceType.get());
        if (!this.queryName.get().equals("")) {
            ret.queryName.set(this.queryName.get());
        }
        return ret;
    }

    public void checkParameter(Locale locale) throws InvalidParameterException {
        ParamDesc paramDes = this.getParamDesc();
        if (this.column.get() == null) {
            this.setvValueGroup(paramDes.getValues());
        }
        this.vLimit.set(paramDes.getLimit());
        paramDes.initParam(locale);
    }

    public String getPrompt() {
        return this.promptText.get();
    }

    public void setPrompt(String strPrompt) {
        this.promptText.set(strPrompt);
    }

    public String getType() {
        return this.type.get();
    }

    public UserInput getDefaultValue() {
        int dex = this.index.get();
        Vector<UserInput> v = this.getvValueGroup();
        if (v == null || v.size() == 0) {
            return null;
        }
        if (dex == -1 || dex >= v.size()) {
            return v.lastElement();
        }
        return v.elementAt(dex);
    }

    public DbValue getValue() {
        return this.getParamDesc().getValue();
    }

    @Override
    public JetUDatabase getDatabase() {
        JetContainable p = this.getParent();
        if (p instanceof JetUDatabase) {
            return (JetUDatabase)p;
        }
        return null;
    }

    public SymbolInfo getInfo() {
        return this.getParamDesc().getInfo();
    }

    @Override
    public DbColDesc getColDesc() {
        ParamDesc paramDesc = this.getParamDesc();
        DbColDesc dcd = (DbColDesc)paramDesc.getColDesc().clone();
        switch (paramDesc.getInfo().getDataType()) {
            case 3: {
                dcd.sqlType = 3;
                break;
            }
            case 4: {
                dcd.sqlType = -7;
            }
        }
        this.addCaseSensitiveInfo(dcd);
        this.addEncodingPattern(dcd);
        return dcd;
    }

    public JetUDBTreeNode[] copy() {
        if (this.isCascading.get()) {
            return this.copyCascadingParameter();
        }
        JetUDBTreeNode[] UDBTreeNodes = new JetUDBTreeNode[1];
        JetUParameter newParam = this.createNew();
        JetObject.copyProperties(newParam, this);
        newParam.setResourceName(this.createCopyParameterName());
        UDBTreeNodes[0] = newParam;
        return UDBTreeNodes;
    }

    private String createCopyParameterName() {
        return this.createCopyParameterName(null);
    }

    private String createCopyParameterName(String strName) {
        if (strName == null) {
            strName = this.getResourceName();
        }
        JetUDatabase db = this.getDatabase();
        int i = 1;
        String strTmp = "Copy_of_" + strName;
        while (db.IsMappingNameExist(strTmp)) {
            strTmp = "Copy_(" + String.valueOf(++i) + ")_of_" + strName;
        }
        return strTmp;
    }

    private JetUDBTreeNode[] copyCascadingParameter() {
        if (!this.isCascading.get()) {
            return null;
        }
        Vector<ParamDesc> paramDescs = new Vector<ParamDesc>();
        Vector cascadingParams = this.getCascadingParams();
        for (JetUParameter cascadingParam : cascadingParams) {
            paramDescs.add(cascadingParam.getParamDesc());
        }
        int paramDescSize = paramDescs.size();
        JetUDBTreeNode[] UDBTreeNodes = new JetUDBTreeNode[paramDescSize];
        int index = 0;
        ParamDesc firstParamDesc = (ParamDesc)paramDescs.elementAt(0);
        String newChainID = this.createCopyParameterName(firstParamDesc.getChainID());
        Vector<String> oldNames = new Vector<String>();
        Vector<String> newNames = new Vector<String>();
        for (int i = 0; i < paramDescSize; ++i) {
            ParamDesc paramDesc = (ParamDesc)paramDescs.elementAt(i);
            String curName = paramDesc.name;
            String curNewName = this.createCopyParameterName(paramDesc.name);
            oldNames.add(curName);
            newNames.add(curNewName);
            paramDesc.name = curNewName;
            String curPreLevel = paramDesc.getPreviousLevel();
            String curNextLevel = paramDesc.getNextLevel();
            if (curPreLevel != null && !curPreLevel.equals("")) {
                ParamDesc preParamDesc = (ParamDesc)paramDescs.elementAt(i - 1);
                preParamDesc.setCascadingInfo(newChainID, preParamDesc.getPreviousLevel(), curNewName, preParamDesc.isSetAsParameter());
            }
            if (curNextLevel == null || curNextLevel.equals("")) continue;
            ParamDesc nextParamDesc = (ParamDesc)paramDescs.elementAt(i + 1);
            nextParamDesc.setCascadingInfo(newChainID, curNewName, nextParamDesc.getNextLevel(), nextParamDesc.isSetAsParameter());
            Vector importParams = nextParamDesc.getImportParams();
            Vector<String> newImportParams = new Vector<String>();
            int size = importParams.size();
            for (int indexImportParam = 0; indexImportParam < size; ++indexImportParam) {
                String importParamStr = (String)importParams.elementAt(indexImportParam);
                newImportParams.add(importParamStr);
            }
            String importSql = nextParamDesc.getImportSql();
            for (int k = 0; k < oldNames.size(); ++k) {
                for (int j = 0; j < newImportParams.size(); ++j) {
                    String pName = ((String)newImportParams.elementAt(j)).toString();
                    if (!((String)oldNames.elementAt(k)).equals(pName)) continue;
                    newImportParams.setElementAt((String)newNames.elementAt(k), j);
                    break;
                }
                importSql = importSql.replaceFirst("@\"" + (String)oldNames.elementAt(k) + "\"", "@\"" + (String)newNames.elementAt(k) + "\"");
            }
            nextParamDesc.setImportParams(newImportParams);
            nextParamDesc.setImportSql(importSql);
        }
        for (ParamDesc paramDesc : paramDescs) {
            JetUParameter newParam = JetUParameter.createParameter(paramDesc);
            UDBTreeNodes[index++] = newParam;
        }
        return UDBTreeNodes;
    }

    private Vector getCascadingParams() {
        Vector cascadingParams = new Vector();
        if (!this.isCascading.get()) {
            return cascadingParams;
        }
        JetUDatabase uDatabase = this.getDatabase();
        String PLevel = this.previousLevel.get();
        String NLevel = this.nextLevel.get();
        Vector<JetUParameter> PreParams = new Vector<JetUParameter>();
        Vector<JetUParameter> NextParams = new Vector<JetUParameter>();
        while (PLevel != null && !"".equals(PLevel)) {
            JetUParameter preParam = (JetUParameter)uDatabase.getResourceByName(PLevel);
            PLevel = preParam.previousLevel.get();
            PreParams.add(preParam);
        }
        for (int i = PreParams.size(); i > 0; --i) {
            cascadingParams.add(PreParams.elementAt(i - 1));
        }
        cascadingParams.add(this);
        while (NLevel != null && !"".equals(NLevel)) {
            JetUParameter nextParam = (JetUParameter)uDatabase.getResourceByName(NLevel);
            NLevel = nextParam.nextLevel.get();
            NextParams.add(nextParam);
        }
        for (JetUParameter param : NextParams) {
            cascadingParams.add(param);
        }
        return cascadingParams;
    }

    public boolean rename(String newName) {
        JetUDatabase db = this.getDatabase();
        StringBuffer error = new StringBuffer();
        if (!this.getUniverse().IsMappingNameOK(newName, error)) {
            return false;
        }
        if (this.isCascading.get()) {
            JetUParameter nextParam;
            String nextName;
            String oldName = this.getResourceName();
            String prevName = this.previousLevel.get();
            if (prevName != null && prevName.length() > 0) {
                JetUParameter prevParam = (JetUParameter)db.getResourceByName(prevName);
                prevParam.nextLevel.set(newName);
            }
            if ((nextName = this.nextLevel.get()) != null && nextName.length() > 0) {
                nextParam = (JetUParameter)db.getResourceByName(nextName);
                nextParam.previousLevel.set(newName);
            }
            while (nextName != null && nextName.length() > 0) {
                nextParam = (JetUParameter)db.getResourceByName(nextName);
                String impSql = nextParam.importSql.get().replaceFirst("@\"" + oldName + "\"", "@\"" + newName + "\"");
                nextParam.importSql.set(impSql);
                Vector importParams = nextParam.referParams.get();
                for (int i = 0; i < importParams.size(); ++i) {
                    String pName = importParams.elementAt(i).toString();
                    if (!pName.equals(oldName)) continue;
                    importParams.setElementAt(newName, i);
                    break;
                }
                nextParam.referParams.set(importParams);
                nextName = nextParam.nextLevel.get();
            }
        }
        this.setResourceName(newName);
        return true;
    }

    @Override
    public String getDefinition() {
        return "Prompt: " + this.promptText.get() + ", Type: " + this.type.get() + ", Limitation: " + this.vLimit.get() + ", Default value: " + this.getvValueGroup() + ", User Format: " + this.userFormat.get() + ", Operation: " + this.operation.get() + ", Index: " + this.index.get() + ", dbColDesc: " + this.getColDesc() + ",WhenOutOfRange: " + this.whenOutOfRange.get();
    }

    @Override
    JetObject getDefaultGUIFieldObject() {
        try {
            return (JetObject)Class.forName("jet.report.JetRptParameterField").newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    void initGUIFieldObject(JetObject guiFieldObj) {
        guiFieldObj.nameToProperty("Parameter").set(this.getResourceName());
    }

    @Override
    public String toString() {
        return this.getDefinition();
    }

    public ParamDesc getNoRangeCheckParamDesc() {
        return this.getParamDesc(false);
    }

    public ParamDesc getParamDesc() {
        return this.getParamDesc(true);
    }

    private ParamDesc getParamDesc(boolean checkRange) {
        ParamDesc paramDesc = null;
        paramDesc = checkRange ? new ParamDesc(this.name.get(), this.type.get(), this.promptText.get(), this.vLimit.get(), this.getvValueGroup(), this.userFormat.get(), this.operation.get(), this.index.get(), this.getBinding(), this.isMultipleValue.get()) : new NoRangeCheckParamDesc(this.name.get(), this.type.get(), this.promptText.get(), this.vLimit.get(), this.getvValueGroup(), this.userFormat.get(), this.operation.get(), this.index.get(), this.getBinding(), this.isMultipleValue.get());
        paramDesc.setColumn(this.column.get());
        paramDesc.setColumns(this.columns.get());
        paramDesc.setDistinct(this.distinct.get());
        paramDesc.setBVName(this.bvName.get());
        paramDesc.setIsDynamicParam(this.isDynamicParam.get());
        paramDesc.setDataMappingFile(this.getDataMappingFile());
        paramDesc.setGetValueFromAPI(this.getValueFromAPI.get());
        paramDesc.setRequired(this.req.get());
        paramDesc.setImportSql(this.importSql.get());
        paramDesc.setSecurityEntry(this.securityEntry.get());
        paramDesc.setImportParams(this.referParams.get());
        paramDesc.setUseCurrentDate(this.useCurrentDate.get());
        paramDesc.setUseCurrentDateWhenBlank(this.useCurrentDateWhenBlank.get());
        paramDesc.setDynamicTemplate(this.dynamicTemplate.get());
        paramDesc.setCascadingInfo(this.chainID.get(), this.previousLevel.get(), this.nextLevel.get(), this.isSetAsParameter.get());
        paramDesc.setHideParameterWhenSingleValueReturn(this.hideParameterWhenSingleValueReturn.get());
        if (this.getDatabase() != null) {
            paramDesc.setDataSource(this.getDatabase().getResourceName());
        } else {
            paramDesc.setDataSource(this.dataSourceName.get());
        }
        paramDesc.isStringNull = this.isStringNull.get();
        paramDesc.setIsMultipleValue(this.isMultipleValue.get());
        paramDesc.setAllowTypeIn(this.allowTypeIn.get());
        paramDesc.setWhenOutOfRange(this.whenOutOfRange.get());
        if (this.isMultipleValue.get()) {
            paramDesc.setAllowAll(this.isAllowAll.get());
            paramDesc.setAllSelected(this.isAllSelected.get());
        }
        paramDesc.stringFormat = this.stringFormat.get();
        paramDesc.isSetAsParameter();
        paramDesc.setIsCascading(this.isCascading.get());
        if (!this.actionOnValueChange_nullFlag.get()) {
            paramDesc.def.defineValueChangeAction(this.actionOnValueChange_Catalog.get(), this.actionOnValueChange_DataSource.get(), this.actionOnValueChange_QueryName.get(), this.actionOnValueChange_BLName.get(), this.actionOnValueChange_DataSourceType.get(), this.actionOnValueChange_FormulaName.get());
        }
        if (this.isMultipleValue.booleanValue() && this.isAllowAll.booleanValue()) {
            paramDesc.setAllSelected(true);
        }
        Definition definition = paramDesc.getDefinition();
        if (!this.queryName.get().equals("")) {
            definition.defineBindColumn(this.queryName.get(), this.column.get(), this.columns.get(), 0);
        } else {
            this.setDefineBindColumn(paramDesc, this.referQueryName, this.referQueryColumn, this.referQueryDisplayColumn);
        }
        if (this.sortType.get() == 0) {
            definition.clearSortInfo();
        } else {
            Vector sortByTypes = this.sortByColumnsType.get();
            Vector<SortByColumn> vSortByColumns = new Vector<SortByColumn>();
            for (int i = 0; i < sortByTypes.size(); ++i) {
                vSortByColumns.add(new SortByColumn(Integer.valueOf(sortByTypes.elementAt(i).toString()), this.sortByColumns.get().elementAt(i).toString()));
            }
            definition.defineSortInfo(this.sortType.get(), vSortByColumns);
        }
        return paramDesc;
    }

    public Vector getValues() {
        return this.getvValueGroup();
    }

    public int getDefaultIndex() {
        return this.index.get();
    }

    public int getOperation() {
        return this.operation.get();
    }

    public String getFormat() {
        return this.userFormat.get();
    }

    public Vector getLimit() {
        return this.vLimit.get();
    }

    public int getWhenOutOfRange() {
        return this.whenOutOfRange.get();
    }

    public static JetUParameter createParameter(ParamDesc paramDesc) {
        ValueListSortInfo valueListSortInfo;
        Vector value = new Vector();
        if (paramDesc.getColumn() == null) {
            value = paramDesc.getValues(null);
        }
        JetUParameter uParam = new JetUParameter(paramDesc.getName(), "", paramDesc.getType(), paramDesc.getPrompt(), paramDesc.getLimit(), value, paramDesc.getFormat(), paramDesc.getOperation(), paramDesc.getDefaultIndex());
        uParam.column.set(paramDesc.getColumn());
        uParam.columns.set(paramDesc.getColumns());
        uParam.distinct.set(paramDesc.isDistinct());
        uParam.dataSourceName.set(paramDesc.getDataSource());
        uParam.bvName.set(paramDesc.getBVName());
        uParam.isDynamicParam.set(paramDesc.isDynamicParam());
        uParam.getValueFromAPI.set(paramDesc.isGetValueFromAPI());
        uParam.req.set(paramDesc.isRequired());
        uParam.importSql.set(paramDesc.getImportSql());
        uParam.securityEntry.set(paramDesc.getSecurityEntry());
        uParam.referParams.set(paramDesc.getImportParams());
        uParam.createDescription();
        uParam.isStringNull.set(paramDesc.isStringNull);
        uParam.isMultipleValue.set(paramDesc.isMultipleValue());
        uParam.allowTypeIn.set(paramDesc.isAllowTypeIn());
        uParam.whenOutOfRange.set(paramDesc.getWhenOutOfRange());
        uParam.stringFormat.set(paramDesc.stringFormat);
        uParam.useCurrentDate.set(paramDesc.isUseCurrentDate());
        uParam.useCurrentDateWhenBlank.set(paramDesc.isUseCurrentDateWhenBlank());
        uParam.dynamicTemplate.set(paramDesc.getDynamicTemplate());
        uParam.isCascading.set(paramDesc.isCascading());
        ActionOnValueChange action = paramDesc.def.getValueChangeAction();
        if (action == null) {
            uParam.actionOnValueChange_nullFlag.set(true);
        } else {
            uParam.actionOnValueChange_nullFlag.set(false);
            uParam.actionOnValueChange_Catalog.set(action.getCatalog());
            uParam.actionOnValueChange_DataSource.set(action.getDataSource());
            uParam.actionOnValueChange_QueryName.set(action.getQueryName());
            uParam.actionOnValueChange_BLName.set(action.getBLName());
            uParam.actionOnValueChange_FormulaName.set(action.getFormulaName());
            uParam.actionOnValueChange_DataSourceType.set(action.getDataSourceType());
        }
        uParam.previousLevel.set(paramDesc.getPreviousLevel());
        uParam.nextLevel.set(paramDesc.getNextLevel());
        uParam.chainID.set(paramDesc.getChainID());
        uParam.isAllowAll.set(paramDesc.isAllowAll());
        uParam.isAllSelected.set(paramDesc.isAllSelected());
        uParam.isSetAsParameter.set(paramDesc.isSetAsParameter());
        uParam.hideParameterWhenSingleValueReturn.set(paramDesc.isHideParameterWhenSingleValueReturn());
        BindColumn bindColumn = paramDesc.getDefinition().getBindColumn();
        if (bindColumn != null && bindColumn.getQueryName() != null) {
            uParam.queryName.set(bindColumn.getQueryName());
            uParam.column.set(bindColumn.getValueColumn());
            uParam.columns.set(bindColumn.getDisplayColumns());
        }
        if ((valueListSortInfo = paramDesc.getDefinition().getSortInfo()) != null) {
            uParam.sortType.set(valueListSortInfo.getSortType());
            Vector sortInfos = valueListSortInfo.getSortByColumns();
            Vector<String> vSortByColumnsType = new Vector<String>();
            Vector<String> vSortByColumn = new Vector<String>();
            for (SortByColumn sby : sortInfos) {
                vSortByColumnsType.add("" + sby.getSortType());
                vSortByColumn.add(sby.getSortByColumn());
            }
            uParam.sortByColumnsType.set(vSortByColumnsType);
            uParam.sortByColumns.set(vSortByColumn);
        }
        uParam.checkType();
        return uParam;
    }

    public void setParameter(ParamDesc paramDesc) {
        BindColumn bindColumn;
        Vector v = paramDesc.getLimit();
        this.vLimit.removePropertyChangeListener(this);
        this.maxValue.removePropertyChangeListener(this);
        this.minValue.removePropertyChangeListener(this);
        this.promptText.set(paramDesc.getPrompt());
        this.type.set(paramDesc.getType());
        if (paramDesc.getColumn() == null) {
            this.setvValueGroup(paramDesc.getValues(null));
        } else {
            this.setvValueGroup(new Vector<UserInput>());
        }
        this.vLimit.set(v);
        switch (v.size()) {
            case 1: {
                this.minValue.set((String)v.elementAt(0));
                this.maxValue.set("");
                break;
            }
            case 2: {
                this.minValue.set((String)v.elementAt(0));
                this.maxValue.set((String)v.elementAt(1));
                break;
            }
            default: {
                this.minValue.set("");
                this.maxValue.set("");
            }
        }
        this.vLimit.addPropertyChangeListener(this);
        this.maxValue.addPropertyChangeListener(this);
        this.minValue.addPropertyChangeListener(this);
        this.userFormat.set(paramDesc.getFormat());
        this.operation.set(paramDesc.getOperation());
        this.index.set(paramDesc.getDefaultIndex());
        this.column.set(paramDesc.getColumn());
        this.columns.set(paramDesc.getColumns());
        this.distinct.set(paramDesc.isDistinct());
        this.dataSourceName.set(paramDesc.getDataSource());
        this.bvName.set(paramDesc.getBVName());
        this.isDynamicParam.set(paramDesc.isDynamicParam());
        this.getValueFromAPI.set(paramDesc.isGetValueFromAPI());
        this.req.set(paramDesc.isRequired());
        this.importSql.set(paramDesc.getImportSql());
        this.securityEntry.set(paramDesc.getSecurityEntry());
        this.referParams.set(paramDesc.getImportParams());
        this.isStringNull.set(paramDesc.isStringNull);
        this.isMultipleValue.set(paramDesc.isMultipleValue());
        this.allowTypeIn.set(paramDesc.isAllowTypeIn());
        this.whenOutOfRange.set(paramDesc.getWhenOutOfRange());
        this.stringFormat.set(paramDesc.stringFormat);
        this.useCurrentDate.set(paramDesc.isUseCurrentDate());
        this.useCurrentDateWhenBlank.set(paramDesc.isUseCurrentDateWhenBlank());
        this.dynamicTemplate.set(paramDesc.getDynamicTemplate());
        this.isCascading.set(paramDesc.isCascading());
        ActionOnValueChange action = paramDesc.def.getValueChangeAction();
        if (action == null) {
            this.actionOnValueChange_nullFlag.set(true);
        } else {
            this.actionOnValueChange_nullFlag.set(false);
            this.actionOnValueChange_Catalog.set(action.getCatalog());
            this.actionOnValueChange_DataSource.set(action.getDataSource());
            this.actionOnValueChange_QueryName.set(action.getQueryName());
            this.actionOnValueChange_BLName.set(action.getBLName());
            this.actionOnValueChange_FormulaName.set(action.getFormulaName());
            this.actionOnValueChange_DataSourceType.set(action.getDataSourceType());
        }
        this.previousLevel.set(paramDesc.getPreviousLevel());
        this.nextLevel.set(paramDesc.getNextLevel());
        this.chainID.set(paramDesc.getChainID());
        this.isAllowAll.set(paramDesc.isAllowAll());
        this.isAllSelected.set(paramDesc.isAllSelected());
        this.isSetAsParameter.set(paramDesc.isSetAsParameter());
        this.hideParameterWhenSingleValueReturn.set(paramDesc.isHideParameterWhenSingleValueReturn());
        this.setFormatDefault(MappingSQLType.mapSQLTypeToInt(paramDesc.getType()));
        this.createDescription();
        if (this.referQueryName != null) {
            this.getDatabase().removeQuery(this.referQueryName);
            this.referQueryName = null;
        }
        if ((bindColumn = paramDesc.getDefinition().getBindColumn()) != null && bindColumn.getQueryName() != null) {
            this.queryName.set(bindColumn.getQueryName());
            this.column.set(bindColumn.getValueColumn());
            this.columns.set(bindColumn.getDisplayColumns());
        } else {
            this.queryName.set("");
        }
        ValueListSortInfo valueListSortInfo = paramDesc.getDefinition().getSortInfo();
        if (valueListSortInfo != null) {
            this.sortType.set(valueListSortInfo.getSortType());
            Vector sortInfos = valueListSortInfo.getSortByColumns();
            Vector<String> vSortByColumnsType = new Vector<String>();
            Vector<String> vSortByColumn = new Vector<String>();
            for (SortByColumn sby : sortInfos) {
                vSortByColumnsType.add("" + sby.getSortType());
                vSortByColumn.add(sby.getSortByColumn());
            }
            this.sortByColumns.set(vSortByColumn);
            this.sortByColumns.set(vSortByColumn);
        }
        this.checkType();
    }

    public void setDefaultValue(String value) {
        UnevaluatedValueListItem userInput = new UnevaluatedValueListItem(value, false, null, null);
        this.setDefaultValue(userInput);
    }

    public void setDefaultValue(UserInput userInput) {
        int idx = this.vValue.get().indexOf(userInput);
        if (idx > -1) {
            this.index.set(idx);
        } else {
            Vector<UserInput> v = this.getvValueGroup();
            v.add(userInput);
            this.setvValueGroup(v);
        }
    }

    public void setBinding(String binding) {
        this.binding.set(binding);
    }

    public String getBinding() {
        String ret = this.binding.get();
        return ret.equals("") ? null : ret;
    }

    @Override
    public String getInstancePrefix() {
        return "Parameter";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        if (source == this.maxValue || source == this.minValue) {
            Vector<String> v = new Vector<String>();
            v.addElement(this.minValue.get());
            v.addElement(this.maxValue.get());
            this.vLimit.removePropertyChangeListener(this);
            this.vLimit.set(v);
            this.vLimit.addPropertyChangeListener(this);
        } else if (source == this.vLimit) {
            Vector<String> v = this.vLimit.get();
            int size = v.size();
            if (size == 2) {
                this.minValue.removePropertyChangeListener(this);
                this.minValue.set((String)v.elementAt(0));
                this.maxValue.removePropertyChangeListener(this);
                this.maxValue.set((String)v.elementAt(1));
                this.minValue.addPropertyChangeListener(this);
                this.maxValue.addPropertyChangeListener(this);
            } else {
                v = new Vector<String>();
                v.addElement(this.minValue.get());
                v.addElement(this.maxValue.get());
                this.vLimit.removePropertyChangeListener(this);
                this.vLimit.set(v);
                this.vLimit.addPropertyChangeListener(this);
            }
        } else if (source == this.type) {
            this.checkType();
        }
    }

    void checkType() {
        String ty = this.type.get();
        if (ty.equalsIgnoreCase("Boolean")) {
            this.maxValue.setEditFlag(0);
            this.minValue.setEditFlag(0);
        } else if (ty.equalsIgnoreCase("String") && !"".equals(this.column.get())) {
            this.maxValue.setEditFlag(0);
            this.minValue.setEditFlag(0);
        } else {
            this.maxValue.setEditFlag(2);
            this.minValue.setEditFlag(2);
        }
        if (this.isCascading.get()) {
            this.importSql.setEditFlag(3);
        } else {
            this.importSql.setEditFlag(2);
        }
        if (!this.queryName.get().equals("")) {
            this.importSql.setEditFlag(0);
        }
    }

    @Override
    public boolean isSimilar(JetUResourceEntity field) {
        boolean bRet;
        JetUParameter tFormula = (JetUParameter)field;
        boolean bl = bRet = super.isSimilar(field) && this.type.equal(tFormula.type);
        if (bRet) {
            String src = this.column.get();
            String target = tFormula.column.get();
            if (src != null && target != null) {
                bRet = src.equalsIgnoreCase(target);
            }
        }
        return bRet;
    }

    @Override
    public boolean isSimilarExceptName(JetUResourceEntity field) {
        boolean bRet;
        JetUParameter tFormula = (JetUParameter)field;
        boolean bl = bRet = super.isSimilarExceptName(field) && this.type.equal(tFormula.type);
        if (bRet) {
            String src = this.column.get();
            String target = tFormula.column.get();
            if (src != null && target != null) {
                bRet = src.equalsIgnoreCase(target);
            }
        }
        return bRet;
    }

    public boolean isReferPara() {
        Vector refP = this.referParams.get();
        return refP != null && refP.size() > 0;
    }

    public void getAllReferP(JetUUniverse unvs, String dsName, String strQueryName, Hashtable referUParam) {
        Vector mappingFlds = this.referParams.get();
        int iFldCount = mappingFlds.size();
        for (int i = 0; i < iFldCount; ++i) {
            JetUResourceEntity en;
            String strRscName = (String)mappingFlds.elementAt(i);
            JetUResourceEntity entity = dsName != null ? unvs.getResourceByName(dsName, strQueryName, strRscName) : unvs.getResourceByName(strQueryName, strRscName);
            if (entity == null && (en = unvs.getAnyResourceByName(strRscName)) != null && en instanceof JetUParameter) {
                entity = en;
            }
            if (entity == null || !(entity instanceof JetUParameter)) continue;
            JetUParameter up = (JetUParameter)entity;
            referUParam.put(strRscName, entity);
            if (!up.isReferPara()) continue;
            up.getAllReferP(unvs, dsName, strQueryName, referUParam);
        }
    }

    public JetUParamBuildInUQuery createCascadParamRefedQuery(JetUParameter param) {
        JetUParamBuildInUQuery buildInCRDQuery = null;
        if (param != null && param.isCascading.get()) {
            String tempQueryName = "\u007fUQ~Cascading-" + param.chainID.get();
            JetUQuery query = this.getDatabase().GetQueryByResourceName(tempQueryName);
            if (query == null) {
                Vector columns = new Vector();
                this.getColumnsOfCascadingParameter(param, columns);
                String queryName = tempQueryName;
                RptPsqlQuery rptPsqlQuery = new RptPsqlQuery();
                rptPsqlQuery.setUniverse(this.getUniverse(), this.getDatabase().getResourceName());
                JetField entity = (JetField)((Object)this.getDatabase().getResourceByName(param.column.get()));
                if (entity == null) {
                    return null;
                }
                rptPsqlQuery.setUConnection(entity.getConnection());
                rptPsqlQuery.setMappingName(queryName);
                for (int i = 0; i < columns.size(); ++i) {
                    rptPsqlQuery.addUFieldByName(columns.get(i).toString());
                }
                Vector sortCol = param.sortByColumns.get();
                if (sortCol != null) {
                    for (int i = 0; i < sortCol.size(); ++i) {
                        rptPsqlQuery.addUFieldByName(sortCol.get(i).toString());
                    }
                }
                buildInCRDQuery = new JetUParamBuildInUQuery(queryName, rptPsqlQuery);
                this.bindCRDQueryToCascadingParam(buildInCRDQuery, param);
            }
        }
        return buildInCRDQuery;
    }

    private void getColumnsOfCascadingParameter(JetUParameter param, Vector ret) {
        if (param != null && param.isCascading.get()) {
            JetUParameter parameter = null;
            Vector<Object> value = new Vector<Object>();
            parameter = param;
            String s = parameter.nextLevel.get();
            while (!"".equals(s)) {
                parameter = this.getDatabase().getParameterByResourceName(s);
                s = parameter.nextLevel.get();
            }
            value.add(parameter.column.get());
            value.add(parameter.columns.get());
            String previousLevel = parameter.previousLevel.get();
            while (!"".equals(previousLevel) && (parameter = this.getDatabase().getParameterByResourceName(previousLevel)) != null) {
                value.add(parameter.columns.get());
                value.add(parameter.column.get());
                previousLevel = parameter.previousLevel.get();
            }
            for (int i = 0; i < value.size(); ++i) {
                if (value.get(i) instanceof Vector) {
                    Vector temp = (Vector)value.get(i);
                    for (int j = 0; j < temp.size(); ++j) {
                        ret.add(temp.get(j));
                    }
                    continue;
                }
                ret.add(value.get(i));
            }
        }
    }

    private void bindCRDQueryToCascadingParam(JetUParamBuildInUQuery buildInUQuery, JetUParameter param) {
        if (buildInUQuery != null && param != null) {
            Vector paramsOfDB = param.getDatabase().getParameters();
            for (int i = 0; i < paramsOfDB.size(); ++i) {
                JetUParameter tempParam = (JetUParameter)paramsOfDB.get(i);
                if (!param.chainID.equal(tempParam.chainID)) continue;
                String queryName = buildInUQuery.getResourceName();
                tempParam.setCascadParamBindQueryName(queryName);
            }
        }
    }

    public String getCascadParamBindQueryName() {
        return this.cascadParamBindQueryName.get();
    }

    private void setCascadParamBindQueryName(String queryName) {
        this.cascadParamBindQueryName.set(queryName);
    }

    public String getSecurityEntry() {
        return this.securityEntry.get();
    }

    public String getRunTimeRefedQueryName() {
        return this.referQueryName;
    }

    public void setRunTimeRefedQueryName(String value) {
        this.referQueryName = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindQueryToParameter(ParamDesc paramDesc, Connection conObj) {
        if (paramDesc.getColumn() != null && !"".equals(paramDesc.getColumn())) {
            Object object = this.referQuerLocker;
            synchronized (object) {
                if (this.referQueryName == null) {
                    JetUQueriable buildInQuery = null;
                    if (ReportEnv.productid == JRProductConstants.PRODUCTIDFORSERVER) {
                        String tempQueryName = fileQueryNamePrefix + paramDesc.getName();
                        buildInQuery = this.getDatabase().getQueriableByResourceName(tempQueryName);
                        logger.debug("Get existing buildinQuery by " + tempQueryName + " ==>  " + buildInQuery);
                        if (buildInQuery == null) {
                            tempQueryName = queryNamePrefix + paramDesc.getName();
                            buildInQuery = this.getDatabase().getQueriableByResourceName(tempQueryName);
                            logger.debug("Get existing buildinQuery by " + tempQueryName + " ==>  " + buildInQuery);
                        }
                    }
                    if (paramDesc.getImportSql() != null && !"".equals(paramDesc.getImportSql())) {
                        if (buildInQuery == null) {
                            buildInQuery = this.createParamRefedUQueryWithSQLStatement(paramDesc);
                        }
                        if (buildInQuery == null) {
                            buildInQuery = this.createParamRefedFileQuery(paramDesc, conObj);
                        }
                    }
                    if (buildInQuery == null) {
                        buildInQuery = this.createParamRefedUQuery(paramDesc);
                    }
                    if (buildInQuery != null) {
                        this.bindQueryToParam(buildInQuery, paramDesc);
                    }
                } else {
                    this.setDefineBindColumn(paramDesc, this.referQueryName, this.referQueryColumn, this.referQueryDisplayColumn);
                }
            }
        }
    }

    private boolean isBindColumnFromXmlConnection() {
        JetField entity;
        JetUConnection conn = null;
        if (this.getDatabase() != null && (entity = (JetField)((Object)this.getDatabase().getResourceByName(this.column.get()))) != null) {
            conn = entity.getConnection();
        }
        return conn instanceof JetUXMLConnection || conn instanceof JetUWebServiceConnection;
    }

    private JetUParamBuildInUQuery createParamRefedUQuery(ParamDesc paramDesc) {
        JetUParamBuildInUQuery buildInQuery = null;
        if (!paramDesc.getColumn().equals(null) && !paramDesc.getColumn().equals("")) {
            Vector sortCol;
            String colName = paramDesc.getColumn();
            String queryName = queryNamePrefix + paramDesc.getName();
            JetUParamBuildInUQuery tempQuery = (JetUParamBuildInUQuery)this.getDatabase().getQueriableByResourceName(queryName);
            if (tempQuery != null) {
                this.getDatabase().removeQuery(tempQuery);
            }
            RptPsqlQuery rptPsqlQuery = new RptPsqlQuery();
            rptPsqlQuery.setUniverse(this.getUniverse(), this.getDatabase().getResourceName());
            JetField entity = (JetField)((Object)this.getDatabase().getResourceByName(paramDesc.getColumn()));
            rptPsqlQuery.setUConnection(entity.getConnection());
            rptPsqlQuery.setMappingName(queryName);
            rptPsqlQuery.addUFieldByName(colName);
            rptPsqlQuery.setDistinct(paramDesc.isDistinct());
            Hashtable<String, String> fields = new Hashtable<String, String>();
            Vector cols = paramDesc.getColumns();
            for (int i = 0; i < cols.size(); ++i) {
                rptPsqlQuery.addUFieldByName(cols.get(i).toString());
                fields.put(cols.get(i).toString(), cols.get(i).toString());
            }
            ValueListSortInfo sortInfo = paramDesc.getDefinition().getSortInfo();
            if (sortInfo != null && (sortCol = sortInfo.getSortByColumns()) != null) {
                for (int i = 0; i < sortCol.size(); ++i) {
                    if (fields.get(sortCol.get(i).toString()) != null) continue;
                    rptPsqlQuery.addUFieldByName(sortCol.get(i).toString());
                    fields.put(sortCol.get(i).toString(), sortCol.get(i).toString());
                }
            }
            buildInQuery = new JetUParamBuildInUQuery(queryName, rptPsqlQuery);
            this.getDatabase().addQuery(buildInQuery);
        }
        return buildInQuery;
    }

    private JetUParamBuildInUQuery createParamRefedUQueryWithSQLStatement(ParamDesc paramDesc) {
        JetUParamBuildInUQuery buildInQuery = null;
        if (!paramDesc.getImportSql().equals(null) && !paramDesc.getImportSql().equals("")) {
            String sqlStatement = paramDesc.getImportSql();
            if (paramDesc.isDistinct() && !JetUParameter.hasDistinct(sqlStatement)) {
                sqlStatement = StringTools.replaceIngnoreCase(sqlStatement, selectToken, "SELECT DISTINCT", 0);
            }
            sqlStatement = this.buildCascadParamOrderSQL(paramDesc, sqlStatement);
            String queryName = queryNamePrefix + paramDesc.getName();
            JetUParamBuildInUQuery temp = (JetUParamBuildInUQuery)this.getDatabase().getQueriableByResourceName(queryName);
            if (temp != null) {
                this.getDatabase().removeQuery(temp);
            }
            RptPsqlQuery psqlQuery = new RptPsqlQuery(queryName);
            psqlQuery.setUniverse(this.getUniverse(), this.getDatabase().getResourceName());
            JetField entity = (JetField)((Object)this.getDatabase().getResourceByName(paramDesc.getColumn()));
            psqlQuery.setUConnection(entity.getConnection());
            try {
                ASTQueryStatement astquerystatement = QueryParser.parse(sqlStatement);
                if (!paramDesc.isCascading() && this.hasWhereClause(astquerystatement)) {
                    return null;
                }
                psqlQuery.reloadFromQueryTree(astquerystatement);
            }
            catch (ParseException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Parse sqlstatement error when create query with sql statement of parameter: \n SQL Statement : " + sqlStatement);
                }
                return null;
            }
            catch (ReloadQueryException e) {
                if (logger.isDebugEnabled()) {
                    logger.error("ReloadQuery error when create query with sql statement of parameter: \n SQL Statement : " + sqlStatement);
                }
                return null;
            }
            catch (Throwable e) {
                if (logger.isDebugEnabled()) {
                    logger.error("Other error when create query with sql statement of parameter: \n SQL Statement : " + sqlStatement);
                }
                return null;
            }
            buildInQuery = new JetUParamBuildInUQuery(queryName, psqlQuery);
            JetObject jetRptQuery = psqlQuery.createJetObject();
            buildInQuery.add(jetRptQuery);
            this.getDatabase().addQuery(buildInQuery);
        }
        return buildInQuery;
    }

    private boolean hasWhereClause(ASTQueryStatement root) {
        int sz = root.jjtGetNumChildren();
        Node n = null;
        for (int i = 0; i < sz; ++i) {
            n = root.jjtGetChild(i);
            if (!(n instanceof ASTWhereClause)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasDistinct(String sqlStatement) {
        String sqlString = sqlStatement.trim().toUpperCase();
        if (sqlString.startsWith(selectToken)) {
            return sqlString.substring(selectToken.length()).trim().startsWith(distinctToken);
        }
        return false;
    }

    private String buildCascadParamOrderSQL(ParamDesc paramDesc, String sqlStr) {
        ValueListSortInfo sortInfo = paramDesc.getDefinition().getSortInfo();
        if (sqlStr != null && sortInfo != null && 3 == sortInfo.getSortType() && sortInfo.getSortByColumns() != null) {
            String tempQueryName;
            Vector displayColumns = this.getNeedAddSelOrderCols(paramDesc);
            if (displayColumns.size() == 0) {
                return sqlStr;
            }
            String queryName = tempQueryName = "\u007fUQ~Cascading-order";
            RptPsqlQuery rptPsqlQuery = new RptPsqlQuery();
            rptPsqlQuery.setUniverse(this.getUniverse(), this.getDatabase().getResourceName());
            JetField entity = (JetField)((Object)this.getDatabase().getResourceByName(paramDesc.getColumn()));
            rptPsqlQuery.setUConnection(entity.getConnection());
            rptPsqlQuery.setMappingName(queryName);
            for (int i = 0; i < displayColumns.size(); ++i) {
                rptPsqlQuery.addUFieldByName(displayColumns.get(i).toString());
            }
            StringBuffer sqlBuf = new StringBuffer();
            String selOrder = rptPsqlQuery.getSQL();
            int index = (selOrder = StringTools.replaceAllIngnoreCase(selOrder, selectToken, "")).indexOf("FROM");
            if (index != -1) {
                selOrder = selOrder.substring(0, index);
            }
            index = sqlStr.indexOf("FROM");
            sqlBuf.append(sqlStr.substring(0, index - 1));
            sqlBuf.append("," + selOrder);
            sqlBuf.append(sqlStr.substring(index));
            return sqlBuf.toString();
        }
        return sqlStr;
    }

    private Vector getNeedAddSelOrderCols(ParamDesc paramDesc) {
        Vector<String> needAddSelOrderCols = new Vector<String>();
        if (paramDesc == null) {
            return needAddSelOrderCols;
        }
        ValueListSortInfo sortInfo = paramDesc.getDefinition().getSortInfo();
        if (sortInfo == null || sortInfo.getSortType() != 3) {
            return needAddSelOrderCols;
        }
        Vector orderCols = sortInfo.getSortByColumns();
        BindColumn bindColumn = paramDesc.getDefinition().getBindColumn();
        Vector<String> displayColumns = paramDesc.getColumns();
        if (displayColumns == null) {
            displayColumns = new Vector<String>();
        }
        if (paramDesc.getColumn() != null) {
            displayColumns.add(paramDesc.getColumn());
        }
        for (SortByColumn sbc : orderCols) {
            if (displayColumns.contains(sbc.getSortByColumn())) continue;
            needAddSelOrderCols.add(sbc.getSortByColumn());
        }
        return needAddSelOrderCols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JetUParamBuildInFileQuery createParamRefedFileQuery(ParamDesc paramDesc, Connection conObj) {
        JetUParamBuildInFileQuery buildInFileQuery = null;
        if (!paramDesc.getImportSql().equals(null) && !paramDesc.getImportSql().equals("")) {
            FileOutputStream outStream;
            File sqlFile;
            JetUJDBCConnection jdbccon;
            JetUDatabase db;
            Connection conn;
            String queryName;
            block20: {
                byte[] sqlByte;
                block19: {
                    queryName = fileQueryNamePrefix + paramDesc.getName();
                    String importSql = paramDesc.getImportSql();
                    boolean isDistinct = paramDesc.isDistinct();
                    int index = importSql.indexOf(distinctToken);
                    if (isDistinct && index == -1) {
                        importSql = StringTools.replaceAllIngnoreCase(importSql, selectToken, "SELECT DISTINCT");
                    }
                    conn = conObj;
                    db = this.getDatabase();
                    JetField entity = (JetField)((Object)db.getResourceByName(paramDesc.getColumn()));
                    jdbccon = (JetUJDBCConnection)entity.getConnection();
                    JetUParamBuildInFileQuery temp = (JetUParamBuildInFileQuery)jdbccon.GetFileQueryByResourceName(queryName);
                    if (temp != null) {
                        jdbccon.removeFileQuery(temp);
                    }
                    TempFile tempFile = new TempFile(this.getUniverse().getFilePath(), "SQLFile");
                    sqlFile = tempFile.createTempFile();
                    sqlByte = importSql.getBytes();
                    outStream = null;
                    try {
                        outStream = new FileOutputStream(sqlFile);
                    }
                    catch (FileNotFoundException e1) {
                        if (!logger.isDebugEnabled()) break block19;
                        logger.debug("File " + sqlFile.getPath() + " not found.");
                    }
                }
                try {
                    outStream.write(sqlByte);
                }
                catch (IOException e1) {
                    if (!logger.isDebugEnabled()) break block20;
                    logger.debug("");
                }
            }
            try {
                FileQuery fileQuery = FileQuery.createFileQuery(sqlFile.getPath(), this.getUniverse(), db.getResourceName(), null, jdbccon.getResourceName(), conn);
                buildInFileQuery = new JetUParamBuildInFileQuery(queryName, "", fileQuery);
                JetObject jetFileQuery = fileQuery.createJetObject();
                fileQuery.putToJetObject(jetFileQuery);
                buildInFileQuery.add(jetFileQuery);
                buildInFileQuery.connectionName.set(jdbccon.getResourceName());
                jdbccon.addFileQuery(buildInFileQuery);
            }
            catch (BadFileQueryException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Bad fileQuery!");
                }
                JetUParamBuildInFileQuery jetUParamBuildInFileQuery = null;
                return jetUParamBuildInFileQuery;
            }
            finally {
                block22: {
                    try {
                        outStream.close();
                        sqlFile.delete();
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) break block22;
                        logger.debug("OutStream close error. ");
                    }
                }
            }
        }
        return buildInFileQuery;
    }

    private void bindQueryToParam(JetUQueriable queriable, ParamDesc paramDesc) {
        String queriableName = queriable.getResourceName();
        Vector fields = queriable.getFields();
        String fieldName = null;
        Vector<String> displayColumn = new Vector<String>();
        ValueListSortInfo sortInfo = paramDesc.getDefinition().getSortInfo();
        Vector displayColumns = this.getNeedAddSelOrderCols(paramDesc);
        int orderColSize = displayColumns.size();
        if (fields.size() - orderColSize > 0) {
            fieldName = ((JetUResourceEntity)fields.get(0)).getResourceName();
            for (int i = 1; i < fields.size() - orderColSize; ++i) {
                displayColumn.add(((JetUResourceEntity)fields.get(i)).getResourceName());
            }
        }
        this.setDefineBindColumn(paramDesc, queriableName, fieldName, displayColumn);
        this.referQueryName = queriableName;
        this.referQueryColumn = fieldName;
        this.referQueryDisplayColumn = displayColumn;
    }

    private void setDefineBindColumn(ParamDesc paramDesc, String queriableName, String fieldName, Vector displayColumn) {
        Definition def = paramDesc.getDefinition();
        if (this.isBindColumnFromXmlConnection()) {
            if (queriableName == null) {
                this.bindQueryToParameter(paramDesc, null);
                def.defineBindColumn(this.referQueryName, this.referQueryColumn, this.referQueryDisplayColumn, 0);
            }
            def.defineBindColumn(queriableName, fieldName, displayColumn, 0);
        } else if (queriableName != null) {
            def.defineBindColumn(queriableName, fieldName, displayColumn);
        }
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return grpDesc;
    }

    @Override
    public void afterInit() {
        JetObject parent;
        super.afterInit();
        for (parent = (JetObject)((Object)this.getParent()); !(parent instanceof JetUUniverse) && parent != null; parent = (JetObject)((Object)parent.getParent())) {
        }
        if (parent == null) {
            return;
        }
        JetUUniverse universe = (JetUUniverse)parent;
        int version = universe.getVersion();
        if (version < 65550) {
            this.whenOutOfRange.set(1);
        } else if (version >= 65550 && version <= 65551) {
            if (!"".equals(this.column.get())) {
                this.whenOutOfRange.set(2);
            } else {
                this.whenOutOfRange.set(1);
            }
        }
        if (version <= 65551 && !"".equals(this.column.get())) {
            this.allowTypeIn.set(false);
        }
        this.checkType();
    }

    @Override
    public String getDataMappingFileAuto() {
        JetUResourceEntity entity;
        JetUDatabase database;
        if (this.isDynamicParam.get()) {
            return "";
        }
        String displayCol = null;
        Vector displayCols = this.columns.get();
        if (displayCols.size() > 0) {
            displayCol = (String)displayCols.get(0);
        } else if (!"".equals(this.column.get())) {
            displayCol = this.column.get();
        }
        if (displayCol != null && (database = this.getDatabase()) != null && (entity = database.getResourceByName(displayCol)) != null) {
            return entity.getDataMappingFile();
        }
        return "";
    }

    static {
        nameIdx.put("padding-right", new Integer(0));
        nameIdx.put("IsStringNull", new Integer(1));
        nameIdx.put("DefaultNo", new Integer(2));
        nameIdx.put("RightLine", new Integer(3));
        nameIdx.put("HorizontalAlignment", new Integer(4));
        nameIdx.put("Value", new Integer(5));
        nameIdx.put("PatternStyle", new Integer(6));
        nameIdx.put("Format", new Integer(7));
        nameIdx.put("ObjName", new Integer(8));
        nameIdx.put("Column", new Integer(9));
        nameIdx.put("MaxValue", new Integer(10));
        nameIdx.put("Bold", new Integer(11));
        nameIdx.put("AutoFit", new Integer(12));
        nameIdx.put("Width", new Integer(13));
        nameIdx.put("UserFormat", new Integer(14));
        nameIdx.put("DynamicTemplate", new Integer(15));
        nameIdx.put("ReferParams", new Integer(16));
        nameIdx.put("GUIField", new Integer(17));
        nameIdx.put("Height", new Integer(18));
        nameIdx.put("UseCurrentDateWhenBlank", new Integer(19));
        nameIdx.put("stringFormat", new Integer(20));
        nameIdx.put("Operation", new Integer(21));
        nameIdx.put("padding-bottom", new Integer(22));
        nameIdx.put("ImportSql", new Integer(23));
        nameIdx.put("Name", new Integer(24));
        nameIdx.put("ShadowColor", new Integer(25));
        nameIdx.put("Columns", new Integer(26));
        nameIdx.put("BottomLine", new Integer(27));
        nameIdx.put("padding-top", new Integer(28));
        nameIdx.put("Description", new Integer(29));
        nameIdx.put("Binding", new Integer(30));
        nameIdx.put("Required", new Integer(31));
        nameIdx.put("BorderWidth", new Integer(32));
        nameIdx.put("Background", new Integer(33));
        nameIdx.put("DisplayWidth", new Integer(34));
        nameIdx.put("VerticalAlignment", new Integer(35));
        nameIdx.put("PatternColor", new Integer(36));
        nameIdx.put("TopLine", new Integer(37));
        nameIdx.put("ObjParamName", new Integer(38));
        nameIdx.put("MinValue", new Integer(39));
        nameIdx.put("Limit", new Integer(40));
        nameIdx.put("FontSize", new Integer(41));
        nameIdx.put("Underline", new Integer(42));
        nameIdx.put("LeftLine", new Integer(43));
        nameIdx.put("Type", new Integer(44));
        nameIdx.put("FontFace", new Integer(45));
        nameIdx.put("Alignment", new Integer(46));
        nameIdx.put("padding-left", new Integer(47));
        nameIdx.put("WordWrap", new Integer(48));
        nameIdx.put("Italic", new Integer(49));
        nameIdx.put("UseCurrentDate", new Integer(50));
        nameIdx.put("StrikeOut", new Integer(51));
        nameIdx.put("BorderColor", new Integer(52));
        nameIdx.put("PromptText", new Integer(53));
        nameIdx.put("Foreground", new Integer(54));
        nameIdx.put("Distinct", new Integer(55));
        nameIdx.put("Shadow", new Integer(56));
        nameIdx.put("Record Level Secirity", new Integer(57));
        nameIdx.put("HideParameterWhenSingleValueReturn", new Integer(58));
        nameIdx.put("AllowUseExpression", new Integer(59));
        nameIdx.put("GetValueFromAPI", new Integer(60));
        grpDesc = new HashVector(7);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "General";
        grpItems = new Vector<String>(26);
        grpItems.add("Name");
        grpItems.add("Description");
        grpItems.add("GUIField");
        grpItems.add("DisplayWidth");
        grpItems.add("Columns");
        grpItems.add("Column");
        grpItems.add("PromptText");
        grpItems.add("Type");
        grpItems.add("Value");
        grpItems.add("MinValue");
        grpItems.add("MaxValue");
        grpItems.add("UserFormat");
        grpItems.add("ObjName");
        grpItems.add("ObjParamName");
        grpItems.add("Required");
        grpItems.add("Operation");
        grpItems.add("DefaultNo");
        grpItems.add("Binding");
        grpItems.add("Distinct");
        grpItems.add("ImportSql");
        grpItems.add("IsStringNull");
        grpItems.add("stringFormat");
        grpItems.add("UseCurrentDate");
        grpItems.add("UseCurrentDateWhenBlank");
        grpItems.add("RecordLevelSecurity");
        grpItems.add("HideParameterWhenSingleValueReturn");
        grpItems.add("GetValueFromAPI");
        grpItems.add("OnValueChange");
        grpItems.add("DsnOfAction");
        grpDesc.put(grpName, grpItems);
        grpName = "TextFormat";
        grpItems = new Vector(11);
        grpItems.add("FontFace");
        grpItems.add("FontSize");
        grpItems.add("Bold");
        grpItems.add("Italic");
        grpItems.add("StrikeOut");
        grpItems.add("Underline");
        grpItems.add("Format");
        grpItems.add("AutoFit");
        grpItems.add("WordWrap");
        grpItems.add("VerticalAlignment");
        grpItems.add("HorizontalAlignment");
        grpDesc.put(grpName, grpItems);
        grpName = "Padding";
        grpItems = new Vector(4);
        grpItems.add("padding-top");
        grpItems.add("padding-bottom");
        grpItems.add("padding-left");
        grpItems.add("padding-right");
        grpDesc.put(grpName, grpItems);
        grpName = "Geometry";
        grpItems = new Vector(2);
        grpItems.add("Width");
        grpItems.add("Height");
        grpDesc.put(grpName, grpItems);
        grpName = "Color";
        grpItems = new Vector(2);
        grpItems.add("Background");
        grpItems.add("Foreground");
        grpDesc.put(grpName, grpItems);
        grpName = "Border";
        grpItems = new Vector(8);
        grpItems.add("BorderWidth");
        grpItems.add("TopLine");
        grpItems.add("BottomLine");
        grpItems.add("LeftLine");
        grpItems.add("RightLine");
        grpItems.add("Shadow");
        grpItems.add("BorderColor");
        grpItems.add("ShadowColor");
        grpDesc.put(grpName, grpItems);
        grpName = "Pattern";
        grpItems = new Vector(2);
        grpItems.add("PatternColor");
        grpItems.add("PatternStyle");
        grpDesc.put(grpName, grpItems);
        grpName = "Others";
        grpItems = new Vector(1);
        grpItems.add("DataMappingFile");
        grpDesc.put(grpName, grpItems);
        buildinParameter = new JetUParameter(BUILDINPARAMETERNAME, "", "Please input logo URL:", "String", "");
    }
}

