/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetRootable;
import jet.universe.JetUColumnInfo;
import jet.universe.JetUField;
import jet.universe.JetUPath;
import jet.universe.JetUPrejoin;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUTableInfo;
import jet.universe.JetUTableView;
import jet.universe.Prejoin;

public class JetUPrejoins
extends JetUResourceContainer
implements JetRootable {
    private int jetcVersion = 65648;
    public JetNumber x = new JetNumber(this, "X");
    public JetNumber y = new JetNumber(this, "Y");
    public JetNumber width = new JetNumber(this, "Width");
    public JetNumber height = new JetNumber(this, "Height");
    Hashtable namingCount = new Hashtable();
    Hashtable namingTable = new Hashtable();
    private static final String prejoinKey = new JetUPrejoin().getClass().getName();
    private static final String tableKey = new JetUTableInfo().getClass().getName();
    private static final String pathKey = new JetUPath().getClass().getName();
    int refcount;
    private static final HashMap nameIdx = new HashMap(6);

    public JetUPrejoins() {
        this.namingCount.put(prejoinKey, new Integer(0));
        this.namingCount.put(tableKey, new Integer(0));
        this.namingCount.put(pathKey, new Integer(0));
    }

    @Override
    public JetObject add(JetObject child) {
        if (child != null) {
            if (child instanceof JetUPrejoin) {
                this.namingCount.put(prejoinKey, new Integer((Integer)this.namingCount.get(prejoinKey) + 1));
                return super.add(child);
            }
            if (child instanceof JetUTableInfo) {
                this.namingCount.put(tableKey, new Integer((Integer)this.namingCount.get(tableKey) + 1));
                return super.add(child);
            }
            if (child instanceof JetUPath) {
                this.namingCount.put(pathKey, new Integer((Integer)this.namingCount.get(pathKey) + 1));
                return super.add(child);
            }
        }
        return child;
    }

    public void removeTableView(String tableview) {
        if (tableview != null) {
            JetUPrejoin prejoin;
            int sz = this.children.size();
            Vector deljoins = new Vector();
            Vector paths = new Vector();
            Vector pjs = new Vector();
            int i = sz;
            while (--i >= 0) {
                Object o = this.children.elementAt(i);
                if (o instanceof JetUTableInfo) {
                    JetUTableInfo tinfo = (JetUTableInfo)o;
                    if (!tinfo.tableName.get().equals(tableview)) continue;
                    this.children.removeElement(o);
                    continue;
                }
                if (o instanceof JetUPrejoin) {
                    prejoin = (JetUPrejoin)o;
                    if (prejoin.tableFrom.get().equals(tableview) || prejoin.tableTo.get().equals(tableview)) {
                        this.children.removeElement(o);
                        deljoins.addElement(o);
                        continue;
                    }
                    pjs.addElement(o);
                    continue;
                }
                if (!(o instanceof JetUPath)) continue;
                paths.addElement(o);
            }
            sz = paths.size();
            if (deljoins.size() > 0 && sz > 0) {
                for (int i2 = 0; i2 < deljoins.size(); ++i2) {
                    JetUPrejoin join = (JetUPrejoin)deljoins.elementAt(i2);
                    int j = sz;
                    block2: while (--j >= 0) {
                        JetUPath path = (JetUPath)paths.elementAt(j);
                        Vector c = path.getChildren();
                        for (int k = 0; k < c.size(); ++k) {
                            prejoin = (JetUPrejoin)c.elementAt(k);
                            if (!prejoin.match(join)) continue;
                            path.remove(prejoin);
                            if (path.getChildren().size() > 0) continue block2;
                            this.children.removeElement(path);
                            continue block2;
                        }
                    }
                }
            }
        }
    }

    public void addQueriable(JetUQueriable queriable) {
        JetUTableInfo tinfo = new JetUTableInfo();
        tinfo.tableName.set(queriable.getResourceName());
        tinfo.tableType.set(2);
        int sz = this.children.size();
        JetUTableInfo target = tinfo;
        target.x.set(10);
        target.y.set(10);
        int x = 0;
        int y = 0;
        int i = sz;
        while (--i >= 0) {
            Object o = this.children.elementAt(i);
            if (!(o instanceof JetUTableInfo)) continue;
            JetUTableInfo temp = (JetUTableInfo)o;
            x = Math.max(temp.x.get(), x);
            y = Math.max(temp.y.get(), y);
        }
        tinfo.x.set(x + 24);
        tinfo.y.set(y + 24);
        tinfo.width.set(100);
        tinfo.height.set(100);
        Vector cols = queriable.getFields();
        for (int j = 0; j < cols.size(); ++j) {
            JetUQueriableField field = (JetUQueriableField)cols.elementAt(j);
            JetUColumnInfo column = new JetUColumnInfo();
            column.columnName.set(field.getResourceName());
            tinfo.add(column);
        }
        this.add(tinfo);
    }

    public void addTableView(JetUTableView tableview) {
        JetUTableInfo tinfo = new JetUTableInfo();
        tinfo.tableName.set(tableview.name.get());
        tinfo.tableType.set(0);
        int sz = this.children.size();
        JetUTableInfo target = tinfo;
        target.x.set(10);
        target.y.set(10);
        int x = 0;
        int y = 0;
        int i = sz;
        while (--i >= 0) {
            Object o = this.children.elementAt(i);
            if (!(o instanceof JetUTableInfo)) continue;
            JetUTableInfo temp = (JetUTableInfo)o;
            x = Math.max(temp.x.get(), x);
            y = Math.max(temp.y.get(), y);
        }
        tinfo.x.set(x + 24);
        tinfo.y.set(y + 24);
        tinfo.width.set(100);
        tinfo.height.set(100);
        Vector cols = tableview.getFields();
        for (int j = 0; j < cols.size(); ++j) {
            JetUField field = (JetUField)cols.elementAt(j);
            JetUColumnInfo column = new JetUColumnInfo();
            column.columnName.set(field.colName.get());
            tinfo.add(column);
        }
        this.add(tinfo);
    }

    @Override
    public synchronized int getRefCount() {
        return this.refcount;
    }

    @Override
    public synchronized void free() {
        --this.refcount;
    }

    @Override
    public void setNamingCount(Hashtable nc) {
    }

    @Override
    public Hashtable getNamingCount() {
        return this.namingCount;
    }

    @Override
    public void setCached(boolean c) {
    }

    @Override
    public synchronized void refer() {
        ++this.refcount;
    }

    @Override
    public boolean isCached() {
        return false;
    }

    @Override
    public void clearMem() {
        this.children.removeAllElements();
    }

    @Override
    public void setNamingTable(Hashtable nt) {
        if (nt != null) {
            this.namingTable = nt;
        }
    }

    @Override
    public Hashtable getNamingTable() {
        return this.namingTable;
    }

    public boolean update(Hashtable tables, Vector prejoins) {
        boolean modified;
        boolean bl = modified = tables != null || prejoins != null;
        if (!modified) {
            modified = false;
        } else {
            Object o;
            int sz = this.children.size();
            if (prejoins != null) {
                int i = sz;
                while (--i >= 0) {
                    o = this.children.elementAt(i);
                    if (!(o instanceof JetUPrejoin)) continue;
                    this.children.removeElement(o);
                }
                sz = prejoins.size();
                for (int i2 = 0; i2 < sz; ++i2) {
                    JetUPrejoin prejoin = new JetUPrejoin();
                    Prejoin pj = (Prejoin)prejoins.elementAt(i2);
                    String[] infos = pj.getJoinInfo();
                    prejoin.tableFrom.set(infos[0]);
                    prejoin.columnFrom.set(infos[1]);
                    prejoin.tableTo.set(infos[2]);
                    prejoin.columnTo.set(infos[3]);
                    prejoin.operator.set(infos[4]);
                    prejoin.outerJoin.set(infos[6]);
                    prejoin.opX.set(infos[7]);
                    prejoin.opY.set(infos[8]);
                    prejoin.moved.set(infos[9]);
                    prejoin.setJoinCondition(pj.getJoinCondition());
                    this.add(prejoin);
                }
            }
            if (tables != null) {
                sz = this.children.size();
                for (int i = 0; i < sz; ++i) {
                    Rectangle bounds;
                    o = this.children.elementAt(i);
                    if (!(o instanceof JetUTableInfo)) continue;
                    JetUTableInfo tinfo = (JetUTableInfo)o;
                    Vector table = (Vector)tables.get(tinfo.tableName.get());
                    if (table.isEmpty() || (bounds = (Rectangle)table.elementAt(0)) == null) continue;
                    tinfo.x.set(bounds.x);
                    tinfo.y.set(bounds.y);
                    tinfo.width.set(bounds.width);
                    tinfo.height.set(bounds.height);
                }
            }
        }
        return modified;
    }

    public Hashtable getTables() {
        Hashtable tables = new Hashtable();
        int sz = this.children.size();
        for (int i = 0; i < sz; ++i) {
            Object o = this.children.elementAt(i);
            if (!(o instanceof JetUTableInfo)) continue;
            JetUTableInfo tinfo = (JetUTableInfo)o;
            Vector<Object> table = new Vector<Object>();
            table.addElement(new Rectangle(tinfo.x.get(), tinfo.y.get(), tinfo.width.get(), tinfo.height.get()));
            Vector c = tinfo.getChildren();
            for (int j = 0; j < c.size(); ++j) {
                table.addElement(((JetUColumnInfo)c.elementAt((int)j)).columnName.get());
            }
            tables.put(tinfo.tableName.get(), table);
        }
        return tables;
    }

    public Vector getPrejoins() {
        Vector<Prejoin> prejoins = new Vector<Prejoin>((Integer)this.namingCount.get(prejoinKey));
        int sz = this.children.size();
        for (int i = 0; i < sz; ++i) {
            Object o = this.children.elementAt(i);
            if (!(o instanceof JetUPrejoin)) continue;
            JetUPrejoin join = (JetUPrejoin)o;
            Prejoin pj = new Prejoin();
            pj.setJoinInfo(new String[]{join.tableFrom.get(), join.columnFrom.get(), join.tableTo.get(), join.columnTo.get(), join.operator.get(), new Boolean(join.isSQL92.get()).toString(), String.valueOf(join.outerJoin.get()), String.valueOf(join.opX.get()), String.valueOf(join.opY.get()), new Boolean(join.moved.get()).toString()});
            pj.setJoinCondition(join.getJoinCondition());
            prejoins.add(pj);
        }
        return prejoins;
    }

    public Vector getPaths() {
        Vector paths = new Vector((Integer)this.namingCount.get(pathKey));
        int sz = this.children.size();
        for (int i = 0; i < sz; ++i) {
            Object o = this.children.elementAt(i);
            if (!(o instanceof JetUPath)) continue;
            paths.addElement(o);
        }
        return paths;
    }

    public void setPaths(Vector paths) {
        int sz;
        int i = sz = this.children.size();
        while (--i >= 0) {
            Object o = this.children.elementAt(i);
            if (!(o instanceof JetUPath)) continue;
            this.children.removeElement(o);
            ((JetUPath)o).setParent(null);
        }
        sz = paths.size();
        for (i = 0; i < sz; ++i) {
            this.add((JetUPath)paths.elementAt(i));
        }
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < this.children.size(); ++i) {
            ret.append(this.children.elementAt(i).toString()).append(" | ");
        }
        return ret.toString();
    }

    @Override
    public String getInstancePrefix() {
        return "UPrejoins";
    }

    @Override
    public void setVersion(int ver) {
        this.jetcVersion = ver;
    }

    @Override
    public int getVersion() {
        return this.jetcVersion;
    }

    @Override
    public void afterInit() {
        super.afterInit();
        this.jetcVersion = 65648;
    }

    public void mergePrejoin(JetUPrejoin[] prejoins) {
        Vector joins = new Vector((Integer)this.namingCount.get(prejoinKey));
        int sz = this.children.size();
        for (int i = 0; i < sz; ++i) {
            Object o = this.children.elementAt(i);
            if (!(o instanceof JetUPrejoin)) continue;
            joins.add(o);
        }
        for (JetUPrejoin prejoin : prejoins) {
            if (this.containPrejoin(joins, prejoin)) continue;
            this.add(prejoin);
        }
    }

    private boolean containPrejoin(Vector prejoins, JetUPrejoin prejoin) {
        int sz = prejoins.size();
        for (int i = 0; i < sz; ++i) {
            JetUPrejoin join;
            Object o = prejoins.elementAt(i);
            if (!(o instanceof JetUPrejoin) || !(join = (JetUPrejoin)o).match(prejoin)) continue;
            return true;
        }
        return false;
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    static {
        nameIdx.put("Y", new Integer(0));
        nameIdx.put("X", new Integer(1));
        nameIdx.put("Description", new Integer(2));
        nameIdx.put("Name", new Integer(3));
        nameIdx.put("Height", new Integer(4));
        nameIdx.put("Width", new Integer(5));
    }
}

