/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.datatypes.DataTypeUtils;
import java.util.HashMap;
import java.util.Vector;
import jet.connect.DbColDesc;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.universe.JetUConnection;
import jet.universe.JetUDBField;
import jet.universe.JetUProcedure;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUResourceField;
import jet.universe.JetUTableView;
import jet.util.HashVector;
import toolkit.db.ProcColumnInfo;

public class JetUProcField
extends JetUResourceField
implements JetUDBField,
JetUQueriableField {
    public JetNumber columnIndex;
    public JetString colName;
    public JetNumber sqlType;
    public JetNumber precision;
    public JetNumber length;
    public JetNumber scale;
    public JetNumber radix;
    public JetNumber nullable;
    public JetNumber currency;
    public JetBoolean array;
    private static final HashMap nameIdx = new HashMap(43);
    private static final HashVector grpDesc;

    public JetUProcField() {
    }

    public JetUProcField(String strName, String strDescription, ProcColumnInfo procCol) {
        super(strName, strDescription);
        this.columnIndex.set(procCol.iIndex);
        this.colName.set(procCol.strName);
        this.sqlType.set(procCol.iSQLType);
        this.sqlType.setPropertyChoice(DataTypeUtils.getSQLTypeChoiceVector());
        this.sqlType.setEditorType(JetProperty.COMBO_EDITOR);
        this.precision.set(procCol.iPrecision);
        this.scale.set(procCol.iScale);
        this.nullable.set(procCol.iNullable);
        this.nullable.setPropertyChoice(DataTypeUtils.getNullableChoiceVector());
        this.nullable.setEditorType(JetProperty.COMBO_EDITOR);
        this.currency.setEditorType(JetProperty.COMBO_EDITOR);
        this.array.set(procCol.bArray);
        this.setHAlignmentDefault(procCol.iSQLType);
        this.setVAlignmentDefault(procCol.iSQLType);
        this.setFormatDefault(procCol.iSQLType);
    }

    @Override
    void init() {
        super.init();
        this.colName = new JetString(this, "ColumnName");
        this.sqlType = new JetNumber(this, "SQLType");
        this.sqlType.setPropertyChoice(DataTypeUtils.getSQLTypeChoiceVector());
        this.sqlType.setEditorType(JetProperty.COMBO_EDITOR);
        this.precision = new JetNumber(this, "Precision");
        this.scale = new JetNumber(this, "Scale");
        this.nullable = new JetNumber(this, "Nullable");
        this.nullable.setPropertyChoice(DataTypeUtils.getNullableChoiceVector());
        this.nullable.setEditorType(JetProperty.COMBO_EDITOR);
        this.columnIndex = new JetNumber(this, "ColumnIndex");
        this.radix = new JetNumber(this, "Radix");
        this.length = new JetNumber(this, "Length");
        this.currency = new JetNumber(this, "Currency");
        this.currency.setPropertyChoice(DataTypeUtils.getIsCurrencyChoiceVector());
        this.currency.setEditorType(JetProperty.COMBO_EDITOR);
        this.array = new JetBoolean(this, "Array");
    }

    @Override
    public JetUQueriable getQueriable() {
        return this.getProcedure();
    }

    public JetUProcedure getProcedure() {
        return (JetUProcedure)this.getParent();
    }

    @Override
    public String getQueriableName() {
        JetUProcedure uProcedure = this.getProcedure();
        if (uProcedure != null) {
            return uProcedure.getResourceName();
        }
        return null;
    }

    @Override
    public String getFldName() {
        return this.colName.get();
    }

    public void setFldName(String strColName) {
        this.colName.set(strColName);
    }

    @Override
    public int getSqlType() {
        return this.sqlType.get();
    }

    public void setSqlType(int iSQLType) {
        this.sqlType.set(iSQLType);
        this.setHAlignmentDefault(iSQLType);
        this.setVAlignmentDefault(iSQLType);
    }

    public int getPrecision() {
        return this.precision.get();
    }

    public void setPrecision(int iPrecision) {
        this.precision.set(iPrecision);
    }

    public int getLength() {
        return this.length.get();
    }

    public void setLength(int iLength) {
        this.length.set(iLength);
    }

    public int getScale() {
        return this.scale.get();
    }

    public void setScale(int iScale) {
        this.scale.set(iScale);
    }

    public boolean getArray() {
        return this.array.get();
    }

    public void setArray(boolean bArray) {
        this.array.set(bArray);
    }

    public int getRadix() {
        return this.radix.get();
    }

    public void setRadix(int iRadix) {
        this.radix.set(iRadix);
    }

    public int getNullable() {
        return this.nullable.get();
    }

    public void setNullable(int iNullable) {
        this.nullable.set(iNullable);
    }

    public int getColIndex() {
        return this.columnIndex.get();
    }

    public void setColIndex(int iColIndex) {
        this.columnIndex.set(iColIndex);
    }

    @Override
    public DbColDesc getColDesc() {
        DbColDesc dcd = new DbColDesc(this.getFldName(), this.getSqlType(), this.getPrecision(), this.getScale(), this.getNullable());
        if (this.currency.get() > 0) {
            dcd.setCurrency(true);
        }
        dcd.setArray(this.getArray());
        this.addCaseSensitiveInfo(dcd);
        this.addEncodingPattern(dcd);
        return dcd;
    }

    @Override
    public String getTableName() {
        return null;
    }

    @Override
    public JetUTableView getTable() {
        return null;
    }

    @Override
    public String getDefinition() {
        return null;
    }

    @Override
    public String toString() {
        String strParam = "ProcField[" + this.getResourceName() + "|" + this.getQueriableName() + "|" + this.getFldName() + " ]";
        return strParam;
    }

    @Override
    public String getInstancePrefix() {
        return "ProcedureField";
    }

    @Override
    public boolean isSimilar(JetUResourceEntity field) {
        return super.isSimilar(field) && this.columnIndex.equal(((JetUProcField)field).columnIndex) && this.colName.equal(((JetUProcField)field).colName) && this.sqlType.equal(((JetUProcField)field).sqlType);
    }

    @Override
    public boolean isSimilarExceptName(JetUResourceEntity field) {
        return super.isSimilarExceptName(field) && this.columnIndex.equal(((JetUProcField)field).columnIndex) && this.colName.equal(((JetUProcField)field).colName) && this.sqlType.equal(((JetUProcField)field).sqlType);
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        return grpDesc;
    }

    @Override
    public JetUConnection getConnection() {
        return this.getProcedure().getConnection();
    }

    static {
        nameIdx.put("SQLType", new Integer(0));
        nameIdx.put("padding-right", new Integer(1));
        nameIdx.put("RightLine", new Integer(2));
        nameIdx.put("HorizontalAlignment", new Integer(3));
        nameIdx.put("PatternStyle", new Integer(4));
        nameIdx.put("Format", new Integer(5));
        nameIdx.put("Precision", new Integer(6));
        nameIdx.put("Length", new Integer(7));
        nameIdx.put("Bold", new Integer(8));
        nameIdx.put("AutoFit", new Integer(9));
        nameIdx.put("Width", new Integer(10));
        nameIdx.put("GUIField", new Integer(11));
        nameIdx.put("Height", new Integer(12));
        nameIdx.put("Radix", new Integer(13));
        nameIdx.put("padding-bottom", new Integer(14));
        nameIdx.put("Array", new Integer(15));
        nameIdx.put("Name", new Integer(16));
        nameIdx.put("ShadowColor", new Integer(17));
        nameIdx.put("ColumnIndex", new Integer(18));
        nameIdx.put("BottomLine", new Integer(19));
        nameIdx.put("padding-top", new Integer(20));
        nameIdx.put("Description", new Integer(21));
        nameIdx.put("BorderWidth", new Integer(22));
        nameIdx.put("Background", new Integer(23));
        nameIdx.put("Scale", new Integer(24));
        nameIdx.put("DisplayWidth", new Integer(25));
        nameIdx.put("VerticalAlignment", new Integer(26));
        nameIdx.put("PatternColor", new Integer(27));
        nameIdx.put("TopLine", new Integer(28));
        nameIdx.put("FontSize", new Integer(29));
        nameIdx.put("Underline", new Integer(30));
        nameIdx.put("LeftLine", new Integer(31));
        nameIdx.put("Nullable", new Integer(32));
        nameIdx.put("ColumnName", new Integer(33));
        nameIdx.put("FontFace", new Integer(34));
        nameIdx.put("Alignment", new Integer(35));
        nameIdx.put("padding-left", new Integer(36));
        nameIdx.put("WordWrap", new Integer(37));
        nameIdx.put("Italic", new Integer(38));
        nameIdx.put("StrikeOut", new Integer(39));
        nameIdx.put("BorderColor", new Integer(40));
        nameIdx.put("Currency", new Integer(41));
        nameIdx.put("Foreground", new Integer(42));
        nameIdx.put("Shadow", new Integer(43));
        grpDesc = new HashVector(7);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "General";
        grpItems = new Vector<String>(13);
        grpItems.add("Name");
        grpItems.add("Description");
        grpItems.add("GUIField");
        grpItems.add("DisplayWidth");
        grpItems.add("ColumnName");
        grpItems.add("ColumnIndex");
        grpItems.add("SQLType");
        grpItems.add("Precision");
        grpItems.add("Scale");
        grpItems.add("Nullable");
        grpItems.add("Currency");
        grpItems.add("Array");
        grpItems.add("Radix");
        grpItems.add("Length");
        grpDesc.put(grpName, grpItems);
        grpName = "TextFormat";
        grpItems = new Vector(11);
        grpItems.add("FontFace");
        grpItems.add("FontSize");
        grpItems.add("Bold");
        grpItems.add("Italic");
        grpItems.add("StrikeOut");
        grpItems.add("Underline");
        grpItems.add("Format");
        grpItems.add("AutoFit");
        grpItems.add("WordWrap");
        grpItems.add("VerticalAlignment");
        grpItems.add("HorizontalAlignment");
        grpDesc.put(grpName, grpItems);
        grpName = "Padding";
        grpItems = new Vector(4);
        grpItems.add("padding-top");
        grpItems.add("padding-bottom");
        grpItems.add("padding-left");
        grpItems.add("padding-right");
        grpDesc.put(grpName, grpItems);
        grpName = "Geometry";
        grpItems = new Vector(2);
        grpItems.add("Width");
        grpItems.add("Height");
        grpDesc.put(grpName, grpItems);
        grpName = "Color";
        grpItems = new Vector(2);
        grpItems.add("Background");
        grpItems.add("Foreground");
        grpDesc.put(grpName, grpItems);
        grpName = "Border";
        grpItems = new Vector(8);
        grpItems.add("BorderWidth");
        grpItems.add("TopLine");
        grpItems.add("BottomLine");
        grpItems.add("LeftLine");
        grpItems.add("RightLine");
        grpItems.add("Shadow");
        grpItems.add("BorderColor");
        grpItems.add("ShadowColor");
        grpDesc.put(grpName, grpItems);
        grpName = "Pattern";
        grpItems = new Vector(2);
        grpItems.add("PatternColor");
        grpItems.add("PatternStyle");
        grpDesc.put(grpName, grpItems);
        grpName = "Others";
        grpItems = new Vector(1);
        grpItems.add("DataMappingFile");
        grpDesc.put(grpName, grpItems);
    }
}

