/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import com.jinfonet.datatypes.DataTypeUtils;
import java.util.HashMap;
import jet.connect.DbColDesc;
import jet.controls.JetBoolean;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetProperty;
import jet.controls.JetString;
import jet.universe.JetUProcedure;
import jet.universe.JetUResourceEntity;
import toolkit.db.ParaInterface;
import toolkit.db.ProcParaInfo;

public class JetUProcParameter
extends JetUResourceEntity
implements ParaInterface {
    public JetNumber index = new JetNumber(this, "Index");
    public JetString parameterName = new JetString(this, "ParameterName");
    public JetEnumeration type = new JetEnumeration(this, "Type", 81);
    public JetNumber sqlType = new JetNumber(this, "SQLType");
    public JetString sqlTypeName = new JetString(this, "SQLTypeName");
    public JetNumber precision = new JetNumber(this, "Precision");
    public JetNumber length = new JetNumber(this, "Length");
    public JetNumber scale = new JetNumber(this, "Scale");
    public JetNumber radix = new JetNumber(this, "Radix");
    public JetNumber nullable = new JetNumber(this, "Nullable");
    public JetString value = new JetString(this, "Value");
    public JetBoolean bIsNull = new JetBoolean(this, "BIsNull");
    public JetBoolean bSpecialField = new JetBoolean(this, "BSpecialField");
    private static final HashMap nameIdx = new HashMap(17);

    public JetUProcParameter() {
    }

    public JetUProcParameter(String strName, String strDescription, ProcParaInfo procParam) {
        super(strName, strDescription);
        this.index.set(procParam.iIndex);
        this.parameterName.set(procParam.strName);
        this.type.set(new Integer(procParam.iType));
        this.sqlType.set(procParam.iSQLType);
        this.sqlType.setPropertyChoice(DataTypeUtils.getSQLTypeChoiceVector());
        this.sqlType.setEditorType(JetProperty.COMBO_EDITOR);
        this.sqlTypeName.set(procParam.strSQLTypeName);
        this.precision.set(procParam.iPrecision);
        this.length.set(procParam.iLength);
        this.scale.set(procParam.iScale);
        this.radix.set(procParam.iRadix);
        this.nullable.set(procParam.iNullable);
        this.nullable.setPropertyChoice(DataTypeUtils.getNullableChoiceVector());
        this.nullable.setEditorType(JetProperty.COMBO_EDITOR);
        this.value.set(procParam.value);
        this.bIsNull.set(procParam.getbNull());
        this.bSpecialField.set(procParam.getIsSpecialField());
    }

    public JetUProcedure getProcedure() {
        return (JetUProcedure)this.getParent();
    }

    public String getProcedureName() {
        JetUProcedure uProcedure = this.getProcedure();
        if (uProcedure != null) {
            return uProcedure.getResourceName();
        }
        return null;
    }

    @Override
    public int getIndex() {
        return this.index.get();
    }

    public void setIndex(int iIndex) {
        this.index.set(iIndex);
    }

    public String getParameterName() {
        return this.parameterName.get();
    }

    public void set(String strParameterName) {
        this.parameterName.set(strParameterName);
    }

    @Override
    public boolean isINParameter() {
        return this.type.intValue() == 1 || this.type.intValue() == 2;
    }

    public boolean isOUTParameter() {
        return this.type.intValue() == 4 || this.type.intValue() == 2;
    }

    @Override
    public int getType() {
        return this.type.intValue();
    }

    public void setType(int iType) {
        this.type.set(new Integer(iType));
    }

    @Override
    public int getSQLType() {
        return this.sqlType.get();
    }

    public void setSQLType(int iSQLType) {
        this.sqlType.set(iSQLType);
    }

    @Override
    public String getSQLTypeName() {
        return this.sqlTypeName.get();
    }

    public void setSQLTypeName(String strSqlTypeName) {
        this.sqlTypeName.set(strSqlTypeName);
    }

    public int getPrecision() {
        return this.precision.get();
    }

    public void setPrecision(int iPrecision) {
        this.precision.set(iPrecision);
    }

    @Override
    public int getLength() {
        return this.length.get();
    }

    public void setLength(int iLength) {
        this.length.set(iLength);
    }

    public int getScale() {
        return this.scale.get();
    }

    public void setScale(int iScale) {
        this.scale.set(iScale);
    }

    @Override
    public int getRadix() {
        return this.radix.get();
    }

    public void setRadix(int iRadix) {
        this.radix.set(iRadix);
    }

    public int getNullable() {
        return this.nullable.get();
    }

    public void setNullable(int iNullable) {
        this.nullable.set(iNullable);
    }

    @Override
    public String getValue() {
        return this.value.get();
    }

    @Override
    public void setValue(String strValue) {
        this.value.set(strValue);
    }

    @Override
    public DbColDesc getColDesc() {
        return null;
    }

    @Override
    public String getDefinition() {
        return null;
    }

    @Override
    public String getName() {
        return this.getParameterName();
    }

    @Override
    public String getInstancePrefix() {
        return "ProcdureParameter";
    }

    @Override
    public boolean isSimilar(JetUResourceEntity field) {
        return super.isSimilar(field) && this.index.equal(((JetUProcParameter)field).index) && this.parameterName.equal(((JetUProcParameter)field).parameterName) && this.type.equal(((JetUProcParameter)field).type) && this.sqlType.equal(((JetUProcParameter)field).sqlType);
    }

    @Override
    public boolean isSimilarExceptName(JetUResourceEntity field) {
        return super.isSimilarExceptName(field) && this.index.equal(((JetUProcParameter)field).index) && this.parameterName.equal(((JetUProcParameter)field).parameterName) && this.type.equal(((JetUProcParameter)field).type) && this.sqlType.equal(((JetUProcParameter)field).sqlType);
    }

    @Override
    public String toString() {
        return null;
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public void setbNull(boolean bNull) {
        this.bIsNull.set(bNull);
    }

    @Override
    public boolean getbNull() {
        return this.bIsNull.get();
    }

    @Override
    public boolean getIsSpecialField() {
        return this.bSpecialField.get();
    }

    @Override
    public void setIsSpecialField(boolean bSpecialField) {
        this.bSpecialField.set(bSpecialField);
    }

    static {
        nameIdx.put("DisplayWidth", new Integer(0));
        nameIdx.put("Name", new Integer(1));
        nameIdx.put("ParameterName", new Integer(2));
        nameIdx.put("Precision", new Integer(3));
        nameIdx.put("SQLType", new Integer(4));
        nameIdx.put("Description", new Integer(5));
        nameIdx.put("Length", new Integer(6));
        nameIdx.put("SQLTypeName", new Integer(7));
        nameIdx.put("Radix", new Integer(8));
        nameIdx.put("GUIField", new Integer(9));
        nameIdx.put("Type", new Integer(10));
        nameIdx.put("Value", new Integer(11));
        nameIdx.put("Scale", new Integer(12));
        nameIdx.put("Nullable", new Integer(13));
        nameIdx.put("Index", new Integer(14));
        nameIdx.put("BIsNull", new Integer(15));
        nameIdx.put("BSpecialField", new Integer(16));
    }
}

