/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.log.JRLogger;
import jet.universe.JetUConnection;
import jet.universe.JetUDatabase;
import jet.universe.JetUFormula;
import jet.universe.JetUParameter;
import jet.universe.JetUProcField;
import jet.universe.JetUProcParameter;
import jet.universe.JetUQueriable;
import jet.universe.JetUQueriableField;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUUniverse;
import jet.universe.UMapTable;
import jet.universe.businesslogic.BLDupleNameException;
import jet.universe.businesslogic.BLIlegalNameException;
import jet.universe.businesslogic.JBusinessLogic;
import jet.universe.businesslogic.JBusinessView;
import jet.universe.businesslogic.impl.BusinessLogic;
import jet.universe.businesslogic.impl.BusinessView;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.FormulaHasGrammarError;
import jet.util.HashVector;
import toolkit.db.ProcColumnInfo;
import toolkit.db.ProcInfo;
import toolkit.db.ProcParaInfo;

public class JetUProcedure
extends JetUResourceContainer
implements JetUQueriable {
    public JetString connectionName = new JetString(this, "ConnectionName");
    public JetString qualifier = new JetString(this, "Qualifier");
    public JetString owner = new JetString(this, "Owner");
    public JetString procedureName = new JetString(this, "ProcedureName");
    public JetEnumeration transactionIsolation = new JetEnumeration(this, "TransactionIsolation", 99);
    public JetEnumeration readOnly = new JetEnumeration(this, "ReadOnly", 84);
    public JetNumber maxRows = new JetNumber(this, "maxRows");
    public JetNumber maxDuration = new JetNumber(this, "maxDuration");
    ProcInfo proc = null;
    private static JRLogger logger = JRLogger.getLogger(JetUProcedure.class.getName());
    private static final HashMap nameIdx = new HashMap(9);
    private static final HashVector grpDesc;

    public JetUProcedure() {
        this.initialize();
    }

    public JetUProcedure(String strName, String strDescription) {
        super(strName, strDescription);
        this.initialize();
    }

    public JetUProcedure(String strName, String strDescription, ProcInfo proc) {
        super(strName, strDescription);
        this.initialize();
        this.qualifier.set(proc.getCatalog());
        this.owner.set(proc.getSchema());
        this.procedureName.set(proc.getName());
        this.proc = proc;
    }

    protected void initialize() {
        this.transactionIsolation.set(new Integer(0));
        this.readOnly.set(new Integer(1));
    }

    public void InitProcedure() {
        String strMappingName;
        super.InitAfterCreate();
        Vector vecParameters = this.proc.getParameters();
        int iParamCount = vecParameters.size();
        for (int i = 0; i < iParamCount; ++i) {
            ProcParaInfo procParam = (ProcParaInfo)vecParameters.elementAt(i);
            strMappingName = procParam.getResourceName();
            if (strMappingName == null || strMappingName.length() <= 0) {
                strMappingName = this.getMappingName(procParam.strName);
            }
            JetUProcParameter uprocParam = new JetUProcParameter(strMappingName, "", procParam);
            this.addParameter(uprocParam);
        }
        Vector vecColumns = this.proc.getColumns();
        int iColCount = vecColumns.size();
        for (int i = 0; i < iColCount; ++i) {
            ProcColumnInfo procCol = (ProcColumnInfo)vecColumns.elementAt(i);
            strMappingName = this.getMappingName(procCol.strName);
            JetUProcField uprocField = new JetUProcField(strMappingName, "", procCol);
            this.addField(uprocField);
        }
        this.proc = null;
    }

    public JetUProcedure cloneEntity() {
        JetUProcedure retProc = new JetUProcedure(this.getResourceName(), this.getDesc());
        retProc.connectionName.set(this.connectionName.get());
        retProc.setQualifier(this.getQualifier());
        retProc.setOwner(this.getOwner());
        retProc.setProcedureName(this.getProcedureName());
        Vector vecParams = this.getParameters();
        int iSize = vecParams.size();
        for (int i = 0; i < iSize; ++i) {
            JetUProcParameter srcParam = (JetUProcParameter)vecParams.elementAt(i);
            JetUProcParameter destParam = new JetUProcParameter();
            JetObject.copyProperties(destParam, srcParam);
            retProc.addParameter(destParam);
        }
        Vector vecFields = this.getFields();
        int jSize = vecFields.size();
        for (int i = 0; i < jSize; ++i) {
            JetUProcField srcField = (JetUProcField)vecFields.elementAt(i);
            JetUProcField destField = new JetUProcField();
            JetObject.copyProperties(destField, srcField);
            retProc.addField(destField);
        }
        JetObject.copyProperties(retProc, this);
        retProc.removeBL();
        JBusinessLogic bl = this.getBL();
        retProc.add((JetObject)((Object)(bl == null ? null : bl.copy())));
        retProc.removeBV();
        JBusinessView bv = this.getBV();
        retProc.add((JetObject)((Object)(bv == null ? null : bv.copy())));
        return retProc;
    }

    protected String getMappingName(String strRealName) {
        StringBuffer error = new StringBuffer();
        JetUDatabase db = this.getDatabase();
        String strTemp = null;
        String strMappingName = strRealName;
        boolean bIsOK = db.IsMappingNameOK(strMappingName, error);
        int i = 1;
        if (!bIsOK) {
            strMappingName = this.getResourceName() + "_" + strRealName;
            bIsOK = db.IsMappingNameOK(strMappingName, error);
        }
        strTemp = strMappingName;
        while (!bIsOK) {
            strMappingName = strTemp + i++;
            bIsOK = db.IsMappingNameOK(strMappingName, error);
        }
        return strMappingName;
    }

    protected void addParameter(JetUProcParameter uprocParam) {
        this.add(uprocParam);
    }

    protected void addField(JetUProcField uprocField) {
        this.add(uprocField);
        uprocField.InitAfterCreate();
    }

    public String getQualifier() {
        return this.qualifier.get();
    }

    public void setQualifier(String strQlf) {
        this.qualifier.set(strQlf);
    }

    public String getOwner() {
        return this.owner.get();
    }

    public void setOwner(String strOwner) {
        this.owner.set(strOwner);
    }

    public String getProcedureName() {
        return this.procedureName.get();
    }

    public void setProcedureName(String strProcedureName) {
        this.procedureName.set(strProcedureName);
    }

    public void setTransactionIsolation(int iTransactionIsolation) {
        this.transactionIsolation.set(new Integer(iTransactionIsolation));
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionIsolation.intValue();
    }

    public void setReadOnly(int iReadOnly) {
        this.readOnly.set(new Integer(iReadOnly));
    }

    public void setMaxRows(int maxRows) {
        this.maxRows.set(maxRows);
    }

    @Override
    public int getMaxRows() {
        return this.maxRows.get();
    }

    public void setMaxDuration(int maxDuration) {
        this.maxDuration.set(maxDuration);
    }

    @Override
    public int getMaxDuration() {
        return this.maxDuration.get();
    }

    @Override
    public int getReadOnly() {
        return this.readOnly.intValue();
    }

    public JetUConnection getConnection() {
        return this.getDatabase().getConnectionByResourceName(this.connectionName.get());
    }

    @Override
    public JetUConnection[] getConnections() {
        JetUConnection conn = this.getConnection();
        if (conn == null) {
            return new JetUConnection[0];
        }
        return new JetUConnection[]{conn};
    }

    public Vector getParameters() {
        Vector<JetObject> vecRet = new Vector<JetObject>();
        Vector vecChildren = this.getChildren();
        int iSize = vecChildren.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)vecChildren.elementAt(i);
            if (!(child instanceof JetUProcParameter)) continue;
            vecRet.addElement(child);
        }
        return vecRet;
    }

    public boolean hasINParameter() {
        Vector vecParams = this.getParameters();
        int paraNum = vecParams.size();
        JetUProcParameter jetPara = null;
        for (int i = 0; i < paraNum; ++i) {
            jetPara = (JetUProcParameter)vecParams.elementAt(i);
            if (!jetPara.isINParameter()) continue;
            return true;
        }
        return false;
    }

    public JetUProcParameter getParameterByResourceName(String strParamName) {
        Vector vecRet = new Vector();
        Vector vecChildren = this.getChildren();
        int iSize = vecChildren.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)vecChildren.elementAt(i);
            if (!(child instanceof JetUProcParameter) || !((JetUProcParameter)child).getResourceName().equalsIgnoreCase(strParamName)) continue;
            return (JetUProcParameter)child;
        }
        return null;
    }

    @Override
    public Vector getFields() {
        Vector<JetObject> vecRet = new Vector<JetObject>();
        Vector vecChildren = this.getChildren();
        int iSize = vecChildren.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)vecChildren.elementAt(i);
            if (!(child instanceof JetUProcField)) continue;
            vecRet.addElement(child);
        }
        return vecRet;
    }

    @Override
    public JetUResourceEntity getFieldByResourceName(String fldName) {
        Vector vecChildren = this.getChildren();
        int iSize = vecChildren.size();
        for (int i = 0; i < iSize; ++i) {
            JetObject child = (JetObject)vecChildren.elementAt(i);
            if (!(child instanceof JetUProcField) || !((JetUProcField)child).getResourceName().equalsIgnoreCase(fldName)) continue;
            return (JetUProcField)child;
        }
        return null;
    }

    @Override
    public String getFullSQLString() {
        return this.getSQLString();
    }

    @Override
    public String getSQLString() {
        return null;
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse unvs, String mappingname) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        return this.isFieldValidToQuery(unvs, mappingname, "");
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse unvs, String mappingname, String dataSourceName) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        JetUResourceEntity entity = unvs.getResourceByName(dataSourceName, this.getResourceName(), mappingname);
        if (entity == null) {
            throw new CannotFindEntity(mappingname);
        }
        return this.isFieldValidToQuery(unvs, entity, dataSourceName);
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse unvs, JetUResourceEntity re) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        return this.isFieldValidToQuery(unvs, re, "");
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse unvs, JetUResourceEntity re, String dataSourceName) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        boolean bRet = false;
        if (re instanceof JetUParameter) {
            bRet = true;
        } else if (re instanceof JetUFormula) {
            bRet = this.isFormulaValidToQuery((JetUFormula)re, unvs, dataSourceName);
        } else if (re instanceof JetUQueriableField && re instanceof JetUProcField) {
            bRet = ((JetUProcField)re).getProcedure() == this;
        }
        return bRet;
    }

    public boolean isFormulaValidToQuery(JetUFormula uFormula, JetUUniverse universe) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        return this.isFormulaValidToQuery(uFormula, universe, "");
    }

    public boolean isFormulaValidToQuery(JetUFormula uFormula, JetUUniverse universe, String dataSourceName) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        Vector dbFlds = uFormula.getRefDbFld();
        if (dbFlds != null) {
            int iCount = dbFlds.size();
            for (int i = 0; i < iCount; ++i) {
                String name2 = (String)dbFlds.elementAt(i);
                try {
                    if (this.isFieldValidToQuery(universe, name2, dataSourceName)) continue;
                    return false;
                }
                catch (CannotFindEntity e) {
                    throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name2);
                }
            }
        }
        Vector refFormulas = uFormula.getRefFormuFld();
        int iSize = refFormulas.size();
        for (int i = 0; i < iSize; ++i) {
            String name3 = (String)refFormulas.elementAt(i);
            try {
                if (this.isFieldValidToQuery(universe, name3, dataSourceName)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name3);
            }
        }
        Vector groups = uFormula.getGroupByVector();
        iSize = groups.size();
        for (int i = 0; i < iSize; ++i) {
            String name4 = (String)groups.elementAt(i);
            if (uFormula instanceof JetUSummary && JetUDatabase.isDigital(name4)) continue;
            try {
                if (name4.equalsIgnoreCase("Report") || this.isFieldValidToQuery(universe, name4, dataSourceName)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name4);
            }
        }
        return true;
    }

    @Override
    public Vector getAutoGroupFields() {
        return null;
    }

    @Override
    void RemoveEntitiesFromMapTable(UMapTable mapTable) {
        Vector children = this.getChildren();
        int iSize = children.size();
        JetObject child = null;
        for (int i = 0; i < iSize; ++i) {
            child = (JetObject)children.elementAt(i);
            if (child instanceof JetUResourceContainer) {
                ((JetUResourceContainer)child).RemoveEntitiesFromMapTable(mapTable);
            }
            if (!(child instanceof JetUResourceEntity) || child instanceof JetUProcParameter) continue;
            mapTable.removeElement((JetUResourceEntity)child);
        }
    }

    public boolean resetProcedure(ProcInfo proc) {
        String strMappingName;
        String name2;
        int i;
        JetUProcField uField;
        JetUProcParameter uParam;
        this.objectModified();
        this.initialize();
        this.qualifier.set(proc.getCatalog());
        this.owner.set(proc.getSchema());
        this.procedureName.set(proc.getName());
        this.proc = proc;
        Vector oParams = this.getParameters();
        int iOP = oParams.size();
        Hashtable<String, String> opNames = new Hashtable<String, String>(iOP);
        for (int i2 = 0; i2 < iOP; ++i2) {
            uParam = (JetUProcParameter)oParams.elementAt(i2);
            opNames.put(uParam.getName(), uParam.getResourceName());
        }
        Vector oFields = this.getFields();
        int iOF = oFields.size();
        Hashtable<String, String> ofNames = new Hashtable<String, String>(iOF);
        for (int i3 = 0; i3 < iOF; ++i3) {
            uField = (JetUProcField)oFields.elementAt(i3);
            ofNames.put(uField.getFldName(), uField.getResourceName());
        }
        Vector nParams = proc.getParameters();
        for (i = 0; i < iOP; ++i) {
            uParam = (JetUProcParameter)oParams.elementAt(i);
            this.remove(uParam);
        }
        for (i = 0; i < iOF; ++i) {
            uField = (JetUProcField)oFields.elementAt(i);
            this.remove(uField);
        }
        if (nParams != null) {
            for (i = 0; i < nParams.size(); ++i) {
                ProcParaInfo procParam = (ProcParaInfo)nParams.elementAt(i);
                name2 = procParam.getName();
                strMappingName = (String)opNames.get(name2);
                if (!(strMappingName != null && (procParam.getResourceName() == null || strMappingName.equals(procParam.getResourceName())) || (strMappingName = procParam.getResourceName()) != null && strMappingName.length() > 0)) {
                    strMappingName = this.getMappingName(procParam.strName);
                }
                uParam = new JetUProcParameter(strMappingName, "", procParam);
                this.addParameter(uParam);
            }
        }
        Vector nFields = proc.getColumns();
        for (int i4 = 0; i4 < nFields.size(); ++i4) {
            ProcColumnInfo procCol = (ProcColumnInfo)nFields.elementAt(i4);
            name2 = procCol.getName();
            strMappingName = (String)ofNames.get(name2);
            if (strMappingName == null) {
                strMappingName = this.getMappingName(procCol.strName);
            }
            uField = new JetUProcField(strMappingName, "", procCol);
            this.addField(uField);
        }
        proc = null;
        JetUUniverse.objectChanged(this.getUniverse(), this, 1002);
        return true;
    }

    @Override
    public String toString() {
        return this.getProcedureName() + this.getChildren();
    }

    @Override
    public String getInstancePrefix() {
        return "Procedure";
    }

    @Override
    public boolean isSimilar(JetUResourceContainer container) {
        if (!super.isSimilar(container)) {
            return false;
        }
        boolean isBLSimilar = this.isBLSimilar((JetUProcedure)container);
        if (!isBLSimilar) {
            return false;
        }
        boolean isBVSimilar = this.isBVSimilar((JetUProcedure)container);
        return isBVSimilar;
    }

    private boolean isBLSimilar(JetUProcedure procedure) {
        JBusinessLogic bl2;
        JBusinessLogic bl1 = this.getBL();
        if (bl1 == (bl2 = procedure.getBL())) {
            return true;
        }
        if (bl1 == null) {
            return bl2 == null;
        }
        return bl1.isSimilar(bl2);
    }

    private boolean isBVSimilar(JetUProcedure procedure) {
        JBusinessView bv2;
        JBusinessView bv1 = this.getBV();
        if (bv1 == (bv2 = procedure.getBV())) {
            return true;
        }
        if (bv1 == null) {
            return bv2 == null;
        }
        return bv1.isSimilar(bv2);
    }

    public JBusinessLogic newBL(String blName) throws BLIlegalNameException, BLDupleNameException {
        if (this.getBL() != null) {
            return null;
        }
        BusinessLogic bl = new BusinessLogic();
        bl.setName(blName);
        bl.setDisplayName(blName);
        this.add(bl);
        return bl;
    }

    public JBusinessView newBV(String bvName) throws BLIlegalNameException, BLDupleNameException {
        if (this.getBV() != null) {
            return null;
        }
        BusinessView bv = new BusinessView();
        bv.setDisplayName(bvName);
        this.add(bv);
        return bv;
    }

    public void removeBL() {
        JBusinessLogic bl = this.getBL();
        if (bl != null) {
            this.remove((JetObject)((Object)bl));
        }
    }

    public void removeBV() {
        JBusinessView bv = this.getBV();
        if (bv != null) {
            this.remove((JetObject)((Object)bv));
        }
    }

    @Override
    public JBusinessLogic getBL() {
        Vector children = this.getChildren();
        JBusinessLogic ret = null;
        for (JetObject element : children) {
            JBusinessLogic bl;
            if (!(element instanceof JBusinessLogic) || (bl = (JBusinessLogic)((Object)element)).getElementType() != 0) continue;
            ret = bl;
        }
        return ret;
    }

    @Override
    public JBusinessView getBV() {
        Vector children = this.getChildren();
        JBusinessView ret = null;
        for (JetObject element : children) {
            JBusinessLogic bl;
            if (!(element instanceof JBusinessLogic) || (bl = (JBusinessLogic)((Object)element)).getElementType() != 1) continue;
            ret = (JBusinessView)bl;
        }
        return ret;
    }

    @Override
    public void InitAfterLoad() {
        Vector children = this.getChildren();
        if (children == null) {
            return;
        }
        int iSize = children.size();
        for (int i = 0; i < iSize; ++i) {
            if (!(children.get(i) instanceof JBusinessLogic)) continue;
            BusinessLogic bl = (BusinessLogic)children.get(i);
            bl.initAfterLoad();
        }
    }

    @Override
    public HashMap getIndecialMap() {
        return nameIdx;
    }

    @Override
    public HashVector getPropGrpsDesc() {
        if (this.bEditable) {
            return grpDesc;
        }
        return null;
    }

    @Override
    public boolean isFieldValidToQuery(JetUUniverse unvs, String mappingname, String dataSourceName, Map<String, String> refFldOfFml) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        JetUResourceEntity en;
        if (refFldOfFml.containsKey(mappingname)) {
            return true;
        }
        refFldOfFml.put(mappingname, "");
        JetUResourceEntity entity = unvs.getResourceByName(dataSourceName, this.getResourceName(), mappingname);
        if (entity == null && (en = unvs.getAnyResourceByName(mappingname)) != null && en instanceof JetUParameter) {
            entity = en;
        }
        if (entity == null) {
            throw new CannotFindEntity(mappingname);
        }
        return this.isFieldValidToQuery(unvs, entity, dataSourceName, refFldOfFml);
    }

    private boolean isFieldValidToQuery(JetUUniverse unvs, JetUResourceEntity entity, String dataSourceName, Map<String, String> refFldOfFml) throws FormulaHasGrammarError, CannotFindFrmlRefFld, CannotFindEntity {
        boolean bRet = false;
        if (entity instanceof JetUParameter) {
            bRet = true;
        } else if (entity instanceof JetUFormula) {
            bRet = this.isFormulaValidToQuery((JetUFormula)entity, unvs, dataSourceName, refFldOfFml);
        } else if (entity instanceof JetUQueriableField && entity instanceof JetUProcField) {
            bRet = ((JetUProcField)entity).getProcedure() == this;
        }
        return bRet;
    }

    private boolean isFormulaValidToQuery(JetUFormula uFormula, JetUUniverse universe, String dataSourceName, Map<String, String> refFldOfFml) throws FormulaHasGrammarError, CannotFindFrmlRefFld {
        Vector dbFlds = uFormula.getRefDbFld();
        if (dbFlds != null) {
            int iCount = dbFlds.size();
            for (int i = 0; i < iCount; ++i) {
                String name2 = (String)dbFlds.elementAt(i);
                try {
                    if (this.isFieldValidToQuery(universe, name2, dataSourceName, refFldOfFml)) continue;
                    return false;
                }
                catch (CannotFindEntity e) {
                    throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name2);
                }
            }
        }
        Vector refFormulas = uFormula.getRefFormuFld();
        int iSize = refFormulas.size();
        for (int i = 0; i < iSize; ++i) {
            String name3 = (String)refFormulas.elementAt(i);
            try {
                if (this.isFieldValidToQuery(universe, name3, dataSourceName, refFldOfFml)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name3);
            }
        }
        Vector groups = uFormula.getGroupByVector();
        iSize = groups.size();
        for (int i = 0; i < iSize; ++i) {
            String name4 = (String)groups.elementAt(i);
            if (uFormula instanceof JetUSummary && JetUDatabase.isDigital(name4)) continue;
            try {
                if (name4.equalsIgnoreCase("Report") || this.isFieldValidToQuery(universe, name4, dataSourceName, refFldOfFml)) continue;
                return false;
            }
            catch (CannotFindEntity e) {
                throw new CannotFindFrmlRefFld(uFormula.getResourceName(), name4);
            }
        }
        return true;
    }

    @Override
    public int isPushDownGroupQuery() {
        return 2;
    }

    @Override
    public boolean canPushdownSort(String fieldMappingName) {
        return false;
    }

    static {
        nameIdx.put("Qualifier", new Integer(0));
        nameIdx.put("TransactionIsolation", new Integer(1));
        nameIdx.put("maxRows", new Integer(2));
        nameIdx.put("Name", new Integer(3));
        nameIdx.put("Description", new Integer(4));
        nameIdx.put("ProcedureName", new Integer(5));
        nameIdx.put("ReadOnly", new Integer(6));
        nameIdx.put("maxDuration", new Integer(7));
        nameIdx.put("Owner", new Integer(8));
        nameIdx.put("ConnectionName", new Integer(9));
        grpDesc = new HashVector(1);
        String grpName = null;
        Vector<String> grpItems = null;
        grpName = "anonymous";
        grpItems = new Vector<String>(9);
        grpItems.add("Qualifier");
        grpItems.add("TransactionIsolation");
        grpItems.add("maxRows");
        grpItems.add("Name");
        grpItems.add("Description");
        grpItems.add("ProcedureName");
        grpItems.add("ReadOnly");
        grpItems.add("maxDuration");
        grpItems.add("Owner");
        grpItems.add("ConnectionName");
        grpDesc.put(grpName, grpItems);
    }
}

